/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.jaxwsmodel.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.api.jaxws.project.JaxWsBuildScriptExtensionProvider;
import org.netbeans.modules.websvc.api.jaxws.project.WSUtils;
import org.netbeans.modules.websvc.api.jaxws.project.config.ClientAlreadyExistsExeption;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModelProvider;
import org.netbeans.modules.websvc.api.jaxws.project.config.ServiceAlreadyExistsExeption;
import org.netbeans.modules.websvc.jaxwsmodel.project_config1_0.Client;
import org.netbeans.modules.websvc.jaxwsmodel.project_config1_0.Clients;
import org.netbeans.modules.websvc.jaxwsmodel.project_config1_0.JaxWs;
import org.netbeans.modules.websvc.jaxwsmodel.project_config1_0.Service;
import org.netbeans.modules.websvc.jaxwsmodel.project_config1_0.Services;
import org.openide.ErrorManager;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.util.ChangeSupport;

public final class JaxWsModelImpl
implements JaxWsModel {
    private static final String JAX_WS_XML_RESOURCE = "/org/netbeans/modules/websvc/jaxwsmodel/resources/jax-ws.xml";
    private JaxWs jaxws;
    private FileObject fo;
    private Object initLock = new Object();
    private List<JaxWsModel.ServiceListener> serviceListeners;
    private List<PropertyChangeListener> propertyChangeListeners;
    private List<PropertyChangeListener> cachedListeners;
    private ChangeSupport changeSupport;
    private Project project;

    public JaxWsModelImpl(Project project) {
        this.project = project;
        this.fo = WSUtils.findJaxWsFileObject(project);
        if (this.fo != null) {
            try {
                this.jaxws = JaxWs.createGraph(this.fo.getInputStream());
            }
            catch (IOException ex) {
                Logger.getLogger(JaxWsModelImpl.class.getName()).log(Level.INFO, "JaxWsModel creation failed", ex);
            }
            final Project prj = project;
            this.fo.addFileChangeListener((FileChangeListener)new FileChangeAdapter(){

                public void fileChanged(FileEvent fe) {
                    JaxWsBuildScriptExtensionProvider extProvider = (JaxWsBuildScriptExtensionProvider)prj.getLookup().lookup(JaxWsBuildScriptExtensionProvider.class);
                    if (extProvider != null) {
                        try {
                            extProvider.handleJaxWsModelChanges(JaxWsModelImpl.this);
                        }
                        catch (IOException ex) {
                            Logger.getLogger(JaxWsModelImpl.class.getName()).log(Level.INFO, "failed to implement changes in jaxws-build.xml", ex);
                        }
                    }
                }
            });
        }
        this.propertyChangeListeners = new ArrayList<PropertyChangeListener>();
        this.cachedListeners = new ArrayList<PropertyChangeListener>();
        this.serviceListeners = new ArrayList<JaxWsModel.ServiceListener>();
        this.changeSupport = new ChangeSupport((Object)this);
    }

    public JaxWsModelImpl(JaxWs jaxws) {
        this(jaxws, null);
    }

    public JaxWsModelImpl(JaxWs jaxws, FileObject fo) {
        this.jaxws = jaxws;
        this.fo = fo;
        this.propertyChangeListeners = new ArrayList<PropertyChangeListener>();
        this.serviceListeners = new ArrayList<JaxWsModel.ServiceListener>();
        this.changeSupport = new ChangeSupport((Object)this);
    }

    @Override
    public org.netbeans.modules.websvc.api.jaxws.project.config.Service[] getServices() {
        if (this.jaxws == null) {
            return new org.netbeans.modules.websvc.api.jaxws.project.config.Service[0];
        }
        Services services = this.jaxws.getServices();
        if (services == null) {
            return new org.netbeans.modules.websvc.api.jaxws.project.config.Service[0];
        }
        Service[] org = services.getService();
        if (org == null) {
            return new org.netbeans.modules.websvc.api.jaxws.project.config.Service[0];
        }
        org.netbeans.modules.websvc.api.jaxws.project.config.Service[] newServices = new org.netbeans.modules.websvc.api.jaxws.project.config.Service[org.length];
        for (int i = 0; i < org.length; ++i) {
            newServices[i] = JaxWsModelProvider.getDefault().createService((Object)org[i]);
        }
        return newServices;
    }

    @Override
    public void setJsr109(Boolean jsr109) {
        if (this.jaxws != null) {
            this.jaxws.setJsr109(jsr109);
        }
    }

    @Override
    public Boolean getJsr109() {
        return this.jaxws == null ? null : this.jaxws.getJsr109();
    }

    @Override
    public org.netbeans.modules.websvc.api.jaxws.project.config.Service findServiceByName(String name) {
        Service service = this.findService(name);
        return service == null ? null : JaxWsModelProvider.getDefault().createService((Object)service);
    }

    @Override
    public org.netbeans.modules.websvc.api.jaxws.project.config.Service findServiceByImplementationClass(String wsClassName) {
        Service service = this._findServiceByClass(wsClassName);
        return service == null ? null : JaxWsModelProvider.getDefault().createService((Object)service);
    }

    private Service findService(String name) {
        if (this.jaxws == null) {
            return null;
        }
        Services services = this.jaxws.getServices();
        if (services == null) {
            return null;
        }
        Service[] org = services.getService();
        if (org == null) {
            return null;
        }
        for (int i = 0; i < org.length; ++i) {
            if (!name.equals(org[i].getName())) continue;
            return org[i];
        }
        return null;
    }

    private Service _findServiceByClass(String wsClassName) {
        if (this.jaxws == null) {
            return null;
        }
        Services services = this.jaxws.getServices();
        if (services == null) {
            return null;
        }
        Service[] org = services.getService();
        if (org == null) {
            return null;
        }
        for (int i = 0; i < org.length; ++i) {
            if (!wsClassName.equals(org[i].getImplementationClass())) continue;
            return org[i];
        }
        return null;
    }

    @Override
    public boolean removeService(String name) {
        Service service = this.findService(name);
        if (name == null) {
            return false;
        }
        this.fireServiceRemoved(name);
        this.jaxws.getServices().removeService(service);
        return true;
    }

    @Override
    public boolean removeServiceByClassName(String webserviceClassName) {
        Service service;
        if (webserviceClassName != null && (service = this._findServiceByClass(webserviceClassName)) != null) {
            this.fireServiceRemoved(service.getName());
            this.jaxws.getServices().removeService(service);
            return true;
        }
        return false;
    }

    @Override
    public org.netbeans.modules.websvc.api.jaxws.project.config.Service addService(String name, String implementationClass) throws ServiceAlreadyExistsExeption {
        if (this.jaxws == null && this.project != null) {
            try {
                WSUtils.createJaxWsFileObject(this.project);
            }
            catch (IOException ex) {
                Logger.getLogger(JaxWsModelImpl.class.getName()).log(Level.INFO, "failed to create jax-ws.xml", ex);
            }
        }
        if (this.findService(name) != null) {
            throw new ServiceAlreadyExistsExeption(name);
        }
        Service service = this.jaxws.getServices().newService();
        service.setName(name);
        service.setImplementationClass(implementationClass);
        this.jaxws.getServices().addService(service);
        this.fireServiceAdded(name, implementationClass);
        return JaxWsModelProvider.getDefault().createService((Object)service);
    }

    @Override
    public org.netbeans.modules.websvc.api.jaxws.project.config.Service addService(String name, String implementationClass, String wsdlUrl, String serviceName, String portName, String packageName) throws ServiceAlreadyExistsExeption {
        if (this.jaxws == null && this.project != null) {
            try {
                WSUtils.createJaxWsFileObject(this.project);
            }
            catch (IOException ex) {
                Logger.getLogger(JaxWsModelImpl.class.getName()).log(Level.INFO, "failed to create jax-ws.xml", ex);
            }
        }
        if (this.findService(name) != null) {
            throw new ServiceAlreadyExistsExeption(name);
        }
        Service service = this.jaxws.getServices().newService();
        service.setName(name);
        service.setImplementationClass(implementationClass);
        service.setWsdlUrl(wsdlUrl);
        service.setServiceName(serviceName);
        service.setPortName(portName);
        service.setPackageName(packageName);
        this.jaxws.getServices().addService(service);
        return JaxWsModelProvider.getDefault().createService((Object)service);
    }

    @Override
    public org.netbeans.modules.websvc.api.jaxws.project.config.Client[] getClients() {
        if (this.jaxws == null) {
            return new org.netbeans.modules.websvc.api.jaxws.project.config.Client[0];
        }
        Clients clients = this.jaxws.getClients();
        if (clients == null) {
            return new org.netbeans.modules.websvc.api.jaxws.project.config.Client[0];
        }
        Client[] org = clients.getClient();
        if (org == null) {
            return new org.netbeans.modules.websvc.api.jaxws.project.config.Client[0];
        }
        org.netbeans.modules.websvc.api.jaxws.project.config.Client[] newClients = new org.netbeans.modules.websvc.api.jaxws.project.config.Client[org.length];
        for (int i = 0; i < org.length; ++i) {
            newClients[i] = JaxWsModelProvider.getDefault().createClient((Object)org[i]);
        }
        return newClients;
    }

    @Override
    public org.netbeans.modules.websvc.api.jaxws.project.config.Client findClientByName(String name) {
        Client client = this.findClient(name);
        return client == null ? null : JaxWsModelProvider.getDefault().createClient((Object)client);
    }

    @Override
    public org.netbeans.modules.websvc.api.jaxws.project.config.Client findClientByWsdlUrl(String wsdlUrl) {
        if (this.jaxws == null) {
            return null;
        }
        Clients clients = this.jaxws.getClients();
        if (clients == null) {
            return null;
        }
        Client[] org = clients.getClient();
        if (org == null) {
            return null;
        }
        for (int i = 0; i < org.length; ++i) {
            if (!wsdlUrl.equals(org[i].getWsdlUrl())) continue;
            return JaxWsModelProvider.getDefault().createClient((Object)org[i]);
        }
        return null;
    }

    private Client findClient(String name) {
        if (this.jaxws == null) {
            return null;
        }
        Clients clients = this.jaxws.getClients();
        if (clients == null) {
            return null;
        }
        Client[] org = clients.getClient();
        if (org == null) {
            return null;
        }
        for (int i = 0; i < org.length; ++i) {
            if (!name.equals(org[i].getName())) continue;
            return org[i];
        }
        return null;
    }

    @Override
    public boolean removeClient(String name) {
        Client client = this.findClient(name);
        if (client == null) {
            return false;
        }
        this.jaxws.getClients().removeClient(client);
        return true;
    }

    @Override
    public org.netbeans.modules.websvc.api.jaxws.project.config.Client addClient(String name, String wsdlUrl, String packageName) throws ClientAlreadyExistsExeption {
        if (this.jaxws == null && this.project != null) {
            try {
                WSUtils.createJaxWsFileObject(this.project);
            }
            catch (IOException ex) {
                Logger.getLogger(JaxWsModelImpl.class.getName()).log(Level.INFO, "failed to create jax-ws.xml", ex);
            }
        }
        if (this.findClient(name) != null) {
            throw new ClientAlreadyExistsExeption(name);
        }
        Client client = this.jaxws.getClients().newClient();
        client.setName(name);
        client.setWsdlUrl(wsdlUrl);
        if (packageName != null) {
            client.setPackageName(packageName);
            client.setPackageNameForceReplace("true");
        }
        this.jaxws.getClients().addClient(client);
        return JaxWsModelProvider.getDefault().createClient((Object)client);
    }

    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener l) {
        if (this.jaxws == null) {
            this.cachedListeners.add(l);
        } else {
            JaxWsPCL jaxWsPcl = new JaxWsPCL(l);
            this.propertyChangeListeners.add(jaxWsPcl);
            this.jaxws.addPropertyChangeListener(jaxWsPcl);
        }
    }

    @Override
    public synchronized void removePropertyChangeListener(PropertyChangeListener l) {
        if (this.jaxws == null) {
            this.cachedListeners.remove(l);
        } else {
            for (PropertyChangeListener pcl : this.propertyChangeListeners) {
                if (l != ((JaxWsPCL)pcl).getOriginalListener()) continue;
                this.jaxws.removePropertyChangeListener(pcl);
                this.propertyChangeListeners.remove(pcl);
                break;
            }
        }
    }

    @Override
    public void merge(JaxWsModel newJaxWs) {
        if (this.jaxws != null) {
            JaxWsModelImpl impl = (JaxWsModelImpl)newJaxWs;
            if (impl.jaxws != null) {
                this.jaxws.merge(((JaxWsModelImpl)newJaxWs).jaxws, 3);
            }
        }
    }

    @Override
    public void write(OutputStream os) throws IOException {
        if (this.jaxws != null) {
            this.jaxws.write(os);
        }
    }

    @Override
    public FileObject getJaxWsFile() {
        return this.fo;
    }

    @Override
    public void setJaxWsFile(FileObject fo) {
        JaxWsBuildScriptExtensionProvider extProvider;
        this.fo = fo;
        if (fo != null && this.project != null && (extProvider = (JaxWsBuildScriptExtensionProvider)this.project.getLookup().lookup(JaxWsBuildScriptExtensionProvider.class)) != null) {
            try {
                this.jaxws = JaxWs.createGraph(fo.getInputStream());
            }
            catch (IOException ex) {
                // empty catch block
            }
            final Project prj = this.project;
            fo.addFileChangeListener((FileChangeListener)new FileChangeAdapter(){

                public void fileChanged(FileEvent fe) {
                    JaxWsBuildScriptExtensionProvider extProvider = (JaxWsBuildScriptExtensionProvider)prj.getLookup().lookup(JaxWsBuildScriptExtensionProvider.class);
                    if (extProvider != null) {
                        try {
                            extProvider.handleJaxWsModelChanges(JaxWsModelImpl.this);
                        }
                        catch (IOException ex) {
                            Logger.getLogger(JaxWsModelImpl.class.getName()).log(Level.INFO, "failed to implement changes in jaxws-build.xml", ex);
                        }
                    }
                }
            });
            if (this.jaxws != null) {
                for (PropertyChangeListener l : this.cachedListeners) {
                    this.addPropertyChangeListener(l);
                }
                this.cachedListeners.clear();
            }
        }
        this.changeSupport.fireChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write() throws IOException {
        if (this.fo != null) {
            FileLock lock = null;
            OutputStream os = null;
            try {
                lock = this.fo.lock();
                os = this.fo.getOutputStream(lock);
                this.write(os);
                os.close();
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
            finally {
                if (lock != null) {
                    lock.releaseLock();
                }
                if (os != null) {
                    os.close();
                }
            }
        } else {
            throw new IOException("No FileObject for writing specified");
        }
    }

    @Override
    public synchronized void addServiceListener(JaxWsModel.ServiceListener listener) {
        if (listener != null) {
            this.serviceListeners.add(listener);
        }
    }

    @Override
    public synchronized void removeServiceListener(JaxWsModel.ServiceListener listener) {
        this.serviceListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireServiceAdded(String name, String implementationClass) {
        Iterator<JaxWsModel.ServiceListener> it = this.serviceListeners.iterator();
        JaxWsModelImpl jaxWsModelImpl = this;
        synchronized (jaxWsModelImpl) {
            while (it.hasNext()) {
                it.next().serviceAdded(name, implementationClass);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireServiceRemoved(String name) {
        Iterator<JaxWsModel.ServiceListener> it = this.serviceListeners.iterator();
        JaxWsModelImpl jaxWsModelImpl = this;
        synchronized (jaxWsModelImpl) {
            while (it.hasNext()) {
                it.next().serviceRemoved(name);
            }
        }
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    private class JaxWsPCL
    implements PropertyChangeListener {
        PropertyChangeListener originalListener;

        JaxWsPCL(PropertyChangeListener originalListener) {
            this.originalListener = originalListener;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Object newValue;
            Object oldValue = evt.getOldValue();
            JaxWsModelProvider factory = JaxWsModelProvider.getDefault();
            if (oldValue != null) {
                if (oldValue instanceof Client) {
                    oldValue = factory.createClient(oldValue);
                }
                if (oldValue instanceof Service) {
                    oldValue = factory.createService(oldValue);
                }
            }
            if ((newValue = evt.getNewValue()) != null) {
                if (newValue instanceof Client) {
                    newValue = factory.createClient(newValue);
                }
                if (newValue instanceof Service) {
                    newValue = factory.createService(newValue);
                }
            }
            this.originalListener.propertyChange(new PropertyChangeEvent(evt.getSource(), evt.getPropertyName(), oldValue, newValue));
        }

        PropertyChangeListener getOriginalListener() {
            return this.originalListener;
        }
    }
}

