/*
 * Decompiled with CFR 0.152.
 */
package javassist.compiler.ast;

import javassist.compiler.CompileError;
import javassist.compiler.ast.ASTree;
import javassist.compiler.ast.DoubleConst;
import javassist.compiler.ast.Visitor;

public class IntConst
extends ASTree {
    protected long value;
    protected int type;

    public IntConst(long v, int tokenId) {
        this.value = v;
        this.type = tokenId;
    }

    public long get() {
        return this.value;
    }

    public void set(long v) {
        this.value = v;
    }

    public int getType() {
        return this.type;
    }

    public String toString() {
        return Long.toString(this.value);
    }

    public void accept(Visitor v) throws CompileError {
        v.atIntConst(this);
    }

    public ASTree compute(int op, ASTree right) {
        if (right instanceof IntConst) {
            return this.compute0(op, (IntConst)right);
        }
        if (right instanceof DoubleConst) {
            return this.compute0(op, (DoubleConst)right);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private IntConst compute0(int op, IntConst right) {
        void var10_8;
        int type1 = this.type;
        int type2 = right.type;
        int newType = type1 == 403 || type2 == 403 ? 403 : (type1 == 401 && type2 == 401 ? 401 : 402);
        long value1 = this.value;
        long value2 = right.value;
        switch (op) {
            case 43: {
                long newValue = value1 + value2;
                break;
            }
            case 45: {
                long newValue = value1 - value2;
                break;
            }
            case 42: {
                long newValue = value1 * value2;
                break;
            }
            case 47: {
                long newValue = value1 / value2;
                break;
            }
            case 37: {
                long newValue = value1 % value2;
                break;
            }
            case 124: {
                long newValue = value1 | value2;
                break;
            }
            case 94: {
                long newValue = value1 ^ value2;
                break;
            }
            case 38: {
                long newValue = value1 & value2;
                break;
            }
            case 364: {
                long newValue = this.value << (int)value2;
                newType = type1;
                break;
            }
            case 366: {
                long newValue = this.value >> (int)value2;
                newType = type1;
                break;
            }
            case 370: {
                long newValue = this.value >>> (int)value2;
                newType = type1;
                break;
            }
            default: {
                return null;
            }
        }
        return new IntConst((long)var10_8, newType);
    }

    /*
     * WARNING - void declaration
     */
    private DoubleConst compute0(int op, DoubleConst right) {
        void var7_5;
        double value1 = this.value;
        double value2 = right.value;
        switch (op) {
            case 43: {
                double newValue = value1 + value2;
                break;
            }
            case 45: {
                double newValue = value1 - value2;
                break;
            }
            case 42: {
                double newValue = value1 * value2;
                break;
            }
            case 47: {
                double newValue = value1 / value2;
                break;
            }
            case 37: {
                double newValue = value1 % value2;
                break;
            }
            default: {
                return null;
            }
        }
        return new DoubleConst((double)var7_5, right.type);
    }
}

