/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java;

import java.io.IOException;
import java.text.MessageFormat;
import javax.swing.Action;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.refactoring.api.ui.ExplorerContext;
import org.netbeans.modules.refactoring.api.ui.RefactoringActionsFactory;
import org.netbeans.modules.refactoring.java.RetoucheUtils;
import org.netbeans.modules.refactoring.java.plugins.RenameRefactoringPlugin;
import org.netbeans.spi.java.project.support.ui.PackageRenameHandler;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class PackageRenameHandlerImpl
implements PackageRenameHandler {
    public void handleRename(Node node, String newName) {
        DataFolder dob = (DataFolder)node.getCookie(DataObject.class);
        FileObject fo = dob.getPrimaryFile();
        if (node.isLeaf()) {
            try {
                if (!RetoucheUtils.isValidPackageName(newName)) {
                    String msg = new MessageFormat(NbBundle.getMessage(RenameRefactoringPlugin.class, (String)"ERR_InvalidPackage")).format(new Object[]{newName});
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg, 1));
                    return;
                }
                ClassPath sourcepath = ClassPath.getClassPath((FileObject)fo, (String)"classpath/source");
                if (sourcepath == null) {
                    throw new IOException("no sourcepath for " + fo);
                }
                FileObject root = sourcepath.findOwnerRoot(fo);
                if (root == null) {
                    throw new IOException(fo + " not in its own sourcepath " + sourcepath);
                }
                FileObject newFolder = FileUtil.createFolder((FileObject)root, (String)newName.replace('.', '/'));
                while (dob.getChildren().length == 0 && dob.isDeleteAllowed() && !dob.getPrimaryFile().equals(newFolder)) {
                    DataFolder parent = dob.getFolder();
                    dob.delete();
                    dob = parent;
                }
            }
            catch (IOException ioe) {
                ErrorManager.getDefault().notify((Throwable)ioe);
            }
            return;
        }
        InstanceContent ic = new InstanceContent();
        ic.add((Object)node);
        ExplorerContext d = new ExplorerContext();
        d.setNewName(newName);
        ic.add((Object)d);
        AbstractLookup l = new AbstractLookup((AbstractLookup.Content)ic);
        Action a = RefactoringActionsFactory.renameAction().createContextAwareInstance((Lookup)l);
        if (Boolean.TRUE.equals(a.getValue("applicable"))) {
            a.actionPerformed(RefactoringActionsFactory.DEFAULT_EVENT);
        }
    }
}

