/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.ui;

import java.text.MessageFormat;
import java.util.HashSet;
import java.util.ResourceBundle;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.ui.ElementHeaders;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.WhereUsedQuery;
import org.netbeans.modules.refactoring.java.RetoucheUtils;
import org.netbeans.modules.refactoring.java.api.WhereUsedQueryConstants;
import org.netbeans.modules.refactoring.java.ui.WhereUsedPanel;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class WhereUsedQueryUI
implements RefactoringUI {
    private WhereUsedQuery query = null;
    private final String name;
    private WhereUsedPanel panel;
    private final TreePathHandle element;
    private ElementKind kind;
    private AbstractRefactoring delegate;
    private ResourceBundle bundle;

    public WhereUsedQueryUI(TreePathHandle handle, CompilationInfo info) {
        this.query = new WhereUsedQuery(Lookups.singleton((Object)handle));
        this.query.getContext().add((Object)info.getClasspathInfo());
        this.element = handle;
        Element el = handle.resolveElement(info);
        if (el != null) {
            this.name = ElementHeaders.getHeader((Element)el, (CompilationInfo)info, (String)"%name%");
            this.kind = el.getKind();
        } else {
            this.name = "";
            this.kind = ElementKind.OTHER;
        }
    }

    public WhereUsedQueryUI(TreePathHandle jmiObject, String name, AbstractRefactoring delegate) {
        this.delegate = delegate;
        this.element = jmiObject;
        this.name = name;
    }

    public boolean isQuery() {
        return true;
    }

    public CustomRefactoringPanel getPanel(ChangeListener parent) {
        if (this.panel == null) {
            this.panel = new WhereUsedPanel(this.name, this.element, parent);
        }
        return this.panel;
    }

    public Problem setParameters() {
        this.query.putValue((Object)"SEARCH_IN_COMMENTS", (Object)this.panel.isSearchInComments());
        if (this.panel.getScope() == WhereUsedPanel.Scope.ALL) {
            if (this.kind == ElementKind.METHOD && this.panel.isMethodFromBaseClass()) {
                TreePathHandle basem = this.panel.getBaseMethod();
                if (basem != null && (basem.getFileObject() == null || basem.getFileObject().getNameExt().endsWith("class"))) {
                    this.query.getContext().add((Object)RetoucheUtils.getClasspathInfoFor(this.element, basem));
                } else {
                    this.query.getContext().add((Object)RetoucheUtils.getClasspathInfoFor(basem));
                }
            } else {
                this.query.getContext().add((Object)RetoucheUtils.getClasspathInfoFor(this.element));
            }
        } else {
            ClasspathInfo info = (ClasspathInfo)this.query.getContext().lookup(ClasspathInfo.class);
            Project p = FileOwnerQuery.getOwner((FileObject)this.element.getFileObject());
            Sources sources = ProjectUtils.getSources((Project)p);
            HashSet<FileObject> roots = new HashSet<FileObject>();
            for (SourceGroup sg : sources.getSourceGroups("java")) {
                roots.add(sg.getRootFolder());
            }
            ClassPath rcp = ClassPathSupport.createClassPath((FileObject[])roots.toArray(new FileObject[roots.size()]));
            info = ClasspathInfo.create((ClassPath)info.getClassPath(ClasspathInfo.PathKind.BOOT), (ClassPath)info.getClassPath(ClasspathInfo.PathKind.COMPILE), (ClassPath)rcp);
            this.query.getContext().add((Object)info);
        }
        if (this.kind == ElementKind.METHOD) {
            this.setForMethod();
            return this.query.checkParameters();
        }
        if (this.kind.isClass() || this.kind.isInterface()) {
            this.setForClass();
            return this.query.checkParameters();
        }
        return null;
    }

    private void setForMethod() {
        if (this.panel.isMethodFromBaseClass()) {
            this.query.setRefactoringSource(Lookups.singleton((Object)this.panel.getBaseMethod()));
        } else {
            this.query.setRefactoringSource(Lookups.singleton((Object)this.element));
        }
        this.query.putValue((Object)WhereUsedQueryConstants.FIND_OVERRIDING_METHODS, (Object)this.panel.isMethodOverriders());
        this.query.putValue((Object)"FIND_REFERENCES", (Object)this.panel.isMethodFindUsages());
    }

    private void setForClass() {
        this.query.putValue((Object)WhereUsedQueryConstants.FIND_SUBCLASSES, (Object)this.panel.isClassSubTypes());
        this.query.putValue((Object)WhereUsedQueryConstants.FIND_DIRECT_SUBCLASSES, (Object)this.panel.isClassSubTypesDirectOnly());
        this.query.putValue((Object)"FIND_REFERENCES", (Object)this.panel.isClassFindUsages());
    }

    public Problem checkParameters() {
        if (this.kind == ElementKind.METHOD) {
            this.setForMethod();
            return this.query.fastCheckParameters();
        }
        if (this.kind.isClass() || this.kind.isInterface()) {
            this.setForClass();
            return this.query.fastCheckParameters();
        }
        return null;
    }

    public AbstractRefactoring getRefactoring() {
        return this.query != null ? this.query : this.delegate;
    }

    public String getDescription() {
        if (this.panel != null) {
            if (this.kind == ElementKind.INTERFACE || this.kind == ElementKind.CLASS) {
                if (!this.panel.isClassFindUsages()) {
                    if (!this.panel.isClassSubTypesDirectOnly()) {
                        return this.getString("DSC_WhereUsedFindAllSubTypes", this.name);
                    }
                    return this.getString("DSC_WhereUsedFindDirectSubTypes", this.name);
                }
            } else if (this.kind == ElementKind.METHOD) {
                String description = null;
                if (this.panel.isMethodFindUsages()) {
                    description = this.getString("DSC_FindUsages");
                }
                if (this.panel.isMethodOverriders()) {
                    description = description != null ? description + " " + this.getString("DSC_And") + " " : "";
                    description = description + this.getString("DSC_WhereUsedMethodOverriders");
                }
                description = description + " " + this.getString("DSC_WhereUsedOf", this.panel.getMethodDeclaringClass() + '.' + this.name);
                return description;
            }
        }
        return this.getString("DSC_WhereUsed", this.name);
    }

    private String getString(String key) {
        if (this.bundle == null) {
            this.bundle = NbBundle.getBundle(WhereUsedQueryUI.class);
        }
        return this.bundle.getString(key);
    }

    private String getString(String key, String value) {
        return new MessageFormat(this.getString(key)).format(new Object[]{value});
    }

    public String getName() {
        return new MessageFormat(NbBundle.getMessage(WhereUsedPanel.class, (String)"LBL_UsagesOf")).format(new Object[]{this.name});
    }

    public boolean hasParameters() {
        return true;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(WhereUsedQueryUI.class);
    }
}

