/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2me.cdc.project.savaje;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class SavajeJnlpBuilder
extends Task {
    private File dir;
    private String file;
    private String codebase;
    private String extensionBase;
    private String distJar;
    private String smallIcon;
    private String focusedIcon;
    private String applicationTitle;
    private String applicationVendor;
    private String applicationIcon;
    private String applicationDescription;
    private String mainClass;
    private String applicationArgs;
    private boolean debug;
    private String debugPort;
    private List filesets = new LinkedList();

    public void addFileset(FileSet fs) {
        this.filesets.add(fs);
    }

    public void setDir(File dir) {
        this.dir = dir;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public void setCodebase(String codebase) {
        this.codebase = codebase;
    }

    public void setExtensionBase(String extensionBase) {
        this.extensionBase = extensionBase;
    }

    public void setDistJar(String distJar) {
        this.distJar = distJar;
    }

    public void setSmallIcon(String smallIcon) {
        this.smallIcon = smallIcon;
    }

    public void setFocusedIcon(String focusedIcon) {
        this.focusedIcon = focusedIcon;
    }

    public void setApplicationTitle(String applicationTitle) {
        this.applicationTitle = applicationTitle;
    }

    public void setApplicationVendor(String applicationVendor) {
        this.applicationVendor = applicationVendor;
    }

    public void setApplicationIcon(String applicationIcon) {
        this.applicationIcon = applicationIcon;
    }

    public void setApplicationDescription(String applicationDescription) {
        this.applicationDescription = applicationDescription;
    }

    public void setMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    public void setApplicationArgs(String applicationArgs) {
        this.applicationArgs = applicationArgs;
    }

    public void execute() throws BuildException {
        if (!this.dir.exists()) {
            throw new BuildException("Target directory does not exist");
        }
        if (!this.dir.isDirectory()) {
            throw new BuildException("Target directory is a file");
        }
        if (this.file == null) {
            throw new BuildException("Target file name is not specified");
        }
        if (this.distJar == null) {
            throw new BuildException("Target file name is not specified");
        }
        if (this.codebase == null) {
            throw new BuildException("Codebase is not specified");
        }
        if (this.applicationTitle == null) {
            throw new BuildException("Application title is not specified");
        }
        if (this.applicationVendor == null) {
            throw new BuildException("Application vendor is not specified");
        }
        if (this.applicationDescription == null) {
            throw new BuildException("Application icon is not specified");
        }
        if (this.mainClass == null) {
            throw new BuildException("main class is not specified");
        }
        File targetFile = new File(this.dir, this.file);
        try {
            FileWriter fileWriter = new FileWriter(targetFile);
            PrintWriter printW = new PrintWriter(fileWriter);
            printW.println("<?xml version=\"1.0\" encoding=\"utf-8\" ?>");
            printW.println("<jnlp codebase=\"sb:///" + this.codebase + "/\">");
            printW.println();
            printW.println("  <resources>");
            printW.println("    <j2se version=\"1.4+\"/>");
            printW.println("    <jar href=\"lib/classes.jar\"/>");
            if (this.smallIcon != null && this.smallIcon.length() != 0 && this.smallIcon.indexOf("${") == -1) {
                printW.println("    <property name=\"icon.small\" value=\"" + this.smallIcon + "\"/>");
            }
            if (this.focusedIcon != null && this.focusedIcon.length() != 0 && this.focusedIcon.indexOf("${") == -1) {
                printW.println("    <property name=\"icon.focused\" value=\"" + this.focusedIcon + "\"/>");
            }
            printW.println("  </resources>");
            printW.println();
            if (this.debug && this.debugPort != null && this.debugPort.length() != 0) {
                this.getProject().log("Adding debug information to jnlp file.");
                printW.println("  <resources os=\"savaJe\">");
                printW.println("     <property name=\"flag\" value=\"-g\"/>");
                printW.println("  </resources>");
                printW.println();
                String dbg = "port=" + this.debugPort + " suspend=y ";
                this.applicationArgs = this.applicationArgs == null ? dbg : dbg + this.applicationArgs;
            }
            printW.println("  <information>");
            printW.println("    <title>" + this.applicationTitle + "</title>");
            printW.println("    <vendor>" + this.applicationVendor + "</vendor>");
            if (this.applicationIcon != null && this.applicationIcon.length() != 0 && this.applicationIcon.indexOf("${") == -1) {
                printW.println("    <icon href=\"" + this.applicationIcon + "\"/>");
            }
            if (this.applicationDescription.length() != 0) {
                printW.println("    <description>" + this.applicationDescription + "</description>");
            }
            printW.println("  </information>");
            printW.println();
            printW.println("  <application-desc main-class=\"" + this.mainClass + "\">");
            if (this.applicationArgs != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(this.applicationArgs, " ");
                while (stringTokenizer.hasMoreTokens()) {
                    printW.println("    <argument>" + stringTokenizer.nextToken() + "</argument>");
                }
            }
            printW.println("  </application-desc>");
            printW.println();
            printW.println("</jnlp>");
            printW.close();
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setDebugPort(String debugPort) {
        this.debugPort = debugPort;
    }
}

