/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.toolchain.ui;

import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.CompilerSetManager;
import org.netbeans.modules.cnd.api.toolchain.ui.IsChangedListener;
import org.netbeans.modules.cnd.api.toolchain.ui.ToolsCacheManager;
import org.netbeans.modules.cnd.toolchain.compilerset.CompilerSetManagerImpl;
import org.netbeans.modules.cnd.toolchain.compilerset.ToolUtils;
import org.netbeans.modules.cnd.toolchain.ui.options.AddCompilerSetPanel;
import org.netbeans.modules.cnd.toolchain.ui.options.HostToolsPanelModel;
import org.netbeans.modules.cnd.toolchain.ui.options.ToolsCacheManagerImpl;
import org.netbeans.modules.cnd.toolchain.ui.options.ToolsPanel;
import org.netbeans.modules.cnd.utils.ui.ModalMessageDlg;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakSet;
import org.openide.windows.WindowManager;

public class ToolsPanelSupport {
    private static CompilerSet currentCompilerSet;
    private static final ToolsCacheManagerImpl cacheManager;
    public static final String OK_LISTENER_KEY = "okVetoableListener";
    public static final String SELECTED_TOOLCHAIN_KEY = "selectedToolchain";
    private static Set<ChangeListener> listenerChanged;
    private static final Set<ChangeListener> listenerModified;
    private static final Set<IsChangedListener> listenerIsChanged;
    private static Set<ChangeListener> codeAssistanceChanged;

    public static ToolsCacheManager getToolsCacheManager() {
        return cacheManager;
    }

    public static boolean isUnsupportedMake(String name) {
        name = ToolUtils.getBaseName(name);
        return name.toLowerCase().equals("mingw32-make.exe");
    }

    public static void addCompilerSetChangeListener(ChangeListener l) {
        listenerChanged.add(l);
    }

    public static void removeCompilerSetChangeListener(ChangeListener l) {
        listenerChanged.remove(l);
    }

    public static void fireCompilerSetChange(CompilerSet set) {
        ChangeEvent ev = new ChangeEvent(set);
        currentCompilerSet = set;
        for (ChangeListener l : listenerChanged) {
            l.stateChanged(ev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addCompilerSetModifiedListener(ChangeListener l) {
        Set<ChangeListener> set = listenerModified;
        synchronized (set) {
            listenerModified.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeCompilerSetModifiedListener(ChangeListener l) {
        Set<ChangeListener> set = listenerModified;
        synchronized (set) {
            listenerModified.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fireCompilerSetModified(CompilerSet set) {
        ChangeEvent ev = new ChangeEvent(set);
        Set<ChangeListener> set2 = listenerModified;
        synchronized (set2) {
            for (ChangeListener l : listenerModified) {
                l.stateChanged(ev);
            }
        }
    }

    public static CompilerSet getCurrentCompilerSet() {
        return currentCompilerSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addIsChangedListener(IsChangedListener l) {
        Set<IsChangedListener> set = listenerIsChanged;
        synchronized (set) {
            listenerIsChanged.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeIsChangedListener(IsChangedListener l) {
        Set<IsChangedListener> set = listenerIsChanged;
        synchronized (set) {
            listenerIsChanged.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isChangedInOtherPanels() {
        boolean isChanged = false;
        Set<IsChangedListener> set = listenerIsChanged;
        synchronized (set) {
            for (IsChangedListener l : listenerIsChanged) {
                if (!l.isChanged()) continue;
                isChanged = true;
                break;
            }
        }
        return isChanged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Runnable> saveChangesInOtherPanels() {
        ArrayList<Runnable> res = new ArrayList<Runnable>();
        Set<IsChangedListener> set = listenerIsChanged;
        synchronized (set) {
            for (IsChangedListener l : listenerIsChanged) {
                Runnable saveChanges = l.saveChanges();
                if (saveChanges == null) continue;
                res.add(saveChanges);
            }
        }
        return res;
    }

    public static void addCodeAssistanceChangeListener(ChangeListener l) {
        codeAssistanceChanged.add(l);
    }

    public static void removeCodeAssistanceChangeListener(ChangeListener l) {
        codeAssistanceChanged.remove(l);
    }

    public static void fireCodeAssistanceChange(CompilerSetManager csm) {
        ChangeEvent ev = new ChangeEvent(csm);
        for (ChangeListener l : codeAssistanceChanged) {
            l.stateChanged(ev);
        }
    }

    public static JComponent getToolsPanelComponent(ExecutionEnvironment env, String selectedCompilerSetName) {
        HostToolsPanelModel model = new HostToolsPanelModel(env);
        if (selectedCompilerSetName != null && selectedCompilerSetName.length() > 0) {
            model.setSelectedCompilerSetName(selectedCompilerSetName);
        }
        final ToolsPanel tp = new ToolsPanel(model, "ConfiguringBuildTools");
        tp.update();
        VetoableChangeListener okL = new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                tp.applyChanges();
                tp.putClientProperty(ToolsPanelSupport.SELECTED_TOOLCHAIN_KEY, tp.getSelectedToolchain());
            }
        };
        tp.putClientProperty(OK_LISTENER_KEY, okL);
        return tp;
    }

    public static Future<CompilerSet> invokeNewCompilerSetWizard(ExecutionEnvironment env) {
        CompilerSetManagerImpl csm = (CompilerSetManagerImpl)cacheManager.getCompilerSetManagerCopy(env, true);
        CompilerSet cs = AddCompilerSetPanel.invokeMe(csm);
        if (cs != null) {
            return RequestProcessor.getDefault().submit((Runnable)new CompilerSetAction(csm, cs, CompilerSetActionType.ADD), (Object)cs);
        }
        return null;
    }

    public static RequestProcessor.Task setDefaultCompilerSet(ExecutionEnvironment env, String csName) {
        CompilerSetManagerImpl csm = (CompilerSetManagerImpl)cacheManager.getCompilerSetManagerCopy(env, true);
        return RequestProcessor.getDefault().post((Runnable)new CompilerSetAction(csm, csm.getCompilerSet(csName), CompilerSetActionType.SET_DEFAULT));
    }

    public static RequestProcessor.Task removeCompilerSet(ExecutionEnvironment env, String csName) {
        CompilerSetManagerImpl csm = (CompilerSetManagerImpl)cacheManager.getCompilerSetManagerCopy(env, true);
        return RequestProcessor.getDefault().post((Runnable)new CompilerSetAction(csm, csm.getCompilerSet(csName), CompilerSetActionType.REMOVE));
    }

    public static RequestProcessor.Task restoreCompilerSets(final ExecutionEnvironment env) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                CompilerSetManagerImpl oldCsm = (CompilerSetManagerImpl)CompilerSetManager.get(env);
                cacheManager.restoreCompilerSets(oldCsm);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            ModalMessageDlg.runLongTask((Frame)WindowManager.getDefault().getMainWindow(), (Runnable)runnable, null, null, (String)NbBundle.getMessage(ToolsPanelSupport.class, (String)"RestoringToolchainsTitle"), (String)NbBundle.getMessage(ToolsPanelSupport.class, (String)"RestoringToolchainsMessage"));
        } else {
            runnable.run();
        }
        return RequestProcessor.getDefault().post((Runnable)new CompilerSetAction(null, null, CompilerSetActionType.NONE));
    }

    private ToolsPanelSupport() {
    }

    static {
        cacheManager = (ToolsCacheManagerImpl)ToolsCacheManager.createInstance();
        listenerChanged = new WeakSet();
        listenerModified = new WeakSet();
        listenerIsChanged = new WeakSet();
        codeAssistanceChanged = new WeakSet();
    }

    private static final class CompilerSetAction
    implements Runnable {
        private final CompilerSetManagerImpl compilerSetManager;
        private final CompilerSet compilerSet;
        private final CompilerSetActionType action;

        public CompilerSetAction(CompilerSetManagerImpl compilerSetManager, CompilerSet compilerSet, CompilerSetActionType action) {
            this.compilerSetManager = compilerSetManager;
            this.compilerSet = compilerSet;
            this.action = action;
        }

        @Override
        public void run() {
            switch (this.action) {
                case ADD: {
                    this.compilerSetManager.add(this.compilerSet);
                    break;
                }
                case REMOVE: {
                    this.compilerSetManager.remove(this.compilerSetManager.getCompilerSet(this.compilerSet.getName()));
                    break;
                }
                case SET_DEFAULT: {
                    this.compilerSetManager.setDefault(this.compilerSetManager.getCompilerSet(this.compilerSet.getName()));
                }
            }
            cacheManager.applyChanges(null);
        }
    }

    private static enum CompilerSetActionType {
        NONE,
        ADD,
        REMOVE,
        SET_DEFAULT;

    }
}

