/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.ejb.cmp3.metadata.tables;

import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataLogger;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.columns.MetadataJoinColumns;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.tables.MetadataTable;

public class MetadataJoinTable
extends MetadataTable {
    private JoinColumn[] m_joinColumns = new JoinColumn[0];
    private JoinColumn[] m_inverseJoinColumns = new JoinColumn[0];
    protected MetadataJoinColumns m_jColumns;
    protected MetadataJoinColumns m_inverseJColumns;

    public MetadataJoinTable(MetadataLogger logger) {
        super(logger);
    }

    public MetadataJoinTable(JoinTable joinTable, MetadataLogger logger) {
        this(logger);
        if (joinTable != null) {
            this.m_name = joinTable.name();
            this.m_schema = joinTable.schema();
            this.m_catalog = joinTable.catalog();
            this.m_joinColumns = joinTable.joinColumns();
            this.m_inverseJoinColumns = joinTable.inverseJoinColumns();
            this.processName();
            this.processUniqueConstraints(joinTable.uniqueConstraints());
        }
    }

    public String getCatalogContext() {
        return "metadata_default_join_table_catalog";
    }

    public MetadataJoinColumns getInverseJoinColumns() {
        if (this.m_inverseJColumns == null) {
            this.m_inverseJColumns = this.processInverseJoinColumns();
        }
        return this.m_inverseJColumns;
    }

    public MetadataJoinColumns getJoinColumns() {
        if (this.m_jColumns == null) {
            this.m_jColumns = this.processJoinColumns();
        }
        return this.m_jColumns;
    }

    public String getNameContext() {
        return "metadata_default_join_table_name";
    }

    public String getSchemaContext() {
        return "metadata_default_join_table_schema";
    }

    public boolean loadedFromXML() {
        return false;
    }

    protected MetadataJoinColumns processInverseJoinColumns() {
        return new MetadataJoinColumns(this.m_inverseJoinColumns);
    }

    protected MetadataJoinColumns processJoinColumns() {
        return new MetadataJoinColumns(this.m_joinColumns);
    }
}

