/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.catalog;

import java.beans.IntrospectionException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import javax.swing.Action;
import org.netbeans.modules.xml.catalog.CatalogEntry;
import org.netbeans.modules.xml.catalog.lib.URLEnvironment;
import org.netbeans.modules.xml.catalog.spi.CatalogReader;
import org.netbeans.modules.xml.catalog.spi.CatalogWriter;
import org.netbeans.modules.xml.catalog.user.UserXMLCatalog;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.actions.DeleteAction;
import org.openide.actions.EditAction;
import org.openide.actions.PropertiesAction;
import org.openide.actions.ViewAction;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.ViewCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.SaveAsCapable;
import org.openide.nodes.BeanNode;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditor;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.windows.CloneableOpenSupport;

final class CatalogEntryNode
extends BeanNode
implements EditCookie,
Node.Cookie {
    private transient ViewCookie myView;
    private boolean isCatalogWriter;
    private CatalogReader catalogReader;

    public CatalogEntryNode(CatalogEntry entry) throws IntrospectionException {
        super((Object)entry);
        this.getCookieSet().add((Node.Cookie)this);
        this.catalogReader = entry.getCatalog();
        if (this.catalogReader instanceof CatalogWriter) {
            this.isCatalogWriter = true;
        }
    }

    public boolean isCatalogWriter() {
        return this.isCatalogWriter;
    }

    public Action getPreferredAction() {
        if (this.isCatalogWriter) {
            return SystemAction.get(EditAction.class);
        }
        return SystemAction.get(ViewAction.class);
    }

    public void edit() {
        UserXMLCatalog catalog = (UserXMLCatalog)this.getCatalogReader();
        try {
            DataObject obj;
            EditCookie editCookie;
            URI uri = new URI(this.getSystemID());
            File file = new File(uri);
            FileObject fo = FileUtil.toFileObject((File)file);
            boolean editPossible = false;
            if (fo != null && (editCookie = (EditCookie)(obj = DataObject.find((FileObject)fo)).getCookie(EditCookie.class)) != null) {
                editPossible = true;
                editCookie.edit();
            }
            if (!editPossible) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(CatalogEntryNode.class, (String)"MSG_CannotOpenURI", (Object)this.getSystemID()), 1));
            }
        }
        catch (Throwable ex) {
            ErrorManager.getDefault().notify(ex);
        }
    }

    private CatalogReader getCatalogReader() {
        return this.catalogReader;
    }

    public Action[] getActions(boolean context) {
        if (this.isCatalogWriter) {
            return new Action[]{SystemAction.get(EditAction.class), SystemAction.get(DeleteAction.class), null, SystemAction.get(PropertiesAction.class)};
        }
        return new Action[]{SystemAction.get(ViewAction.class), null, SystemAction.get(PropertiesAction.class)};
    }

    public Node.Cookie getCookie(Class clazz) {
        if (ViewCookie.class.equals((Object)clazz)) {
            return this.getViewCookie();
        }
        if (SaveAsCapable.class.equals((Object)clazz)) {
            return new MySaveAsCookie();
        }
        if (InputStream.class.equals((Object)clazz)) {
            return new MyInputStreamCookie();
        }
        return super.getCookie(clazz);
    }

    private ViewCookie getViewCookie() {
        String sys = this.getSystemID();
        if (sys == null) {
            return null;
        }
        if (this.myView == null) {
            ViewEnv env = new ViewEnv(this.getPublicID(), sys);
            this.myView = new ViewCookieImpl(env);
        }
        return this.myView;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    private String getPublicID() {
        return ((CatalogEntry)this.getBean()).getPublicID();
    }

    private String getSystemID() {
        return ((CatalogEntry)this.getBean()).getSystemID();
    }

    public String getShortDescription() {
        String displayName = this.getPublicID();
        if (displayName.startsWith("SCHEMA:")) {
            displayName = displayName.substring("SCHEMA:".length());
        }
        return displayName;
    }

    public void destroy() throws IOException {
        super.destroy();
        if (this.isCatalogWriter) {
            CatalogWriter catalogWriter = (CatalogWriter)((Object)((CatalogEntry)this.getBean()).getCatalog());
            catalogWriter.registerCatalogEntry(this.getPublicID(), null);
        }
    }

    private class ViewEnv
    extends URLEnvironment {
        private static final long serialVersionUID = -5031004511063404433L;

        ViewEnv(String publicId, String systemId) {
            super(publicId, systemId);
        }

        public CloneableOpenSupport findCloneableOpenSupport() {
            return (ViewCookieImpl)CatalogEntryNode.this.getCookie(ViewCookieImpl.class);
        }
    }

    private class ViewCookieImpl
    extends CloneableEditorSupport
    implements EditorCookie,
    ViewCookie {
        ViewCookieImpl(CloneableEditorSupport.Env env) {
            super(env);
        }

        protected String messageName() {
            return NbBundle.getMessage(CatalogEntryNode.class, (String)"MSG_opened_entity", (Object)CatalogEntryNode.this.getPublicID());
        }

        protected String messageSave() {
            return NbBundle.getMessage(CatalogEntryNode.class, (String)"MSG_ENTITY_SAVE", (Object)CatalogEntryNode.this.getPublicID());
        }

        protected String messageToolTip() {
            String publicID = CatalogEntryNode.this.getPublicID();
            if (publicID.startsWith("SCHEMA:")) {
                publicID = publicID.substring("SCHEMA:".length());
            }
            return publicID;
        }

        protected String messageOpening() {
            return NbBundle.getMessage(CatalogEntryNode.class, (String)"MSG_ENTITY_OPENING", (Object)CatalogEntryNode.this.getPublicID());
        }

        protected String messageOpened() {
            return NbBundle.getMessage(CatalogEntryNode.class, (String)"MSG_ENTITY_OPENED", (Object)CatalogEntryNode.this.getPublicID());
        }

        protected CloneableEditor createCloneableEditor() {
            CloneableEditor editor = new CloneableEditor(this){

                public int getPersistenceType() {
                    return 2;
                }
            };
            editor.setActivatedNodes(new Node[]{CatalogEntryNode.this});
            return editor;
        }
    }

    private class MyInputStreamCookie
    extends InputStream
    implements Node.Cookie {
        private InputStream myInputStream;

        private MyInputStreamCookie() {
            try {
                this.myInputStream = new URL(CatalogEntryNode.this.getSystemID()).openStream();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public int available() throws IOException {
            return this.myInputStream.available();
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.myInputStream.read(b);
        }

        @Override
        public int read() throws IOException {
            return this.myInputStream.read();
        }

        @Override
        public synchronized void reset() throws IOException {
            this.myInputStream.reset();
        }
    }

    private class MySaveAsCookie
    implements Node.Cookie,
    SaveAsCapable {
        private MySaveAsCookie() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void saveAs(FileObject folder, String fileName) throws IOException {
            FileObject newFile = folder.getFileObject(fileName);
            if (newFile == null) {
                newFile = FileUtil.createData((FileObject)folder, (String)fileName);
            }
            OutputStream output = newFile.getOutputStream();
            InputStream input = new URL(CatalogEntryNode.this.getSystemID()).openStream();
            try {
                byte[] buffer = new byte[4096];
                while (input.available() > 0) {
                    output.write(buffer, 0, input.read(buffer));
                }
            }
            finally {
                input.close();
                output.close();
            }
        }
    }
}

