/*
 * Decompiled with CFR 0.152.
 */
package org.openidex.search;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openidex.search.FileObjectFilter;
import org.openidex.search.SearchInfo;
import org.openidex.search.SimpleSearchIterator;
import org.openidex.search.Utils;

class SimpleSearchInfo
implements SearchInfo.Files {
    static final SearchInfo.Files EMPTY_SEARCH_INFO = new SearchInfo.Files(){

        @Override
        public boolean canSearch() {
            return true;
        }

        @Override
        public Iterator<DataObject> objectsToSearch() {
            return Collections.emptyList().iterator();
        }

        @Override
        public Iterator<FileObject> filesToSearch() {
            return Collections.emptyList().iterator();
        }
    };
    private final DataFolder rootFolder;
    private final boolean recursive;
    private final FileObjectFilter[] filters;

    SimpleSearchInfo(DataFolder folder, boolean recursive, FileObjectFilter[] filters) {
        if (folder == null) {
            throw new IllegalArgumentException();
        }
        if (filters != null && filters.length == 0) {
            filters = null;
        }
        this.rootFolder = folder;
        this.recursive = recursive;
        this.filters = filters;
    }

    @Override
    public boolean canSearch() {
        return this.filters != null ? this.checkFolderAgainstFilters(this.rootFolder.getPrimaryFile()) : true;
    }

    @Override
    public Iterator<DataObject> objectsToSearch() {
        return Utils.toDataObjectIterator(this.filesToSearch());
    }

    @Override
    public Iterator<FileObject> filesToSearch() {
        return new SimpleSearchIterator(this.rootFolder, this.recursive, this.filters != null ? Arrays.asList(this.filters) : null);
    }

    private boolean checkFolderAgainstFilters(FileObject folder) {
        assert (folder.isFolder());
        for (int i = 0; i < this.filters.length; ++i) {
            if (this.filters[i].traverseFolder(folder) != 0) continue;
            return false;
        }
        return true;
    }
}

