/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.ModuleFactory;
import org.openide.util.Enumerations;
import org.openide.util.Lookup;

public class ProxyClassLoader
extends ClassLoader {
    private static final Logger LOGGER = Logger.getLogger(ProxyClassLoader.class.getName());
    private static final boolean LOG_LOADING;
    private static final ClassLoader TOP_CL;
    private final Map<String, Package> packages = new HashMap<String, Package>();
    private ProxyClassLoader[] parents;
    private final boolean transitive;
    private ClassLoader systemCL = TOP_CL;
    private static final Map<String, Set<ProxyClassLoader>> packageCoverage;
    private Set<ProxyClassLoader> parentSet = new HashSet<ProxyClassLoader>();
    private static Map<String, Boolean> sclPackages;
    private static final Set<String> arbitraryLoadWarnings;

    public ProxyClassLoader(ClassLoader[] parents, boolean transitive) {
        super(TOP_CL);
        this.transitive = transitive;
        this.parents = this.coalesceParents(parents);
        this.parentSet.addAll(Arrays.asList(this.parents));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void addCoveredPackages(Iterable<String> coveredPackages) {
        Map<String, Set<ProxyClassLoader>> map = packageCoverage;
        synchronized (map) {
            for (String pkg : coveredPackages) {
                Set<ProxyClassLoader> delegates = packageCoverage.get(pkg);
                if (delegates == null) {
                    delegates = Collections.singleton(this);
                    packageCoverage.put(pkg, delegates);
                    continue;
                }
                if (delegates.size() == 1) {
                    delegates = new HashSet<ProxyClassLoader>(delegates);
                    packageCoverage.put(pkg, delegates);
                    delegates.add(this);
                    continue;
                }
                delegates.add(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(ClassLoader[] nueparents) throws IllegalArgumentException {
        if (nueparents == null) {
            throw new IllegalArgumentException("null parents array");
        }
        for (ClassLoader cl : nueparents) {
            if (cl != null) continue;
            throw new IllegalArgumentException("null parent: " + Arrays.asList(nueparents));
        }
        ProxyClassLoader[] resParents = null;
        ModuleFactory moduleFactory = (ModuleFactory)Lookup.getDefault().lookup(ModuleFactory.class);
        if (moduleFactory != null && moduleFactory.removeBaseClassLoader()) {
            this.systemCL = ClassLoader.getSystemClassLoader();
            resParents = this.coalesceAppend(new ProxyClassLoader[0], nueparents);
        } else {
            resParents = this.coalesceAppend(this.parents, nueparents);
        }
        ProxyClassLoader proxyClassLoader = this;
        synchronized (proxyClassLoader) {
            this.parents = resParents;
            this.parentSet.clear();
            this.parentSet.addAll(Arrays.asList(this.parents));
        }
    }

    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (LOG_LOADING && !name.startsWith("java.")) {
            LOGGER.log(Level.FINEST, "{0} initiated loading of {1}", new Object[]{this, name});
        }
        Class cls = null;
        int last = name.lastIndexOf(46);
        if (last == -1) {
            throw new ClassNotFoundException("Will not load classes from default package (" + name + ")");
        }
        String pkg = last >= 0 ? name.substring(0, last) : "";
        String path = pkg.replace('.', '/') + "/";
        Set<ProxyClassLoader> del = packageCoverage.get(pkg);
        Boolean boo = sclPackages.get(pkg);
        if ((boo == null || boo.booleanValue()) && this.shouldDelegateResource(path, null)) {
            try {
                cls = this.systemCL.loadClass(name);
                if (boo == null) {
                    sclPackages.put(pkg, true);
                }
                return cls;
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        if (del != null) {
            if (del.size() == 1) {
                ProxyClassLoader pcl = del.iterator().next();
                if ((pcl == this || this.parentSet.contains(pcl) && this.shouldDelegateResource(path, pcl)) && (cls = pcl.selfLoadClass(pkg, name)) != null) {
                    sclPackages.put(pkg, false);
                }
            } else {
                for (ProxyClassLoader pcl : this.parents) {
                    Class _cls;
                    if (!del.contains(pcl) || !this.shouldDelegateResource(path, pcl) || (_cls = pcl.selfLoadClass(pkg, name)) == null) continue;
                    if (cls == null) {
                        cls = _cls;
                        continue;
                    }
                    if (cls == _cls) continue;
                    String message = "Will not load class " + name + " arbitrarily from one of " + cls.getClassLoader() + " and " + pcl + " starting from " + this + "; see http://wiki.netbeans.org/DevFaqModuleCCE";
                    ClassNotFoundException cnfe = new ClassNotFoundException(message);
                    if (arbitraryLoadWarnings.add(message)) {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.log(Level.FINE, null, cnfe);
                        } else {
                            LOGGER.warning(message);
                        }
                    }
                    throw cnfe;
                }
                if (cls == null && del.contains(this)) {
                    cls = this.selfLoadClass(pkg, name);
                }
                if (cls != null) {
                    sclPackages.put(pkg, false);
                }
            }
        }
        if (cls == null && this.shouldDelegateResource(path, null)) {
            try {
                cls = this.systemCL.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                throw new ClassNotFoundException(this.diagnosticCNFEMessage(e.getMessage(), del), e);
            }
        }
        if (cls == null) {
            throw new ClassNotFoundException(this.diagnosticCNFEMessage(name, del));
        }
        if (resolve) {
            this.resolveClass(cls);
        }
        return cls;
    }

    private String diagnosticCNFEMessage(String base, Set<ProxyClassLoader> del) {
        String parentSetS;
        int size = this.parentSet.size();
        if (size <= 10) {
            parentSetS = this.parentSet.toString();
        } else {
            StringBuilder b = new StringBuilder();
            Iterator<ProxyClassLoader> parentSetI = this.parentSet.iterator();
            for (int i = 0; i < 10; ++i) {
                b.append(i == 0 ? "[" : ", ");
                b.append(parentSetI.next());
            }
            b.append(", ...").append(size - 10).append(" more]");
            parentSetS = b.toString();
        }
        return base + " starting from " + this + " with possible defining loaders " + del + " and declared parents " + parentSetS;
    }

    private synchronized Class selfLoadClass(String pkg, String name) {
        Class cls = this.findLoadedClass(name);
        if (cls == null) {
            try {
                cls = this.doLoadClass(pkg, name);
            }
            catch (NoClassDefFoundError e) {
                throw (NoClassDefFoundError)new NoClassDefFoundError(e.getMessage() + " while loading " + name + "; see http://wiki.netbeans.org/DevFaqTroubleshootClassNotFound").initCause(e);
            }
            if (LOG_LOADING && !name.startsWith("java.")) {
                LOGGER.log(Level.FINEST, "{0} loaded {1}", new Object[]{this, name});
            }
        }
        return cls;
    }

    protected Class doLoadClass(String pkg, String name) {
        return null;
    }

    private String stripInitialSlash(String resource) {
        if (resource.startsWith("/")) {
            LOGGER.log(Level.WARNING, "Should not use initial '/' in calls to ClassLoader.getResource(s): {0}", resource);
            return resource.substring(1);
        }
        return resource;
    }

    @Override
    public final URL getResource(String name) {
        return this.getResourceImpl(name);
    }

    URL getResourceImpl(String name) {
        URL u;
        URL url = null;
        int last = (name = this.stripInitialSlash(name)).lastIndexOf(47);
        String pkg = last >= 0 ? name.substring(0, last).replace('/', '.') : "";
        String path = name.substring(0, last + 1);
        Boolean systemPackage = sclPackages.get(pkg);
        if ((systemPackage == null || systemPackage.booleanValue()) && this.shouldDelegateResource(path, null) && (u = this.systemCL.getResource(name)) != null) {
            if (systemPackage == null) {
                sclPackages.put(pkg, true);
            }
            return u;
        }
        Set<ProxyClassLoader> del = packageCoverage.get(pkg);
        if (del == null) {
            if (this.shouldDelegateResource(path, null)) {
                url = this.systemCL.getResource(name);
            }
        } else if (del.size() == 1) {
            ProxyClassLoader pcl = del.iterator().next();
            if (pcl == this || this.parentSet.contains(pcl) && this.shouldDelegateResource(path, pcl)) {
                url = pcl.findResource(name);
            }
        } else {
            ProxyClassLoader pcl;
            ProxyClassLoader[] arr$ = this.parents;
            int len$ = arr$.length;
            for (int i$ = 0; !(i$ >= len$ || del.contains(pcl = arr$[i$]) && this.shouldDelegateResource(path, pcl) && (url = pcl.findResource(name)) != null); ++i$) {
            }
            if (url == null && del.contains(this)) {
                url = this.findResource(name);
            }
        }
        if (url == null && this.shouldDelegateResource(path, null)) {
            url = this.systemCL.getResource(name);
        }
        return url;
    }

    @Override
    public URL findResource(String name) {
        return super.findResource(name);
    }

    @Override
    public final Enumeration<URL> getResources(String name) throws IOException {
        return this.getResourcesImpl(name);
    }

    synchronized Enumeration<URL> getResourcesImpl(String name) throws IOException {
        Set<ProxyClassLoader> del;
        name = this.stripInitialSlash(name);
        int slashIdx = name.lastIndexOf(47);
        String path = name.substring(0, slashIdx + 1);
        String pkg = name.startsWith("META-INF/") ? name.substring(8) : (slashIdx >= 0 ? name.substring(0, slashIdx).replace('/', '.') : "");
        ArrayList<Enumeration<URL>> sub = new ArrayList<Enumeration<URL>>();
        if (this.shouldDelegateResource(path, null)) {
            sub.add(this.systemCL.getResources(name));
        }
        if ((del = packageCoverage.get(pkg)) != null) {
            for (ProxyClassLoader pcl : this.parents) {
                if (!del.contains(pcl) || !this.shouldDelegateResource(path, pcl)) continue;
                sub.add(pcl.findResources(name));
            }
            if (del.contains(this)) {
                sub.add(this.findResources(name));
            }
        }
        return Enumerations.concat(Collections.enumeration(sub));
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        return super.findResources(name);
    }

    @Override
    protected Package getPackage(String name) {
        return this.getPackageFast(name, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Package getPackageFast(String name, boolean recurse) {
        Map<String, Package> map = this.packages;
        synchronized (map) {
            ProxyClassLoader par;
            Package pkg = this.packages.get(name);
            if (pkg != null) {
                return pkg;
            }
            if (!recurse) {
                return null;
            }
            for (int i = 0; i < this.parents.length && (pkg = (par = this.parents[i]).getPackageFast(name, false)) == null; ++i) {
            }
            if (pkg == null) {
                pkg = super.getPackage(name);
            }
            if (pkg != null) {
                this.packages.put(name, pkg);
            }
            return pkg;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Package definePackage(String name, String specTitle, String specVersion, String specVendor, String implTitle, String implVersion, String implVendor, URL sealBase) throws IllegalArgumentException {
        Map<String, Package> map = this.packages;
        synchronized (map) {
            Package pkg = super.definePackage(name, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, sealBase);
            this.packages.put(name, pkg);
            return pkg;
        }
    }

    @Override
    protected synchronized Package[] getPackages() {
        return this.getPackages(new HashSet<ClassLoader>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Package[] getPackages(Set<ClassLoader> addedParents) {
        HashMap<String, Package> all = new HashMap<String, Package>();
        this.addPackages(all, super.getPackages());
        for (int i = 0; i < this.parents.length; ++i) {
            ProxyClassLoader par = this.parents[i];
            if (!(par instanceof ProxyClassLoader) || !addedParents.add(par)) continue;
            this.addPackages(all, par.getPackages(addedParents));
        }
        Map<String, Package> map = this.packages;
        synchronized (map) {
            all.keySet().removeAll(this.packages.keySet());
            this.packages.putAll(all);
        }
        return this.packages.values().toArray(new Package[this.packages.size()]);
    }

    private ProxyClassLoader[] coalesceParents(ClassLoader[] loaders) throws IllegalArgumentException {
        return this.coalesceAppend(new ProxyClassLoader[0], loaders);
    }

    private ProxyClassLoader[] coalesceAppend(ProxyClassLoader[] existing, ClassLoader[] appended) throws IllegalArgumentException {
        int likelySize = existing.length + appended.length;
        LinkedHashSet<ClassLoader> uniq = new LinkedHashSet<ClassLoader>(likelySize);
        uniq.addAll(Arrays.asList(existing));
        if (uniq.containsAll(Arrays.asList(appended))) {
            return existing;
        }
        for (ClassLoader l : appended) {
            this.addRec(uniq, l);
        }
        boolean head = true;
        ArrayList<ProxyClassLoader> pcls = new ArrayList<ProxyClassLoader>(uniq.size());
        for (ClassLoader l : uniq) {
            if (head) {
                if (l instanceof ProxyClassLoader) {
                    head = false;
                    pcls.add((ProxyClassLoader)l);
                    continue;
                }
                if (ProxyClassLoader.isParentOf(this.systemCL, l)) {
                    this.systemCL = l;
                    continue;
                }
                throw new IllegalArgumentException("Bad ClassLoader ordering: " + Arrays.asList(appended));
            }
            if (l instanceof ProxyClassLoader) {
                pcls.add((ProxyClassLoader)l);
                continue;
            }
            throw new IllegalArgumentException("Bad ClassLoader ordering: " + Arrays.asList(appended));
        }
        ProxyClassLoader[] ret = pcls.toArray(new ProxyClassLoader[pcls.size()]);
        return ret;
    }

    private static boolean isParentOf(ClassLoader parent, ClassLoader child) {
        while (child != null) {
            if (child == parent) {
                return true;
            }
            child = child.getParent();
        }
        return false;
    }

    private void addRec(Set<ClassLoader> resultingUnique, ClassLoader loader) throws IllegalArgumentException {
        if (loader == this) {
            throw new IllegalArgumentException("cycle in parents");
        }
        if (resultingUnique.contains(loader)) {
            return;
        }
        if (loader instanceof ProxyClassLoader && ((ProxyClassLoader)loader).transitive) {
            for (ProxyClassLoader lpar : ((ProxyClassLoader)loader).parents) {
                this.addRec(resultingUnique, lpar);
            }
        }
        resultingUnique.add(loader);
    }

    private void addPackages(Map<String, Package> all, Package[] pkgs) {
        for (int i = 0; i < pkgs.length; ++i) {
            all.put(pkgs[i].getName(), pkgs[i]);
        }
    }

    protected final void setSystemClassLoader(ClassLoader s) {
        this.systemCL = s;
    }

    protected boolean shouldDelegateResource(String pkg, ClassLoader parent) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Map<String, Set<ProxyClassLoader>> map = packageCoverage;
        synchronized (map) {
            Iterator<String> it = packageCoverage.keySet().iterator();
            while (it.hasNext()) {
                String pkg = it.next();
                Set<ProxyClassLoader> set = packageCoverage.get(pkg);
                if (set.contains(this) && set.size() == 1) {
                    it.remove();
                    continue;
                }
                set.remove(this);
            }
        }
    }

    final ClassLoader firstParent() {
        if (this.parents == null || this.parents.length == 0) {
            return null;
        }
        return this.parents[0];
    }

    static {
        TOP_CL = ProxyClassLoader.class.getClassLoader();
        boolean prop1 = System.getProperty("org.netbeans.ProxyClassLoader.level") != null;
        LOG_LOADING = prop1 || LOGGER.isLoggable(Level.FINE);
        packageCoverage = new HashMap<String, Set<ProxyClassLoader>>();
        sclPackages = Collections.synchronizedMap(new HashMap());
        arbitraryLoadWarnings = Collections.synchronizedSet(new HashSet());
    }
}

