/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.spi;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.logging.Level;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.remote.spi.FileSystemProviderImplementation;
import org.netbeans.modules.remote.support.RemoteLogger;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Parameters;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileSystemProvider {
    private static final Collection<? extends FileSystemProviderImplementation> ALL_PROVIDERS = Lookup.getDefault().lookupAll(FileSystemProviderImplementation.class);

    private FileSystemProvider() {
    }

    public static FileSystem getFileSystem(ExecutionEnvironment env) {
        return FileSystemProvider.getFileSystem(env, "/");
    }

    public static ExecutionEnvironment getExecutionEnvironment(FileSystem fileSystem) {
        for (FileSystemProviderImplementation fileSystemProviderImplementation : ALL_PROVIDERS) {
            if (!fileSystemProviderImplementation.isMine(fileSystem)) continue;
            return fileSystemProviderImplementation.getExecutionEnvironment(fileSystem);
        }
        return ExecutionEnvironmentFactory.getLocal();
    }

    public static ExecutionEnvironment getExecutionEnvironment(FileObject fileObject) {
        try {
            return FileSystemProvider.getExecutionEnvironment(fileObject.getFileSystem());
        }
        catch (FileStateInvalidException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return ExecutionEnvironmentFactory.getLocal();
        }
    }

    public static FileSystem getFileSystem(ExecutionEnvironment env, String root) {
        for (FileSystemProviderImplementation fileSystemProviderImplementation : ALL_PROVIDERS) {
            if (!fileSystemProviderImplementation.isMine(env)) continue;
            return fileSystemProviderImplementation.getFileSystem(env, root);
        }
        FileSystemProvider.noProvidersWarning(env);
        return null;
    }

    public static boolean waitWrites(ExecutionEnvironment env, Collection<FileObject> filesToWait, Collection<String> failedFiles) throws InterruptedException {
        for (FileSystemProviderImplementation fileSystemProviderImplementation : ALL_PROVIDERS) {
            if (!fileSystemProviderImplementation.isMine(env)) continue;
            return fileSystemProviderImplementation.waitWrites(env, filesToWait, failedFiles);
        }
        FileSystemProvider.noProvidersWarning(env);
        return true;
    }

    public static boolean waitWrites(ExecutionEnvironment env, Collection<String> failedFiles) throws InterruptedException {
        for (FileSystemProviderImplementation fileSystemProviderImplementation : ALL_PROVIDERS) {
            if (!fileSystemProviderImplementation.isMine(env)) continue;
            return fileSystemProviderImplementation.waitWrites(env, failedFiles);
        }
        FileSystemProvider.noProvidersWarning(env);
        return true;
    }

    public static String normalizeAbsolutePath(String absPath, ExecutionEnvironment env) {
        for (FileSystemProviderImplementation fileSystemProviderImplementation : ALL_PROVIDERS) {
            if (!fileSystemProviderImplementation.isMine(env)) continue;
            return fileSystemProviderImplementation.normalizeAbsolutePath(absPath, env);
        }
        FileSystemProvider.noProvidersWarning(env);
        return FileUtil.normalizePath((String)absPath);
    }

    public static String normalizeAbsolutePath(String absPath, FileSystem fileSystem) {
        for (FileSystemProviderImplementation fileSystemProviderImplementation : ALL_PROVIDERS) {
            if (!fileSystemProviderImplementation.isMine(fileSystem)) continue;
            return fileSystemProviderImplementation.normalizeAbsolutePath(absPath, fileSystem);
        }
        FileSystemProvider.noProvidersWarning(fileSystem);
        return FileUtil.normalizePath((String)absPath);
    }

    public static FileObject getFileObject(FileObject baseFileObject, String relativeOrAbsolutePath) {
        for (FileSystemProviderImplementation fileSystemProviderImplementation : ALL_PROVIDERS) {
            if (!fileSystemProviderImplementation.isMine(baseFileObject)) continue;
            return fileSystemProviderImplementation.getFileObject(baseFileObject, relativeOrAbsolutePath);
        }
        FileSystemProvider.noProvidersWarning(baseFileObject);
        if (FileSystemProvider.isAbsolute(relativeOrAbsolutePath)) {
            try {
                return baseFileObject.getFileSystem().findResource(relativeOrAbsolutePath);
            }
            catch (FileStateInvalidException ex) {
                return null;
            }
        }
        return baseFileObject.getFileObject(relativeOrAbsolutePath);
    }

    public static FileObject getFileObject(ExecutionEnvironment env, String absPath) {
        for (FileSystemProviderImplementation fileSystemProviderImplementation : ALL_PROVIDERS) {
            if (!fileSystemProviderImplementation.isMine(env)) continue;
            return fileSystemProviderImplementation.getFileSystem(env, "/").findResource(absPath);
        }
        FileSystemProvider.noProvidersWarning(env);
        return FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(absPath)));
    }

    public static FileObject getCanonicalFileObject(FileObject fileObject) throws IOException {
        for (FileSystemProviderImplementation fileSystemProviderImplementation : ALL_PROVIDERS) {
            if (!fileSystemProviderImplementation.isMine(fileObject)) continue;
            return fileSystemProviderImplementation.getCanonicalFileObject(fileObject);
        }
        FileSystemProvider.noProvidersWarning(fileObject);
        return fileObject;
    }

    public static String getCanonicalPath(FileObject fileObject) throws IOException {
        for (FileSystemProviderImplementation fileSystemProviderImplementation : ALL_PROVIDERS) {
            if (!fileSystemProviderImplementation.isMine(fileObject)) continue;
            return fileSystemProviderImplementation.getCanonicalPath(fileObject);
        }
        FileSystemProvider.noProvidersWarning(fileObject);
        return fileObject.getPath();
    }

    public static String getCanonicalPath(FileSystem fileSystem, String absPath) throws IOException {
        for (FileSystemProviderImplementation fileSystemProviderImplementation : ALL_PROVIDERS) {
            if (!fileSystemProviderImplementation.isMine(fileSystem)) continue;
            return fileSystemProviderImplementation.getCanonicalPath(fileSystem, absPath);
        }
        FileSystemProvider.noProvidersWarning(fileSystem);
        return absPath;
    }

    public static String getCanonicalPath(ExecutionEnvironment env, String absPath) throws IOException {
        for (FileSystemProviderImplementation fileSystemProviderImplementation : ALL_PROVIDERS) {
            if (!fileSystemProviderImplementation.isMine(env)) continue;
            return fileSystemProviderImplementation.getCanonicalPath(env, absPath);
        }
        FileSystemProvider.noProvidersWarning(env);
        return absPath;
    }

    public static boolean isAbsolute(ExecutionEnvironment env, String path) {
        for (FileSystemProviderImplementation fileSystemProviderImplementation : ALL_PROVIDERS) {
            if (!fileSystemProviderImplementation.isMine(env)) continue;
            return fileSystemProviderImplementation.isAbsolute(path);
        }
        return true;
    }

    public static boolean isAbsolute(String path) {
        if (path == null || path.length() == 0) {
            return false;
        }
        if (path.charAt(0) == '/') {
            return true;
        }
        if (path.charAt(0) == '\\') {
            return true;
        }
        return path.indexOf(58) == 1 && Utilities.isWindows();
    }

    public static FileObject fileToFileObject(File file) {
        Parameters.notNull((CharSequence)"file", (Object)file);
        for (FileSystemProviderImplementation fileSystemProviderImplementation : ALL_PROVIDERS) {
            if (!fileSystemProviderImplementation.isMine(file)) continue;
            return fileSystemProviderImplementation.fileToFileObject(file);
        }
        FileSystemProvider.noProvidersWarning(file);
        return FileUtil.toFileObject((File)file);
    }

    public static FileObject urlToFileObject(String url) {
        for (FileSystemProviderImplementation fileSystemProviderImplementation : ALL_PROVIDERS) {
            if (!fileSystemProviderImplementation.isMine(url)) continue;
            return fileSystemProviderImplementation.urlToFileObject(url);
        }
        FileSystemProvider.noProvidersWarning(url);
        return null;
    }

    public static String toUrl(FileSystem fileSystem, String absPath) {
        Parameters.notNull((CharSequence)"fileSystem", (Object)fileSystem);
        for (FileSystemProviderImplementation fileSystemProviderImplementation : ALL_PROVIDERS) {
            if (!fileSystemProviderImplementation.isMine(fileSystem)) continue;
            return fileSystemProviderImplementation.toURL(fileSystem, absPath);
        }
        FileSystemProvider.noProvidersWarning(fileSystem);
        return absPath;
    }

    public static String fileObjectToUrl(FileObject fileObject) {
        Parameters.notNull((CharSequence)"fileObject", (Object)fileObject);
        for (FileSystemProviderImplementation fileSystemProviderImplementation : ALL_PROVIDERS) {
            if (!fileSystemProviderImplementation.isMine(fileObject)) continue;
            return fileSystemProviderImplementation.toURL(fileObject);
        }
        FileSystemProvider.noProvidersWarning(fileObject);
        try {
            return fileObject.getURL().toExternalForm();
        }
        catch (FileStateInvalidException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    public static void addDownloadListener(DownloadListener listener) {
        for (FileSystemProviderImplementation fileSystemProviderImplementation : ALL_PROVIDERS) {
            fileSystemProviderImplementation.addDownloadListener(listener);
        }
    }

    public static void removeDownloadListener(DownloadListener listener) {
        for (FileSystemProviderImplementation fileSystemProviderImplementation : ALL_PROVIDERS) {
            fileSystemProviderImplementation.addDownloadListener(listener);
        }
    }

    public static void scheduleRefresh(FileObject fileObject) {
        Parameters.notNull((CharSequence)"fileObject", (Object)fileObject);
        for (FileSystemProviderImplementation fileSystemProviderImplementation : ALL_PROVIDERS) {
            if (!fileSystemProviderImplementation.isMine(fileObject)) continue;
            fileSystemProviderImplementation.scheduleRefresh(fileObject);
            return;
        }
        FileSystemProvider.noProvidersWarning(fileObject);
    }

    public static void scheduleRefresh(ExecutionEnvironment env, Collection<String> paths) {
        for (FileSystemProviderImplementation fileSystemProviderImplementation : ALL_PROVIDERS) {
            if (!fileSystemProviderImplementation.isMine(env)) continue;
            fileSystemProviderImplementation.scheduleRefresh(env, paths);
            return;
        }
        FileSystemProvider.noProvidersWarning(env);
    }

    private static void noProvidersWarning(Object object) {
        if (RemoteLogger.getInstance().isLoggable(Level.FINE)) {
            if (RemoteLogger.getInstance().isLoggable(Level.FINEST)) {
                String message = "No file system providers for " + object;
                RemoteLogger.getInstance().log(Level.FINEST, message, new Exception(message));
            } else {
                RemoteLogger.getInstance().log(Level.FINE, "No file system providers for {0}", object);
            }
        }
    }

    public static interface DownloadListener {
        public void postConnectDownloadFinished(ExecutionEnvironment var1);
    }
}

