/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.game;

import java.awt.BorderLayout;
import java.awt.Dialog;
import java.awt.Point;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.netbeans.modules.vmd.api.io.DataObjectContext;
import org.netbeans.modules.vmd.api.io.DesignDocumentAwareness;
import org.netbeans.modules.vmd.api.io.IOUtils;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.DesignEvent;
import org.netbeans.modules.vmd.api.model.DesignEventFilter;
import org.netbeans.modules.vmd.api.model.DesignListener;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.game.GameAccessController;
import org.netbeans.modules.vmd.game.GameEditorView;
import org.netbeans.modules.vmd.game.integration.components.GameTypes;
import org.netbeans.modules.vmd.game.model.AnimatedTile;
import org.netbeans.modules.vmd.game.model.AnimatedTileCD;
import org.netbeans.modules.vmd.game.model.GlobalRepository;
import org.netbeans.modules.vmd.game.model.GlobalRepositoryListener;
import org.netbeans.modules.vmd.game.model.Identifiable;
import org.netbeans.modules.vmd.game.model.ImageResource;
import org.netbeans.modules.vmd.game.model.ImageResourceCD;
import org.netbeans.modules.vmd.game.model.ImageResourceListener;
import org.netbeans.modules.vmd.game.model.Layer;
import org.netbeans.modules.vmd.game.model.Scene;
import org.netbeans.modules.vmd.game.model.SceneCD;
import org.netbeans.modules.vmd.game.model.SceneItemCD;
import org.netbeans.modules.vmd.game.model.SceneListener;
import org.netbeans.modules.vmd.game.model.Sequence;
import org.netbeans.modules.vmd.game.model.SequenceCD;
import org.netbeans.modules.vmd.game.model.SequenceContainer;
import org.netbeans.modules.vmd.game.model.SequenceContainerListener;
import org.netbeans.modules.vmd.game.model.SequenceListener;
import org.netbeans.modules.vmd.game.model.Sprite;
import org.netbeans.modules.vmd.game.model.SpriteCD;
import org.netbeans.modules.vmd.game.model.StaticTile;
import org.netbeans.modules.vmd.game.model.TiledLayer;
import org.netbeans.modules.vmd.game.model.TiledLayerCD;
import org.netbeans.modules.vmd.game.model.TiledLayerListener;
import org.netbeans.modules.vmd.game.nbdialog.SelectImageForLayerDialog;
import org.netbeans.modules.vmd.midp.components.MidpProjectSupport;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class GameController
implements DesignDocumentAwareness,
GlobalRepositoryListener,
SceneListener,
TiledLayerListener,
SequenceContainerListener,
SequenceListener,
ImageResourceListener,
PropertyChangeListener,
DesignListener {
    private static boolean DEBUG = false;
    private static boolean DEBUG_UNDO = false;
    private final Map<Long, String> changeMap = new HashMap<Long, String>();
    private final Map<Identifiable, DesignComponent> designIdMap = new HashMap<Identifiable, DesignComponent>();
    public static final String PROJECT_TYPE_GAME = "vmd-midp-game";
    private DataObjectContext context;
    private GameEditorView gameEditorView;
    private JComponent loadingPanel;
    private JPanel panel = new JPanel(new BorderLayout());
    private DesignDocument document;

    public GameController(DataObjectContext context, GameEditorView gameEditorView) {
        this.context = context;
        this.gameEditorView = gameEditorView;
        this.loadingPanel = IOUtils.createLoadingPanel();
        this.panel.add(this.loadingPanel);
        this.context.addDesignDocumentAwareness((DesignDocumentAwareness)this);
    }

    public JComponent getVisualRepresentation() {
        return this.panel;
    }

    public DesignDocument getDesignDocument() {
        return this.document;
    }

    public GlobalRepository getGameDesign() {
        final DesignDocument doc = this.getDesignDocument();
        if (doc == null) {
            return null;
        }
        final GlobalRepository[] gameDesign = new GlobalRepository[]{null};
        doc.getTransactionManager().readAccess(new Runnable(){

            @Override
            public void run() {
                GameAccessController controller = (GameAccessController)doc.getListenerManager().getAccessController(GameAccessController.class);
                gameDesign[0] = controller.getGameDesign();
            }
        });
        return gameDesign[0];
    }

    private DesignComponent getImageResourceDC(Set<DesignComponent> set) {
        for (DesignComponent designComponent : set) {
            if (designComponent == null || !designComponent.getType().equals((Object)ImageResourceCD.TYPEID)) continue;
            return designComponent;
        }
        return null;
    }

    public void designChanged(DesignEvent event) {
        if (DEBUG_UNDO) {
            System.out.println("GameController.designChanged() : " + event.getEventID());
        }
        for (DesignComponent designComponent : event.getCreatedComponents()) {
            this.modelComponent(designComponent);
        }
        DesignComponent imgResDC = null;
        DesignComponent root = this.document.getRootComponent();
        if (event.getFullyAffectedHierarchies().contains(root)) {
            this.refreshGameDesign(root, event);
        } else {
            imgResDC = this.getImageResourceDC(event.getFullyAffectedHierarchies());
            if (imgResDC != null) {
                this.refreshImageResource(imgResDC, event);
            } else {
                for (DesignComponent designComponent : event.getFullyAffectedComponents()) {
                    TypeID typeId = designComponent.getType();
                    assert (typeId != null);
                    if (DEBUG_UNDO) {
                        System.out.println("Affected ComponentID: " + designComponent.getComponentID() + ", type: " + designComponent.getType().getString());
                    }
                    if (typeId.equals((Object)SceneCD.TYPEID)) {
                        this.refreshScene(designComponent, event);
                        continue;
                    }
                    if (typeId.equals((Object)TiledLayerCD.TYPEID)) {
                        this.refreshTiledLayer(designComponent, event);
                        continue;
                    }
                    if (typeId.equals((Object)SpriteCD.TYPEID)) {
                        this.refreshSprite(designComponent, event);
                        continue;
                    }
                    if (typeId.equals((Object)SequenceCD.TYPEID)) {
                        this.refreshSequence(designComponent, event);
                        continue;
                    }
                    if (typeId.equals((Object)AnimatedTileCD.TYPEID)) {
                        this.refreshAnimatedTile(designComponent, event);
                        continue;
                    }
                    if (!DEBUG_UNDO) continue;
                    System.out.println("Currently not handling this in type in GameController.designChanged() typeId: " + typeId.getString());
                }
            }
        }
    }

    private void refreshGameDesign(DesignComponent designComponent, DesignEvent event) {
        boolean found;
        if (this.changeMap.remove(designComponent.getComponentID()) != null) {
            return;
        }
        this.getGameDesign().removeGlobalRepositoryListener(this);
        this.getGameDesign().removePropertyChangeListener(this);
        GlobalRepository globalRepo = this.getGameDesign();
        Collection dcChildren = designComponent.getComponents();
        HashSet<Identifiable> children = new HashSet<Identifiable>();
        children.addAll(globalRepo.getImageResources());
        children.addAll(globalRepo.getScenes());
        children.addAll(globalRepo.getSprites());
        children.addAll(globalRepo.getTiledLayers());
        for (DesignComponent dc : dcChildren) {
            found = false;
            for (Identifiable child : children) {
                if (dc.getComponentID() != child.getId()) continue;
                found = true;
                break;
            }
            if (found) continue;
            this.modelComponent(dc);
        }
        for (Identifiable child : children) {
            found = false;
            for (DesignComponent dc : dcChildren) {
                if (child.getId() != dc.getComponentID()) continue;
                found = true;
                break;
            }
            if (found) continue;
            globalRepo.removeIdentifiable(child.getId());
        }
        this.getGameDesign().addGlobalRepositoryListener(this);
        this.getGameDesign().addPropertyChangeListener(this);
        globalRepo.getMainView().requestEditing(globalRepo);
    }

    private void refreshScene(DesignComponent designComponent, DesignEvent event) {
        Scene scene = this.getGameDesign().getScene(designComponent.getComponentID());
        scene.removePropertyChangeListener(this);
        scene.removeSceneListener(this);
        if (event.isComponentPropertyChanged(designComponent, "scenecd.prop.name")) {
            if ("scenecd.prop.name".equals(this.changeMap.get(designComponent.getComponentID()))) {
                this.changeMap.remove(designComponent.getComponentID());
            } else {
                String name = (String)designComponent.readProperty("scenecd.prop.name").getPrimitiveValue();
                scene.setName(name);
            }
        } else if ("scenecd.prop.sceneitems".equals(this.changeMap.get(designComponent.getComponentID()))) {
            this.changeMap.remove(designComponent.getComponentID());
        } else {
            ArrayList<Layer> newLayers = new ArrayList<Layer>();
            List sceneItemsProps = designComponent.readProperty("scenecd.prop.sceneitems").getArray();
            for (PropertyValue sceneItemProp : sceneItemsProps) {
                DesignComponent sceneItemDC = sceneItemProp.getComponent();
                Point layerLocation = (Point)sceneItemDC.readProperty("sceneitemcd.prop.position").getPrimitiveValue();
                Boolean locked = (Boolean)sceneItemDC.readProperty("sceneitemcd.prop.lock").getPrimitiveValue();
                Boolean visible = (Boolean)sceneItemDC.readProperty("sceneitemcd.prop.visible").getPrimitiveValue();
                DesignComponent layerDC = sceneItemDC.readProperty("sceneitemcd.prop.layer").getComponent();
                int zOrder = (Integer)sceneItemDC.readProperty("sceneitemcd.prop.z.order").getPrimitiveValue();
                Layer layer = this.getGameDesign().getLayer(layerDC.getComponentID());
                newLayers.add(layer);
                if (!scene.contains(layer)) {
                    scene.append(layer);
                }
                scene.setLayerLocked(layer, false);
                scene.move(layer, zOrder);
                scene.setLayerPosition(layer, layerLocation, false);
                scene.setLayerVisible(layer, visible);
                scene.setLayerLocked(layer, locked);
            }
            ArrayList<Layer> origLayers = new ArrayList<Layer>(scene.getLayers());
            for (Layer origLayer : origLayers) {
                boolean found = false;
                for (Layer newLayer : newLayers) {
                    if (!origLayer.getName().equals(newLayer.getName())) continue;
                    found = true;
                }
                if (found) continue;
                scene.remove(origLayer);
            }
        }
        scene.addPropertyChangeListener(this);
        scene.addSceneListener(this);
        this.getGameDesign().getMainView().requestEditing(scene);
    }

    private void refreshLayerProperties(DesignComponent designComponent, DesignEvent event) {
        Layer layer = this.getGameDesign().getLayer(designComponent.getComponentID());
        if ("layercd.prop.name".equals(this.changeMap.get(designComponent.getComponentID()))) {
            this.changeMap.remove(designComponent.getComponentID());
        } else if (event.isComponentPropertyChanged(designComponent, "layercd.prop.name")) {
            String name = (String)designComponent.readProperty("layercd.prop.name").getPrimitiveValue();
            layer.setName(name);
        }
        if (event.isComponentPropertyChanged(designComponent, "layercd.prop.imageresource")) {
            // empty if block
        }
        if (event.isComponentPropertyChanged(designComponent, "layercd.prop.tile.width")) {
            // empty if block
        }
        if (event.isComponentPropertyChanged(designComponent, "layercd.prop.tile.height")) {
            // empty if block
        }
    }

    private void refreshTiledLayer(DesignComponent designComponent, DesignEvent event) {
        TiledLayer layer = (TiledLayer)this.getGameDesign().getLayer(designComponent.getComponentID());
        layer.removePropertyChangeListener(this);
        layer.removeTiledLayerListener(this);
        this.refreshLayerProperties(designComponent, event);
        if ("tiledlayercd.prop.tiles".equals(this.changeMap.get(designComponent.getComponentID()))) {
            this.changeMap.remove(designComponent.getComponentID());
        } else if (event.isComponentPropertyChanged(designComponent, "tiledlayercd.prop.tiles")) {
            int[][] grid = (int[][])designComponent.readProperty("tiledlayercd.prop.tiles").getPrimitiveValue();
            layer.setTiles(grid);
        }
        layer.addPropertyChangeListener(this);
        layer.addTiledLayerListener(this);
        this.getGameDesign().getMainView().requestEditing(layer);
    }

    private void refreshSprite(DesignComponent designComponent, DesignEvent event) {
        Sprite layer = (Sprite)this.getGameDesign().getLayer(designComponent.getComponentID());
        layer.removePropertyChangeListener(this);
        layer.removeSequenceContainerListener(this);
        this.refreshLayerProperties(designComponent, event);
        DesignComponent imgResDC = designComponent.readProperty("layercd.prop.imageresource").getComponent();
        ImageResource imgRes = this.getGameDesign().getImageResource(imgResDC.getComponentID());
        if ("sequencecontainer.prop.sequences".equals(this.changeMap.get(designComponent.getComponentID()))) {
            this.changeMap.remove(designComponent.getComponentID());
        } else if (event.isComponentPropertyChanged(designComponent, "sequencecontainer.prop.sequences")) {
            List sequenceDCs = designComponent.readProperty("sequencecontainer.prop.sequences").getArray();
            List<Sequence> oldSequences = layer.getSequences();
            ArrayList<Sequence> newSequences = new ArrayList<Sequence>();
            for (PropertyValue propertyValue : sequenceDCs) {
                DesignComponent sequenceDC = propertyValue.getComponent();
                Sequence sequence = (Sequence)this.findIdentifiable(sequenceDC.getComponentID());
                assert (sequence != null);
                newSequences.add(sequence);
                if (oldSequences.contains(sequence)) continue;
                layer.append(sequence);
            }
            ArrayList<Sequence> iterOldSequences = new ArrayList<Sequence>(layer.getSequences());
            for (Sequence sequence : iterOldSequences) {
                if (newSequences.contains(sequence)) continue;
                if (DEBUG_UNDO) {
                    System.out.println("remove seq: " + sequence + " from sprite: " + layer);
                }
                layer.remove(sequence);
            }
        }
        if ("sequencecontainer.prop.defaultsequence".equals(this.changeMap.get(designComponent.getComponentID()))) {
            this.changeMap.remove(designComponent.getComponentID());
        } else if (event.isComponentPropertyChanged(designComponent, "sequencecontainer.prop.defaultsequence")) {
            DesignComponent defaultSequenceDC = designComponent.readProperty("sequencecontainer.prop.defaultsequence").getComponent();
            Sequence defSeq = imgRes.getSequence(defaultSequenceDC.getComponentID());
            layer.setDefaultSequence(defSeq);
        }
        layer.addPropertyChangeListener(this);
        layer.addSequenceContainerListener(this);
        this.getGameDesign().getMainView().requestEditing(layer);
    }

    private void refreshAnimatedTile(DesignComponent designComponent, DesignEvent event) {
        DesignComponent imgResDC = designComponent.readProperty("animatedtilecd.prop.imageresource").getComponent();
        if (imgResDC == null) {
            return;
        }
        ImageResource imgRes = this.getGameDesign().getImageResource(imgResDC.getComponentID());
        AnimatedTile animTile = imgRes.getAnimatedTile(designComponent.getComponentID());
        animTile.removePropertyChangeListener(this);
        animTile.removeSequenceContainerListener(this);
        if ("animatedtilecd.prop.name".equals(this.changeMap.get(designComponent.getComponentID()))) {
            this.changeMap.remove(designComponent.getComponentID());
        } else if (event.isComponentPropertyChanged(designComponent, "animatedtilecd.prop.name")) {
            String name = (String)designComponent.readProperty("animatedtilecd.prop.name").getPrimitiveValue();
            animTile.setName(name);
        }
        if ("sequencecontainer.prop.sequences".equals(this.changeMap.get(designComponent.getComponentID()))) {
            this.changeMap.remove(designComponent.getComponentID());
        } else if (event.isComponentPropertyChanged(designComponent, "sequencecontainer.prop.sequences")) {
            List sequenceDCs = designComponent.readProperty("sequencecontainer.prop.sequences").getArray();
            List<Sequence> sequences = animTile.getSequences();
            ArrayList<Sequence> newSequences = new ArrayList<Sequence>();
            for (PropertyValue propertyValue : sequenceDCs) {
                DesignComponent sequenceDC = propertyValue.getComponent();
                Sequence sequence = imgRes.getSequence(sequenceDC.getComponentID());
                newSequences.add(sequence);
                if (sequences.contains(sequence)) continue;
                animTile.append(sequence);
            }
            ArrayList<Sequence> iterOldSequences = new ArrayList<Sequence>(animTile.getSequences());
            for (Sequence sequence : iterOldSequences) {
                if (newSequences.contains(sequence)) continue;
                animTile.remove(sequence);
            }
        }
        if ("sequencecontainer.prop.defaultsequence".equals(this.changeMap.get(designComponent.getComponentID()))) {
            this.changeMap.remove(designComponent.getComponentID());
        } else if (event.isComponentPropertyChanged(designComponent, "sequencecontainer.prop.defaultsequence")) {
            DesignComponent defaultSequenceDC = designComponent.readProperty("sequencecontainer.prop.defaultsequence").getComponent();
            Sequence defSeq = imgRes.getSequence(defaultSequenceDC.getComponentID());
            animTile.setDefaultSequence(defSeq);
        }
        animTile.addPropertyChangeListener(this);
        animTile.addSequenceContainerListener(this);
        this.getGameDesign().getMainView().requestEditing(animTile);
    }

    private Identifiable findIdentifiable(long id) {
        for (Identifiable identifiable : this.designIdMap.keySet()) {
            if (identifiable.getId() != id) continue;
            return identifiable;
        }
        return null;
    }

    private void refreshSequence(DesignComponent designComponent, DesignEvent event) {
        DesignComponent imgResDC = designComponent.readProperty("sequncecd.prop.imageresource").getComponent();
        if (imgResDC == null) {
            return;
        }
        Sequence sequence = (Sequence)this.findIdentifiable(designComponent.getComponentID());
        sequence.removePropertyChangeListener(this);
        sequence.removeSequenceListener(this);
        if ("sequncecd.prop.name".equals(this.changeMap.get(designComponent.getComponentID()))) {
            this.changeMap.remove(designComponent.getComponentID());
        } else if (event.isComponentPropertyChanged(designComponent, "sequncecd.prop.name")) {
            String name = (String)designComponent.readProperty("sequncecd.prop.name").getPrimitiveValue();
            sequence.setName(name);
        }
        if ("sequncecd.prop.framems".equals(this.changeMap.get(designComponent.getComponentID()))) {
            this.changeMap.remove(designComponent.getComponentID());
        } else if (event.isComponentPropertyChanged(designComponent, "sequncecd.prop.framems")) {
            int frameMs = (Integer)designComponent.readProperty("sequncecd.prop.framems").getPrimitiveValue();
            sequence.setFrameMs(frameMs);
        }
        if ("sequncecd.prop.frames".equals(this.changeMap.get(designComponent.getComponentID()))) {
            this.changeMap.remove(designComponent.getComponentID());
        } else if (event.isComponentPropertyChanged(designComponent, "sequncecd.prop.frames")) {
            int[] frames = (int[])designComponent.readProperty("sequncecd.prop.frames").getPrimitiveValue();
            sequence.setFrames(frames);
        }
        if (event.isComponentPropertyChanged(designComponent, "sequncecd.prop.frame.width") || event.isComponentPropertyChanged(designComponent, "sequncecd.prop.frame.height") || event.isComponentPropertyChanged(designComponent, "sequncecd.prop.zero.based.index")) {
            // empty if block
        }
        sequence.addPropertyChangeListener(this);
        sequence.addSequenceListener(this);
    }

    private void refreshImageResource(DesignComponent designComponent, DesignEvent event) {
        boolean found;
        if (this.changeMap.remove(designComponent.getComponentID()) != null) {
            return;
        }
        ImageResource imgRes = this.getGameDesign().getImageResource(designComponent.getComponentID());
        imgRes.removeImageResourceListener(this);
        Collection dcChildren = designComponent.getComponents();
        HashSet<AnimatedTile> children = new HashSet<AnimatedTile>(imgRes.getAnimatedTiles());
        for (DesignComponent dc : dcChildren) {
            found = false;
            for (AnimatedTile child : children) {
                if (dc.getComponentID() != child.getId()) continue;
                found = true;
                break;
            }
            if (found) continue;
            this.modelComponent(dc);
        }
        for (AnimatedTile child : children) {
            found = false;
            for (DesignComponent dc : dcChildren) {
                if (child.getId() != dc.getComponentID()) continue;
                found = true;
                break;
            }
            if (found) continue;
            imgRes.removeAnimatedTile(child.getIndex());
        }
        imgRes.addImageResourceListener(this);
        this.getGameDesign().getMainView().requestEditing(this.getGameDesign());
    }

    public void setDesignDocument(final DesignDocument designDocument) {
        if (DEBUG) {
            System.out.println(">>>> Set design document to: " + designDocument);
        }
        if (designDocument == this.document) {
            return;
        }
        this.panel.removeAll();
        GlobalRepository oldGameDesign = this.getGameDesign();
        if (this.document != null) {
            this.document.getListenerManager().removeDesignListener((DesignListener)this);
            this.removeListeners(this.designIdMap.keySet().toArray());
            oldGameDesign.removeGlobalRepositoryListener(this);
            oldGameDesign.removeAllComponents();
            oldGameDesign.getMainView().removeEditorManagerListener(this.gameEditorView);
            this.designIdMap.clear();
        }
        JComponent view = null;
        this.document = designDocument;
        GlobalRepository gameDesign = this.getGameDesign();
        this.gameEditorView.setGameDesign(gameDesign);
        if (designDocument == null) {
            view = this.loadingPanel;
        } else {
            designDocument.getTransactionManager().readAccess(new Runnable(){

                @Override
                public void run() {
                    DesignComponent root = designDocument.getRootComponent();
                    GameController.this.modelComponent(root);
                    GameController.this.registerListeners(GameController.this.designIdMap.keySet().toArray());
                    DesignEventFilter f = new DesignEventFilter(new DesignEventFilter[0]);
                    f.setGlobal(true);
                    f.addComponentFilter(root, true);
                    designDocument.getListenerManager().addDesignListener((DesignListener)GameController.this, f);
                }
            });
            if (!this.validateImages(gameDesign)) {
                this.context.getCloneableEditorSupport().close();
                return;
            }
            gameDesign.getMainView().addEditorManagerListener(this.gameEditorView);
            view = gameDesign.getMainView().getRootComponent();
            gameDesign.addGlobalRepositoryListener(this);
            gameDesign.getMainView().requestEditing(gameDesign);
        }
        this.panel.add(view);
        this.panel.validate();
    }

    private boolean validateImages(GlobalRepository gameDesign) {
        boolean imagesFixed = true;
        HashMap<ImageResource, String> updatedResources = new HashMap<ImageResource, String>();
        Collection<ImageResource> imageResources = gameDesign.getImageResources();
        for (ImageResource imageResource : imageResources) {
            DesignComponent imageResourceDC;
            if (imageResource.getURL() != null || this.validateImageResource(imageResource, imageResourceDC = this.designIdMap.get(imageResource), updatedResources)) continue;
            imagesFixed = false;
            break;
        }
        if (imagesFixed) {
            this.fixUpdatedImagesInDocument(updatedResources);
        }
        return imagesFixed;
    }

    private void fixUpdatedImagesInDocument(final Map<ImageResource, String> updatedResources) {
        this.document.getTransactionManager().writeAccess(new Runnable(){

            @Override
            public void run() {
                for (ImageResource imageResource : updatedResources.keySet()) {
                    DesignComponent imageResourceDC = (DesignComponent)GameController.this.designIdMap.get(imageResource);
                    String newPath = (String)updatedResources.get(imageResource);
                    GameController.this.changeMap.put(imageResourceDC.getComponentID(), "imageresourcecd.prop.imagepath");
                    imageResourceDC.writeProperty("imageresourcecd.prop.imagepath", MidpTypes.createStringValue((String)newPath));
                }
            }
        });
    }

    private void removeListeners(Object ... objectsOfInterest) {
        for (Object o : objectsOfInterest) {
            Identifiable s;
            if (DEBUG_UNDO) {
                System.out.println("removeListeners on: " + o);
            }
            if (o instanceof Scene) {
                s = (Scene)o;
                ((Scene)s).removeSceneListener(this);
                ((Scene)s).removePropertyChangeListener(this);
                continue;
            }
            if (o instanceof TiledLayer) {
                TiledLayer tl = (TiledLayer)o;
                tl.removeTiledLayerListener(this);
                tl.removePropertyChangeListener(this);
                continue;
            }
            if (o instanceof Sprite) {
                s = (Sprite)o;
                ((Sprite)s).removeSequenceContainerListener(this);
                ((Layer)s).removePropertyChangeListener(this);
                continue;
            }
            if (o instanceof Sequence) {
                s = (Sequence)o;
                ((Sequence)s).removeSequenceListener(this);
                ((Sequence)s).removePropertyChangeListener(this);
                continue;
            }
            if (o instanceof AnimatedTile) {
                AnimatedTile a = (AnimatedTile)o;
                a.removeSequenceContainerListener(this);
                a.removePropertyChangeListener(this);
                continue;
            }
            if (!(o instanceof ImageResource)) continue;
            ImageResource i = (ImageResource)o;
            i.removeImageResourceListener(this);
        }
    }

    private void registerListeners(Object ... objectsOfInterest) {
        for (Object o : objectsOfInterest) {
            Identifiable s;
            if (DEBUG_UNDO) {
                System.out.println("registerListeners on: " + o);
            }
            if (o instanceof Scene) {
                s = (Scene)o;
                ((Scene)s).addSceneListener(this);
                ((Scene)s).addPropertyChangeListener(this);
                continue;
            }
            if (o instanceof TiledLayer) {
                TiledLayer tl = (TiledLayer)o;
                tl.addTiledLayerListener(this);
                tl.addPropertyChangeListener(this);
                continue;
            }
            if (o instanceof Sprite) {
                s = (Sprite)o;
                ((Sprite)s).addSequenceContainerListener(this);
                ((Layer)s).addPropertyChangeListener(this);
                continue;
            }
            if (o instanceof Sequence) {
                s = (Sequence)o;
                ((Sequence)s).addSequenceListener(this);
                ((Sequence)s).addPropertyChangeListener(this);
                continue;
            }
            if (o instanceof AnimatedTile) {
                AnimatedTile a = (AnimatedTile)o;
                a.addSequenceContainerListener(this);
                a.addPropertyChangeListener(this);
                continue;
            }
            if (!(o instanceof ImageResource)) continue;
            ImageResource i = (ImageResource)o;
            i.addImageResourceListener(this);
        }
    }

    private void modelComponent(DesignComponent designComponent) {
        if (designComponent == null) {
            return;
        }
        Collection children = designComponent.getComponents();
        for (DesignComponent child : children) {
            this.modelComponent(child);
        }
        TypeID typeId = designComponent.getType();
        assert (typeId != null);
        if (typeId.equals((Object)SceneCD.TYPEID)) {
            Scene scene = this.constructScene(designComponent);
            this.designIdMap.put(scene, designComponent);
        } else if (typeId.equals((Object)TiledLayerCD.TYPEID)) {
            TiledLayer layer = this.constructTiledLayer(designComponent);
            this.designIdMap.put(layer, designComponent);
        } else if (typeId.equals((Object)SpriteCD.TYPEID)) {
            Sprite sprite = this.constructSprite(designComponent);
            this.designIdMap.put(sprite, designComponent);
        } else if (typeId.equals((Object)SequenceCD.TYPEID)) {
            Sequence sequence = this.constructSequence(designComponent);
            this.designIdMap.put(sequence, designComponent);
        } else if (typeId.equals((Object)ImageResourceCD.TYPEID)) {
            ImageResource imageResource = this.constructImageResource(designComponent);
            this.designIdMap.put(imageResource, designComponent);
        } else if (typeId.equals((Object)AnimatedTileCD.TYPEID)) {
            AnimatedTile animatedTile = this.constructAnimatedTile(designComponent);
            this.designIdMap.put(animatedTile, designComponent);
        }
    }

    private AnimatedTile constructAnimatedTile(DesignComponent animatedTileDC) {
        int index = (Integer)animatedTileDC.readProperty("animatedtilecd.prop.index").getPrimitiveValue();
        String name = (String)animatedTileDC.readProperty("animatedtilecd.prop.name").getPrimitiveValue();
        DesignComponent imgResDC = animatedTileDC.readProperty("animatedtilecd.prop.imageresource").getComponent();
        ImageResource imgRes = this.constructImageResource(imgResDC);
        AnimatedTile animatedTile = imgRes.getAnimatedTileByName(name);
        if (animatedTile != null) {
            return animatedTile;
        }
        DesignComponent defaultSequenceDC = animatedTileDC.readProperty("sequencecontainer.prop.defaultsequence").getComponent();
        List sequenceDCs = animatedTileDC.readProperty("sequencecontainer.prop.sequences").getArray();
        Sequence defaultSequence = this.constructSequence(defaultSequenceDC);
        animatedTile = imgRes.createAnimatedTile(index, name, defaultSequence);
        animatedTile.setId(animatedTileDC.getComponentID());
        for (PropertyValue propertyValue : sequenceDCs) {
            DesignComponent sequenceDC = propertyValue.getComponent();
            Sequence sequence = this.constructSequence(sequenceDC);
            if (sequence == defaultSequence) continue;
            animatedTile.append(sequence);
        }
        Identifiable old = this.findIdentifiable(animatedTileDC.getComponentID());
        if (old != null) {
            if (DEBUG_UNDO) {
                System.out.println("> Recreated " + animatedTile + " remove old mapping and create a new one");
            }
            this.designIdMap.remove(old);
            this.removeListeners(old);
            this.designIdMap.put(animatedTile, animatedTileDC);
            this.registerListeners(animatedTile);
        }
        return animatedTile;
    }

    private Sprite constructSprite(DesignComponent spriteDC) {
        String name = (String)spriteDC.readProperty("layercd.prop.name").getPrimitiveValue();
        Sprite sprite = (Sprite)this.getGameDesign().getLayerByName(name);
        if (sprite != null) {
            return sprite;
        }
        DesignComponent imgResDC = spriteDC.readProperty("layercd.prop.imageresource").getComponent();
        ImageResource imgRes = this.constructImageResource(imgResDC);
        DesignComponent defaultSequenceDC = spriteDC.readProperty("sequencecontainer.prop.defaultsequence").getComponent();
        List sequenceDCs = spriteDC.readProperty("sequencecontainer.prop.sequences").getArray();
        Sequence defaultSequence = this.constructSequence(defaultSequenceDC);
        sprite = this.getGameDesign().createSprite(name, imgRes, defaultSequence);
        sprite.setId(spriteDC.getComponentID());
        for (PropertyValue propertyValue : sequenceDCs) {
            DesignComponent sequenceDC = propertyValue.getComponent();
            Sequence sequence = this.constructSequence(sequenceDC);
            if (sequence == defaultSequence) continue;
            sprite.append(sequence);
        }
        Identifiable old = this.findIdentifiable(spriteDC.getComponentID());
        if (old != null) {
            if (DEBUG_UNDO) {
                System.out.println("> Recreated " + sprite + " remove old mapping and create a new one");
            }
            this.designIdMap.remove(old);
            this.removeListeners(old);
            this.designIdMap.put(sprite, spriteDC);
            this.registerListeners(sprite);
        }
        return sprite;
    }

    private TiledLayer constructTiledLayer(DesignComponent tiledLayerDC) {
        String name = (String)tiledLayerDC.readProperty("layercd.prop.name").getPrimitiveValue();
        TiledLayer tiledLayer = (TiledLayer)this.getGameDesign().getLayerByName(name);
        if (tiledLayer != null) {
            return tiledLayer;
        }
        DesignComponent imgResDC = tiledLayerDC.readProperty("layercd.prop.imageresource").getComponent();
        ImageResource imgRes = this.constructImageResource(imgResDC);
        int[][] gridOriginal = (int[][])tiledLayerDC.readProperty("tiledlayercd.prop.tiles").getPrimitiveValue();
        int tileWidth = MidpTypes.getInteger((PropertyValue)tiledLayerDC.readProperty("layercd.prop.tile.width"));
        int tileHeight = MidpTypes.getInteger((PropertyValue)tiledLayerDC.readProperty("layercd.prop.tile.height"));
        int[][] grid = TiledLayer.cloneTiles(gridOriginal);
        tiledLayer = this.getGameDesign().createTiledLayer(name, imgRes, grid, tileWidth, tileHeight);
        tiledLayer.setId(tiledLayerDC.getComponentID());
        Identifiable old = this.findIdentifiable(tiledLayerDC.getComponentID());
        if (old != null) {
            if (DEBUG_UNDO) {
                System.out.println("> Recreated " + tiledLayer + " remove old mapping and create a new one");
            }
            this.designIdMap.remove(old);
            this.removeListeners(old);
            this.designIdMap.put(tiledLayer, tiledLayerDC);
            this.registerListeners(tiledLayer);
        }
        return tiledLayer;
    }

    private Sequence constructSequence(DesignComponent sequenceDC) {
        String name = (String)sequenceDC.readProperty("sequncecd.prop.name").getPrimitiveValue();
        DesignComponent imgResDC = sequenceDC.readProperty("sequncecd.prop.imageresource").getComponent();
        ImageResource imgRes = this.constructImageResource(imgResDC);
        Sequence sequence = imgRes.getSequenceByName(name);
        if (sequence != null) {
            return sequence;
        }
        int frameMs = (Integer)sequenceDC.readProperty("sequncecd.prop.framems").getPrimitiveValue();
        int[] frames = (int[])sequenceDC.readProperty("sequncecd.prop.frames").getPrimitiveValue();
        int frameWidth = (Integer)sequenceDC.readProperty("sequncecd.prop.frame.width").getPrimitiveValue();
        int frameHeight = (Integer)sequenceDC.readProperty("sequncecd.prop.frame.height").getPrimitiveValue();
        boolean zeroBasedIndex = (Boolean)sequenceDC.readProperty("sequncecd.prop.zero.based.index").getPrimitiveValue();
        sequence = imgRes.createSequence(name, frames.length, frameWidth, frameHeight, zeroBasedIndex);
        sequence.setId(sequenceDC.getComponentID());
        sequence.setFrameMs(frameMs);
        for (int i = 0; i < frames.length; ++i) {
            sequence.setFrame((StaticTile)imgRes.getTile(frames[i], frameWidth, frameHeight, zeroBasedIndex), i);
        }
        Identifiable old = this.findIdentifiable(sequenceDC.getComponentID());
        if (old != null) {
            if (DEBUG_UNDO) {
                System.out.println("> Recreated " + sequence + " remove old mapping and create a new one");
            }
            this.designIdMap.remove(old);
            this.removeListeners(old);
            this.designIdMap.put(sequence, sequenceDC);
            this.registerListeners(sequence);
        }
        return sequence;
    }

    private ImageResource constructImageResource(DesignComponent imageResourceDC) {
        URL imgResUrl = null;
        String imgResPath = (String)imageResourceDC.readProperty("imageresourcecd.prop.imagepath").getPrimitiveValue();
        String imgResName = (String)imageResourceDC.readProperty("imageresourcecd.prop.name").getPrimitiveValue();
        ImageResource imgRes = this.getGameDesign().getImageResource(imgResPath);
        if (imgRes != null) {
            return imgRes;
        }
        Map imagesMap = MidpProjectSupport.getFileObjectsForRelativeResourcePath((DesignDocument)this.document, (String)imgResPath);
        if (imagesMap.size() == 1) {
            FileObject fo = (FileObject)imagesMap.keySet().iterator().next();
            try {
                imgResUrl = fo.getURL();
            }
            catch (FileStateInvalidException e) {
                e.printStackTrace();
            }
        }
        ImageResource imageResource = this.getGameDesign().getImageResource(imgResUrl, imgResPath);
        imageResource.setName(imgResName);
        imageResource.setId(imageResourceDC.getComponentID());
        return imageResource;
    }

    private boolean validateImageResource(ImageResource imageResource, DesignComponent imageResourceDC, Map<ImageResource, String> updatedResources) {
        FileObject fo;
        boolean imageFixed = false;
        String imgResPath = imageResource.getRelativeResourcePath();
        Map imagesMap = MidpProjectSupport.getFileObjectsForRelativeResourcePath((DesignDocument)this.document, (String)imgResPath);
        if (imagesMap.size() > 1) {
            if (DEBUG) {
                System.out.println("found multiple images matching the relative path:");
                for (Map.Entry entry : imagesMap.entrySet()) {
                    System.out.println("root: " + entry.getValue() + ", path: " + entry.getKey());
                }
            }
            SelectImageForLayerDialog dialog = new SelectImageForLayerDialog(NbBundle.getMessage(GameController.class, (String)"GameController.SelectImageDialog.description1_txt", (Object)imgResPath), imagesMap.keySet());
            DialogDescriptor dd = new DialogDescriptor((Object)dialog, NbBundle.getMessage(GameController.class, (String)"GameController.SelectImageDialog.title"));
            dd.setValid(false);
            dd.setButtonListener((ActionListener)dialog);
            dialog.setDialogDescriptor(dd);
            Dialog d = DialogDisplayer.getDefault().createDialog(dd);
            d.setVisible(true);
            fo = dialog.getValue();
            if (dialog.isCancelled() || fo == null) {
                return imageFixed;
            }
            String newPath = "/" + FileUtil.getRelativePath((FileObject)((FileObject)imagesMap.get(fo)), (FileObject)fo);
            if (DEBUG) {
                System.out.println("Setting new path: " + newPath);
            }
            updatedResources.put(imageResource, newPath);
            if (DEBUG_UNDO) {
                System.out.println("Set new path: " + newPath);
            }
        } else if (imagesMap.isEmpty()) {
            fo = null;
            if (DEBUG) {
                System.out.println("Image " + imgResPath + " doesn't exist, select a replacement.");
            }
            Map images = MidpProjectSupport.getImagesForProject((DesignDocument)this.document, (boolean)false);
            SelectImageForLayerDialog dialog = new SelectImageForLayerDialog(NbBundle.getMessage(GameController.class, (String)"GameController.SelectImageDialog.description2_txt", (Object)imgResPath), images.keySet());
            DialogDescriptor dd = new DialogDescriptor((Object)dialog, NbBundle.getMessage(GameController.class, (String)"GameController.SelectImageDialog.title"));
            dd.setValid(false);
            dd.setButtonListener((ActionListener)dialog);
            dialog.setDialogDescriptor(dd);
            Dialog d = DialogDisplayer.getDefault().createDialog(dd);
            d.setVisible(true);
            fo = dialog.getValue();
            if (dialog.isCancelled() || fo == null) {
                return imageFixed;
            }
            String newPath = (String)images.get(fo);
            if (DEBUG) {
                System.out.println("Setting new path: " + newPath);
            }
            updatedResources.put(imageResource, newPath);
            if (DEBUG_UNDO) {
                System.out.println("Set new path: " + newPath);
            }
        } else {
            fo = (FileObject)imagesMap.keySet().iterator().next();
            if (DEBUG) {
                System.out.println("Found single matching image ULR: " + fo.getPath());
            }
        }
        try {
            if (fo != null) {
                URL imgResUrl = fo.getURL();
                imageResource.setURL(imgResUrl);
                imageFixed = true;
            }
        }
        catch (FileStateInvalidException e) {
            throw new RuntimeException(e);
        }
        return imageFixed;
    }

    private Scene constructScene(DesignComponent sceneDC) {
        String name = (String)sceneDC.readProperty("scenecd.prop.name").getPrimitiveValue();
        Scene scene = this.getGameDesign().getSceneByName(name);
        if (scene != null) {
            return scene;
        }
        scene = this.getGameDesign().createScene(name);
        scene.setId(sceneDC.getComponentID());
        List sceneItemsProps = sceneDC.readProperty("scenecd.prop.sceneitems").getArray();
        for (PropertyValue sceneItemProp : sceneItemsProps) {
            DesignComponent sceneItemDC = sceneItemProp.getComponent();
            Point layerLocation = (Point)sceneItemDC.readProperty("sceneitemcd.prop.position").getPrimitiveValue();
            Boolean locked = (Boolean)sceneItemDC.readProperty("sceneitemcd.prop.lock").getPrimitiveValue();
            Boolean visible = (Boolean)sceneItemDC.readProperty("sceneitemcd.prop.visible").getPrimitiveValue();
            DesignComponent layerDC = sceneItemDC.readProperty("sceneitemcd.prop.layer").getComponent();
            int zOrder = (Integer)sceneItemDC.readProperty("sceneitemcd.prop.z.order").getPrimitiveValue();
            Layer layer = null;
            layer = layerDC.getType().equals((Object)TiledLayerCD.TYPEID) ? this.constructTiledLayer(layerDC) : this.constructSprite(layerDC);
            scene.append(layer);
            scene.move(layer, zOrder);
            scene.setLayerPosition(layer, layerLocation, false);
            scene.setLayerVisible(layer, visible);
            scene.setLayerLocked(layer, locked);
        }
        Identifiable old = this.findIdentifiable(sceneDC.getComponentID());
        if (old != null) {
            if (DEBUG_UNDO) {
                System.out.println("> Recreated " + scene + " remove old mapping and create a new one");
            }
            this.designIdMap.remove(old);
            this.removeListeners(old);
            this.designIdMap.put(scene, sceneDC);
            this.registerListeners(scene);
        }
        return scene;
    }

    public static DesignComponent createSceneDCFromScene(DesignDocument doc, Map<Identifiable, DesignComponent> designIdMap, Scene scene) {
        DesignComponent dcScene = designIdMap.get(scene);
        if (dcScene != null) {
            return dcScene;
        }
        dcScene = doc.createComponent(SceneCD.TYPEID);
        scene.setId(dcScene.getComponentID());
        dcScene.writeProperty("scenecd.prop.name", MidpTypes.createStringValue((String)scene.getName()));
        GameController.writeSceneItemsToSceneDC(doc, designIdMap, dcScene, scene);
        return dcScene;
    }

    private static void writeSceneItemsToSceneDC(DesignDocument doc, Map<Identifiable, DesignComponent> designIdMap, DesignComponent dcScene, Scene scene) {
        List sceneItemProps = dcScene.readProperty("scenecd.prop.sceneitems").getArray();
        for (PropertyValue propertyValue : sceneItemProps) {
            DesignComponent dcSceneItemComp = propertyValue.getComponent();
            dcSceneItemComp.removeFromParentComponent();
        }
        dcScene.writeProperty("scenecd.prop.sceneitems", PropertyValue.createEmptyArray((TypeID)SceneItemCD.TYPEID));
        List<Layer> layers = scene.getLayers();
        ArrayList<PropertyValue> scenePropValues = new ArrayList<PropertyValue>();
        Iterator<Layer> it = layers.iterator();
        while (it.hasNext()) {
            DesignComponent sceneItemDC = doc.createComponent(SceneItemCD.TYPEID);
            Layer layer = it.next();
            DesignComponent layerDC = designIdMap.get(layer);
            assert (layerDC != null);
            sceneItemDC.writeProperty("sceneitemcd.prop.layer", PropertyValue.createComponentReference((DesignComponent)layerDC));
            sceneItemDC.writeProperty("sceneitemcd.prop.lock", MidpTypes.createBooleanValue((boolean)scene.isLayerLocked(layer)));
            sceneItemDC.writeProperty("sceneitemcd.prop.visible", MidpTypes.createBooleanValue((boolean)scene.isLayerVisible(layer)));
            sceneItemDC.writeProperty("sceneitemcd.prop.position", GameTypes.createPointProperty(scene.getLayerPosition(layer)));
            sceneItemDC.writeProperty("sceneitemcd.prop.z.order", MidpTypes.createIntegerValue((int)scene.indexOf(layer)));
            dcScene.addComponent(sceneItemDC);
            PropertyValue sceneItemPropVal = PropertyValue.createComponentReference((DesignComponent)sceneItemDC);
            scenePropValues.add(sceneItemPropVal);
        }
        dcScene.writeProperty("scenecd.prop.sceneitems", PropertyValue.createArray((TypeID)SceneItemCD.TYPEID, scenePropValues));
    }

    public static DesignComponent createTiledLayerDCFromTiledLayer(DesignDocument doc, Map<Identifiable, DesignComponent> designIdMap, TiledLayer layer) {
        DesignComponent dcLayer = designIdMap.get(layer);
        if (dcLayer != null) {
            return dcLayer;
        }
        dcLayer = doc.createComponent(TiledLayerCD.TYPEID);
        layer.setId(dcLayer.getComponentID());
        dcLayer.writeProperty("layercd.prop.name", MidpTypes.createStringValue((String)layer.getName()));
        DesignComponent dcImgRes = designIdMap.get(layer.getImageResource());
        assert (dcImgRes != null);
        dcLayer.writeProperty("layercd.prop.imageresource", PropertyValue.createComponentReference((DesignComponent)dcImgRes));
        PropertyValue propTiles = GameTypes.createTilesProperty(layer.getTiles());
        dcLayer.writeProperty("tiledlayercd.prop.tiles", propTiles);
        dcLayer.writeProperty("layercd.prop.tile.width", MidpTypes.createIntegerValue((int)layer.getTileWidth()));
        dcLayer.writeProperty("layercd.prop.tile.height", MidpTypes.createIntegerValue((int)layer.getTileHeight()));
        return dcLayer;
    }

    public DesignComponent createAnimatedTileDCFromAnimatedTile(AnimatedTile tile) {
        DesignComponent dcAt = this.designIdMap.get(tile);
        if (dcAt != null) {
            return dcAt;
        }
        dcAt = this.document.createComponent(AnimatedTileCD.TYPEID);
        tile.setId(dcAt.getComponentID());
        dcAt.writeProperty("animatedtilecd.prop.name", MidpTypes.createStringValue((String)tile.getName()));
        dcAt.writeProperty("animatedtilecd.prop.index", MidpTypes.createIntegerValue((int)tile.getIndex()));
        dcAt.writeProperty("animatedtilecd.prop.width", MidpTypes.createIntegerValue((int)tile.getWidth()));
        dcAt.writeProperty("animatedtilecd.prop.height", MidpTypes.createIntegerValue((int)tile.getHeight()));
        DesignComponent dcImgRes = this.designIdMap.get(tile.getImageResource());
        assert (dcImgRes != null);
        dcAt.writeProperty("animatedtilecd.prop.imageresource", PropertyValue.createComponentReference((DesignComponent)dcImgRes));
        ArrayList<PropertyValue> sequencePropValues = new ArrayList<PropertyValue>();
        for (Sequence seq : tile.getSequences()) {
            DesignComponent dcSeq = this.designIdMap.get(seq);
            if (dcSeq == null) {
                dcSeq = this.createSequenceDCFromSequence(seq);
                this.designIdMap.put(seq, dcSeq);
            }
            if (!dcAt.getComponents().contains(dcSeq)) {
                dcAt.addComponent(dcSeq);
            }
            if (seq == tile.getDefaultSequence()) {
                dcAt.writeProperty("sequencecontainer.prop.defaultsequence", PropertyValue.createComponentReference((DesignComponent)dcSeq));
            }
            PropertyValue seqPropertyValue = PropertyValue.createComponentReference((DesignComponent)dcSeq);
            sequencePropValues.add(seqPropertyValue);
        }
        dcAt.writeProperty("sequencecontainer.prop.sequences", PropertyValue.createArray((TypeID)SequenceCD.TYPEID, sequencePropValues));
        return dcAt;
    }

    public DesignComponent createSpriteDCFromSprite(Sprite layer) {
        DesignComponent dcLayer = this.designIdMap.get(layer);
        if (dcLayer != null) {
            return dcLayer;
        }
        dcLayer = this.document.createComponent(SpriteCD.TYPEID);
        layer.setId(dcLayer.getComponentID());
        dcLayer.writeProperty("layercd.prop.name", MidpTypes.createStringValue((String)layer.getName()));
        dcLayer.writeProperty("layercd.prop.tile.width", MidpTypes.createIntegerValue((int)layer.getTileWidth()));
        dcLayer.writeProperty("layercd.prop.tile.height", MidpTypes.createIntegerValue((int)layer.getTileHeight()));
        DesignComponent dcImgRes = this.designIdMap.get(layer.getImageResource());
        assert (dcImgRes != null);
        dcLayer.writeProperty("layercd.prop.imageresource", PropertyValue.createComponentReference((DesignComponent)dcImgRes));
        ArrayList<PropertyValue> sequencePropValues = new ArrayList<PropertyValue>();
        for (Sequence seq : layer.getSequences()) {
            DesignComponent dcSeq = this.designIdMap.get(seq);
            if (dcSeq == null) {
                dcSeq = this.createSequenceDCFromSequence(seq);
                this.designIdMap.put(seq, dcSeq);
            }
            if (!dcLayer.getComponents().contains(dcSeq)) {
                dcLayer.addComponent(dcSeq);
            }
            if (seq == layer.getDefaultSequence()) {
                dcLayer.writeProperty("sequencecontainer.prop.defaultsequence", PropertyValue.createComponentReference((DesignComponent)dcSeq));
            }
            PropertyValue seqPropertyValue = PropertyValue.createComponentReference((DesignComponent)dcSeq);
            sequencePropValues.add(seqPropertyValue);
        }
        dcLayer.writeProperty("sequencecontainer.prop.sequences", PropertyValue.createArray((TypeID)SequenceCD.TYPEID, sequencePropValues));
        return dcLayer;
    }

    public DesignComponent createImageResourceDCFromImageResource(ImageResource imageResource) {
        DesignComponent dcImgRes = this.designIdMap.get(imageResource);
        if (dcImgRes != null) {
            return dcImgRes;
        }
        dcImgRes = this.document.createComponent(ImageResourceCD.TYPEID);
        imageResource.setId(dcImgRes.getComponentID());
        dcImgRes.writeProperty("imageresourcecd.prop.imagepath", MidpTypes.createStringValue((String)imageResource.getRelativeResourcePath()));
        dcImgRes.writeProperty("imageresourcecd.prop.name", MidpTypes.createStringValue((String)imageResource.getName(true)));
        this.writeAnimatedTilesToImageResourceDC(dcImgRes, imageResource);
        return dcImgRes;
    }

    private void writeAnimatedTilesToImageResourceDC(DesignComponent dcImgRes, ImageResource imageResource) {
        for (AnimatedTile at : imageResource.getAnimatedTiles()) {
            DesignComponent dcAnimTile = this.designIdMap.get(at);
            if (dcAnimTile != null) continue;
            assert (!dcImgRes.getComponents().contains(dcAnimTile));
            dcAnimTile = this.createAnimatedTileDCFromAnimatedTile(at);
            dcImgRes.addComponent(dcAnimTile);
            this.designIdMap.put(at, dcAnimTile);
        }
    }

    public DesignComponent createSequenceDCFromSequence(Sequence sequence) {
        DesignComponent dcSequence = this.designIdMap.get(sequence);
        if (dcSequence != null) {
            return dcSequence;
        }
        dcSequence = this.document.createComponent(SequenceCD.TYPEID);
        sequence.setId(dcSequence.getComponentID());
        dcSequence.writeProperty("sequncecd.prop.name", MidpTypes.createStringValue((String)sequence.getName()));
        DesignComponent dcImg = this.designIdMap.get(sequence.getImageResource());
        assert (dcImg != null);
        dcSequence.writeProperty("sequncecd.prop.imageresource", PropertyValue.createComponentReference((DesignComponent)dcImg));
        dcSequence.writeProperty("sequncecd.prop.frames", GameTypes.createFramesProperty(sequence.getFramesAsArray()));
        dcSequence.writeProperty("sequncecd.prop.framems", MidpTypes.createIntegerValue((int)sequence.getFrameMs()));
        dcSequence.writeProperty("sequncecd.prop.frame.width", MidpTypes.createIntegerValue((int)sequence.getFrameWidth()));
        dcSequence.writeProperty("sequncecd.prop.frame.height", MidpTypes.createIntegerValue((int)sequence.getFrameHeight()));
        dcSequence.writeProperty("sequncecd.prop.zero.based.index", MidpTypes.createBooleanValue((boolean)sequence.isZeroBasedIndex()));
        this.registerListeners(sequence);
        return dcSequence;
    }

    @Override
    public void sceneAdded(final Scene scene, int index) {
        final DesignDocument doc = this.document;
        this.document.getTransactionManager().writeAccess(new Runnable(){

            @Override
            public void run() {
                DesignComponent sceneDC = GameController.createSceneDCFromScene(doc, GameController.this.designIdMap, scene);
                GameController.this.designIdMap.put(scene, sceneDC);
                GameController.this.changeMap.put(doc.getRootComponent().getComponentID(), scene.getName());
                scene.addSceneListener(GameController.this);
                scene.addPropertyChangeListener(GameController.this);
                doc.getRootComponent().addComponent(sceneDC);
            }
        });
        if (DEBUG_UNDO) {
            System.out.println("Scene added " + scene);
        }
    }

    @Override
    public void sceneRemoved(final Scene scene, int index) {
        final DesignDocument doc = this.document;
        scene.removeSceneListener(this);
        final DesignComponent dcScene = this.designIdMap.get(scene);
        assert (dcScene != null);
        this.document.getTransactionManager().writeAccess(new Runnable(){

            @Override
            public void run() {
                GameController.this.changeMap.put(doc.getRootComponent().getComponentID(), scene.getName());
                GameController.this.document.deleteComponent(dcScene);
            }
        });
        if (DEBUG_UNDO) {
            System.out.println("Scene removed: " + scene);
        }
    }

    @Override
    public void tiledLayerAdded(final TiledLayer tiledLayer, int index) {
        DesignDocument doc = this.document;
        this.document.getTransactionManager().writeAccess(new Runnable(){

            @Override
            public void run() {
                DesignDocument doc = GameController.this.document;
                DesignComponent tiledLayerDC = GameController.createTiledLayerDCFromTiledLayer(doc, GameController.this.designIdMap, tiledLayer);
                GameController.this.changeMap.put(doc.getRootComponent().getComponentID(), tiledLayer.getName());
                tiledLayer.addTiledLayerListener(GameController.this);
                tiledLayer.addPropertyChangeListener(GameController.this);
                doc.getRootComponent().addComponent(tiledLayerDC);
            }
        });
        if (DEBUG_UNDO) {
            System.out.println("TL added: " + tiledLayer);
        }
    }

    @Override
    public void tiledLayerRemoved(final TiledLayer tiledLayer, int index) {
        final DesignDocument doc = this.document;
        tiledLayer.removeTiledLayerListener(this);
        final DesignComponent dcLayer = this.designIdMap.get(tiledLayer);
        assert (dcLayer != null);
        this.document.getTransactionManager().writeAccess(new Runnable(){

            @Override
            public void run() {
                GameController.this.changeMap.put(doc.getRootComponent().getComponentID(), tiledLayer.getName());
                GameController.this.document.deleteComponent(dcLayer);
            }
        });
        if (DEBUG_UNDO) {
            System.out.println("TL removed: " + tiledLayer);
        }
    }

    @Override
    public void spriteAdded(final Sprite sprite, int index) {
        final DesignDocument doc = this.document;
        this.document.getTransactionManager().writeAccess(new Runnable(){

            @Override
            public void run() {
                DesignComponent spriteDC = GameController.this.createSpriteDCFromSprite(sprite);
                GameController.this.designIdMap.put(sprite, spriteDC);
                GameController.this.changeMap.put(doc.getRootComponent().getComponentID(), sprite.getName());
                sprite.addSequenceContainerListener(GameController.this);
                sprite.addPropertyChangeListener(GameController.this);
                GameController.this.document.getRootComponent().addComponent(spriteDC);
            }
        });
        if (DEBUG_UNDO) {
            System.out.println("Sprite added: " + sprite);
        }
    }

    @Override
    public void spriteRemoved(final Sprite sprite, int index) {
        final DesignDocument doc = this.document;
        sprite.removeSequenceContainerListener(this);
        final DesignComponent dcLayer = this.designIdMap.get(sprite);
        assert (dcLayer != null);
        this.document.getTransactionManager().writeAccess(new Runnable(){

            @Override
            public void run() {
                GameController.this.changeMap.put(doc.getRootComponent().getComponentID(), sprite.getName());
                GameController.this.document.deleteComponent(dcLayer);
            }
        });
        if (DEBUG_UNDO) {
            System.out.println("Sprite removed: " + sprite);
        }
    }

    @Override
    public void imageResourceAdded(final ImageResource imageResource) {
        DesignDocument doc = this.document;
        this.document.getTransactionManager().writeAccess(new Runnable(){

            @Override
            public void run() {
                DesignDocument doc = GameController.this.document;
                DesignComponent imgResDC = GameController.this.createImageResourceDCFromImageResource(imageResource);
                GameController.this.designIdMap.put(imageResource, imgResDC);
                GameController.this.changeMap.put(doc.getRootComponent().getComponentID(), imageResource.getName());
                imageResource.addImageResourceListener(GameController.this);
                doc.getRootComponent().addComponent(imgResDC);
            }
        });
        if (DEBUG_UNDO) {
            System.out.println("ImgRes added: " + imageResource);
        }
    }

    @Override
    public void layerAdded(final Scene sourceScene, final Layer layer, int index) {
        this.document.getTransactionManager().writeAccess(new Runnable(){

            @Override
            public void run() {
                DesignComponent dcScene = (DesignComponent)GameController.this.designIdMap.get(sourceScene);
                assert (dcScene != null);
                DesignComponent dcLayer = (DesignComponent)GameController.this.designIdMap.get(layer);
                assert (dcLayer != null);
                GameController.this.changeMap.put(dcScene.getComponentID(), "scenecd.prop.sceneitems");
                GameController.writeSceneItemsToSceneDC(GameController.this.document, GameController.this.designIdMap, dcScene, sourceScene);
            }
        });
        if (DEBUG_UNDO) {
            System.out.println("Layer added: " + layer);
        }
    }

    @Override
    public void layerRemoved(final Scene sourceScene, final Layer layer, Scene.LayerInfo info, int index) {
        this.document.getTransactionManager().writeAccess(new Runnable(){

            @Override
            public void run() {
                DesignComponent dcScene = (DesignComponent)GameController.this.designIdMap.get(sourceScene);
                assert (dcScene != null);
                DesignComponent dcLayer = (DesignComponent)GameController.this.designIdMap.get(layer);
                assert (dcLayer != null);
                GameController.this.changeMap.put(dcScene.getComponentID(), "scenecd.prop.sceneitems");
                GameController.writeSceneItemsToSceneDC(GameController.this.document, GameController.this.designIdMap, dcScene, sourceScene);
            }
        });
        if (DEBUG_UNDO) {
            System.out.println("Layer removed: " + layer);
        }
    }

    @Override
    public void layerMoved(final Scene sourceScene, final Layer layer, int indexOld, int indexNew) {
        this.document.getTransactionManager().writeAccess(new Runnable(){

            @Override
            public void run() {
                DesignComponent dcScene = (DesignComponent)GameController.this.designIdMap.get(sourceScene);
                assert (dcScene != null);
                DesignComponent dcLayer = (DesignComponent)GameController.this.designIdMap.get(layer);
                assert (dcLayer != null);
                GameController.this.changeMap.put(dcScene.getComponentID(), "scenecd.prop.sceneitems");
                GameController.writeSceneItemsToSceneDC(GameController.this.document, GameController.this.designIdMap, dcScene, sourceScene);
            }
        });
        if (DEBUG_UNDO) {
            System.out.println("Layer moved: " + layer);
        }
    }

    @Override
    public void layerPositionChanged(final Scene sourceScene, final Layer layer, Point oldPosition, Point newPosition, boolean inTransition) {
        if (inTransition) {
            return;
        }
        this.document.getTransactionManager().writeAccess(new Runnable(){

            @Override
            public void run() {
                DesignComponent dcScene = (DesignComponent)GameController.this.designIdMap.get(sourceScene);
                assert (dcScene != null);
                DesignComponent dcLayer = (DesignComponent)GameController.this.designIdMap.get(layer);
                assert (dcLayer != null);
                GameController.this.changeMap.put(dcScene.getComponentID(), "scenecd.prop.sceneitems");
                GameController.writeSceneItemsToSceneDC(GameController.this.document, GameController.this.designIdMap, dcScene, sourceScene);
            }
        });
        if (DEBUG_UNDO) {
            System.out.println("Layer position changed: " + layer);
        }
    }

    @Override
    public void layerLockChanged(final Scene sourceScene, final Layer layer, boolean locked) {
        this.document.getTransactionManager().writeAccess(new Runnable(){

            @Override
            public void run() {
                DesignComponent dcScene = (DesignComponent)GameController.this.designIdMap.get(sourceScene);
                assert (dcScene != null);
                DesignComponent dcLayer = (DesignComponent)GameController.this.designIdMap.get(layer);
                assert (dcLayer != null);
                GameController.this.changeMap.put(dcScene.getComponentID(), "scenecd.prop.sceneitems");
                GameController.writeSceneItemsToSceneDC(GameController.this.document, GameController.this.designIdMap, dcScene, sourceScene);
            }
        });
        if (DEBUG_UNDO) {
            System.out.println("Layer lock changed: " + layer);
        }
    }

    @Override
    public void layerVisibilityChanged(final Scene sourceScene, final Layer layer, boolean visible) {
        this.document.getTransactionManager().writeAccess(new Runnable(){

            @Override
            public void run() {
                DesignComponent dcScene = (DesignComponent)GameController.this.designIdMap.get(sourceScene);
                assert (dcScene != null);
                DesignComponent dcLayer = (DesignComponent)GameController.this.designIdMap.get(layer);
                assert (dcLayer != null);
                GameController.this.changeMap.put(dcScene.getComponentID(), "scenecd.prop.sceneitems");
                GameController.writeSceneItemsToSceneDC(GameController.this.document, GameController.this.designIdMap, dcScene, sourceScene);
            }
        });
        if (DEBUG_UNDO) {
            System.out.println("Layer visibility changed: " + layer);
        }
    }

    @Override
    public void tileChanged(TiledLayer source, int row, int col) {
        this.updateTiledLayerDCProps(source);
    }

    @Override
    public void tilesChanged(TiledLayer source, Set positions) {
        this.updateTiledLayerDCProps(source);
    }

    @Override
    public void tilesStructureChanged(TiledLayer source) {
        this.updateTiledLayerDCProps(source);
    }

    @Override
    public void columnsInserted(TiledLayer source, int index, int count) {
        this.updateTiledLayerDCProps(source);
    }

    @Override
    public void columnsRemoved(TiledLayer source, int index, int count) {
        this.updateTiledLayerDCProps(source);
    }

    @Override
    public void rowsInserted(TiledLayer source, int index, int count) {
        this.updateTiledLayerDCProps(source);
    }

    @Override
    public void rowsRemoved(TiledLayer source, int index, int count) {
        this.updateTiledLayerDCProps(source);
    }

    private void updateTiledLayerDCProps(final TiledLayer layer) {
        this.document.getTransactionManager().writeAccess(new Runnable(){

            @Override
            public void run() {
                DesignComponent dcLayer = (DesignComponent)GameController.this.designIdMap.get(layer);
                assert (dcLayer != null);
                GameController.this.changeMap.put(dcLayer.getComponentID(), "tiledlayercd.prop.tiles");
                PropertyValue propTiles = GameTypes.createTilesProperty(layer.getTiles());
                dcLayer.writeProperty("tiledlayercd.prop.tiles", propTiles);
            }
        });
        if (DEBUG_UNDO) {
            System.out.println("Layer props changed: " + layer);
        }
    }

    @Override
    public void sequenceAdded(SequenceContainer source, Sequence sequence, int index) {
        this.sequenceContainerChanged(source);
    }

    @Override
    public void sequenceRemoved(SequenceContainer source, Sequence sequence, int index) {
        this.sequenceContainerChanged(source);
    }

    @Override
    public void sequenceMoved(SequenceContainer source, Sequence sequence, int indexOld, int indexNew) {
        this.sequenceContainerChanged(source);
    }

    private void sequenceContainerChanged(final SequenceContainer sequenceContainer) {
        DesignComponent dcSequenceContainer = this.designIdMap.get(sequenceContainer);
        assert (dcSequenceContainer != null);
        this.document.getTransactionManager().writeAccess(new Runnable(){

            @Override
            public void run() {
                GameController.this.writeSequencesToSequenceContainerDC(sequenceContainer);
            }
        });
        if (DEBUG_UNDO) {
            System.out.println("Seq container changed: " + sequenceContainer);
        }
    }

    private void writeSequencesToSequenceContainerDC(SequenceContainer sequenceContainer) {
        DesignComponent dcSequenceContainer = this.designIdMap.get(sequenceContainer);
        assert (dcSequenceContainer != null);
        ArrayList<PropertyValue> sequenceDCs = new ArrayList<PropertyValue>();
        List<Sequence> sequences = sequenceContainer.getSequences();
        ArrayList iter = new ArrayList(dcSequenceContainer.getComponents());
        for (DesignComponent dcSequence : iter) {
            boolean found = false;
            for (Sequence sequence : sequences) {
                if (this.designIdMap.get(sequence) != dcSequence) continue;
                found = true;
                break;
            }
            if (found) continue;
            dcSequenceContainer.removeComponent(dcSequence);
        }
        for (Sequence sequence : sequences) {
            DesignComponent dcSequence = this.designIdMap.get(sequence);
            if (dcSequence == null) {
                dcSequence = this.createSequenceDCFromSequence(sequence);
                this.designIdMap.put(sequence, dcSequence);
            }
            if (!dcSequenceContainer.getComponents().contains(dcSequence)) {
                dcSequenceContainer.addComponent(dcSequence);
            }
            PropertyValue seqPropVal = PropertyValue.createComponentReference((DesignComponent)dcSequence);
            sequenceDCs.add(seqPropVal);
        }
        this.changeMap.put(dcSequenceContainer.getComponentID(), "sequencecontainer.prop.sequences");
        dcSequenceContainer.writeProperty("sequencecontainer.prop.sequences", PropertyValue.createArray((TypeID)SequenceCD.TYPEID, sequenceDCs));
    }

    @Override
    public void frameAdded(Sequence sequence, int index) {
        this.updateSequenceFrames(sequence);
    }

    @Override
    public void frameRemoved(Sequence sequence, int index) {
        this.updateSequenceFrames(sequence);
    }

    @Override
    public void frameModified(Sequence sequence, int index) {
        this.updateSequenceFrames(sequence);
    }

    @Override
    public void framesChanged(Sequence sequence) {
        this.updateSequenceFrames(sequence);
    }

    private void updateSequenceFrames(final Sequence sequence) {
        this.document.getTransactionManager().writeAccess(new Runnable(){

            @Override
            public void run() {
                DesignComponent dcSequence = (DesignComponent)GameController.this.designIdMap.get(sequence);
                assert (dcSequence != null);
                GameController.this.changeMap.put(dcSequence.getComponentID(), "sequncecd.prop.frames");
                int[] frames = sequence.getFramesAsArray();
                dcSequence.writeProperty("sequncecd.prop.frames", GameTypes.createFramesProperty(frames));
            }
        });
        if (DEBUG_UNDO) {
            System.out.println("Seq frames changed: " + sequence);
        }
    }

    @Override
    public void animatedTileAdded(final ImageResource imgRes, final AnimatedTile tile) {
        this.document.getTransactionManager().writeAccess(new Runnable(){

            @Override
            public void run() {
                if (DEBUG) {
                    System.out.println("animatedTileAdded: " + tile);
                }
                DesignComponent dcImgRes = (DesignComponent)GameController.this.designIdMap.get(imgRes);
                assert (dcImgRes != null);
                GameController.this.writeAnimatedTilesToImageResourceDC(dcImgRes, imgRes);
                DesignComponent dcAnimTile = (DesignComponent)GameController.this.designIdMap.get(tile);
                assert (dcAnimTile != null);
                GameController.this.changeMap.put(dcImgRes.getComponentID(), "imageresourcecd.prop.name");
                tile.addSequenceContainerListener(GameController.this);
                tile.addPropertyChangeListener(GameController.this);
            }
        });
        if (DEBUG_UNDO) {
            System.out.println("Anim tile added: " + tile);
        }
    }

    @Override
    public void animatedTileRemoved(final ImageResource imgRes, final AnimatedTile tile) {
        this.document.getTransactionManager().writeAccess(new Runnable(){

            @Override
            public void run() {
                if (DEBUG) {
                    System.out.println("animatedTileRemoved: " + tile);
                }
                DesignComponent dcAnimTile = (DesignComponent)GameController.this.designIdMap.get(tile);
                assert (dcAnimTile != null);
                DesignComponent dcImgRes = (DesignComponent)GameController.this.designIdMap.get(imgRes);
                assert (dcImgRes != null);
                dcImgRes.removeComponent(dcAnimTile);
                ArrayList tmp = new ArrayList(dcAnimTile.getComponents());
                for (DesignComponent child : tmp) {
                    GameController.this.changeMap.put(child.getComponentID(), null);
                    dcAnimTile.removeComponent(child);
                    GameController.this.document.deleteComponent(child);
                }
                GameController.this.document.deleteComponent(dcAnimTile);
                GameController.this.changeMap.put(dcImgRes.getComponentID(), "imageresourcecd.prop.name");
            }
        });
        if (DEBUG_UNDO) {
            System.out.println("Anim tile removed: " + tile);
        }
        this.gameEditorView.discardAllEdits();
    }

    @Override
    public void sequenceAdded(ImageResource source, Sequence sequence) {
        if (DEBUG_UNDO) {
            System.out.println("IGNORE ImageResourceListener Seq added: " + sequence);
        }
    }

    @Override
    public void sequenceRemoved(ImageResource source, Sequence sequence) {
        if (DEBUG_UNDO) {
            System.out.println("IGNORE ImageResourceListener Seq removed: " + sequence);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        DesignComponent dc = this.designIdMap.get(e.getSource());
        assert (dc != null);
        if (dc.getType() == SceneCD.TYPEID) {
            this.handleScenePropChange(dc, e);
        } else if (dc.getType() == AnimatedTileCD.TYPEID) {
            this.handleAnimatedTilePropChange(dc, e);
        } else if (dc.getType() == ImageResourceCD.TYPEID) {
            this.handleImageResourcePropChange(dc, e);
        } else if (dc.getType() == SequenceCD.TYPEID) {
            this.handleSequencePropChange(dc, e);
        } else if (dc.getType() == SpriteCD.TYPEID) {
            this.handleSpritePropChange(dc, e);
        } else if (dc.getType() == TiledLayerCD.TYPEID) {
            this.handleTiledLayerPropChange(dc, e);
        }
    }

    private void handleScenePropChange(final DesignComponent dcScene, final PropertyChangeEvent e) {
        if (e.getPropertyName().equals("editable.prop.name")) {
            this.document.getTransactionManager().writeAccess(new Runnable(){

                @Override
                public void run() {
                    String newName = (String)e.getNewValue();
                    dcScene.writeProperty("scenecd.prop.name", MidpTypes.createStringValue((String)newName));
                    GameController.this.changeMap.put(dcScene.getComponentID(), "scenecd.prop.name");
                }
            });
            if (DEBUG_UNDO) {
                System.out.println("Scene name changed: " + dcScene);
            }
        }
    }

    private void handleAnimatedTilePropChange(final DesignComponent dcAnimatedTile, final PropertyChangeEvent e) {
        if (e.getPropertyName().equals("editable.prop.name")) {
            this.document.getTransactionManager().writeAccess(new Runnable(){

                @Override
                public void run() {
                    String newName = (String)e.getNewValue();
                    dcAnimatedTile.writeProperty("animatedtilecd.prop.name", MidpTypes.createStringValue((String)newName));
                    GameController.this.changeMap.put(dcAnimatedTile.getComponentID(), "animatedtilecd.prop.name");
                }
            });
            if (DEBUG_UNDO) {
                System.out.println("AnimatedTile name changed: " + dcAnimatedTile);
            }
        }
        if (e.getPropertyName().equals("sequencecontainer.prop.defaultsequence")) {
            this.document.getTransactionManager().writeAccess(new Runnable(){

                @Override
                public void run() {
                    Sequence newDefSeq = (Sequence)e.getNewValue();
                    DesignComponent dcDefSeq = (DesignComponent)GameController.this.designIdMap.get(newDefSeq);
                    dcAnimatedTile.writeProperty("sequencecontainer.prop.defaultsequence", PropertyValue.createComponentReference((DesignComponent)dcDefSeq));
                    GameController.this.changeMap.put(dcAnimatedTile.getComponentID(), "sequencecontainer.prop.defaultsequence");
                }
            });
            if (DEBUG_UNDO) {
                System.out.println("AnimatedTile def seq changed: " + dcAnimatedTile);
            }
        }
    }

    private void handleImageResourcePropChange(DesignComponent dcImageResource, PropertyChangeEvent e) {
    }

    private void handleSequencePropChange(final DesignComponent dcSequence, final PropertyChangeEvent e) {
        if (e.getPropertyName().equals("sequence.prop.name")) {
            this.document.getTransactionManager().writeAccess(new Runnable(){

                @Override
                public void run() {
                    String newName = (String)e.getNewValue();
                    dcSequence.writeProperty("sequncecd.prop.name", MidpTypes.createStringValue((String)newName));
                    GameController.this.changeMap.put(dcSequence.getComponentID(), "sequncecd.prop.name");
                }
            });
            if (DEBUG_UNDO) {
                System.out.println("Sequence name changed: " + dcSequence);
            }
        } else if (e.getPropertyName().equals("sequence.prop.frames.ms")) {
            this.document.getTransactionManager().writeAccess(new Runnable(){

                @Override
                public void run() {
                    int ms = (Integer)e.getNewValue();
                    dcSequence.writeProperty("sequncecd.prop.framems", MidpTypes.createIntegerValue((int)ms));
                    GameController.this.changeMap.put(dcSequence.getComponentID(), "sequncecd.prop.framems");
                }
            });
            if (DEBUG_UNDO) {
                System.out.println("Sequence frame ms changed: " + dcSequence);
            }
        }
    }

    private void handleSpritePropChange(final DesignComponent dcSprite, final PropertyChangeEvent e) {
        if (e.getPropertyName().equals("editable.prop.name")) {
            this.document.getTransactionManager().writeAccess(new Runnable(){

                @Override
                public void run() {
                    String newName = (String)e.getNewValue();
                    dcSprite.writeProperty("layercd.prop.name", MidpTypes.createStringValue((String)newName));
                    GameController.this.changeMap.put(dcSprite.getComponentID(), "layercd.prop.name");
                }
            });
            if (DEBUG_UNDO) {
                System.out.println("Sprite name changed: " + dcSprite);
            }
        } else if (e.getPropertyName().equals("sequencecontainer.prop.defaultsequence")) {
            this.document.getTransactionManager().writeAccess(new Runnable(){

                @Override
                public void run() {
                    Sequence newDefSeq = (Sequence)e.getNewValue();
                    DesignComponent dcDefSeq = (DesignComponent)GameController.this.designIdMap.get(newDefSeq);
                    dcSprite.writeProperty("sequencecontainer.prop.defaultsequence", PropertyValue.createComponentReference((DesignComponent)dcDefSeq));
                    GameController.this.changeMap.put(dcSprite.getComponentID(), "sequencecontainer.prop.defaultsequence");
                }
            });
            if (DEBUG_UNDO) {
                System.out.println("Sprite def seq changed: " + dcSprite);
            }
        }
    }

    private void handleTiledLayerPropChange(final DesignComponent dcTiledLayer, final PropertyChangeEvent e) {
        if (e.getPropertyName().equals("editable.prop.name")) {
            this.document.getTransactionManager().writeAccess(new Runnable(){

                @Override
                public void run() {
                    String newName = (String)e.getNewValue();
                    dcTiledLayer.writeProperty("layercd.prop.name", MidpTypes.createStringValue((String)newName));
                    GameController.this.changeMap.put(dcTiledLayer.getComponentID(), "layercd.prop.name");
                }
            });
            if (DEBUG_UNDO) {
                System.out.println("TiledLayer name changed: " + dcTiledLayer);
            }
        }
    }
}

