/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.expr;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.BooleanType;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.ByteType;
import com.sun.jdi.ByteValue;
import com.sun.jdi.CharType;
import com.sun.jdi.CharValue;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassNotPreparedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.DoubleType;
import com.sun.jdi.DoubleValue;
import com.sun.jdi.Field;
import com.sun.jdi.FloatType;
import com.sun.jdi.FloatValue;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.IntegerType;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.InternalException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.LongType;
import com.sun.jdi.LongValue;
import com.sun.jdi.Method;
import com.sun.jdi.Mirror;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveType;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ShortType;
import com.sun.jdi.ShortValue;
import com.sun.jdi.StackFrame;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.AssertTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.BreakTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ContinueTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EmptyStatementTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ErroneousTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.LabeledStatementTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.tree.WildcardTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDAClassType;
import org.netbeans.api.debugger.jpda.LocalVariable;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.expr.Assert;
import org.netbeans.modules.debugger.jpda.expr.EvaluationContext;
import org.netbeans.modules.debugger.jpda.expr.InvocationExceptionTranslated;
import org.netbeans.modules.debugger.jpda.expr.JDIVariable;
import org.netbeans.modules.debugger.jpda.expr.JavaExpression;
import org.netbeans.modules.debugger.jpda.jdi.ArrayTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.models.CallStackFrameImpl;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.modules.debugger.jpda.models.ReturnVariableImpl;
import org.netbeans.modules.debugger.jpda.util.JPDAUtils;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class EvaluatorVisitor
extends TreePathScanner<Mirror, EvaluationContext> {
    private static final Logger loggerMethod = Logger.getLogger("org.netbeans.modules.debugger.jpda.invokeMethod");
    private static final Logger loggerValue = Logger.getLogger("org.netbeans.modules.debugger.jpda.getValue");
    private Type newArrayType;
    private JavaExpression expression;
    private Map<Tree, Type> subExpressionTypes = new IdentityHashMap<Tree, Type>();
    private static final String BRACKETS = "[][][][][][][][][][][][][][][][][][][][]";
    private static final Set<String> PRIMITIVE_CLASS_NAMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(Boolean.class.getName(), Byte.class.getName(), Character.class.getName(), Short.class.getName(), Integer.class.getName(), Long.class.getName(), Float.class.getName(), Double.class.getName())));

    public EvaluatorVisitor(JavaExpression expression) {
        this.expression = expression;
    }

    private Type getSubExpressionType(Tree t) {
        Type type = this.subExpressionTypes.get(t);
        if (type != null) {
            return type;
        }
        if (t.getKind() == Tree.Kind.PARENTHESIZED) {
            return this.getSubExpressionType(((ParenthesizedTree)t).getExpression());
        }
        return null;
    }

    @Override
    public Mirror scan(Tree tree, EvaluationContext evaluationContext) {
        Mirror result = (Mirror)super.scan(tree, evaluationContext);
        if (result instanceof ArtificialMirror) {
            return ((ArtificialMirror)result).getVMMirror();
        }
        return result;
    }

    @Override
    public Mirror scan(TreePath path, EvaluationContext evaluationContext) {
        Mirror result = (Mirror)super.scan(path, evaluationContext);
        if (result instanceof ArtificialMirror) {
            return ((ArtificialMirror)result).getVMMirror();
        }
        return result;
    }

    @Override
    public Mirror scan(Iterable<? extends Tree> nodes, EvaluationContext evaluationContext) {
        Mirror result = (Mirror)super.scan(nodes, evaluationContext);
        if (result instanceof ArtificialMirror) {
            return ((ArtificialMirror)result).getVMMirror();
        }
        return result;
    }

    @Override
    public Mirror visitAnnotation(AnnotationTree arg0, EvaluationContext evaluationContext) {
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Mirror visitMethodInvocation(MethodInvocationTree arg0, EvaluationContext evaluationContext) {
        void var15_28;
        ReferenceType type;
        Element elm;
        String methodName;
        if (!evaluationContext.canInvokeMethods()) {
            Assert.error(arg0, "canNotInvokeMethods");
        }
        if (loggerMethod.isLoggable(Level.FINE)) {
            loggerMethod.fine("STARTED : " + arg0 + " in thread " + evaluationContext.getFrame().thread());
        }
        Mirror object = null;
        Boolean isStatic = null;
        ExpressionTree expr = arg0.getMethodSelect();
        Type preferredType = null;
        TreePath currentPath = this.getCurrentPath();
        if (expr.getKind() == Tree.Kind.MEMBER_SELECT) {
            MemberSelectTree mst = (MemberSelectTree)expr;
            object = mst.getExpression().accept(this, evaluationContext);
            methodName = mst.getIdentifier().toString();
            if (object == null) {
                Assert.error((Tree)arg0, "methodCallOnNull", methodName);
            }
            if (mst.getExpression().toString().equals("super")) {
                preferredType = this.getSubExpressionType(mst.getExpression());
            }
            if (currentPath != null) {
                TreePath memberSelectPath = TreePath.getPath(currentPath, (Tree)mst);
                if (memberSelectPath == null) {
                    memberSelectPath = currentPath;
                }
                elm = evaluationContext.getTrees().getElement(memberSelectPath);
            } else {
                elm = null;
            }
        } else if (currentPath != null) {
            TreePath methodInvokePath = TreePath.getPath(currentPath, (Tree)arg0);
            if (methodInvokePath == null) {
                methodInvokePath = currentPath;
            }
            elm = evaluationContext.getTrees().getElement(methodInvokePath);
            methodName = elm.getSimpleName().toString();
        } else {
            elm = null;
            methodName = expr.toString();
        }
        List<? extends TypeMirror> paramTypes = null;
        String enclosingClass = null;
        if (elm != null) {
            TypeMirror typeMirror = elm.asType();
            TypeKind kind = typeMirror.getKind();
            if (kind == TypeKind.ERROR) {
                elm = null;
            } else {
                if (kind != TypeKind.EXECUTABLE) {
                    Assert.error(arg0, "noSuchMethod", elm.getSimpleName().toString(), elm.getEnclosingElement().getSimpleName().toString());
                }
                ExecutableElement methodElement = (ExecutableElement)elm;
                ExecutableType executableType = (ExecutableType)typeMirror;
                paramTypes = executableType.getParameterTypes();
                isStatic = methodElement.getModifiers().contains((Object)Modifier.STATIC);
                Element enclosing = methodElement.getEnclosingElement();
                if (enclosing.getKind() == ElementKind.CLASS) {
                    TypeElement enclosingClassElement = (TypeElement)enclosing;
                    enclosingClass = ElementUtilities.getBinaryName((TypeElement)enclosingClassElement);
                }
            }
        }
        List<? extends ExpressionTree> args = arg0.getArguments();
        ArrayList<Value> argVals = new ArrayList<Value>(args.size());
        for (ExpressionTree expressionTree : args) {
            Mirror argValue = expressionTree.accept(this, evaluationContext);
            if (argValue != null && !(argValue instanceof Value)) {
                Assert.error(expressionTree, "Not a value");
            }
            if (argValue instanceof ArtificialMirror) {
                argValue = ((ArtificialMirror)argValue).getVMMirror();
            }
            argVals.add((Value)argValue);
        }
        ArrayList<Type> argTypes = null;
        if (elm == null) {
            argTypes = new ArrayList<Type>(argVals.size());
            for (Value value : argVals) {
                if (value == null) {
                    VirtualMachine vm = evaluationContext.getDebugger().getVirtualMachine();
                    if (vm == null) {
                        return null;
                    }
                    argTypes.add(vm.classesByName("java.lang.Object").get(0));
                    continue;
                }
                argTypes.add(value.type());
            }
        }
        if (isStatic == null) {
            if (object instanceof ClassType || object instanceof ArrayType) {
                type = (ReferenceType)object;
                Object var15_20 = null;
                isStatic = Boolean.TRUE;
            } else if (object instanceof ObjectReference) {
                ObjectReference objectReference = (ObjectReference)object;
                type = (ReferenceType)preferredType;
                if (type == null) {
                    type = (ReferenceType)objectReference.type();
                }
            } else {
                ObjectReference objectReference = evaluationContext.getContextObject();
                if (objectReference != null) {
                    type = objectReference.referenceType();
                } else {
                    Assert.error((Tree)arg0, "invokeInstanceMethodAsStatic", methodName);
                    type = evaluationContext.getFrame().location().declaringType();
                }
            }
        } else if (isStatic.booleanValue()) {
            Object var15_23 = null;
            if (object instanceof ClassType || object instanceof ArrayType) {
                type = (ReferenceType)object;
            } else if (object instanceof ObjectReference) {
                type = (ReferenceType)((ObjectReference)object).type();
            } else {
                ReferenceType dt;
                type = evaluationContext.getFrame().location().declaringType();
                if (enclosingClass != null && (dt = this.findEnclosingType(type, enclosingClass)) != null) {
                    type = dt;
                }
            }
        } else {
            void var15_27;
            if (object != null) {
                if (object instanceof ClassType) {
                    Assert.error((Tree)arg0, "invokeInstanceMethodAsStatic", methodName);
                    Object var15_24 = null;
                    type = null;
                } else {
                    ObjectReference objectReference = (ObjectReference)object;
                    type = (ReferenceType)preferredType;
                    if (type == null) {
                        type = objectReference.referenceType();
                    }
                }
            } else {
                ObjectReference objectReference = evaluationContext.getContextObject();
                if (objectReference != null) {
                    ReferenceType enclType;
                    type = objectReference.referenceType();
                    if (enclosingClass != null && (enclType = this.findEnclosingType(type, enclosingClass)) != null) {
                        ObjectReference enclObject = this.findEnclosingObject(arg0, objectReference, enclType, null, methodName);
                        if (enclObject != null) {
                            type = enclObject.referenceType();
                        } else {
                            Assert.error(arg0, "noSuchMethod", methodName, type.name());
                        }
                    }
                } else {
                    type = null;
                }
            }
            if (var15_27 == null) {
                Assert.error((Tree)arg0, "methodCallOnNull", methodName);
            }
        }
        if (type instanceof ArrayType) {
            Assert.error(arg0, "methOnArray");
            return null;
        }
        ClassType cType = (ClassType)type;
        Method method = EvaluatorVisitor.getConcreteMethodAndReportProblems(arg0, type, methodName, null, paramTypes, argTypes);
        return this.invokeMethod(arg0, method, isStatic, cType, (ObjectReference)var15_28, argVals, evaluationContext, preferredType != null);
    }

    private static Method getConcreteMethodAndReportProblems(Tree arg0, ReferenceType type, String methodName, String firstParamSignature, List<? extends TypeMirror> paramTypes, List<? extends Type> argTypes) {
        Method method;
        try {
            method = paramTypes != null ? EvaluatorVisitor.getConcreteMethod(type, methodName, firstParamSignature, paramTypes) : EvaluatorVisitor.getConcreteMethod2(type, methodName, argTypes);
        }
        catch (UnsuitableArgumentsException uaex) {
            StringBuilder methodArgs = new StringBuilder("(");
            if (paramTypes != null) {
                for (TypeMirror typeMirror : paramTypes) {
                    if (methodArgs.length() > 1) {
                        methodArgs.append(", ");
                    }
                    methodArgs.append(((Object)typeMirror).toString());
                }
            } else {
                for (Type type2 : argTypes) {
                    if (methodArgs.length() > 1) {
                        methodArgs.append(", ");
                    }
                    methodArgs.append(type2.name());
                }
            }
            methodArgs.append(")");
            if ("<init>".equals(methodName)) {
                Assert.error(arg0, "noSuchConstructorWithArgs", type.name(), methodArgs.toString());
            }
            if (methodArgs.length() == 2) {
                Assert.error(arg0, "noSuchMethod", methodName + methodArgs, type.name());
            } else {
                Assert.error(arg0, "noSuchMethodWithArgs", methodName, type.name(), methodArgs.toString());
            }
            method = null;
        }
        if (method == null) {
            Assert.error(arg0, "noSuchMethod", methodName, type.name());
        }
        return method;
    }

    private static Method getConcreteMethod(ReferenceType type, String methodName, List<? extends TypeMirror> typeArguments) throws UnsuitableArgumentsException {
        return EvaluatorVisitor.getConcreteMethod(type, methodName, null, typeArguments);
    }

    private static Method getConcreteMethod(ReferenceType type, String methodName, String firstParamSignature, List<? extends TypeMirror> typeArguments) throws UnsuitableArgumentsException {
        List<Method> methods = type.methodsByName(methodName);
        String signature = EvaluatorVisitor.createSignature(firstParamSignature, typeArguments);
        boolean constructor = "<init>".equals(methodName);
        for (Method method : methods) {
            if (method.isAbstract() || constructor && !((Object)type).equals(method.declaringType()) || !EvaluatorVisitor.equalMethodSignatures(method.signature(), signature)) continue;
            return method;
        }
        if (methods.size() > 0) {
            throw new UnsuitableArgumentsException();
        }
        return null;
    }

    private static Method getConcreteMethod2(ReferenceType type, String methodName, List<? extends Type> typeArguments) throws UnsuitableArgumentsException {
        List<Method> methods = type.methodsByName(methodName);
        ArrayList<Method> possibleMethods = new ArrayList<Method>();
        ArrayList<Method> methodsWithArgTypesNotLoaded = null;
        boolean constructor = "<init>".equals(methodName);
        for (Method method : methods) {
            if (method.isAbstract() || constructor && !((Object)type).equals(method.declaringType())) continue;
            try {
                if (EvaluatorVisitor.equalTypes(method.argumentTypes(), typeArguments)) {
                    return method;
                }
                if (!EvaluatorVisitor.acceptTypes(method.argumentTypes(), typeArguments)) continue;
                possibleMethods.add(method);
            }
            catch (ClassNotLoadedException ex) {
                if (method.argumentTypeNames().size() != typeArguments.size()) continue;
                if (methodsWithArgTypesNotLoaded == null) {
                    methodsWithArgTypesNotLoaded = new ArrayList<Method>();
                }
                methodsWithArgTypesNotLoaded.add(method);
            }
        }
        if (possibleMethods.size() == 0) {
            if (methods.size() > 0) {
                if (methodsWithArgTypesNotLoaded != null) {
                    return (Method)methodsWithArgTypesNotLoaded.get(0);
                }
                throw new UnsuitableArgumentsException();
            }
            return null;
        }
        return (Method)possibleMethods.get(0);
    }

    private static boolean equalTypes(List<? extends Type> methodTypes, List<? extends Type> argumentTypes) {
        if (methodTypes.size() != argumentTypes.size()) {
            return false;
        }
        int n = methodTypes.size();
        for (int i = 0; i < n; ++i) {
            if (methodTypes.get(i).equals(argumentTypes.get(i)) || EvaluatorVisitor.unboxType(methodTypes.get(i)).equals(EvaluatorVisitor.unboxType(argumentTypes.get(i)))) continue;
            return false;
        }
        return true;
    }

    private static boolean acceptTypes(List<? extends Type> methodTypes, List<? extends Type> argumentTypes) {
        if (methodTypes.size() != argumentTypes.size()) {
            return false;
        }
        int n = methodTypes.size();
        for (int i = 0; i < n; ++i) {
            Type argType;
            Type methodType = EvaluatorVisitor.unboxType(methodTypes.get(i));
            if (methodType.equals(argType = EvaluatorVisitor.unboxType(argumentTypes.get(i))) || EvaluatorVisitor.extendsType(argType, methodType)) continue;
            return false;
        }
        return true;
    }

    private static boolean extendsType(Type argType, Type methodType) {
        if (methodType instanceof ReferenceType && argType instanceof ReferenceType) {
            return EvaluatorVisitor.extendsType((ReferenceType)argType, (ReferenceType)methodType);
        }
        if (methodType instanceof PrimitiveType && argType instanceof PrimitiveType) {
            return EvaluatorVisitor.extendsType((PrimitiveType)argType, (PrimitiveType)methodType);
        }
        return false;
    }

    private static boolean extendsType(ReferenceType t1, ReferenceType t2) {
        if (t2 instanceof InterfaceType) {
            List<InterfaceType> superInterfaces;
            if (t1 instanceof ClassType) {
                superInterfaces = ((ClassType)t1).allInterfaces();
            } else if (t1 instanceof InterfaceType) {
                superInterfaces = ((InterfaceType)t1).superinterfaces();
            } else {
                return false;
            }
            return superInterfaces.contains(t2);
        }
        if (t2 instanceof ClassType) {
            if (t1 instanceof ClassType) {
                ClassType superClass = ((ClassType)t1).superclass();
                if (superClass != null) {
                    if (superClass.equals(t2)) {
                        return true;
                    }
                    return EvaluatorVisitor.extendsType(superClass, t2);
                }
                return false;
            }
            return false;
        }
        if (t2 instanceof ArrayType) {
            if (t1 instanceof ArrayType) {
                try {
                    Type ct1 = ((ArrayType)t1).componentType();
                    Type ct2 = ((ArrayType)t2).componentType();
                    return EvaluatorVisitor.extendsType(ct1, ct2);
                }
                catch (ClassNotLoadedException cnlex) {
                    return false;
                }
            }
            return false;
        }
        throw new IllegalStateException("Unknown ReferenceType: " + t2);
    }

    private static boolean extendsType(PrimitiveType t1, PrimitiveType t2) {
        if (t2 instanceof ShortType) {
            return t2 instanceof ByteType || t2 instanceof ShortType;
        }
        if (t2 instanceof IntegerType) {
            return t2 instanceof ByteType || t2 instanceof ShortType || t2 instanceof IntegerType;
        }
        if (t2 instanceof LongType) {
            return t2 instanceof ByteType || t2 instanceof ShortType || t2 instanceof IntegerType || t2 instanceof LongType;
        }
        if (t2 instanceof FloatType) {
            return !(t2 instanceof BooleanType) && !(t2 instanceof CharType) && !(t2 instanceof DoubleType);
        }
        if (t2 instanceof DoubleType) {
            return !(t2 instanceof BooleanType) && !(t2 instanceof CharType);
        }
        return false;
    }

    private static Type unboxType(Type t) {
        if (t instanceof ClassType) {
            String name = ((ClassType)t).name();
            if (name.equals("java.lang.Boolean")) {
                t = t.virtualMachine().mirrorOf(true).type();
            } else if (name.equals("java.lang.Byte")) {
                t = t.virtualMachine().mirrorOf((byte)10).type();
            } else if (name.equals("java.lang.Character")) {
                t = t.virtualMachine().mirrorOf('a').type();
            } else if (name.equals("java.lang.Integer")) {
                t = t.virtualMachine().mirrorOf(10).type();
            } else if (name.equals("java.lang.Long")) {
                t = t.virtualMachine().mirrorOf(10L).type();
            } else if (name.equals("java.lang.Short")) {
                t = t.virtualMachine().mirrorOf((short)10).type();
            } else if (name.equals("java.lang.Float")) {
                t = t.virtualMachine().mirrorOf(10.0f).type();
            } else if (name.equals("java.lang.Double")) {
                t = t.virtualMachine().mirrorOf(10.0).type();
            }
        }
        return t;
    }

    private static boolean equalMethodSignatures(String s1, String s2) {
        int i = s1.lastIndexOf(")");
        if (i > 0) {
            s1 = s1.substring(0, i);
        }
        if ((i = s2.lastIndexOf(")")) > 0) {
            s2 = s2.substring(0, i);
        }
        return s1.equals(s2);
    }

    private static String createSignature(String firstParamSignature, List<? extends TypeMirror> typeArguments) {
        StringBuilder signature = new StringBuilder("(");
        if (firstParamSignature != null) {
            signature.append(firstParamSignature);
        }
        for (TypeMirror typeMirror : typeArguments) {
            String paramType = EvaluatorVisitor.getTypeName(typeMirror);
            signature.append(EvaluatorVisitor.getSignature(paramType));
        }
        signature.append(')');
        return signature.toString();
    }

    private static String getTypeName(TypeMirror type) {
        if (type.getKind() == TypeKind.ARRAY) {
            return EvaluatorVisitor.getTypeName(((javax.lang.model.type.ArrayType)type).getComponentType()) + "[]";
        }
        if (type.getKind() == TypeKind.TYPEVAR) {
            TypeVariable tv = (TypeVariable)type;
            return EvaluatorVisitor.getTypeName(tv.getUpperBound());
        }
        if (type.getKind() == TypeKind.DECLARED) {
            return ElementUtilities.getBinaryName((TypeElement)((TypeElement)((DeclaredType)type).asElement()));
        }
        return ((Object)type).toString();
    }

    private static String getSignature(String javaType) {
        if (javaType.equals("boolean")) {
            return "Z";
        }
        if (javaType.equals("byte")) {
            return "B";
        }
        if (javaType.equals("char")) {
            return "C";
        }
        if (javaType.equals("short")) {
            return "S";
        }
        if (javaType.equals("int")) {
            return "I";
        }
        if (javaType.equals("long")) {
            return "J";
        }
        if (javaType.equals("float")) {
            return "F";
        }
        if (javaType.equals("double")) {
            return "D";
        }
        if (javaType.endsWith("[]")) {
            return "[" + EvaluatorVisitor.getSignature(javaType.substring(0, javaType.length() - 2));
        }
        return "L" + javaType.replace('.', '/') + ";";
    }

    private static ReferenceType getClassType(Tree tree, TypeMirror type, EvaluationContext evaluationContext) {
        String className = ElementUtilities.getBinaryName((TypeElement)((TypeElement)((DeclaredType)type).asElement()));
        VirtualMachine vm = evaluationContext.getDebugger().getVirtualMachine();
        if (vm == null) {
            return null;
        }
        ReferenceType clazz = EvaluatorVisitor.getOrLoadClass(vm, className, evaluationContext);
        if (clazz == null) {
            Assert.error(tree, "unknownType", className);
        }
        return clazz;
    }

    public static boolean instanceOf(Type left, Type right) {
        if (left == null) {
            return false;
        }
        if (left.equals(right)) {
            return true;
        }
        if (right instanceof ArrayType) {
            Type rightType;
            Type leftType;
            if (!(left instanceof ArrayType)) {
                return false;
            }
            ArrayType leftArray = (ArrayType)left;
            ArrayType rightArray = (ArrayType)right;
            try {
                leftType = leftArray.componentType();
                rightType = rightArray.componentType();
            }
            catch (ClassNotLoadedException e) {
                return false;
            }
            return EvaluatorVisitor.instanceOf(leftType, rightType);
        }
        if (left instanceof ClassType) {
            ClassType classLeft = (ClassType)left;
            if (right instanceof InterfaceType) {
                List<InterfaceType> ifaces;
                try {
                    ifaces = classLeft.allInterfaces();
                }
                catch (ClassNotPreparedException cnpex) {
                    return false;
                }
                for (InterfaceType type : ifaces) {
                    if (!type.equals(right)) continue;
                    return true;
                }
                return false;
            }
            do {
                if ((classLeft = classLeft.superclass()) != null) continue;
                return false;
            } while (!classLeft.equals(right));
            return true;
        }
        if (left instanceof InterfaceType) {
            InterfaceType intLeft = (InterfaceType)left;
            if (right instanceof InterfaceType) {
                List<InterfaceType> ifaces;
                try {
                    ifaces = intLeft.superinterfaces();
                }
                catch (ClassNotPreparedException cnpex) {
                    return false;
                }
                for (InterfaceType type : ifaces) {
                    if (!type.equals(right)) continue;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    @Override
    public Mirror visitAssert(AssertTree arg0, EvaluationContext evaluationContext) {
        Assert.error(arg0, "unsupported");
        return null;
    }

    @Override
    public Mirror visitAssignment(AssignmentTree arg0, EvaluationContext evaluationContext) {
        Mirror var = arg0.getVariable().accept(this, evaluationContext);
        Mirror exp = arg0.getExpression().accept(this, evaluationContext);
        Value value = (Value)exp;
        return this.setToMirror(arg0.getVariable(), value, evaluationContext);
    }

    @Override
    public Mirror visitCompoundAssignment(CompoundAssignmentTree arg0, EvaluationContext evaluationContext) {
        Value value;
        Mirror var = arg0.getVariable().accept(this, evaluationContext);
        Mirror exp = arg0.getExpression().accept(this, evaluationContext);
        VirtualMachine vm = evaluationContext.getDebugger().getVirtualMachine();
        if (vm == null) {
            return null;
        }
        Tree.Kind kind = arg0.getKind();
        if (var instanceof ObjectReference) {
            var = EvaluatorVisitor.unboxIfCan(arg0, (ObjectReference)var, evaluationContext);
        }
        if (var == null) {
            TreePath currentPath = this.getCurrentPath();
            Element elm = null;
            if (currentPath != null) {
                TreePath identifierPath = TreePath.getPath(currentPath, (Tree)arg0.getVariable());
                if (identifierPath == null) {
                    identifierPath = this.getCurrentPath();
                }
                if ((elm = evaluationContext.getTrees().getElement(identifierPath)) instanceof TypeElement && ((TypeElement)elm).asType() instanceof ErrorType) {
                    elm = null;
                }
            }
            if (elm == null) {
                Assert.error(arg0, "evaluateError", arg0.getVariable(), EvaluatorVisitor.operatorToString(kind), arg0.getExpression());
            }
            TypeMirror type = elm.asType();
            switch (type.getKind()) {
                case BOOLEAN: {
                    var = vm.mirrorOf(false);
                    break;
                }
                case BYTE: {
                    var = vm.mirrorOf((byte)0);
                    break;
                }
                case CHAR: {
                    var = vm.mirrorOf('\u0000');
                    break;
                }
                case DOUBLE: {
                    var = vm.mirrorOf(0.0);
                    break;
                }
                case FLOAT: {
                    var = vm.mirrorOf(0.0f);
                    break;
                }
                case INT: {
                    var = vm.mirrorOf(0);
                    break;
                }
                case LONG: {
                    var = vm.mirrorOf(0L);
                    break;
                }
                case SHORT: {
                    var = vm.mirrorOf((short)0);
                    break;
                }
                default: {
                    if (((Object)type).toString().equals("java.lang.String")) {
                        try {
                            var = vm.mirrorOf("null");
                        }
                        catch (UnsupportedOperationException e) {
                            Assert.error(arg0, "unsupportedStringCreation");
                        }
                        break;
                    }
                    Assert.error(arg0, "evaluateError", arg0.getVariable(), EvaluatorVisitor.operatorToString(kind), arg0.getExpression());
                }
            }
        }
        if (var instanceof BooleanValue) {
            boolean v = ((BooleanValue)var).value();
            if (!(exp instanceof BooleanValue)) {
                Assert.error(arg0, "evaluateError", arg0.getVariable(), EvaluatorVisitor.operatorToString(kind), arg0.getExpression());
            }
            boolean e = ((BooleanValue)exp).value();
            switch (kind) {
                case AND_ASSIGNMENT: {
                    v &= e;
                    break;
                }
                case OR_ASSIGNMENT: {
                    v |= e;
                    break;
                }
                case XOR_ASSIGNMENT: {
                    v ^= e;
                    break;
                }
                default: {
                    Assert.error(arg0, "evaluateError", arg0.getVariable(), EvaluatorVisitor.operatorToString(kind), arg0.getExpression());
                }
            }
            value = this.mirrorOf(vm, v);
            return this.setToMirror(arg0.getVariable(), value, evaluationContext);
        }
        if (var instanceof DoubleValue) {
            double v = ((DoubleValue)var).value();
            if (!(exp instanceof PrimitiveValue)) {
                Assert.error(arg0, "evaluateError", arg0.getVariable(), EvaluatorVisitor.operatorToString(kind), arg0.getExpression());
            }
            double e = ((PrimitiveValue)exp).doubleValue();
            switch (kind) {
                case DIVIDE_ASSIGNMENT: {
                    v /= e;
                    break;
                }
                case MINUS_ASSIGNMENT: {
                    v -= e;
                    break;
                }
                case MULTIPLY_ASSIGNMENT: {
                    v *= e;
                    break;
                }
                case PLUS_ASSIGNMENT: {
                    v += e;
                    break;
                }
                default: {
                    Assert.error(arg0, "evaluateError", arg0.getVariable(), EvaluatorVisitor.operatorToString(kind), arg0.getExpression());
                }
            }
            Value value2 = this.mirrorOf(vm, v);
            return this.setToMirror(arg0.getVariable(), value2, evaluationContext);
        }
        if (var instanceof FloatValue) {
            float v = ((FloatValue)var).value();
            if (!(exp instanceof PrimitiveValue)) {
                Assert.error(arg0, "evaluateError", arg0.getVariable(), EvaluatorVisitor.operatorToString(kind), arg0.getExpression());
            }
            float e = ((PrimitiveValue)exp).floatValue();
            switch (kind) {
                case DIVIDE_ASSIGNMENT: {
                    v /= e;
                    break;
                }
                case MINUS_ASSIGNMENT: {
                    v -= e;
                    break;
                }
                case MULTIPLY_ASSIGNMENT: {
                    v *= e;
                    break;
                }
                case PLUS_ASSIGNMENT: {
                    v += e;
                    break;
                }
                default: {
                    Assert.error(arg0, "evaluateError", arg0.getVariable(), EvaluatorVisitor.operatorToString(kind), arg0.getExpression());
                }
            }
            value = this.mirrorOf(vm, Float.valueOf(v));
            return this.setToMirror(arg0.getVariable(), value, evaluationContext);
        }
        if (var instanceof LongValue) {
            long v = ((LongValue)var).value();
            if (!(exp instanceof PrimitiveValue)) {
                Assert.error(arg0, "evaluateError", arg0.getVariable(), EvaluatorVisitor.operatorToString(kind), arg0.getExpression());
            }
            long e = ((PrimitiveValue)exp).longValue();
            switch (kind) {
                case AND_ASSIGNMENT: {
                    v &= e;
                    break;
                }
                case DIVIDE_ASSIGNMENT: {
                    v /= e;
                    break;
                }
                case LEFT_SHIFT_ASSIGNMENT: {
                    v <<= (int)e;
                    break;
                }
                case MINUS_ASSIGNMENT: {
                    v -= e;
                    break;
                }
                case MULTIPLY_ASSIGNMENT: {
                    v *= e;
                    break;
                }
                case OR_ASSIGNMENT: {
                    v |= e;
                    break;
                }
                case PLUS_ASSIGNMENT: {
                    v += e;
                    break;
                }
                case REMAINDER_ASSIGNMENT: {
                    v %= e;
                    break;
                }
                case RIGHT_SHIFT_ASSIGNMENT: {
                    v >>= (int)e;
                    break;
                }
                case UNSIGNED_RIGHT_SHIFT_ASSIGNMENT: {
                    v >>>= (int)e;
                    break;
                }
                case XOR_ASSIGNMENT: {
                    v ^= e;
                    break;
                }
                default: {
                    Assert.error(arg0, "evaluateError", arg0.getVariable(), EvaluatorVisitor.operatorToString(kind), arg0.getExpression());
                }
            }
            Value value3 = this.mirrorOf(vm, v);
            return this.setToMirror(arg0.getVariable(), value3, evaluationContext);
        }
        if (var instanceof IntegerValue) {
            int v = ((IntegerValue)var).value();
            if (!(exp instanceof PrimitiveValue)) {
                Assert.error(arg0, "evaluateError", arg0.getVariable(), EvaluatorVisitor.operatorToString(kind), arg0.getExpression());
            }
            int e = ((PrimitiveValue)exp).intValue();
            switch (kind) {
                case AND_ASSIGNMENT: {
                    v &= e;
                    break;
                }
                case DIVIDE_ASSIGNMENT: {
                    v /= e;
                    break;
                }
                case LEFT_SHIFT_ASSIGNMENT: {
                    v <<= e;
                    break;
                }
                case MINUS_ASSIGNMENT: {
                    v -= e;
                    break;
                }
                case MULTIPLY_ASSIGNMENT: {
                    v *= e;
                    break;
                }
                case OR_ASSIGNMENT: {
                    v |= e;
                    break;
                }
                case PLUS_ASSIGNMENT: {
                    v += e;
                    break;
                }
                case REMAINDER_ASSIGNMENT: {
                    v %= e;
                    break;
                }
                case RIGHT_SHIFT_ASSIGNMENT: {
                    v >>= e;
                    break;
                }
                case UNSIGNED_RIGHT_SHIFT_ASSIGNMENT: {
                    v >>>= e;
                    break;
                }
                case XOR_ASSIGNMENT: {
                    v ^= e;
                    break;
                }
                default: {
                    Assert.error(arg0, "evaluateError", arg0.getVariable(), EvaluatorVisitor.operatorToString(kind), arg0.getExpression());
                }
            }
            value = this.mirrorOf(vm, v);
            return this.setToMirror(arg0.getVariable(), value, evaluationContext);
        }
        if (var instanceof ShortValue) {
            short v = ((ShortValue)var).value();
            if (!(exp instanceof PrimitiveValue)) {
                Assert.error(arg0, "evaluateError", arg0.getVariable(), EvaluatorVisitor.operatorToString(kind), arg0.getExpression());
            }
            int e = ((PrimitiveValue)exp).intValue();
            switch (kind) {
                case AND_ASSIGNMENT: {
                    v = (short)(v & e);
                    break;
                }
                case DIVIDE_ASSIGNMENT: {
                    v = (short)(v / e);
                    break;
                }
                case LEFT_SHIFT_ASSIGNMENT: {
                    v = (short)(v << e);
                    break;
                }
                case MINUS_ASSIGNMENT: {
                    v = (short)(v - e);
                    break;
                }
                case MULTIPLY_ASSIGNMENT: {
                    v = (short)(v * e);
                    break;
                }
                case OR_ASSIGNMENT: {
                    v = (short)(v | e);
                    break;
                }
                case PLUS_ASSIGNMENT: {
                    v = (short)(v + e);
                    break;
                }
                case REMAINDER_ASSIGNMENT: {
                    v = (short)(v % e);
                    break;
                }
                case RIGHT_SHIFT_ASSIGNMENT: {
                    v = (short)(v >> e);
                    break;
                }
                case UNSIGNED_RIGHT_SHIFT_ASSIGNMENT: {
                    v = (short)(v >>> e);
                    break;
                }
                case XOR_ASSIGNMENT: {
                    v = (short)(v ^ e);
                    break;
                }
                default: {
                    Assert.error(arg0, "evaluateError", arg0.getVariable(), EvaluatorVisitor.operatorToString(kind), arg0.getExpression());
                }
            }
            value = this.mirrorOf(vm, v);
            return this.setToMirror(arg0.getVariable(), value, evaluationContext);
        }
        if (var instanceof CharValue) {
            char v = ((CharValue)var).value();
            if (!(exp instanceof PrimitiveValue)) {
                Assert.error(arg0, "evaluateError", arg0.getVariable(), EvaluatorVisitor.operatorToString(kind), arg0.getExpression());
            }
            int e = ((PrimitiveValue)exp).intValue();
            switch (kind) {
                case AND_ASSIGNMENT: {
                    v = (char)(v & e);
                    break;
                }
                case DIVIDE_ASSIGNMENT: {
                    v = (char)(v / e);
                    break;
                }
                case LEFT_SHIFT_ASSIGNMENT: {
                    v = (char)(v << e);
                    break;
                }
                case MINUS_ASSIGNMENT: {
                    v = (char)(v - e);
                    break;
                }
                case MULTIPLY_ASSIGNMENT: {
                    v = (char)(v * e);
                    break;
                }
                case OR_ASSIGNMENT: {
                    v = (char)(v | e);
                    break;
                }
                case PLUS_ASSIGNMENT: {
                    v = (char)(v + e);
                    break;
                }
                case REMAINDER_ASSIGNMENT: {
                    v = (char)(v % e);
                    break;
                }
                case RIGHT_SHIFT_ASSIGNMENT: {
                    v = (char)(v >> e);
                    break;
                }
                case UNSIGNED_RIGHT_SHIFT_ASSIGNMENT: {
                    v = (char)(v >>> e);
                    break;
                }
                case XOR_ASSIGNMENT: {
                    v = (char)(v ^ e);
                    break;
                }
                default: {
                    Assert.error(arg0, "evaluateError", arg0.getVariable(), EvaluatorVisitor.operatorToString(kind), arg0.getExpression());
                }
            }
            value = this.mirrorOf(vm, Character.valueOf(v));
            return this.setToMirror(arg0.getVariable(), value, evaluationContext);
        }
        if (var instanceof ByteValue) {
            byte v = ((ByteValue)var).value();
            if (!(exp instanceof PrimitiveValue)) {
                Assert.error(arg0, "evaluateError", arg0.getVariable(), EvaluatorVisitor.operatorToString(kind), arg0.getExpression());
            }
            int e = ((PrimitiveValue)exp).intValue();
            switch (kind) {
                case AND_ASSIGNMENT: {
                    v = (byte)(v & e);
                    break;
                }
                case DIVIDE_ASSIGNMENT: {
                    v = (byte)(v / e);
                    break;
                }
                case LEFT_SHIFT_ASSIGNMENT: {
                    v = (byte)(v << e);
                    break;
                }
                case MINUS_ASSIGNMENT: {
                    v = (byte)(v - e);
                    break;
                }
                case MULTIPLY_ASSIGNMENT: {
                    v = (byte)(v * e);
                    break;
                }
                case OR_ASSIGNMENT: {
                    v = (byte)(v | e);
                    break;
                }
                case PLUS_ASSIGNMENT: {
                    v = (byte)(v + e);
                    break;
                }
                case REMAINDER_ASSIGNMENT: {
                    v = (byte)(v % e);
                    break;
                }
                case RIGHT_SHIFT_ASSIGNMENT: {
                    v = (byte)(v >> e);
                    break;
                }
                case UNSIGNED_RIGHT_SHIFT_ASSIGNMENT: {
                    v = (byte)(v >>> e);
                    break;
                }
                case XOR_ASSIGNMENT: {
                    v = (byte)(v ^ e);
                    break;
                }
                default: {
                    Assert.error(arg0, "evaluateError", arg0.getVariable(), EvaluatorVisitor.operatorToString(kind), arg0.getExpression());
                }
            }
            value = this.mirrorOf(vm, v);
            return this.setToMirror(arg0.getVariable(), value, evaluationContext);
        }
        if (var instanceof StringReference) {
            String v = ((StringReference)var).value();
            if (exp != null && !(exp instanceof StringReference)) {
                Assert.error(arg0, "evaluateError", arg0.getVariable(), EvaluatorVisitor.operatorToString(kind), arg0.getExpression());
            }
            String e = exp != null ? ((StringReference)exp).value() : null;
            switch (kind) {
                case PLUS_ASSIGNMENT: {
                    v = v + e;
                    break;
                }
                default: {
                    Assert.error(arg0, "evaluateError", arg0.getVariable(), EvaluatorVisitor.operatorToString(kind), arg0.getExpression());
                }
            }
            value = EvaluatorVisitor.createStringMirrorWithDisabledCollection(v, vm, evaluationContext);
            return this.setToMirror(arg0.getVariable(), value, evaluationContext);
        }
        Assert.error(arg0, "evaluateError", arg0.getVariable(), EvaluatorVisitor.operatorToString(kind), arg0.getExpression());
        throw new IllegalStateException("Unknown assignment var type: " + var);
    }

    @Override
    public Mirror visitBinary(BinaryTree arg0, EvaluationContext evaluationContext) {
        boolean isRightNumeric;
        boolean op1;
        VirtualMachine vm = evaluationContext.getDebugger().getVirtualMachine();
        if (vm == null) {
            return null;
        }
        Tree.Kind kind = arg0.getKind();
        Mirror left = arg0.getLeftOperand().accept(this, evaluationContext);
        Mirror right = null;
        if (left instanceof ObjectReference && (kind == Tree.Kind.EQUAL_TO || kind == Tree.Kind.NOT_EQUAL_TO) && (right = arg0.getRightOperand().accept(this, evaluationContext)) instanceof ObjectReference) {
            if (kind == Tree.Kind.EQUAL_TO) {
                return this.mirrorOf(vm, left.equals(right));
            }
            return this.mirrorOf(vm, !left.equals(right));
        }
        if (left instanceof ObjectReference) {
            left = EvaluatorVisitor.unboxIfCan(arg0, (ObjectReference)left, evaluationContext);
        }
        if (left instanceof BooleanValue) {
            op1 = ((BooleanValue)left).booleanValue();
            if (kind == Tree.Kind.CONDITIONAL_AND && !op1) {
                return this.mirrorOf(vm, false);
            }
            if (kind == Tree.Kind.CONDITIONAL_OR && op1) {
                return this.mirrorOf(vm, true);
            }
        }
        if (right == null) {
            right = arg0.getRightOperand().accept(this, evaluationContext);
        }
        if (right instanceof ObjectReference) {
            right = EvaluatorVisitor.unboxIfCan(arg0, (ObjectReference)right, evaluationContext);
        }
        if (left instanceof BooleanValue && right instanceof BooleanValue) {
            boolean res;
            op1 = ((BooleanValue)left).booleanValue();
            boolean op2 = ((BooleanValue)right).booleanValue();
            switch (kind) {
                case AND: {
                    res = op1 & op2;
                    break;
                }
                case CONDITIONAL_AND: {
                    res = op1 && op2;
                    break;
                }
                case CONDITIONAL_OR: {
                    res = op1 || op2;
                    break;
                }
                case EQUAL_TO: {
                    res = op1 == op2;
                    break;
                }
                case NOT_EQUAL_TO: {
                    res = op1 != op2;
                    break;
                }
                case OR: {
                    res = op1 | op2;
                    break;
                }
                case XOR: {
                    res = op1 ^ op2;
                    break;
                }
                default: {
                    this.reportCannotApplyOperator(arg0);
                    return null;
                }
            }
            return this.mirrorOf(vm, res);
        }
        boolean isLeftNumeric = left instanceof PrimitiveValue && !(left instanceof BooleanValue);
        boolean bl = isRightNumeric = right instanceof PrimitiveValue && !(right instanceof BooleanValue);
        if (isLeftNumeric && isRightNumeric) {
            if (left instanceof DoubleValue || right instanceof DoubleValue) {
                double l = ((PrimitiveValue)left).doubleValue();
                double r = ((PrimitiveValue)right).doubleValue();
                double v = 0.0;
                boolean b = false;
                boolean isBoolean = true;
                switch (kind) {
                    case DIVIDE: {
                        v = l / r;
                        isBoolean = false;
                        break;
                    }
                    case MINUS: {
                        v = l - r;
                        isBoolean = false;
                        break;
                    }
                    case MULTIPLY: {
                        v = l * r;
                        isBoolean = false;
                        break;
                    }
                    case PLUS: {
                        v = l + r;
                        isBoolean = false;
                        break;
                    }
                    case EQUAL_TO: {
                        b = l == r;
                        break;
                    }
                    case GREATER_THAN: {
                        b = l > r;
                        break;
                    }
                    case GREATER_THAN_EQUAL: {
                        b = l >= r;
                        break;
                    }
                    case LESS_THAN: {
                        b = l < r;
                        break;
                    }
                    case LESS_THAN_EQUAL: {
                        b = l <= r;
                        break;
                    }
                    case NOT_EQUAL_TO: {
                        b = l != r;
                        break;
                    }
                    default: {
                        this.reportCannotApplyOperator(arg0);
                        return null;
                    }
                }
                if (isBoolean) {
                    return this.mirrorOf(vm, b);
                }
                return this.mirrorOf(vm, v);
            }
            if (left instanceof FloatValue || right instanceof FloatValue) {
                float l = ((PrimitiveValue)left).floatValue();
                float r = ((PrimitiveValue)right).floatValue();
                float v = 0.0f;
                boolean b = false;
                boolean isBoolean = true;
                switch (kind) {
                    case DIVIDE: {
                        v = l / r;
                        isBoolean = false;
                        break;
                    }
                    case MINUS: {
                        v = l - r;
                        isBoolean = false;
                        break;
                    }
                    case MULTIPLY: {
                        v = l * r;
                        isBoolean = false;
                        break;
                    }
                    case PLUS: {
                        v = l + r;
                        isBoolean = false;
                        break;
                    }
                    case EQUAL_TO: {
                        b = l == r;
                        break;
                    }
                    case GREATER_THAN: {
                        b = l > r;
                        break;
                    }
                    case GREATER_THAN_EQUAL: {
                        b = l >= r;
                        break;
                    }
                    case LESS_THAN: {
                        b = l < r;
                        break;
                    }
                    case LESS_THAN_EQUAL: {
                        b = l <= r;
                        break;
                    }
                    case NOT_EQUAL_TO: {
                        b = l != r;
                        break;
                    }
                    default: {
                        this.reportCannotApplyOperator(arg0);
                        return null;
                    }
                }
                if (isBoolean) {
                    return this.mirrorOf(vm, b);
                }
                return this.mirrorOf(vm, Float.valueOf(v));
            }
            if (left instanceof LongValue || right instanceof LongValue) {
                long l = ((PrimitiveValue)left).longValue();
                long r = ((PrimitiveValue)right).longValue();
                long v = 0L;
                boolean b = false;
                boolean isBoolean = false;
                switch (kind) {
                    case DIVIDE: {
                        v = l / r;
                        break;
                    }
                    case MINUS: {
                        v = l - r;
                        break;
                    }
                    case MULTIPLY: {
                        v = l * r;
                        break;
                    }
                    case PLUS: {
                        v = l + r;
                        break;
                    }
                    case REMAINDER: {
                        v = l % r;
                        break;
                    }
                    case LEFT_SHIFT: {
                        v = l << (int)r;
                        break;
                    }
                    case RIGHT_SHIFT: {
                        v = l >> (int)r;
                        break;
                    }
                    case UNSIGNED_RIGHT_SHIFT: {
                        v = l >>> (int)r;
                        break;
                    }
                    case AND: {
                        v = l & r;
                        break;
                    }
                    case OR: {
                        v = l | r;
                        break;
                    }
                    case XOR: {
                        v = l ^ r;
                        break;
                    }
                    case EQUAL_TO: {
                        b = l == r;
                        isBoolean = true;
                        break;
                    }
                    case GREATER_THAN: {
                        b = l > r;
                        isBoolean = true;
                        break;
                    }
                    case GREATER_THAN_EQUAL: {
                        b = l >= r;
                        isBoolean = true;
                        break;
                    }
                    case LESS_THAN: {
                        b = l < r;
                        isBoolean = true;
                        break;
                    }
                    case LESS_THAN_EQUAL: {
                        b = l <= r;
                        isBoolean = true;
                        break;
                    }
                    case NOT_EQUAL_TO: {
                        b = l != r;
                        isBoolean = true;
                        break;
                    }
                    default: {
                        this.reportCannotApplyOperator(arg0);
                        return null;
                    }
                }
                if (isBoolean) {
                    return this.mirrorOf(vm, b);
                }
                return this.mirrorOf(vm, v);
            }
            int l = ((PrimitiveValue)left).intValue();
            int r = ((PrimitiveValue)right).intValue();
            int v = 0;
            boolean b = false;
            boolean isBoolean = false;
            switch (kind) {
                case DIVIDE: {
                    v = l / r;
                    break;
                }
                case MINUS: {
                    v = l - r;
                    break;
                }
                case MULTIPLY: {
                    v = l * r;
                    break;
                }
                case PLUS: {
                    v = l + r;
                    break;
                }
                case REMAINDER: {
                    v = l % r;
                    break;
                }
                case LEFT_SHIFT: {
                    v = l << r;
                    break;
                }
                case RIGHT_SHIFT: {
                    v = l >> r;
                    break;
                }
                case UNSIGNED_RIGHT_SHIFT: {
                    v = l >>> r;
                    break;
                }
                case AND: {
                    v = l & r;
                    break;
                }
                case OR: {
                    v = l | r;
                    break;
                }
                case XOR: {
                    v = l ^ r;
                    break;
                }
                case EQUAL_TO: {
                    b = l == r;
                    isBoolean = true;
                    break;
                }
                case GREATER_THAN: {
                    b = l > r;
                    isBoolean = true;
                    break;
                }
                case GREATER_THAN_EQUAL: {
                    b = l >= r;
                    isBoolean = true;
                    break;
                }
                case LESS_THAN: {
                    b = l < r;
                    isBoolean = true;
                    break;
                }
                case LESS_THAN_EQUAL: {
                    b = l <= r;
                    isBoolean = true;
                    break;
                }
                case NOT_EQUAL_TO: {
                    b = l != r;
                    isBoolean = true;
                    break;
                }
                default: {
                    this.reportCannotApplyOperator(arg0);
                    return null;
                }
            }
            if (isBoolean) {
                return this.mirrorOf(vm, b);
            }
            return this.mirrorOf(vm, v);
        }
        if ((left == null || left instanceof StringReference) && (right == null || right instanceof StringReference) && kind == Tree.Kind.PLUS) {
            String s1 = left == null ? null : ((StringReference)left).value();
            String s2 = right == null ? null : ((StringReference)right).value();
            switch (kind) {
                case PLUS: {
                    return EvaluatorVisitor.createStringMirrorWithDisabledCollection(s1 + s2, vm, evaluationContext);
                }
            }
            this.reportCannotApplyOperator(arg0);
            return null;
        }
        if ((left instanceof StringReference || right instanceof StringReference) && kind == Tree.Kind.PLUS) {
            String s1 = left instanceof StringReference ? ((StringReference)left).value() : this.toString(arg0, left, evaluationContext);
            String s2 = right instanceof StringReference ? ((StringReference)right).value() : this.toString(arg0, right, evaluationContext);
            return EvaluatorVisitor.createStringMirrorWithDisabledCollection(s1 + s2, vm, evaluationContext);
        }
        switch (kind) {
            case EQUAL_TO: {
                return this.mirrorOf(vm, left == right || left != null && left.equals(right));
            }
            case NOT_EQUAL_TO: {
                return this.mirrorOf(vm, left == null && right != null || left != null && !left.equals(right));
            }
        }
        this.reportCannotApplyOperator(arg0);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Mirror visitBlock(BlockTree arg0, EvaluationContext evaluationContext) {
        Mirror lastResult = null;
        try {
            evaluationContext.pushBlock();
            for (StatementTree statementTree : arg0.getStatements()) {
                Mirror res = statementTree.accept(this, evaluationContext);
                if (res != null) {
                    lastResult = res;
                }
                if (!(res instanceof CommandMirror)) continue;
                break;
            }
        }
        finally {
            evaluationContext.popBlock();
        }
        return lastResult;
    }

    @Override
    public Mirror visitBreak(BreakTree arg0, EvaluationContext evaluationContext) {
        Name label = arg0.getLabel();
        if (label != null) {
            Assert.error(arg0, "unsupported");
            return null;
        }
        return new Break();
    }

    @Override
    public Mirror visitCase(CaseTree arg0, EvaluationContext evaluationContext) {
        Assert.error(arg0, "unsupported");
        return null;
    }

    @Override
    public Mirror visitCatch(CatchTree arg0, EvaluationContext evaluationContext) {
        Assert.error(arg0, "unsupported");
        return null;
    }

    @Override
    public Mirror visitClass(ClassTree arg0, EvaluationContext evaluationContext) {
        Assert.error(arg0, "unsupported");
        return null;
    }

    @Override
    public Mirror visitConditionalExpression(ConditionalExpressionTree arg0, EvaluationContext evaluationContext) {
        Mirror condition = arg0.getCondition().accept(this, evaluationContext);
        if (!(condition instanceof BooleanValue)) {
            throw new IllegalStateException("Condition must be boolean: " + arg0.getCondition());
        }
        boolean isTrue = ((BooleanValue)condition).value();
        if (isTrue) {
            return arg0.getTrueExpression().accept(this, evaluationContext);
        }
        return arg0.getFalseExpression().accept(this, evaluationContext);
    }

    @Override
    public Mirror visitContinue(ContinueTree arg0, EvaluationContext evaluationContext) {
        Name label = arg0.getLabel();
        if (label != null) {
            Assert.error(arg0, "unsupported");
            return null;
        }
        return new Continue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Mirror visitDoWhileLoop(DoWhileLoopTree arg0, EvaluationContext evaluationContext) {
        ExpressionTree condition = arg0.getCondition();
        StatementTree statement = arg0.getStatement();
        Mirror result = null;
        do {
            try {
                evaluationContext.pushBlock();
                Mirror res = statement.accept(this, evaluationContext);
                if (res instanceof Break) break;
                if (res instanceof Continue || res == null) continue;
                result = res;
            }
            finally {
                evaluationContext.popBlock();
            }
        } while (((BooleanValue)condition.accept(this, evaluationContext)).value());
        return result;
    }

    @Override
    public Mirror visitErroneous(ErroneousTree arg0, EvaluationContext evaluationContext) {
        Assert.error(arg0, "errorneous");
        return null;
    }

    @Override
    public Mirror visitExpressionStatement(ExpressionStatementTree arg0, EvaluationContext evaluationContext) {
        return arg0.getExpression().accept(this, evaluationContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public Mirror visitEnhancedForLoop(EnhancedForLoopTree arg0, EvaluationContext evaluationContext) {
        block24: {
            exprTree = arg0.getExpression();
            exprValue = exprTree.accept(this, evaluationContext);
            nextMethod = null;
            hasNextMethod = null;
            iterator = null;
            if (!(exprValue instanceof ObjectReference)) {
                Assert.error(arg0, "forEachNotApplicable");
            }
            isArray = true;
            arrayLength = 0;
            if (!(exprValue instanceof ArrayReference)) {
                isArray = false;
                if (!evaluationContext.canInvokeMethods()) {
                    Assert.error(arg0, "canNotInvokeMethods");
                }
                objRef = (ObjectReference)exprValue;
                objType = objRef.referenceType();
                vm = evaluationContext.getDebugger().getVirtualMachine();
                if (vm == null) {
                    return null;
                }
                collType = EvaluatorVisitor.getOrLoadClass(vm, "java.util.Collection", evaluationContext);
                if (!EvaluatorVisitor.instanceOf(objRef.type(), collType)) {
                    Assert.error(arg0, "forEachNotApplicable");
                }
                iteratorMethod = null;
                try {
                    iteratorMethod = EvaluatorVisitor.getConcreteMethod(objType, "iterator", Collections.EMPTY_LIST);
                }
                catch (UnsuitableArgumentsException ex) {
                    // empty catch block
                }
                iterator = (ObjectReference)this.invokeMethod(arg0, iteratorMethod, Boolean.FALSE, (ClassType)objRef.type(), objRef, Collections.EMPTY_LIST, evaluationContext, false);
                try {
                    iteratorType = iterator.referenceType();
                    nextMethod = EvaluatorVisitor.getConcreteMethod(iteratorType, "next", Collections.EMPTY_LIST);
                    hasNextMethod = EvaluatorVisitor.getConcreteMethod(iteratorType, "hasNext", Collections.EMPTY_LIST);
                }
                catch (UnsuitableArgumentsException ex) {}
            } else {
                arrayLength = ((ArrayReference)exprValue).length();
            }
            result = null;
            evaluationContext.pushBlock();
            varTree = arg0.getVariable();
            varTree.accept(this, evaluationContext);
            scriptVar = evaluationContext.getScriptVariableByName(varTree.getName().toString());
            statementTree = arg0.getStatement();
            index = 0;
            while (true) lbl-1000:
            // 4 sources

            {
                if (isArray) {
                    if (index >= arrayLength) {
                        break block24;
                    }
                    value = ((ArrayReference)exprValue).getValue(index);
                    ++index;
                } else {
                    value = this.invokeMethod(arg0, hasNextMethod, Boolean.FALSE, (ClassType)iterator.type(), (ObjectReference)iterator, Collections.EMPTY_LIST, evaluationContext, false);
                    if (!((BooleanValue)value).value()) {
                        break block24;
                    }
                    value = this.invokeMethod(arg0, nextMethod, Boolean.FALSE, (ClassType)iterator.type(), (ObjectReference)iterator, Collections.EMPTY_LIST, evaluationContext, false);
                }
                scriptVar.setValue(value);
                try {
                    evaluationContext.pushBlock();
                    returnValue = statementTree.accept(this, evaluationContext);
                    if (!(returnValue instanceof Break)) {
                        if (returnValue instanceof Continue || returnValue == null) ** GOTO lbl-1000
                        result = returnValue;
                    }
                    break block24;
                }
                finally {
                    evaluationContext.popBlock();
                    continue;
                }
                break;
            }
            ** GOTO lbl-1000
            finally {
                evaluationContext.popBlock();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Mirror visitForLoop(ForLoopTree arg0, EvaluationContext evaluationContext) {
        try {
            evaluationContext.pushBlock();
            for (StatementTree statementTree : arg0.getInitializer()) {
                statementTree.accept(this, evaluationContext);
            }
            Mirror result = null;
            ExpressionTree expressionTree = arg0.getCondition();
            List<? extends ExpressionStatementTree> updateList = arg0.getUpdate();
            StatementTree statement = arg0.getStatement();
            while (expressionTree == null || ((BooleanValue)expressionTree.accept(this, evaluationContext)).value()) {
                Mirror value = null;
                try {
                    evaluationContext.pushBlock();
                    value = statement.accept(this, evaluationContext);
                    if (value instanceof Break) break;
                    if (value instanceof Continue || value == null) continue;
                    result = value;
                }
                finally {
                    evaluationContext.popBlock();
                    if (!(value instanceof Continue) && value instanceof CommandMirror) continue;
                    for (ExpressionStatementTree expressionStatementTree : updateList) {
                        expressionStatementTree.accept(this, evaluationContext);
                    }
                }
            }
            Mirror mirror = result;
            return mirror;
        }
        finally {
            evaluationContext.popBlock();
        }
    }

    private Mirror getIdentifierByName(IdentifierTree arg0, EvaluationContext evaluationContext) {
        Field outer;
        ObjectReference thiz;
        ReferenceType thisType;
        String name = arg0.getName().toString();
        VirtualMachine vm = evaluationContext.getDebugger().getVirtualMachine();
        if (vm == null) {
            return null;
        }
        List<ReferenceType> classes = vm.classesByName(name);
        if (classes.size() > 0) {
            try {
                ReferenceType preferredType = JPDAUtils.getPreferredReferenceType(classes, null);
                if (preferredType != null) {
                    return preferredType;
                }
            }
            catch (VMDisconnectedExceptionWrapper ex) {
                throw ex.getCause();
            }
            return classes.get(0);
        }
        if (name.equals("this")) {
            return evaluationContext.getContextObject();
        }
        if (name.equals("super") && (thisType = evaluationContext.getFrame().location().declaringType()) instanceof ClassType) {
            ClassType superClass = ((ClassType)thisType).superclass();
            ObjectReference thisObject = evaluationContext.getContextObject();
            if (thisObject == null) {
                return superClass;
            }
            this.subExpressionTypes.put(arg0, superClass);
            return thisObject;
        }
        EvaluationContext.ScriptVariable var = evaluationContext.getScriptVariableByName(name);
        if (var != null) {
            evaluationContext.putScriptVariable(arg0, var);
            return var.getValue();
        }
        try {
            com.sun.jdi.LocalVariable lv = evaluationContext.getFrame().visibleVariableByName(name);
            if (lv != null) {
                evaluationContext.putLocalVariable(arg0, lv);
                return evaluationContext.getFrame().getValue(lv);
            }
        }
        catch (AbsentInformationException aiex) {
            // empty catch block
        }
        Field field = evaluationContext.getContextObject() != null ? evaluationContext.getContextObject().referenceType().fieldByName(name) : evaluationContext.getFrame().location().declaringType().fieldByName(name);
        if (field != null) {
            if (field.isStatic()) {
                evaluationContext.putField(arg0, field, null);
                Value v = field.declaringType().getValue(field);
                if (v instanceof ObjectReference) {
                    evaluationContext.disableCollectionOf((ObjectReference)v);
                }
                return v;
            }
            ObjectReference thisObject = evaluationContext.getContextObject();
            if (thisObject != null) {
                evaluationContext.putField(arg0, field, thisObject);
                Value v = thisObject.getValue(field);
                if (v instanceof ObjectReference) {
                    evaluationContext.disableCollectionOf((ObjectReference)v);
                }
                return v;
            }
        }
        if ((thiz = evaluationContext.getContextObject()) != null && (outer = thiz.referenceType().fieldByName("val$" + name)) != null) {
            Value val = thiz.getValue(outer);
            evaluationContext.putField(arg0, outer, thiz);
            return val;
        }
        ReferenceType rt = EvaluatorVisitor.getOrLoadClass(vm, name, evaluationContext);
        if (rt != null) {
            return rt;
        }
        Assert.error((Tree)arg0, "unknownVariable", name);
        return null;
    }

    @Override
    public Mirror visitIdentifier(IdentifierTree arg0, EvaluationContext evaluationContext) {
        String identifier = arg0.getName().toString();
        if (this.expression.classReplaced().equals(identifier)) {
            ReferenceType refType = evaluationContext.getFrame().location().declaringType();
            JPDAClassType classType = evaluationContext.getDebugger().getClassType(refType);
            return ((JDIVariable)classType.classObject()).getJDIValue();
        }
        if (this.expression.returnReplaced().equals(identifier)) {
            ThreadReference tr = evaluationContext.getFrame().thread();
            JPDAThreadImpl thread = evaluationContext.getDebugger().getThread(tr);
            ReturnVariableImpl returnVar = thread.getReturnVariable();
            if (returnVar != null) {
                return returnVar.getJDIValue();
            }
            return null;
        }
        ObjectVariable labeledVar = evaluationContext.getDebugger().getLabeledVariable(identifier);
        if (labeledVar != null) {
            return ((JDIVariable)labeledVar).getJDIValue();
        }
        TreePath currentPath = this.getCurrentPath();
        Element elm = null;
        if (currentPath != null) {
            TreePath identifierPath = TreePath.getPath(currentPath, (Tree)arg0);
            if (identifierPath == null) {
                identifierPath = this.getCurrentPath();
            }
            if ((elm = evaluationContext.getTrees().getElement(identifierPath)) instanceof TypeElement && ((TypeElement)elm).asType() instanceof ErrorType) {
                currentPath = null;
            }
        }
        if (currentPath == null || elm == null) {
            return this.getIdentifierByName(arg0, evaluationContext);
        }
        switch (elm.getKind()) {
            case ANNOTATION_TYPE: 
            case CLASS: 
            case ENUM: 
            case INTERFACE: {
                TypeElement te = (TypeElement)elm;
                String className = ElementUtilities.getBinaryName((TypeElement)te);
                VirtualMachine vm = evaluationContext.getDebugger().getVirtualMachine();
                if (vm == null) {
                    return null;
                }
                ReferenceType rt = EvaluatorVisitor.getOrLoadClass(vm, className, evaluationContext);
                if (rt != null) {
                    return rt;
                }
                Assert.error((Tree)arg0, "unknownType", className);
            }
            case TYPE_PARAMETER: {
                ReferenceType rt;
                VirtualMachine vm;
                TypeParameterElement tpel = (TypeParameterElement)elm;
                List<? extends TypeMirror> bounds = tpel.getBounds();
                for (TypeMirror typeMirror : bounds) {
                    String typeName = EvaluatorVisitor.getTypeName(typeMirror);
                    vm = evaluationContext.getDebugger().getVirtualMachine();
                    if (vm == null) {
                        return null;
                    }
                    rt = EvaluatorVisitor.getOrLoadClass(vm, typeName, evaluationContext);
                    if (rt == null) continue;
                    return rt;
                }
                Assert.error((Tree)arg0, "unknownType", tpel.getSimpleName().toString());
            }
            case ENUM_CONSTANT: {
                return this.getEnumConstant(arg0, (VariableElement)elm, evaluationContext);
            }
            case FIELD: {
                Field field;
                ReferenceType dt;
                ReferenceType thisType;
                VariableElement ve = (VariableElement)elm;
                String string = ve.getSimpleName().toString();
                if (string.equals("this")) {
                    return evaluationContext.getContextObject();
                }
                if (string.equals("super") && (thisType = evaluationContext.getFrame().location().declaringType()) instanceof ClassType) {
                    ClassType superClass = ((ClassType)thisType).superclass();
                    ObjectReference thisObject = evaluationContext.getContextObject();
                    if (thisObject == null) {
                        return superClass;
                    }
                    this.subExpressionTypes.put(arg0, superClass);
                    return thisObject;
                }
                Element enclosing = ve.getEnclosingElement();
                String enclosingClass = null;
                if (enclosing.getKind() == ElementKind.CLASS) {
                    TypeElement enclosingClassElement = (TypeElement)enclosing;
                    enclosingClass = ElementUtilities.getBinaryName((TypeElement)enclosingClassElement);
                }
                ReferenceType declaringType = evaluationContext.getFrame().location().declaringType();
                if (enclosingClass != null && (dt = this.findEnclosingType(declaringType, enclosingClass)) != null) {
                    declaringType = dt;
                }
                if ((field = declaringType.fieldByName(string)) == null) {
                    Assert.error((Tree)arg0, "unknownVariable", string);
                }
                if (field.isStatic()) {
                    evaluationContext.putField(arg0, field, null);
                    Value v = declaringType.getValue(field);
                    if (v instanceof ObjectReference) {
                        evaluationContext.disableCollectionOf((ObjectReference)v);
                    }
                    return v;
                }
                ObjectReference thisObject = evaluationContext.getContextObject();
                if (thisObject != null) {
                    ObjectReference to;
                    if (field.isPrivate()) {
                        thisObject = to = this.findEnclosingObject(arg0, thisObject, declaringType, field.name(), null);
                    } else if (!EvaluatorVisitor.instanceOf(thisObject.referenceType(), declaringType)) {
                        thisObject = to = this.findEnclosingObject(arg0, thisObject, declaringType, field.name(), null);
                    }
                }
                if (thisObject != null) {
                    evaluationContext.putField(arg0, field, thisObject);
                    try {
                        Value v = thisObject.getValue(field);
                        if (v instanceof ObjectReference) {
                            evaluationContext.disableCollectionOf((ObjectReference)v);
                        }
                        return v;
                    }
                    catch (IllegalArgumentException iaex) {
                        Logger.getLogger(this.getClass().getName()).severe("field = " + field + ", thisObject = " + thisObject);
                        throw iaex;
                    }
                }
                Assert.error((Tree)arg0, "accessInstanceVariableFromStaticContext", string);
                throw new IllegalStateException("No current instance available.");
            }
            case LOCAL_VARIABLE: 
            case EXCEPTION_PARAMETER: {
                VariableElement ve = (VariableElement)elm;
                String varName = ve.getSimpleName().toString();
                EvaluationContext.ScriptVariable var = evaluationContext.getScriptVariableByName(varName);
                if (var != null) {
                    evaluationContext.putScriptVariable(arg0, var);
                    return var.getValue();
                }
                try {
                    com.sun.jdi.LocalVariable lv = evaluationContext.getFrame().visibleVariableByName(varName);
                    if (lv == null) {
                        Field outer;
                        ObjectReference thiz;
                        try {
                            thiz = evaluationContext.getFrame().thisObject();
                        }
                        catch (InternalException iex) {
                            if (iex.errorCode() == 35) {
                                thiz = null;
                            }
                            throw iex;
                        }
                        if (thiz != null && (outer = thiz.referenceType().fieldByName("val$" + varName)) != null) {
                            Value val = thiz.getValue(outer);
                            evaluationContext.putField(arg0, outer, thiz);
                            return val;
                        }
                        Assert.error((Tree)arg0, "unknownVariable", varName);
                    }
                    evaluationContext.putLocalVariable(arg0, lv);
                    return evaluationContext.getFrame().getValue(lv);
                }
                catch (AbsentInformationException aiex) {
                    return (Value)Assert.error((Tree)arg0, "unknownVariable", varName);
                }
            }
            case PARAMETER: {
                VariableElement ve = (VariableElement)elm;
                String paramName = ve.getSimpleName().toString();
                StackFrame frame = evaluationContext.getFrame();
                try {
                    com.sun.jdi.LocalVariable lv = frame.visibleVariableByName(paramName);
                    if (lv == null) {
                        Field outer;
                        ObjectReference thiz;
                        try {
                            thiz = frame.thisObject();
                        }
                        catch (InternalException iex) {
                            if (iex.errorCode() == 35) {
                                thiz = null;
                            }
                            throw iex;
                        }
                        if (thiz != null && (outer = thiz.referenceType().fieldByName("val$" + paramName)) != null) {
                            Value val = thiz.getValue(outer);
                            evaluationContext.putField(arg0, outer, thiz);
                            return val;
                        }
                        Assert.error((Tree)arg0, "unknownVariable", paramName);
                    }
                    evaluationContext.putLocalVariable(arg0, lv);
                    return frame.getValue(lv);
                }
                catch (AbsentInformationException aiex) {
                    LocalVariable[] lvs = new CallStackFrameImpl(evaluationContext.getDebugger().getThread(frame.thread()), frame, 0, evaluationContext.getDebugger()).getMethodArguments();
                    if (lvs != null) {
                        for (LocalVariable lv : lvs) {
                            if (!paramName.equals(lv.getName())) continue;
                            return ((JDIVariable)lv).getJDIValue();
                        }
                    }
                    return (Value)Assert.error((Tree)arg0, "unknownVariable", paramName);
                }
            }
            case PACKAGE: {
                return (Value)Assert.error(arg0, "notExpression");
            }
        }
        throw new UnsupportedOperationException("Not supported element kind:" + (Object)((Object)elm.getKind()) + " Tree = '" + arg0 + "'");
    }

    private ReferenceType findEnclosingType(ReferenceType type, String name) {
        if (type.name().equals(name)) {
            return type;
        }
        List<ReferenceType> classes = type.virtualMachine().classesByName(name);
        if (classes.size() == 1) {
            return classes.get(0);
        }
        for (ReferenceType clazz : classes) {
            if (!this.isNestedOf(clazz, type)) continue;
            return clazz;
        }
        return null;
    }

    private boolean isNestedOf(ReferenceType nested, ReferenceType type) {
        if (((Object)nested).equals(type)) {
            return true;
        }
        for (ReferenceType n : nested.nestedTypes()) {
            if (!this.isNestedOf(n, type)) continue;
            return true;
        }
        return false;
    }

    private ObjectReference findEnclosingObject(Tree arg0, ObjectReference object, ReferenceType type, String fieldName, String methodName) {
        if (EvaluatorVisitor.instanceOf(object.referenceType(), type)) {
            return object;
        }
        if (((ReferenceType)object.type()).isStatic()) {
            if (fieldName != null) {
                Assert.error(arg0, "accessInstanceVariableFromStaticContext", fieldName);
            }
            if (methodName != null) {
                Assert.error(arg0, "invokeInstanceMethodAsStatic", methodName);
            }
            return null;
        }
        Field outerRef = null;
        for (int i = 0; i < 9 && (outerRef = object.referenceType().fieldByName("this$" + i)) == null; ++i) {
        }
        if (outerRef == null) {
            return null;
        }
        if ((object = (ObjectReference)object.getValue(outerRef)) == null) {
            return null;
        }
        return this.findEnclosingObject(arg0, object, type, fieldName, methodName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Mirror visitIf(IfTree arg0, EvaluationContext evaluationContext) {
        StatementTree statement;
        Mirror conditionValue = arg0.getCondition().accept(this, evaluationContext);
        if (conditionValue instanceof ObjectReference) {
            conditionValue = EvaluatorVisitor.unboxIfCan(arg0, (ObjectReference)conditionValue, evaluationContext);
        }
        if (!(conditionValue instanceof BooleanValue)) {
            String type = "N/A";
            if (conditionValue instanceof Value) {
                type = ((Value)conditionValue).type().name();
            }
            Assert.error(arg0, "notABoolean", arg0.getCondition().toString(), conditionValue, type);
        }
        if ((statement = ((BooleanValue)conditionValue).value() ? arg0.getThenStatement() : arg0.getElseStatement()) != null) {
            try {
                evaluationContext.pushBlock();
                Mirror mirror = statement.accept(this, evaluationContext);
                return mirror;
            }
            finally {
                evaluationContext.popBlock();
            }
        }
        return null;
    }

    @Override
    public Mirror visitImport(ImportTree arg0, EvaluationContext evaluationContext) {
        Assert.error(arg0, "unsupported");
        return null;
    }

    @Override
    public Mirror visitArrayAccess(ArrayAccessTree arg0, EvaluationContext evaluationContext) {
        int i;
        Mirror array = arg0.getExpression().accept(this, evaluationContext);
        if (array == null) {
            Assert.error((Tree)arg0, "arrayIsNull", arg0.getExpression());
        }
        Mirror index = arg0.getIndex().accept(this, evaluationContext);
        if (!(array instanceof ArrayReference)) {
            Assert.error((Tree)arg0, "notArrayType", arg0.getExpression());
        }
        if (!(index instanceof PrimitiveValue)) {
            Assert.error((Tree)arg0, "arraySizeBadType", index);
        }
        if ((i = ((PrimitiveValue)index).intValue()) < 0 || i >= ((ArrayReference)array).length()) {
            Assert.error(arg0, "arrayIndexOutOfBounds", array, i);
        }
        evaluationContext.putArrayAccess(arg0, (ArrayReference)array, i);
        return ((ArrayReference)array).getValue(i);
    }

    @Override
    public Mirror visitLabeledStatement(LabeledStatementTree arg0, EvaluationContext evaluationContext) {
        Assert.error(arg0, "unsupported");
        return null;
    }

    @Override
    public Mirror visitLiteral(LiteralTree arg0, EvaluationContext evaluationContext) {
        VirtualMachine vm = evaluationContext.getDebugger().getVirtualMachine();
        if (vm == null) {
            return null;
        }
        Object value = arg0.getValue();
        if (value instanceof Boolean) {
            return this.mirrorOf(vm, value);
        }
        if (value instanceof Byte) {
            return this.mirrorOf(vm, value);
        }
        if (value instanceof Character) {
            return this.mirrorOf(vm, value);
        }
        if (value instanceof Double) {
            return this.mirrorOf(vm, value);
        }
        if (value instanceof Float) {
            return this.mirrorOf(vm, value);
        }
        if (value instanceof Integer) {
            return this.mirrorOf(vm, value);
        }
        if (value instanceof Long) {
            return this.mirrorOf(vm, value);
        }
        if (value instanceof Short) {
            return this.mirrorOf(vm, value);
        }
        if (value instanceof String) {
            StringReference str = EvaluatorVisitor.createStringMirrorWithDisabledCollection((String)value, vm, evaluationContext);
            ClassType strClass = (ClassType)vm.classesByName("java.lang.String").get(0);
            try {
                List<Value> args = Collections.emptyList();
                return this.invokeMethod(arg0, strClass.methodsByName("intern").get(0), false, strClass, str, args, evaluationContext, false);
            }
            catch (Exception ex) {
                return str;
            }
        }
        if (value == null) {
            return null;
        }
        throw new UnsupportedOperationException("Unsupported value: " + value);
    }

    @Override
    public Mirror visitMethod(MethodTree arg0, EvaluationContext evaluationContext) {
        Assert.error(arg0, "unsupported");
        return null;
    }

    @Override
    public Mirror visitModifiers(ModifiersTree arg0, EvaluationContext evaluationContext) {
        Assert.error(arg0, "unsupported");
        return null;
    }

    @Override
    public Mirror visitNewArray(NewArrayTree arg0, EvaluationContext evaluationContext) {
        Type type;
        Tree typeTree = arg0.getType();
        if (typeTree == null) {
            if (this.newArrayType == null) {
                throw new IllegalStateException("No type info for " + arg0);
            }
            type = this.newArrayType;
        } else {
            type = (Type)arg0.getType().accept(this, evaluationContext);
        }
        List<? extends ExpressionTree> dimensionTrees = arg0.getDimensions();
        int numDimensions = dimensionTrees.size();
        if (numDimensions > 0) {
            int[] dimensions = new int[numDimensions];
            ArrayType[] arrayTypes = new ArrayType[numDimensions];
            String arrayClassName = type.name() + "[]";
            for (int i = 0; i < numDimensions; ++i) {
                dimensions[i] = ((PrimitiveValue)dimensionTrees.get(numDimensions - 1 - i).accept(this, evaluationContext)).intValue();
                ReferenceType rt = EvaluatorVisitor.getOrLoadClass(type.virtualMachine(), arrayClassName, evaluationContext);
                if (rt == null) {
                    Assert.error((Tree)arg0, "unknownType", arrayClassName);
                }
                arrayTypes[i] = (ArrayType)rt;
                arrayClassName = arrayClassName + "[]";
            }
            return this.constructNewArray(arrayTypes, dimensions, numDimensions - 1, evaluationContext);
        }
        List<? extends ExpressionTree> initializerTrees = arg0.getInitializers();
        return this.constructNewArray(arg0, type, initializerTrees, evaluationContext);
    }

    private ArrayReference constructNewArray(ArrayType[] arrayTypes, int[] dimensions, int dimension, EvaluationContext evaluationContext) {
        ArrayReference array = EvaluatorVisitor.createArrayMirrorWithDisabledCollection(arrayTypes[dimension], dimensions[dimension], evaluationContext);
        if (dimension > 0) {
            ArrayList<ArrayReference> elements = new ArrayList<ArrayReference>(dimensions[dimension]);
            for (int i = 0; i < dimensions[dimension]; ++i) {
                ArrayReference subArray = this.constructNewArray(arrayTypes, dimensions, dimension - 1, evaluationContext);
                elements.add(subArray);
            }
            try {
                array.setValues(elements);
            }
            catch (InvalidTypeException ex) {
                throw new IllegalStateException("ArrayType " + arrayTypes[dimension] + " can not have " + elements + " elements.");
            }
            catch (ClassNotLoadedException ex) {
                throw new IllegalStateException(ex);
            }
        }
        return array;
    }

    private ArrayReference constructNewArray(NewArrayTree arg0, Type type, List<? extends ExpressionTree> initializerTrees, EvaluationContext evaluationContext) {
        int n = initializerTrees.size();
        ArrayList<Value> elements = new ArrayList<Value>(n);
        for (int i = 0; i < n; ++i) {
            ExpressionTree exp = initializerTrees.get(i);
            this.newArrayType = this.getSubArrayType(arg0, type, evaluationContext);
            Value elementValue = (Value)exp.accept(this, evaluationContext);
            this.newArrayType = null;
            if (elementValue instanceof ArtificialMirror) {
                elementValue = (Value)((ArtificialMirror)((Object)elementValue)).getVMMirror();
            }
            elements.add(elementValue);
        }
        int depth = 1;
        ArrayReference array = EvaluatorVisitor.createArrayMirrorWithDisabledCollection(this.getArrayType(arg0, type, depth, evaluationContext), n, evaluationContext);
        this.autoboxElements(arg0, type, elements, evaluationContext);
        try {
            array.setValues(elements);
        }
        catch (InvalidTypeException ex) {
            throw new IllegalStateException("ArrayType " + this.getArrayType(arg0, type, depth, evaluationContext) + " can not have " + elements + " elements.");
        }
        catch (ClassNotLoadedException ex) {
            throw new IllegalStateException(ex);
        }
        return array;
    }

    private ArrayType getArrayType(NewArrayTree arg0, Type type, int depth, EvaluationContext evaluationContext) {
        String arrayClassName;
        if (depth < BRACKETS.length() / 2) {
            arrayClassName = type.name() + BRACKETS.substring(0, 2 * depth);
        } else {
            arrayClassName = type.name() + BRACKETS;
            for (int i = BRACKETS.length() / 2; i < depth; ++i) {
                arrayClassName = arrayClassName + "[]";
            }
        }
        ReferenceType rt = EvaluatorVisitor.getOrLoadClass(type.virtualMachine(), arrayClassName, evaluationContext);
        if (rt == null) {
            Assert.error((Tree)arg0, "unknownType", arrayClassName);
        }
        return (ArrayType)rt;
    }

    private Type getSubArrayType(Tree arg0, Type type, EvaluationContext evaluationContext) {
        String name = type.name();
        if (name.endsWith("[]")) {
            Type pType;
            if (!(name = name.substring(0, name.length() - 2)).endsWith("[]") && (pType = this.getPrimitiveType(name, type.virtualMachine())) != null) {
                return pType;
            }
            if ((type = EvaluatorVisitor.getOrLoadClass(type.virtualMachine(), name, evaluationContext)) == null) {
                Assert.error(arg0, "unknownType", name);
            }
        }
        return type;
    }

    private Type getPrimitiveType(String name, VirtualMachine vm) {
        if (name.equals(Boolean.TYPE.getName())) {
            return vm.mirrorOf(true).type();
        }
        if (name.equals(Byte.TYPE.getName())) {
            return vm.mirrorOf((byte)0).type();
        }
        if (name.equals(Character.TYPE.getName())) {
            return vm.mirrorOf('a').type();
        }
        if (name.equals(Double.TYPE.getName())) {
            return vm.mirrorOf(0.0).type();
        }
        if (name.equals(Float.TYPE.getName())) {
            return vm.mirrorOf(0.0f).type();
        }
        if (name.equals(Integer.TYPE.getName())) {
            return vm.mirrorOf(0).type();
        }
        if (name.equals(Long.TYPE.getName())) {
            return vm.mirrorOf(0L).type();
        }
        if (name.equals(Short.TYPE.getName())) {
            return vm.mirrorOf((short)0).type();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Mirror visitNewClass(NewClassTree arg0, EvaluationContext evaluationContext) {
        InvalidExpressionException ieex;
        List<ReferenceType> nestedTypes;
        ObjectReference thisObject;
        TypeMirror cType;
        TreePath currentPath;
        ClassTree ct = arg0.getClassBody();
        if (ct != null) {
            Assert.error(arg0, "noNewClassWithBody");
        }
        if ((currentPath = this.getCurrentPath()) != null) {
            Element elm;
            TreePath identifierPath = TreePath.getPath(currentPath, (Tree)arg0);
            if (identifierPath == null) {
                identifierPath = currentPath;
            }
            if ((elm = evaluationContext.getTrees().getElement(identifierPath)) != null) {
                if (elm.asType().getKind() == TypeKind.ERROR) {
                    cType = null;
                } else {
                    if (elm.getKind() != ElementKind.CONSTRUCTOR) {
                        throw new IllegalStateException("Element " + elm + " is of " + (Object)((Object)elm.getKind()) + " kind. Tree = " + arg0);
                    }
                    ExecutableElement cElem = (ExecutableElement)elm;
                    cType = cElem.asType();
                }
            } else {
                cType = null;
            }
        } else {
            cType = null;
        }
        ExpressionTree classIdentifier = arg0.getIdentifier();
        Mirror clazz = classIdentifier.accept(this, evaluationContext);
        ClassType classType = (ClassType)clazz;
        List<? extends ExpressionTree> args = arg0.getArguments();
        ArrayList<Value> argVals = new ArrayList<Value>(args.size());
        for (ExpressionTree expressionTree : args) {
            Mirror argValue = expressionTree.accept(this, evaluationContext);
            if (argValue != null && !(argValue instanceof Value)) {
                Assert.error(expressionTree, "Not a value");
            }
            if (argValue instanceof ArtificialMirror) {
                argValue = ((ArtificialMirror)argValue).getVMMirror();
            }
            argVals.add((Value)argValue);
        }
        List<? extends TypeMirror> paramTypes = null;
        Object var12_13 = null;
        ArrayList<Type> argTypes = null;
        if (cType != null) {
            paramTypes = ((ExecutableType)cType).getParameterTypes();
            try {
                thisObject = evaluationContext.getFrame().thisObject();
            }
            catch (InternalException iex) {
                if (iex.errorCode() == 35) {
                    thisObject = null;
                }
                throw iex;
            }
            if (thisObject != null) {
                nestedTypes = ((ReferenceType)thisObject.type()).nestedTypes();
                for (ReferenceType nested : nestedTypes) {
                    if (nested.isStatic() || !((Object)nested).equals(classType)) continue;
                    argVals.add(0, thisObject);
                    String string = thisObject.type().signature();
                }
            }
        } else {
            argTypes = new ArrayList<Type>(argVals.size());
            for (Value value : argVals) {
                if (value == null) {
                    VirtualMachine vm = evaluationContext.getDebugger().getVirtualMachine();
                    if (vm == null) {
                        return null;
                    }
                    argTypes.add(vm.classesByName("java.lang.Object").get(0));
                    continue;
                }
                argTypes.add(value.type());
            }
            try {
                thisObject = evaluationContext.getFrame().thisObject();
            }
            catch (InternalException iex) {
                if (iex.errorCode() == 35) {
                    thisObject = null;
                }
                throw iex;
            }
            if (thisObject != null) {
                nestedTypes = ((ReferenceType)thisObject.type()).nestedTypes();
                for (ReferenceType nested : nestedTypes) {
                    if (nested.isStatic() || !((Object)nested).equals(classType)) continue;
                    argVals.add(0, thisObject);
                    argTypes.add(0, thisObject.type());
                }
            }
        }
        try {
            void var12_14;
            if (loggerMethod.isLoggable(Level.FINE)) {
                loggerMethod.fine("STARTED : " + classType + "." + "<init>" + " (" + argVals + ") in thread " + evaluationContext.getFrame().thread());
            }
            evaluationContext.methodToBeInvoked();
            Method constructorMethod = EvaluatorVisitor.getConcreteMethodAndReportProblems(arg0, classType, "<init>", (String)var12_14, paramTypes, argTypes);
            ObjectReference o = classType.newInstance(evaluationContext.getFrame().thread(), constructorMethod, argVals, 1);
            ObjectReference i$ = o;
            return i$;
        }
        catch (InvalidTypeException itex) {
            throw new IllegalStateException(new InvalidExpressionException((Throwable)itex));
        }
        catch (ClassNotLoadedException cnlex) {
            throw new IllegalStateException(cnlex);
        }
        catch (IncompatibleThreadStateException itsex) {
            ieex = new InvalidExpressionException((Throwable)itsex);
            ieex.initCause((Throwable)itsex);
            throw new IllegalStateException(ieex);
        }
        catch (InvocationException iex) {
            InvocationExceptionTranslated ex = new InvocationExceptionTranslated(iex, evaluationContext.getDebugger());
            InvalidExpressionException ieex2 = new InvalidExpressionException((Throwable)((Object)ex));
            ieex2.initCause((Throwable)((Object)ex));
            throw new IllegalStateException(ieex2);
        }
        catch (UnsupportedOperationException uoex) {
            ieex = new InvalidExpressionException((Throwable)uoex);
            ieex.initCause((Throwable)uoex);
            throw new IllegalStateException(ieex);
        }
        finally {
            try {
                evaluationContext.methodInvokeDone();
            }
            catch (IncompatibleThreadStateException itsex) {
                InvalidExpressionException ieex3 = new InvalidExpressionException((Throwable)itsex);
                ieex3.initCause((Throwable)itsex);
                throw new IllegalStateException(ieex3);
            }
            if (loggerMethod.isLoggable(Level.FINE)) {
                loggerMethod.fine("FINISHED: " + classType + "." + "<init>" + " (" + argVals + ") in thread " + evaluationContext.getFrame().thread());
            }
        }
    }

    @Override
    public Mirror visitParenthesized(ParenthesizedTree arg0, EvaluationContext evaluationContext) {
        return arg0.getExpression().accept(this, evaluationContext);
    }

    @Override
    public Mirror visitReturn(ReturnTree arg0, EvaluationContext evaluationContext) {
        Mirror result;
        ExpressionTree exprTree = arg0.getExpression();
        if (exprTree == null) {
            VirtualMachine vm = evaluationContext.getDebugger().getVirtualMachine();
            if (vm == null) {
                return null;
            }
            result = null;
        } else {
            result = exprTree.accept(this, evaluationContext);
        }
        return new Return(result);
    }

    private Value getEnumConstant(Tree arg0, VariableElement ve, EvaluationContext evaluationContext) {
        String constantName = ve.getSimpleName().toString();
        ReferenceType enumType = EvaluatorVisitor.getClassType(arg0, ve.asType(), evaluationContext);
        Method valueOfMethod = enumType.methodsByName("valueOf").get(0);
        VirtualMachine vm = evaluationContext.getDebugger().getVirtualMachine();
        if (vm == null) {
            return null;
        }
        StringReference constantNameRef = EvaluatorVisitor.createStringMirrorWithDisabledCollection(constantName, vm, evaluationContext);
        Value enumValue = this.invokeMethod(arg0, valueOfMethod, true, (ClassType)enumType, null, Collections.singletonList(constantNameRef), evaluationContext, false);
        return enumValue;
    }

    @Override
    public Mirror visitMemberSelect(MemberSelectTree arg0, EvaluationContext evaluationContext) {
        TreePath currentPath = this.getCurrentPath();
        Element elm = null;
        if (currentPath != null) {
            TreePath memberSelectPath = TreePath.getPath(currentPath, (Tree)arg0);
            if (memberSelectPath == null) {
                memberSelectPath = currentPath;
            }
            if ((elm = evaluationContext.getTrees().getElement(memberSelectPath)) instanceof TypeElement && ((TypeElement)elm).asType() instanceof ErrorType) {
                currentPath = null;
            }
        }
        if (currentPath == null || elm == null) {
            VirtualMachine vm;
            Field f;
            String name = arg0.getIdentifier().toString();
            if (name.equals("class")) {
                String className = arg0.getExpression().toString();
                VirtualMachine vm2 = evaluationContext.getDebugger().getVirtualMachine();
                if (vm2 == null) {
                    return null;
                }
                ReferenceType rt = EvaluatorVisitor.getOrLoadClass(vm2, className, evaluationContext);
                if (rt == null) {
                    Assert.error((Tree)arg0, "unknownType", className);
                }
                return rt.classObject();
            }
            Mirror expr = arg0.getExpression().accept(this, evaluationContext);
            if (expr instanceof ClassType) {
                ClassType clazz = (ClassType)expr;
                if (name.equals("this")) {
                    ObjectReference thisObject = evaluationContext.getContextObject();
                    while (thisObject != null && !((Object)((ReferenceType)thisObject.type())).equals(clazz)) {
                        ReferenceType thisClass = (ReferenceType)thisObject.type();
                        Field outerThisField = thisClass.fieldByName("this$0");
                        if (outerThisField != null) {
                            thisObject = (ObjectReference)thisObject.getValue(outerThisField);
                            continue;
                        }
                        thisObject = null;
                    }
                    if (thisObject == null) {
                        Assert.error((Tree)arg0, "unknownOuterClass", clazz.name());
                    } else {
                        return thisObject;
                    }
                }
                if (name.equals("class")) {
                    return clazz.classObject();
                }
                f = clazz.fieldByName(name);
                if (f != null) {
                    evaluationContext.putField(arg0, f, null);
                    Value v = clazz.getValue(f);
                    if (v instanceof ObjectReference) {
                        evaluationContext.disableCollectionOf((ObjectReference)v);
                    }
                    return v;
                }
            } else if (expr instanceof InterfaceType) {
                if (name.equals("class")) {
                    return ((InterfaceType)expr).classObject();
                }
            } else if (expr instanceof ArrayType) {
                if (name.equals("class")) {
                    return ((ArrayType)expr).classObject();
                }
            } else if (expr instanceof ObjectReference) {
                if (expr instanceof ArrayReference && "length".equals(name)) {
                    return expr.virtualMachine().mirrorOf(((ArrayReference)expr).length());
                }
                ReferenceType type = (ReferenceType)this.getSubExpressionType(arg0.getExpression());
                if (type == null) {
                    type = ((ObjectReference)expr).referenceType();
                }
                if ((f = type.fieldByName(name)) != null) {
                    evaluationContext.putField(arg0, f, (ObjectReference)expr);
                    Value v = ((ObjectReference)expr).getValue(f);
                    if (v instanceof ObjectReference) {
                        evaluationContext.disableCollectionOf((ObjectReference)v);
                    }
                    return v;
                }
            }
            if (expr == null) {
                Assert.error((Tree)arg0, "fieldOnNull", name);
            }
            if ((vm = evaluationContext.getDebugger().getVirtualMachine()) == null) {
                return null;
            }
            ReferenceType rt = EvaluatorVisitor.getOrLoadClass(vm, name, evaluationContext);
            if (rt == null) {
                Assert.error((Tree)arg0, "unknownType", name);
            }
            return rt;
        }
        switch (elm.getKind()) {
            case ENUM_CONSTANT: {
                return this.getEnumConstant(arg0, (VariableElement)elm, evaluationContext);
            }
            case FIELD: {
                VariableElement ve = (VariableElement)elm;
                String fieldName = ve.getSimpleName().toString();
                Mirror expr = arg0.getExpression().accept(this, evaluationContext);
                if (expr instanceof ClassType) {
                    ClassType clazz = (ClassType)expr;
                    if (fieldName.equals("this")) {
                        ObjectReference thisObject = evaluationContext.getContextObject();
                        while (thisObject != null && !((Object)((ReferenceType)thisObject.type())).equals(clazz)) {
                            ReferenceType thisClass = (ReferenceType)thisObject.type();
                            Field outerThisField = thisClass.fieldByName("this$0");
                            if (outerThisField != null) {
                                thisObject = (ObjectReference)thisObject.getValue(outerThisField);
                                continue;
                            }
                            thisObject = null;
                        }
                        if (thisObject == null) {
                            Assert.error((Tree)arg0, "unknownOuterClass", clazz.name());
                        } else {
                            return thisObject;
                        }
                    }
                    if (fieldName.equals("class")) {
                        return clazz.classObject();
                    }
                    Field f = clazz.fieldByName(fieldName);
                    if (f != null) {
                        if (!f.isStatic()) {
                            Assert.error((Tree)arg0, "accessInstanceVariableFromStaticContext", fieldName);
                            return null;
                        }
                        evaluationContext.putField(arg0, f, null);
                        Value v = clazz.getValue(f);
                        if (v instanceof ObjectReference) {
                            evaluationContext.disableCollectionOf((ObjectReference)v);
                        }
                        return v;
                    }
                    Assert.error((Tree)arg0, "unknownField", fieldName);
                    return null;
                }
                if (expr instanceof InterfaceType) {
                    InterfaceType intrfc = (InterfaceType)expr;
                    if (fieldName.equals("class")) {
                        return intrfc.classObject();
                    }
                    Field f = intrfc.fieldByName(fieldName);
                    if (f != null) {
                        Value v = intrfc.getValue(f);
                        if (v instanceof ObjectReference) {
                            evaluationContext.disableCollectionOf((ObjectReference)v);
                        }
                        return v;
                    }
                    Assert.error((Tree)arg0, "unknownField", fieldName);
                    return null;
                }
                if (expr instanceof ArrayType) {
                    ArrayType arr = (ArrayType)expr;
                    if (fieldName.equals("class")) {
                        return arr.classObject();
                    }
                }
                if (expr instanceof ObjectReference) {
                    Field f;
                    if (expr instanceof ArrayReference && "length".equals(fieldName)) {
                        return expr.virtualMachine().mirrorOf(((ArrayReference)expr).length());
                    }
                    ReferenceType type = (ReferenceType)this.getSubExpressionType(arg0.getExpression());
                    if (type == null) {
                        type = ((ObjectReference)expr).referenceType();
                    }
                    if ((f = type.fieldByName(fieldName)) != null) {
                        evaluationContext.putField(arg0, f, (ObjectReference)expr);
                        Value v = ((ObjectReference)expr).getValue(f);
                        if (v instanceof ObjectReference) {
                            evaluationContext.disableCollectionOf((ObjectReference)v);
                        }
                        return v;
                    }
                    Assert.error((Tree)arg0, "unknownField", fieldName);
                    return null;
                }
                if (expr == null) {
                    Assert.error((Tree)arg0, "fieldOnNull", fieldName);
                }
                Assert.error((Tree)arg0, "invalidMemberReference", arg0.toString());
            }
            case CLASS: 
            case ENUM: 
            case INTERFACE: {
                TypeElement te = (TypeElement)elm;
                String className = ElementUtilities.getBinaryName((TypeElement)te);
                VirtualMachine vm = evaluationContext.getDebugger().getVirtualMachine();
                if (vm == null) {
                    return null;
                }
                ReferenceType rt = EvaluatorVisitor.getOrLoadClass(vm, className, evaluationContext);
                if (rt == null) {
                    Assert.error((Tree)arg0, "unknownType", className);
                }
                return rt;
            }
            case PACKAGE: {
                return (Value)Assert.error(arg0, "notExpression");
            }
        }
        throw new UnsupportedOperationException("Not supported yet. Tree = '" + arg0 + "', element kind = " + (Object)((Object)elm.getKind()));
    }

    @Override
    public Mirror visitEmptyStatement(EmptyStatementTree arg0, EvaluationContext evaluationContext) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Mirror visitSwitch(SwitchTree arg0, EvaluationContext evaluationContext) {
        Mirror switchValue = arg0.getExpression().accept(this, evaluationContext);
        CaseTree defaultTree = null;
        Mirror result = null;
        boolean caseMatched = false;
        block7: for (CaseTree caseTree : arg0.getCases()) {
            Mirror value;
            ExpressionTree caseExpr = caseTree.getExpression();
            if (caseExpr == null) {
                defaultTree = caseTree;
                continue;
            }
            if (!caseMatched && this.isEqual(switchValue, value = caseExpr.accept(this, evaluationContext), evaluationContext)) {
                caseMatched = true;
            }
            if (!caseMatched) continue;
            try {
                evaluationContext.pushBlock();
                for (StatementTree statementTree : caseTree.getStatements()) {
                    Mirror res = statementTree.accept(this, evaluationContext);
                    if (res != null && (result = res) instanceof CommandMirror) break block7;
                }
            }
            finally {
                evaluationContext.popBlock();
            }
        }
        if (!caseMatched && defaultTree != null) {
            try {
                evaluationContext.pushBlock();
                for (StatementTree statementTree : defaultTree.getStatements()) {
                    Mirror res = statementTree.accept(this, evaluationContext);
                    if (res == null) continue;
                    result = res;
                }
            }
            finally {
                evaluationContext.popBlock();
            }
        }
        return result;
    }

    @Override
    public Mirror visitSynchronized(SynchronizedTree arg0, EvaluationContext evaluationContext) {
        Assert.error(arg0, "unsupported");
        return null;
    }

    @Override
    public Mirror visitThrow(ThrowTree arg0, EvaluationContext evaluationContext) {
        Assert.error(arg0, "unsupported");
        return null;
    }

    @Override
    public Mirror visitCompilationUnit(CompilationUnitTree arg0, EvaluationContext evaluationContext) {
        Assert.error(arg0, "unsupported");
        return null;
    }

    @Override
    public Mirror visitTry(TryTree arg0, EvaluationContext evaluationContext) {
        Assert.error(arg0, "unsupported");
        return null;
    }

    @Override
    public Mirror visitParameterizedType(ParameterizedTypeTree arg0, EvaluationContext evaluationContext) {
        return arg0.getType().accept(this, evaluationContext);
    }

    @Override
    public Mirror visitArrayType(ArrayTypeTree arg0, EvaluationContext evaluationContext) {
        Type type = (Type)arg0.getType().accept(this, evaluationContext);
        if (type == null) {
            return null;
        }
        String arrayClassName = type.name() + "[]";
        ReferenceType aType = EvaluatorVisitor.getOrLoadClass(type.virtualMachine(), arrayClassName, evaluationContext);
        if (aType != null) {
            return aType;
        }
        Assert.error((Tree)arg0, "unknownType", arrayClassName);
        return null;
    }

    @Override
    public Mirror visitTypeCast(TypeCastTree arg0, EvaluationContext evaluationContext) {
        Mirror type;
        VirtualMachine vm;
        ExpressionTree expTree = arg0.getExpression();
        Mirror expr = expTree.accept(this, evaluationContext);
        if (expr == null) {
            return null;
        }
        Tree typeTree = arg0.getType();
        if (this.getCurrentPath() == null) {
            String className = typeTree.toString();
            vm = evaluationContext.getDebugger().getVirtualMachine();
            if (vm == null) {
                return null;
            }
            ReferenceType rt = EvaluatorVisitor.getOrLoadClass(vm, className, evaluationContext);
            if (rt == null) {
                Assert.error((Tree)arg0, "unknownType", className);
            }
            type = rt;
        } else {
            type = typeTree.accept(this, evaluationContext);
        }
        if (expr instanceof PrimitiveValue) {
            PrimitiveValue primValue = (PrimitiveValue)expr;
            if (primValue instanceof BooleanValue) {
                Assert.assertAssignable(type, BooleanType.class, arg0, "castToBooleanRequired", primValue, type);
                return primValue;
            }
            Assert.assertNotAssignable(type, BooleanType.class, arg0, "castFromBooleanRequired", primValue, type);
            vm = evaluationContext.getDebugger().getVirtualMachine();
            if (vm == null) {
                return null;
            }
            if (type instanceof ByteType) {
                return this.mirrorOf(vm, primValue.byteValue());
            }
            if (type instanceof CharType) {
                return this.mirrorOf(vm, Character.valueOf(primValue.charValue()));
            }
            if (type instanceof DoubleType) {
                return this.mirrorOf(vm, primValue.doubleValue());
            }
            if (type instanceof FloatType) {
                return this.mirrorOf(vm, Float.valueOf(primValue.floatValue()));
            }
            if (type instanceof IntegerType) {
                return this.mirrorOf(vm, primValue.intValue());
            }
            if (type instanceof LongType) {
                return this.mirrorOf(vm, primValue.longValue());
            }
            return this.mirrorOf(vm, primValue.shortValue());
        }
        if (!EvaluatorVisitor.instanceOf(((ObjectReference)expr).type(), (Type)type)) {
            Assert.error(arg0, "castError", ((ObjectReference)expr).type(), type);
        }
        this.subExpressionTypes.put(arg0, (Type)type);
        return expr;
    }

    @Override
    public Mirror visitPrimitiveType(PrimitiveTypeTree arg0, EvaluationContext evaluationContext) {
        TypeKind type = arg0.getPrimitiveTypeKind();
        VirtualMachine vm = evaluationContext.getDebugger().getVirtualMachine();
        if (vm == null) {
            return null;
        }
        switch (type) {
            case BOOLEAN: {
                return vm.mirrorOf(true).type();
            }
            case BYTE: {
                return vm.mirrorOf((byte)0).type();
            }
            case CHAR: {
                return vm.mirrorOf('a').type();
            }
            case DOUBLE: {
                return vm.mirrorOf(0.0).type();
            }
            case FLOAT: {
                return vm.mirrorOf(0.0f).type();
            }
            case INT: {
                return vm.mirrorOf(0).type();
            }
            case LONG: {
                return vm.mirrorOf(0L).type();
            }
            case SHORT: {
                return vm.mirrorOf((short)0).type();
            }
        }
        throw new IllegalStateException("Tree = " + arg0);
    }

    @Override
    public Mirror visitTypeParameter(TypeParameterTree arg0, EvaluationContext evaluationContext) {
        Assert.error(arg0, "unsupported");
        return null;
    }

    @Override
    public Mirror visitInstanceOf(InstanceOfTree arg0, EvaluationContext evaluationContext) {
        Mirror expr = arg0.getExpression().accept(this, evaluationContext);
        VirtualMachine vm = evaluationContext.getDebugger().getVirtualMachine();
        if (vm == null) {
            return null;
        }
        if (expr == null) {
            return this.mirrorOf(vm, false);
        }
        Assert.assertAssignable(expr, ObjectReference.class, arg0, "instanceOfLeftOperandNotAReference", expr);
        ReferenceType expressionType = ((ObjectReference)expr).referenceType();
        Type type = (Type)arg0.getType().accept(this, evaluationContext);
        return this.mirrorOf(vm, EvaluatorVisitor.instanceOf(expressionType, type));
    }

    @Override
    public Mirror visitUnary(UnaryTree arg0, EvaluationContext evaluationContext) {
        Mirror expr = arg0.getExpression().accept(this, evaluationContext);
        VirtualMachine vm = evaluationContext.getDebugger().getVirtualMachine();
        if (vm == null) {
            return null;
        }
        if (expr == null) {
            return null;
        }
        if (expr instanceof ObjectReference) {
            expr = EvaluatorVisitor.unboxIfCan(arg0, (ObjectReference)expr, evaluationContext);
        }
        Tree.Kind kind = arg0.getKind();
        if (expr instanceof BooleanValue) {
            boolean v = ((BooleanValue)expr).value();
            switch (kind) {
                case LOGICAL_COMPLEMENT: {
                    v = !v;
                    break;
                }
                default: {
                    Assert.error(arg0, "evaluateErrorUnary", EvaluatorVisitor.operatorToString(kind), "(boolean) " + arg0.getExpression());
                }
            }
            return this.mirrorOf(vm, v);
        }
        if (expr instanceof ByteValue) {
            byte v = ((ByteValue)expr).value();
            switch (kind) {
                case BITWISE_COMPLEMENT: {
                    int i = ~v;
                    return this.mirrorOf(vm, i);
                }
                case POSTFIX_DECREMENT: {
                    this.setToMirror(arg0.getExpression(), this.mirrorOf(vm, v - 1), evaluationContext);
                    break;
                }
                case POSTFIX_INCREMENT: {
                    this.setToMirror(arg0.getExpression(), this.mirrorOf(vm, v + 1), evaluationContext);
                    break;
                }
                case PREFIX_DECREMENT: {
                    v = (byte)(v - 1);
                    this.setToMirror(arg0.getExpression(), this.mirrorOf(vm, v), evaluationContext);
                    break;
                }
                case PREFIX_INCREMENT: {
                    v = (byte)(v + 1);
                    this.setToMirror(arg0.getExpression(), this.mirrorOf(vm, v), evaluationContext);
                    break;
                }
                case UNARY_MINUS: {
                    byte i = -v;
                    return this.mirrorOf(vm, i);
                }
                case UNARY_PLUS: {
                    break;
                }
                default: {
                    Assert.error(arg0, "evaluateErrorUnary", EvaluatorVisitor.operatorToString(kind), "(byte) " + arg0.getExpression());
                }
            }
            return this.mirrorOf(vm, v);
        }
        if (expr instanceof CharValue) {
            char v = ((CharValue)expr).value();
            switch (kind) {
                case BITWISE_COMPLEMENT: {
                    int i = ~v;
                    return this.mirrorOf(vm, i);
                }
                case POSTFIX_DECREMENT: {
                    this.setToMirror(arg0.getExpression(), this.mirrorOf(vm, v - '\u0001'), evaluationContext);
                    break;
                }
                case POSTFIX_INCREMENT: {
                    this.setToMirror(arg0.getExpression(), this.mirrorOf(vm, v + '\u0001'), evaluationContext);
                    break;
                }
                case PREFIX_DECREMENT: {
                    v = (char)(v - '\u0001');
                    this.setToMirror(arg0.getExpression(), this.mirrorOf(vm, Character.valueOf(v)), evaluationContext);
                    break;
                }
                case PREFIX_INCREMENT: {
                    v = (char)(v + '\u0001');
                    this.setToMirror(arg0.getExpression(), this.mirrorOf(vm, Character.valueOf(v)), evaluationContext);
                    break;
                }
                case UNARY_MINUS: {
                    char i = -v;
                    return this.mirrorOf(vm, i);
                }
                case UNARY_PLUS: {
                    break;
                }
                default: {
                    Assert.error(arg0, "evaluateErrorUnary", EvaluatorVisitor.operatorToString(kind), "(char) " + arg0.getExpression());
                }
            }
            return this.mirrorOf(vm, Character.valueOf(v));
        }
        if (expr instanceof ShortValue) {
            short v = ((ShortValue)expr).value();
            switch (kind) {
                case BITWISE_COMPLEMENT: {
                    int i = ~v;
                    return this.mirrorOf(vm, i);
                }
                case POSTFIX_DECREMENT: {
                    this.setToMirror(arg0.getExpression(), this.mirrorOf(vm, v - 1), evaluationContext);
                    break;
                }
                case POSTFIX_INCREMENT: {
                    this.setToMirror(arg0.getExpression(), this.mirrorOf(vm, v + 1), evaluationContext);
                    break;
                }
                case PREFIX_DECREMENT: {
                    v = (short)(v - 1);
                    this.setToMirror(arg0.getExpression(), this.mirrorOf(vm, v), evaluationContext);
                    break;
                }
                case PREFIX_INCREMENT: {
                    v = (short)(v + 1);
                    this.setToMirror(arg0.getExpression(), this.mirrorOf(vm, v), evaluationContext);
                    break;
                }
                case UNARY_MINUS: {
                    short i = -v;
                    return this.mirrorOf(vm, i);
                }
                case UNARY_PLUS: {
                    break;
                }
                default: {
                    Assert.error(arg0, "evaluateErrorUnary", EvaluatorVisitor.operatorToString(kind), "(short) " + arg0.getExpression());
                }
            }
            return this.mirrorOf(vm, v);
        }
        if (expr instanceof IntegerValue) {
            int v = ((IntegerValue)expr).value();
            switch (kind) {
                case BITWISE_COMPLEMENT: {
                    v ^= 0xFFFFFFFF;
                    break;
                }
                case POSTFIX_DECREMENT: {
                    this.setToMirror(arg0.getExpression(), this.mirrorOf(vm, v - 1), evaluationContext);
                    break;
                }
                case POSTFIX_INCREMENT: {
                    this.setToMirror(arg0.getExpression(), this.mirrorOf(vm, v + 1), evaluationContext);
                    break;
                }
                case PREFIX_DECREMENT: {
                    this.setToMirror(arg0.getExpression(), this.mirrorOf(vm, --v), evaluationContext);
                    break;
                }
                case PREFIX_INCREMENT: {
                    this.setToMirror(arg0.getExpression(), this.mirrorOf(vm, ++v), evaluationContext);
                    break;
                }
                case UNARY_MINUS: {
                    v = -v;
                    break;
                }
                case UNARY_PLUS: {
                    break;
                }
                default: {
                    Assert.error(arg0, "evaluateErrorUnary", EvaluatorVisitor.operatorToString(kind), "(int) " + arg0.getExpression());
                }
            }
            return this.mirrorOf(vm, v);
        }
        if (expr instanceof LongValue) {
            long v = ((LongValue)expr).value();
            switch (kind) {
                case BITWISE_COMPLEMENT: {
                    v ^= 0xFFFFFFFFFFFFFFFFL;
                    break;
                }
                case POSTFIX_DECREMENT: {
                    this.setToMirror(arg0.getExpression(), this.mirrorOf(vm, v - 1L), evaluationContext);
                    break;
                }
                case POSTFIX_INCREMENT: {
                    this.setToMirror(arg0.getExpression(), this.mirrorOf(vm, v + 1L), evaluationContext);
                    break;
                }
                case PREFIX_DECREMENT: {
                    this.setToMirror(arg0.getExpression(), this.mirrorOf(vm, --v), evaluationContext);
                    break;
                }
                case PREFIX_INCREMENT: {
                    this.setToMirror(arg0.getExpression(), this.mirrorOf(vm, ++v), evaluationContext);
                    break;
                }
                case UNARY_MINUS: {
                    v = -v;
                    break;
                }
                case UNARY_PLUS: {
                    break;
                }
                default: {
                    Assert.error(arg0, "evaluateErrorUnary", EvaluatorVisitor.operatorToString(kind), "(long) " + arg0.getExpression());
                }
            }
            return this.mirrorOf(vm, v);
        }
        if (expr instanceof DoubleValue) {
            double v = ((DoubleValue)expr).value();
            switch (kind) {
                case POSTFIX_DECREMENT: {
                    this.setToMirror(arg0.getExpression(), this.mirrorOf(vm, v - 1.0), evaluationContext);
                    break;
                }
                case POSTFIX_INCREMENT: {
                    this.setToMirror(arg0.getExpression(), this.mirrorOf(vm, v + 1.0), evaluationContext);
                    break;
                }
                case PREFIX_DECREMENT: {
                    this.setToMirror(arg0.getExpression(), this.mirrorOf(vm, v -= 1.0), evaluationContext);
                    break;
                }
                case PREFIX_INCREMENT: {
                    this.setToMirror(arg0.getExpression(), this.mirrorOf(vm, v += 1.0), evaluationContext);
                    break;
                }
                case UNARY_MINUS: {
                    v = -v;
                    break;
                }
                case UNARY_PLUS: {
                    break;
                }
                default: {
                    Assert.error(arg0, "evaluateErrorUnary", EvaluatorVisitor.operatorToString(kind), "(double) " + arg0.getExpression());
                }
            }
            return this.mirrorOf(vm, v);
        }
        if (expr instanceof FloatValue) {
            float v = ((FloatValue)expr).value();
            switch (kind) {
                case POSTFIX_DECREMENT: {
                    this.setToMirror(arg0.getExpression(), this.mirrorOf(vm, Float.valueOf(v - 1.0f)), evaluationContext);
                    break;
                }
                case POSTFIX_INCREMENT: {
                    this.setToMirror(arg0.getExpression(), this.mirrorOf(vm, Float.valueOf(v + 1.0f)), evaluationContext);
                    break;
                }
                case PREFIX_DECREMENT: {
                    this.setToMirror(arg0.getExpression(), this.mirrorOf(vm, Float.valueOf(v -= 1.0f)), evaluationContext);
                    break;
                }
                case PREFIX_INCREMENT: {
                    this.setToMirror(arg0.getExpression(), this.mirrorOf(vm, Float.valueOf(v += 1.0f)), evaluationContext);
                    break;
                }
                case UNARY_MINUS: {
                    v = -v;
                    break;
                }
                case UNARY_PLUS: {
                    break;
                }
                default: {
                    Assert.error(arg0, "evaluateErrorUnary", EvaluatorVisitor.operatorToString(kind), "(float) " + arg0.getExpression());
                }
            }
            return this.mirrorOf(vm, Float.valueOf(v));
        }
        Assert.error(arg0, "evaluateErrorUnary", EvaluatorVisitor.operatorToString(kind), arg0.getExpression());
        throw new IllegalStateException("Bad expression type: " + expr);
    }

    private static final String operatorToString(Tree.Kind kind) {
        switch (kind) {
            case AND: {
                return "&";
            }
            case AND_ASSIGNMENT: {
                return "&=";
            }
            case CONDITIONAL_AND: {
                return "&&";
            }
            case CONDITIONAL_OR: {
                return "||";
            }
            case LEFT_SHIFT: {
                return "<<";
            }
            case LEFT_SHIFT_ASSIGNMENT: {
                return "<<=";
            }
            case LOGICAL_COMPLEMENT: {
                return "!";
            }
            case MINUS: {
                return "-";
            }
            case MINUS_ASSIGNMENT: {
                return "-=";
            }
            case MULTIPLY: {
                return "*";
            }
            case MULTIPLY_ASSIGNMENT: {
                return "*=";
            }
            case OR: {
                return "|";
            }
            case OR_ASSIGNMENT: {
                return "|=";
            }
            case PLUS: {
                return "+";
            }
            case PLUS_ASSIGNMENT: {
                return "+=";
            }
            case PREFIX_DECREMENT: {
                return "--";
            }
            case PREFIX_INCREMENT: {
                return "++";
            }
            case REMAINDER: {
                return "%";
            }
            case REMAINDER_ASSIGNMENT: {
                return "%=";
            }
            case RIGHT_SHIFT: {
                return ">>";
            }
            case RIGHT_SHIFT_ASSIGNMENT: {
                return ">>=";
            }
            case UNARY_MINUS: {
                return "-";
            }
            case UNARY_PLUS: {
                return "+";
            }
            case UNSIGNED_RIGHT_SHIFT: {
                return ">>>";
            }
            case UNSIGNED_RIGHT_SHIFT_ASSIGNMENT: {
                return ">>>=";
            }
            case XOR: {
                return "^";
            }
            case XOR_ASSIGNMENT: {
                return "^=";
            }
        }
        return kind.toString();
    }

    @Override
    public Mirror visitVariable(VariableTree arg0, EvaluationContext evaluationContext) {
        String name = arg0.getName().toString();
        if (evaluationContext.getScriptVariableByName(name) != null) {
            Assert.error((Tree)arg0, "localVariableAlreadyDefined", name);
        }
        Tree typeTree = arg0.getType();
        Type type = (Type)typeTree.accept(this, evaluationContext);
        EvaluationContext.ScriptVariable var = evaluationContext.createScriptLocalVariable(name, type);
        ExpressionTree initializer = arg0.getInitializer();
        if (initializer != null) {
            if (Tree.Kind.NEW_ARRAY.equals((Object)initializer.getKind())) {
                try {
                    this.newArrayType = ArrayTypeWrapper.componentType((ArrayType)type);
                }
                catch (ClassNotLoadedException cnlex) {
                    throw new IllegalStateException(cnlex);
                }
                catch (InternalExceptionWrapper ex) {
                }
                catch (VMDisconnectedExceptionWrapper ex) {
                    throw ex.getCause();
                }
            }
            Mirror initialValue = initializer.accept(this, evaluationContext);
            this.newArrayType = null;
            var.setValue(initialValue);
            return initialValue;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Mirror visitWhileLoop(WhileLoopTree arg0, EvaluationContext evaluationContext) {
        ExpressionTree condition = arg0.getCondition();
        StatementTree statement = arg0.getStatement();
        Mirror result = null;
        while (((BooleanValue)condition.accept(this, evaluationContext)).value()) {
            try {
                evaluationContext.pushBlock();
                Mirror res = statement.accept(this, evaluationContext);
                if (res instanceof Break) break;
                if (res instanceof Continue || res == null) continue;
                result = res;
            }
            finally {
                evaluationContext.popBlock();
            }
        }
        return result;
    }

    @Override
    public Mirror visitWildcard(WildcardTree arg0, EvaluationContext evaluationContext) {
        Assert.error(arg0, "unsupported");
        return null;
    }

    @Override
    public Mirror visitOther(Tree arg0, EvaluationContext evaluationContext) {
        Assert.error(arg0, "unsupported");
        return null;
    }

    private Value setToMirror(Tree var, Value value, EvaluationContext evaluationContext) {
        EvaluationContext.VariableInfo varInfo = evaluationContext.getVariableInfo(var);
        if (varInfo == null) {
            Assert.error(var, "unknownVariable", var.toString());
            throw new IllegalStateException("Unknown variable " + var);
        }
        if (value instanceof ArtificialMirror) {
            value = (Value)((ArtificialMirror)((Object)value)).getVMMirror();
        }
        try {
            ArrayList<Value> valuePtr = new ArrayList<Value>(1);
            valuePtr.add(value);
            this.autoboxElements(var, varInfo.getType(), valuePtr, evaluationContext);
            value = (Value)valuePtr.get(0);
        }
        catch (ClassNotLoadedException ex) {
            // empty catch block
        }
        varInfo.setValue(value);
        return value;
    }

    private Value invokeMethod(Tree arg0, Method method, Boolean isStatic, ClassType type, ObjectReference objectReference, List<Value> argVals, EvaluationContext evaluationContext, boolean nonVirtual) {
        if (!evaluationContext.canInvokeMethods()) {
            Assert.error(arg0, "canNotInvokeMethods");
        }
        ThreadReference evaluationThread = null;
        try {
            Value object;
            Value value;
            evaluationThread = evaluationContext.getFrame().thread();
            if (loggerMethod.isLoggable(Level.FINE)) {
                loggerMethod.fine("STARTED : " + objectReference + "." + method + " (" + argVals + ") in thread " + evaluationThread);
            }
            evaluationContext.methodToBeInvoked();
            try {
                EvaluatorVisitor.autoboxArguments(method.argumentTypes(), argVals, evaluationThread, evaluationContext);
            }
            catch (ClassNotLoadedException cnlex) {
                // empty catch block
            }
            if (Boolean.TRUE.equals(isStatic)) {
                value = type.invokeMethod(evaluationThread, method, argVals, 1);
            } else {
                object = objectReference;
                if (type != null) {
                    if (method.isPrivate()) {
                        object = this.findEnclosingObject(arg0, objectReference, type, null, method.name());
                    } else if (!EvaluatorVisitor.instanceOf(objectReference.referenceType(), type)) {
                        object = this.findEnclosingObject(arg0, objectReference, type, null, method.name());
                    }
                }
                if (object == null) {
                    Assert.error(arg0, "noSuchMethod", method.name(), objectReference.referenceType().name());
                }
                value = object.invokeMethod(evaluationThread, method, argVals, 1 | (nonVirtual ? 2 : 0));
            }
            if (value instanceof ObjectReference) {
                // empty if block
            }
            if (loggerMethod.isLoggable(Level.FINE)) {
                loggerMethod.fine("   return = " + value);
            }
            object = value;
            return object;
        }
        catch (InvalidTypeException itex) {
            throw new IllegalStateException(new InvalidExpressionException((Throwable)itex));
        }
        catch (ClassNotLoadedException cnlex) {
            throw new IllegalStateException(cnlex);
        }
        catch (IncompatibleThreadStateException itsex) {
            InvalidExpressionException ieex = new InvalidExpressionException((Throwable)itsex);
            ieex.initCause((Throwable)itsex);
            throw new IllegalStateException(ieex);
        }
        catch (InvalidStackFrameException isfex) {
            InvalidExpressionException ieex = new InvalidExpressionException((Throwable)isfex);
            ieex.initCause((Throwable)isfex);
            throw new IllegalStateException(ieex);
        }
        catch (InvocationException iex) {
            InvocationExceptionTranslated ex = new InvocationExceptionTranslated(iex, evaluationContext.getDebugger());
            InvalidExpressionException ieex = new InvalidExpressionException((Throwable)((Object)ex));
            ieex.initCause((Throwable)((Object)ex));
            throw new IllegalStateException(iex.getLocalizedMessage(), ieex);
        }
        catch (UnsupportedOperationException uoex) {
            InvalidExpressionException ieex = new InvalidExpressionException((Throwable)uoex);
            ieex.initCause((Throwable)uoex);
            throw new IllegalStateException(ieex);
        }
        catch (InternalException inex) {
            if (inex.errorCode() == 502) {
                inex = (InternalException)Exceptions.attachLocalizedMessage((Throwable)inex, (String)NbBundle.getMessage(JPDADebuggerImpl.class, (String)"JDWPError502"));
            }
            throw inex;
        }
        finally {
            if (loggerMethod.isLoggable(Level.FINE)) {
                loggerMethod.fine("FINISHED: " + objectReference + "." + method + " (" + argVals + ") in thread " + evaluationThread);
            }
            try {
                evaluationContext.methodInvokeDone();
            }
            catch (IncompatibleThreadStateException itsex) {
                InvalidExpressionException ieex = new InvalidExpressionException((Throwable)itsex);
                ieex.initCause((Throwable)itsex);
                throw new IllegalStateException(ieex);
            }
        }
    }

    private static void autoboxArguments(List<Type> types, List<Value> argVals, ThreadReference evaluationThread, EvaluationContext evaluationContext) throws InvalidTypeException, ClassNotLoadedException, IncompatibleThreadStateException, InvocationException {
        if (types.size() != argVals.size()) {
            return;
        }
        int n = types.size();
        for (int i = 0; i < n; ++i) {
            Type t = types.get(i);
            Value v = argVals.get(i);
            if (v instanceof ObjectReference && t instanceof PrimitiveType) {
                argVals.set(i, EvaluatorVisitor.unbox((ObjectReference)v, (PrimitiveType)t, evaluationThread, evaluationContext));
            }
            if (!(v instanceof PrimitiveValue) || !(t instanceof ReferenceType)) continue;
            argVals.set(i, EvaluatorVisitor.box((PrimitiveValue)v, (ReferenceType)t, evaluationThread, evaluationContext));
        }
    }

    private void autoboxElements(Tree arg0, Type type, List<Value> elements, EvaluationContext evaluationContext) {
        boolean methodCalled = false;
        ThreadReference evaluationThread = null;
        try {
            Value v;
            int i;
            if (type instanceof PrimitiveType) {
                for (i = 0; i < elements.size(); ++i) {
                    v = elements.get(i);
                    if (!(v instanceof ObjectReference)) continue;
                    if (!methodCalled) {
                        if (!evaluationContext.canInvokeMethods()) {
                            Assert.error(arg0, "canNotInvokeMethods");
                        }
                        evaluationThread = evaluationContext.getFrame().thread();
                        if (loggerMethod.isLoggable(Level.FINE)) {
                            loggerMethod.fine("STARTED : Unbox " + v + " in thread " + evaluationThread);
                        }
                        evaluationContext.methodToBeInvoked();
                        methodCalled = true;
                    }
                    elements.set(i, EvaluatorVisitor.unbox((ObjectReference)v, (PrimitiveType)type, evaluationThread, evaluationContext));
                }
            } else if (type instanceof ReferenceType) {
                for (i = 0; i < elements.size(); ++i) {
                    v = elements.get(i);
                    if (!(v instanceof PrimitiveValue)) continue;
                    if (!methodCalled) {
                        if (!evaluationContext.canInvokeMethods()) {
                            Assert.error(arg0, "canNotInvokeMethods");
                        }
                        evaluationThread = evaluationContext.getFrame().thread();
                        if (loggerMethod.isLoggable(Level.FINE)) {
                            loggerMethod.fine("STARTED : Autobox " + v + " in thread " + evaluationThread);
                        }
                        evaluationContext.methodToBeInvoked();
                        methodCalled = true;
                    }
                    elements.set(i, EvaluatorVisitor.box((PrimitiveValue)v, (ReferenceType)type, evaluationThread, evaluationContext));
                }
            }
        }
        catch (InvalidTypeException itex) {
            throw new IllegalStateException(new InvalidExpressionException((Throwable)itex));
        }
        catch (ClassNotLoadedException cnlex) {
            throw new IllegalStateException(cnlex);
        }
        catch (IncompatibleThreadStateException itsex) {
            InvalidExpressionException ieex = new InvalidExpressionException((Throwable)itsex);
            ieex.initCause((Throwable)itsex);
            throw new IllegalStateException(ieex);
        }
        catch (InvocationException iex) {
            InvocationExceptionTranslated ex = new InvocationExceptionTranslated(iex, evaluationContext.getDebugger());
            InvalidExpressionException ieex = new InvalidExpressionException((Throwable)((Object)ex));
            ieex.initCause((Throwable)((Object)ex));
            throw new IllegalStateException(ieex);
        }
        catch (UnsupportedOperationException uoex) {
            InvalidExpressionException ieex = new InvalidExpressionException((Throwable)uoex);
            ieex.initCause((Throwable)uoex);
            throw new IllegalStateException(ieex);
        }
        finally {
            if (methodCalled) {
                if (loggerMethod.isLoggable(Level.FINE)) {
                    loggerMethod.fine("FINISHED: Autobox/unbox in thread " + evaluationThread);
                }
                try {
                    evaluationContext.methodInvokeDone();
                }
                catch (IncompatibleThreadStateException itsex) {
                    InvalidExpressionException ieex = new InvalidExpressionException((Throwable)itsex);
                    ieex.initCause((Throwable)itsex);
                    throw new IllegalStateException(ieex);
                }
            }
        }
    }

    private static void unboxMethodToBeCalled(Tree arg0, Mirror v, EvaluationContext evaluationContext) {
        if (!evaluationContext.canInvokeMethods()) {
            Assert.error(arg0, "canNotInvokeMethods");
        }
        if (loggerMethod.isLoggable(Level.FINE)) {
            loggerMethod.fine("STARTED : Unbox " + v + " in thread " + evaluationContext.getFrame().thread());
        }
        evaluationContext.methodToBeInvoked();
    }

    private static Mirror unboxIfCan(Tree arg0, ObjectReference r, EvaluationContext evaluationContext) {
        String name = ((ReferenceType)r.type()).name();
        boolean methodCalled = false;
        try {
            if (name.equals(Boolean.class.getName())) {
                EvaluatorVisitor.unboxMethodToBeCalled(arg0, r, evaluationContext);
                methodCalled = true;
                PrimitiveValue primitiveValue = EvaluatorVisitor.invokeUnboxingMethod(r, "booleanValue", evaluationContext.getFrame().thread(), evaluationContext);
                return primitiveValue;
            }
            if (name.equals(Byte.class.getName())) {
                EvaluatorVisitor.unboxMethodToBeCalled(arg0, r, evaluationContext);
                methodCalled = true;
                PrimitiveValue primitiveValue = EvaluatorVisitor.invokeUnboxingMethod(r, "byteValue", evaluationContext.getFrame().thread(), evaluationContext);
                return primitiveValue;
            }
            if (name.equals(Character.class.getName())) {
                EvaluatorVisitor.unboxMethodToBeCalled(arg0, r, evaluationContext);
                methodCalled = true;
                PrimitiveValue primitiveValue = EvaluatorVisitor.invokeUnboxingMethod(r, "charValue", evaluationContext.getFrame().thread(), evaluationContext);
                return primitiveValue;
            }
            if (name.equals(Short.class.getName())) {
                EvaluatorVisitor.unboxMethodToBeCalled(arg0, r, evaluationContext);
                methodCalled = true;
                PrimitiveValue primitiveValue = EvaluatorVisitor.invokeUnboxingMethod(r, "shortValue", evaluationContext.getFrame().thread(), evaluationContext);
                return primitiveValue;
            }
            if (name.equals(Integer.class.getName())) {
                EvaluatorVisitor.unboxMethodToBeCalled(arg0, r, evaluationContext);
                methodCalled = true;
                PrimitiveValue primitiveValue = EvaluatorVisitor.invokeUnboxingMethod(r, "intValue", evaluationContext.getFrame().thread(), evaluationContext);
                return primitiveValue;
            }
            if (name.equals(Long.class.getName())) {
                EvaluatorVisitor.unboxMethodToBeCalled(arg0, r, evaluationContext);
                methodCalled = true;
                PrimitiveValue primitiveValue = EvaluatorVisitor.invokeUnboxingMethod(r, "longValue", evaluationContext.getFrame().thread(), evaluationContext);
                return primitiveValue;
            }
            if (name.equals(Float.class.getName())) {
                EvaluatorVisitor.unboxMethodToBeCalled(arg0, r, evaluationContext);
                methodCalled = true;
                PrimitiveValue primitiveValue = EvaluatorVisitor.invokeUnboxingMethod(r, "floatValue", evaluationContext.getFrame().thread(), evaluationContext);
                return primitiveValue;
            }
            if (name.equals(Double.class.getName())) {
                EvaluatorVisitor.unboxMethodToBeCalled(arg0, r, evaluationContext);
                methodCalled = true;
                PrimitiveValue primitiveValue = EvaluatorVisitor.invokeUnboxingMethod(r, "doubleValue", evaluationContext.getFrame().thread(), evaluationContext);
                return primitiveValue;
            }
            ObjectReference objectReference = r;
            return objectReference;
        }
        catch (InvalidTypeException itex) {
            throw new IllegalStateException(new InvalidExpressionException((Throwable)itex));
        }
        catch (ClassNotLoadedException cnlex) {
            throw new IllegalStateException(cnlex);
        }
        catch (IncompatibleThreadStateException itsex) {
            InvalidExpressionException ieex = new InvalidExpressionException((Throwable)itsex);
            ieex.initCause((Throwable)itsex);
            throw new IllegalStateException(ieex);
        }
        catch (InvocationException iex) {
            InvocationExceptionTranslated ex = new InvocationExceptionTranslated(iex, evaluationContext.getDebugger());
            InvalidExpressionException ieex = new InvalidExpressionException((Throwable)((Object)ex));
            ieex.initCause((Throwable)((Object)ex));
            throw new IllegalStateException(ieex);
        }
        catch (UnsupportedOperationException uoex) {
            InvalidExpressionException ieex = new InvalidExpressionException((Throwable)uoex);
            ieex.initCause((Throwable)uoex);
            throw new IllegalStateException(ieex);
        }
        finally {
            if (methodCalled) {
                if (loggerMethod.isLoggable(Level.FINE)) {
                    loggerMethod.fine("FINISHED: unbox in thread " + evaluationContext.getFrame().thread());
                }
                try {
                    evaluationContext.methodInvokeDone();
                }
                catch (IncompatibleThreadStateException itsex) {
                    InvalidExpressionException ieex = new InvalidExpressionException((Throwable)itsex);
                    ieex.initCause((Throwable)itsex);
                    throw new IllegalStateException(ieex);
                }
            }
        }
    }

    public static Value unbox(ObjectReference val, PrimitiveType type, ThreadReference thread, EvaluationContext context) throws InvalidTypeException, ClassNotLoadedException, IncompatibleThreadStateException, InvocationException {
        PrimitiveValue pv;
        ReferenceType rt = val.referenceType();
        String classType = rt.name();
        if (classType.equals("java.lang.Boolean")) {
            pv = EvaluatorVisitor.invokeUnboxingMethod(val, "booleanValue", thread, context);
        } else if (classType.equals("java.lang.Byte")) {
            pv = EvaluatorVisitor.invokeUnboxingMethod(val, "byteValue", thread, context);
        } else if (classType.equals("java.lang.Character")) {
            pv = EvaluatorVisitor.invokeUnboxingMethod(val, "charValue", thread, context);
        } else if (classType.equals("java.lang.Short")) {
            pv = EvaluatorVisitor.invokeUnboxingMethod(val, "shortValue", thread, context);
        } else if (classType.equals("java.lang.Integer")) {
            pv = EvaluatorVisitor.invokeUnboxingMethod(val, "intValue", thread, context);
        } else if (classType.equals("java.lang.Long")) {
            pv = EvaluatorVisitor.invokeUnboxingMethod(val, "longValue", thread, context);
        } else if (classType.equals("java.lang.Float")) {
            pv = EvaluatorVisitor.invokeUnboxingMethod(val, "floatValue", thread, context);
        } else if (classType.equals("java.lang.Double")) {
            pv = EvaluatorVisitor.invokeUnboxingMethod(val, "doubleValue", thread, context);
        } else {
            return val;
        }
        VirtualMachine vm = pv.virtualMachine();
        if (type instanceof BooleanType && !(pv instanceof BooleanValue)) {
            return vm.mirrorOf(pv.booleanValue());
        }
        if (type instanceof ByteType && !(pv instanceof ByteValue)) {
            return vm.mirrorOf(pv.byteValue());
        }
        if (type instanceof CharType && !(pv instanceof CharValue)) {
            return vm.mirrorOf(pv.charValue());
        }
        if (type instanceof ShortType && !(pv instanceof ShortValue)) {
            return vm.mirrorOf(pv.shortValue());
        }
        if (type instanceof IntegerType && !(pv instanceof IntegerValue)) {
            return vm.mirrorOf(pv.intValue());
        }
        if (type instanceof LongType && !(pv instanceof LongValue)) {
            return vm.mirrorOf(pv.longValue());
        }
        if (type instanceof FloatType && !(pv instanceof FloatValue)) {
            return vm.mirrorOf(pv.floatValue());
        }
        if (type instanceof DoubleType && !(pv instanceof DoubleValue)) {
            return vm.mirrorOf(pv.doubleValue());
        }
        return pv;
    }

    private static ReferenceType adjustBoxingType(ReferenceType type, PrimitiveType primitiveType, EvaluationContext evaluationContext) {
        if (primitiveType instanceof BooleanType) {
            type = EvaluatorVisitor.getOrLoadClass(type.virtualMachine(), Boolean.class.getName(), evaluationContext);
        } else if (primitiveType instanceof ByteType) {
            type = EvaluatorVisitor.getOrLoadClass(type.virtualMachine(), Byte.class.getName(), evaluationContext);
        } else if (primitiveType instanceof CharType) {
            type = EvaluatorVisitor.getOrLoadClass(type.virtualMachine(), Character.class.getName(), evaluationContext);
        } else if (primitiveType instanceof ShortType) {
            type = EvaluatorVisitor.getOrLoadClass(type.virtualMachine(), Short.class.getName(), evaluationContext);
        } else if (primitiveType instanceof IntegerType) {
            type = EvaluatorVisitor.getOrLoadClass(type.virtualMachine(), Integer.class.getName(), evaluationContext);
        } else if (primitiveType instanceof LongType) {
            type = EvaluatorVisitor.getOrLoadClass(type.virtualMachine(), Long.class.getName(), evaluationContext);
        } else if (primitiveType instanceof FloatType) {
            type = EvaluatorVisitor.getOrLoadClass(type.virtualMachine(), Float.class.getName(), evaluationContext);
        } else if (primitiveType instanceof DoubleType) {
            type = EvaluatorVisitor.getOrLoadClass(type.virtualMachine(), Double.class.getName(), evaluationContext);
        }
        return type;
    }

    public static Value box(PrimitiveValue v, ReferenceType type, ThreadReference thread, EvaluationContext evaluationContext) throws InvalidTypeException, ClassNotLoadedException, IncompatibleThreadStateException, InvocationException {
        try {
            ObjectReference o;
            Method constructor = null;
            String classType = type.name();
            if (!PRIMITIVE_CLASS_NAMES.contains(classType)) {
                type = EvaluatorVisitor.adjustBoxingType(type, (PrimitiveType)v.type(), evaluationContext);
            } else {
                VirtualMachine vm = v.virtualMachine();
                if (classType.equals("java.lang.Boolean") && !(v instanceof BooleanValue)) {
                    v = vm.mirrorOf(v.booleanValue());
                } else if (classType.equals("java.lang.Byte") && !(v instanceof ByteValue)) {
                    v = vm.mirrorOf(v.byteValue());
                } else if (classType.equals("java.lang.Character") && !(v instanceof CharValue)) {
                    v = vm.mirrorOf(v.charValue());
                } else if (classType.equals("java.lang.Short") && !(v instanceof ShortValue)) {
                    v = vm.mirrorOf(v.shortValue());
                } else if (classType.equals("java.lang.Integer") && !(v instanceof IntegerValue)) {
                    v = vm.mirrorOf(v.intValue());
                } else if (classType.equals("java.lang.Long") && !(v instanceof LongValue)) {
                    v = vm.mirrorOf(v.longValue());
                } else if (classType.equals("java.lang.Float") && !(v instanceof FloatValue)) {
                    v = vm.mirrorOf(v.floatValue());
                } else if (classType.equals("java.lang.Double") && !(v instanceof DoubleValue)) {
                    v = vm.mirrorOf(v.doubleValue());
                }
            }
            List<Method> methods = type.methodsByName("<init>");
            String signature = "(" + v.type().signature() + ")";
            for (Method method : methods) {
                if (method.isAbstract() || !EvaluatorVisitor.equalMethodSignatures(method.signature(), signature)) continue;
                constructor = method;
            }
            if (constructor == null) {
                throw new RuntimeException("No constructor " + type + " " + signature);
            }
            if (evaluationContext != null) {
                evaluationContext.methodToBeInvoked();
            }
            ObjectReference objectReference = o = ((ClassType)type).newInstance(thread, constructor, Arrays.asList(v), 1);
            return objectReference;
        }
        catch (InvalidTypeException itex) {
            throw itex;
        }
        catch (ClassNotLoadedException cnlex) {
            throw cnlex;
        }
        catch (IncompatibleThreadStateException itsex) {
            throw itsex;
        }
        catch (InvocationException iex) {
            throw iex;
        }
        catch (RuntimeException rex) {
            throw rex;
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected exception while invoking boxing method", e);
        }
        finally {
            if (evaluationContext != null) {
                try {
                    evaluationContext.methodInvokeDone();
                }
                catch (IncompatibleThreadStateException itsex) {
                    InvalidExpressionException ieex = new InvalidExpressionException((Throwable)itsex);
                    ieex.initCause((Throwable)itsex);
                    throw new IllegalStateException(ieex);
                }
            }
        }
    }

    private static PrimitiveValue invokeUnboxingMethod(ObjectReference reference, String methodName, ThreadReference thread, EvaluationContext evaluationContext) throws InvalidTypeException, ClassNotLoadedException, IncompatibleThreadStateException, InvocationException {
        Method toCall = reference.referenceType().methodsByName(methodName).get(0);
        if (evaluationContext != null) {
            evaluationContext.methodToBeInvoked();
        }
        try {
            PrimitiveValue primitiveValue = (PrimitiveValue)reference.invokeMethod(thread, toCall, new ArrayList(0), 1);
            return primitiveValue;
        }
        catch (InvalidTypeException itex) {
            throw itex;
        }
        catch (ClassNotLoadedException cnlex) {
            throw cnlex;
        }
        catch (IncompatibleThreadStateException itsex) {
            throw itsex;
        }
        catch (InvocationException iex) {
            throw iex;
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected exception while invoking unboxing method", e);
        }
        finally {
            if (evaluationContext != null) {
                try {
                    evaluationContext.methodInvokeDone();
                }
                catch (IncompatibleThreadStateException itsex) {
                    InvalidExpressionException ieex = new InvalidExpressionException((Throwable)itsex);
                    ieex.initCause((Throwable)itsex);
                    throw new IllegalStateException(ieex);
                }
            }
        }
    }

    private boolean isEqual(Mirror left, Mirror right, EvaluationContext evaluationContext) {
        boolean isRightNumeric;
        if (left instanceof ObjectReference) {
            return left.equals(right);
        }
        VirtualMachine vm = evaluationContext.getDebugger().getVirtualMachine();
        if (vm == null) {
            return false;
        }
        if (left instanceof BooleanValue && right instanceof BooleanValue) {
            boolean op2;
            boolean op1 = ((BooleanValue)left).booleanValue();
            return op1 == (op2 = ((BooleanValue)right).booleanValue());
        }
        boolean isLeftNumeric = left instanceof PrimitiveValue && !(left instanceof BooleanValue);
        boolean bl = isRightNumeric = right instanceof PrimitiveValue && !(right instanceof BooleanValue);
        if (isLeftNumeric && isRightNumeric) {
            long r;
            if (left instanceof DoubleValue || right instanceof DoubleValue) {
                double r2;
                double l = ((PrimitiveValue)left).doubleValue();
                return l == (r2 = ((PrimitiveValue)right).doubleValue());
            }
            if (left instanceof FloatValue || right instanceof FloatValue) {
                float r3;
                float l = ((PrimitiveValue)left).floatValue();
                return l == (r3 = ((PrimitiveValue)right).floatValue());
            }
            long l = ((PrimitiveValue)left).longValue();
            return l == (r = ((PrimitiveValue)right).longValue());
        }
        return false;
    }

    private String toString(Tree arg0, Mirror v, EvaluationContext evaluationContext) {
        Method method;
        if (v instanceof PrimitiveValue) {
            PrimitiveValue pv = (PrimitiveValue)v;
            PrimitiveType t = (PrimitiveType)pv.type();
            if (t instanceof ByteType) {
                return Byte.toString(pv.byteValue());
            }
            if (t instanceof BooleanType) {
                return Boolean.toString(pv.booleanValue());
            }
            if (t instanceof CharType) {
                return Character.toString(pv.charValue());
            }
            if (t instanceof ShortType) {
                return Short.toString(pv.shortValue());
            }
            if (t instanceof IntegerType) {
                return Integer.toString(pv.intValue());
            }
            if (t instanceof LongType) {
                return Long.toString(pv.longValue());
            }
            if (t instanceof FloatType) {
                return Float.toString(pv.floatValue());
            }
            if (t instanceof DoubleType) {
                return Double.toString(pv.doubleValue());
            }
            throw new IllegalStateException("Unknown primitive type: " + t);
        }
        if (v == null) {
            return "" + null;
        }
        ObjectReference ov = (ObjectReference)v;
        if (ov instanceof ArrayReference) {
            return "#" + ov.uniqueID() + " " + ov.type().name() + "(length=" + ((ArrayReference)ov).length() + ")";
        }
        if (ov instanceof StringReference) {
            return ((StringReference)ov).value();
        }
        List typeArguments = Collections.emptyList();
        try {
            method = EvaluatorVisitor.getConcreteMethod((ReferenceType)ov.type(), "toString", typeArguments);
        }
        catch (UnsuitableArgumentsException uaex) {
            throw new IllegalStateException(uaex);
        }
        ((ClassType)ov.type()).methodsByName("toString");
        List<Value> argVals = Collections.emptyList();
        Value sv = this.invokeMethod(arg0, method, false, null, ov, argVals, evaluationContext, false);
        if (sv instanceof StringReference) {
            return ((StringReference)sv).value();
        }
        if (sv == null) {
            return null;
        }
        return "Result of toString() call on " + ov + " is not a String, but: " + sv;
    }

    private Value mirrorOf(VirtualMachine vm, Object value) {
        if (value instanceof Boolean) {
            return new BooleanVal(vm, (Boolean)value);
        }
        if (value instanceof Character) {
            return new CharVal(vm, ((Character)value).charValue());
        }
        if (value instanceof Byte) {
            return new ByteVal(vm, (Byte)value);
        }
        if (value instanceof Integer) {
            return new IntVal(vm, (Integer)value);
        }
        if (value instanceof Short) {
            return new ShortVal(vm, (Short)value);
        }
        if (value instanceof Long) {
            return new LongVal(vm, (Long)value);
        }
        if (value instanceof Float) {
            return new FloatVal(vm, ((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return new DoubleVal(vm, (Double)value);
        }
        return null;
    }

    private static ReferenceType getOrLoadClass(VirtualMachine vm, String name, EvaluationContext evaluationContext) {
        List<ReferenceType> types = vm.classesByName(name);
        if (types.size() > 0) {
            if (types.size() == 1) {
                return types.get(0);
            }
            ClassLoaderReference contextClassLoader = evaluationContext.getFrame().location().declaringType().classLoader();
            for (ReferenceType type : types) {
                if (!contextClassLoader.equals(type.classLoader())) continue;
                return type;
            }
            try {
                ReferenceType preferedType = JPDAUtils.getPreferredReferenceType(types, null);
                if (preferedType != null) {
                    return preferedType;
                }
            }
            catch (VMDisconnectedExceptionWrapper ex) {
                throw ex.getCause();
            }
            return types.get(0);
        }
        return null;
    }

    private static StringReference createStringMirrorWithDisabledCollection(String s, VirtualMachine vm, EvaluationContext evaluationContext) {
        StringReference sr;
        do {
            try {
                sr = vm.mirrorOf(s);
            }
            catch (UnsupportedOperationException e) {
                Assert.error(null, "unsupportedStringCreation");
                return null;
            }
            try {
                evaluationContext.disableCollectionOf(sr);
            }
            catch (ObjectCollectedException oce) {
                sr = null;
            }
        } while (sr == null);
        return sr;
    }

    private static ArrayReference createArrayMirrorWithDisabledCollection(ArrayType arrayType, int dimension, EvaluationContext evaluationContext) {
        ArrayReference array;
        do {
            array = arrayType.newInstance(dimension);
            try {
                evaluationContext.disableCollectionOf(array);
            }
            catch (ObjectCollectedException oce) {
                array = null;
            }
        } while (array == null);
        return array;
    }

    private void reportCannotApplyOperator(BinaryTree binaryTree) {
        Assert.error((Tree)binaryTree, "cannotApplyOperator", binaryTree.toString());
    }

    private static class DoubleVal
    extends ArtificialMirror
    implements DoubleValue {
        private double value;
        private VirtualMachine vm;

        DoubleVal(VirtualMachine vm, double value) {
            this.vm = vm;
            this.value = value;
        }

        @Override
        public Mirror getVMMirror() {
            return this.vm.mirrorOf(this.value);
        }

        @Override
        public double value() {
            return this.value;
        }

        @Override
        public boolean booleanValue() {
            return this.value != 0.0;
        }

        @Override
        public byte byteValue() {
            return (byte)this.value;
        }

        @Override
        public char charValue() {
            return (char)this.value;
        }

        @Override
        public short shortValue() {
            return (short)this.value;
        }

        @Override
        public int intValue() {
            return (int)this.value;
        }

        @Override
        public long longValue() {
            return (long)this.value;
        }

        @Override
        public float floatValue() {
            return (float)this.value;
        }

        @Override
        public double doubleValue() {
            return this.value;
        }

        @Override
        public Type type() {
            return this.vm.mirrorOf(0.0).type();
        }

        @Override
        public int compareTo(DoubleValue o) {
            return (int)(this.value - o.value());
        }
    }

    private static class FloatVal
    extends ArtificialMirror
    implements FloatValue {
        private float value;
        private VirtualMachine vm;

        FloatVal(VirtualMachine vm, float value) {
            this.vm = vm;
            this.value = value;
        }

        @Override
        public Mirror getVMMirror() {
            return this.vm.mirrorOf(this.value);
        }

        @Override
        public float value() {
            return this.value;
        }

        @Override
        public boolean booleanValue() {
            return this.value != 0.0f;
        }

        @Override
        public byte byteValue() {
            return (byte)this.value;
        }

        @Override
        public char charValue() {
            return (char)this.value;
        }

        @Override
        public short shortValue() {
            return (short)this.value;
        }

        @Override
        public int intValue() {
            return (int)this.value;
        }

        @Override
        public long longValue() {
            return (long)this.value;
        }

        @Override
        public float floatValue() {
            return this.value;
        }

        @Override
        public double doubleValue() {
            return this.value;
        }

        @Override
        public Type type() {
            return this.vm.mirrorOf(0.0f).type();
        }

        @Override
        public int compareTo(FloatValue o) {
            return (int)(this.value - o.value());
        }
    }

    private static class CharVal
    extends ArtificialMirror
    implements CharValue {
        private char value;
        private VirtualMachine vm;

        CharVal(VirtualMachine vm, char value) {
            this.vm = vm;
            this.value = value;
        }

        @Override
        public Mirror getVMMirror() {
            return this.vm.mirrorOf(this.value);
        }

        @Override
        public char value() {
            return this.value;
        }

        @Override
        public boolean booleanValue() {
            return this.value != '\u0000';
        }

        @Override
        public byte byteValue() {
            return (byte)this.value;
        }

        @Override
        public char charValue() {
            return this.value;
        }

        @Override
        public short shortValue() {
            return (short)this.value;
        }

        @Override
        public int intValue() {
            return this.value;
        }

        @Override
        public long longValue() {
            return this.value;
        }

        @Override
        public float floatValue() {
            return this.value;
        }

        @Override
        public double doubleValue() {
            return this.value;
        }

        @Override
        public Type type() {
            return this.vm.mirrorOf(' ').type();
        }

        @Override
        public int compareTo(CharValue o) {
            return this.value - o.value();
        }
    }

    private static class LongVal
    extends ArtificialMirror
    implements LongValue {
        private long value;
        private VirtualMachine vm;

        LongVal(VirtualMachine vm, long value) {
            this.vm = vm;
            this.value = value;
        }

        @Override
        public Mirror getVMMirror() {
            return this.vm.mirrorOf(this.value);
        }

        @Override
        public long value() {
            return this.value;
        }

        @Override
        public boolean booleanValue() {
            return this.value != 0L;
        }

        @Override
        public byte byteValue() {
            return (byte)this.value;
        }

        @Override
        public char charValue() {
            return (char)this.value;
        }

        @Override
        public short shortValue() {
            return (short)this.value;
        }

        @Override
        public int intValue() {
            return (int)this.value;
        }

        @Override
        public long longValue() {
            return this.value;
        }

        @Override
        public float floatValue() {
            return this.value;
        }

        @Override
        public double doubleValue() {
            return this.value;
        }

        @Override
        public Type type() {
            return this.vm.mirrorOf(0L).type();
        }

        @Override
        public int compareTo(LongValue o) {
            return (int)(this.value - o.value());
        }
    }

    private static class IntVal
    extends ArtificialMirror
    implements IntegerValue {
        private int value;
        private VirtualMachine vm;

        IntVal(VirtualMachine vm, int value) {
            this.vm = vm;
            this.value = value;
        }

        @Override
        public Mirror getVMMirror() {
            return this.vm.mirrorOf(this.value);
        }

        @Override
        public int value() {
            return this.value;
        }

        @Override
        public boolean booleanValue() {
            return this.value != 0;
        }

        @Override
        public byte byteValue() {
            return (byte)this.value;
        }

        @Override
        public char charValue() {
            return (char)this.value;
        }

        @Override
        public short shortValue() {
            return (short)this.value;
        }

        @Override
        public int intValue() {
            return this.value;
        }

        @Override
        public long longValue() {
            return this.value;
        }

        @Override
        public float floatValue() {
            return this.value;
        }

        @Override
        public double doubleValue() {
            return this.value;
        }

        @Override
        public Type type() {
            return this.vm.mirrorOf(0).type();
        }

        @Override
        public int compareTo(IntegerValue o) {
            return this.value - o.value();
        }
    }

    private static class ShortVal
    extends ArtificialMirror
    implements ShortValue {
        private short value;
        private VirtualMachine vm;

        ShortVal(VirtualMachine vm, short value) {
            this.vm = vm;
            this.value = value;
        }

        @Override
        public Mirror getVMMirror() {
            return this.vm.mirrorOf(this.value);
        }

        @Override
        public short value() {
            return this.value;
        }

        @Override
        public boolean booleanValue() {
            return this.value != 0;
        }

        @Override
        public byte byteValue() {
            return (byte)this.value;
        }

        @Override
        public char charValue() {
            return (char)this.value;
        }

        @Override
        public short shortValue() {
            return this.value;
        }

        @Override
        public int intValue() {
            return this.value;
        }

        @Override
        public long longValue() {
            return this.value;
        }

        @Override
        public float floatValue() {
            return this.value;
        }

        @Override
        public double doubleValue() {
            return this.value;
        }

        @Override
        public Type type() {
            return this.vm.mirrorOf((short)0).type();
        }

        @Override
        public int compareTo(ShortValue o) {
            return this.value - o.value();
        }
    }

    private static class ByteVal
    extends ArtificialMirror
    implements ByteValue {
        private byte value;
        private VirtualMachine vm;

        ByteVal(VirtualMachine vm, byte value) {
            this.vm = vm;
            this.value = value;
        }

        @Override
        public Mirror getVMMirror() {
            return this.vm.mirrorOf(this.value);
        }

        @Override
        public byte value() {
            return this.value;
        }

        @Override
        public boolean booleanValue() {
            return this.value != 0;
        }

        @Override
        public byte byteValue() {
            return this.value;
        }

        @Override
        public char charValue() {
            return (char)this.value;
        }

        @Override
        public short shortValue() {
            return this.value;
        }

        @Override
        public int intValue() {
            return this.value;
        }

        @Override
        public long longValue() {
            return this.value;
        }

        @Override
        public float floatValue() {
            return this.value;
        }

        @Override
        public double doubleValue() {
            return this.value;
        }

        @Override
        public Type type() {
            return this.vm.mirrorOf((byte)0).type();
        }

        @Override
        public int compareTo(ByteValue o) {
            return this.value - o.value();
        }
    }

    private static class BooleanVal
    extends ArtificialMirror
    implements BooleanValue {
        private boolean value;
        private VirtualMachine vm;

        BooleanVal(VirtualMachine vm, boolean value) {
            this.vm = vm;
            this.value = value;
        }

        @Override
        public Mirror getVMMirror() {
            return this.vm.mirrorOf(this.value);
        }

        @Override
        public boolean value() {
            return this.value;
        }

        @Override
        public boolean booleanValue() {
            return this.value;
        }

        @Override
        public byte byteValue() {
            return (byte)(this.value ? 1 : 0);
        }

        @Override
        public char charValue() {
            return (char)this.byteValue();
        }

        @Override
        public short shortValue() {
            return (short)(this.value ? 1 : 0);
        }

        @Override
        public int intValue() {
            return this.value ? 1 : 0;
        }

        @Override
        public long longValue() {
            return this.value ? 1L : 0L;
        }

        @Override
        public float floatValue() {
            return this.value ? 1.0f : 0.0f;
        }

        @Override
        public double doubleValue() {
            return this.value ? 1.0 : 0.0;
        }

        @Override
        public Type type() {
            return this.vm.mirrorOf(true).type();
        }
    }

    private static final class Return
    extends CommandMirror {
        private Mirror value;

        Return(Mirror value) {
            this.value = value;
        }

        @Override
        public Mirror getVMMirror() {
            return this.value instanceof ArtificialMirror ? ((ArtificialMirror)this.value).getVMMirror() : this.value;
        }

        @Override
        public String toString() {
            return "return";
        }
    }

    private static final class Continue
    extends CommandMirror {
        private Continue() {
        }

        @Override
        public String toString() {
            return "continue";
        }

        @Override
        public Mirror getVMMirror() {
            return null;
        }
    }

    private static final class Break
    extends CommandMirror {
        private Break() {
        }

        @Override
        public String toString() {
            return "break";
        }

        @Override
        public Mirror getVMMirror() {
            return null;
        }
    }

    private static abstract class CommandMirror
    extends ArtificialMirror {
        private CommandMirror() {
        }
    }

    static abstract class ArtificialMirror
    implements Mirror {
        ArtificialMirror() {
        }

        @Override
        public VirtualMachine virtualMachine() {
            return null;
        }

        public abstract Mirror getVMMirror();
    }

    private static final class UnsuitableArgumentsException
    extends Exception {
    }
}

