/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.beans;

import freemarker.template.TemplateModelException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

class MethodMap {
    private static final Class BIGDECIMAL_CLASS = class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = MethodMap.class$("java.math.BigDecimal")) : class$java$math$BigDecimal;
    private static final Class NUMBER_CLASS = class$java$lang$Number == null ? (class$java$lang$Number = MethodMap.class$("java.lang.Number")) : class$java$lang$Number;
    private static final Object[] EMPTY_ARGS = new Object[0];
    private static final Class NULL_CLASS = class$java$lang$Object == null ? (class$java$lang$Object = MethodMap.class$("java.lang.Object")) : class$java$lang$Object;
    private static final ClassString EMPTY_STRING = new ClassString(EMPTY_ARGS);
    private static final Object NO_SUCH_METHOD = new Object();
    private static final Object AMBIGUOUS_METHOD = new Object();
    private final String name;
    private final Map selectorCache = new HashMap();
    private Class[][] unwrapTypes;
    private final List methods = new LinkedList();
    private static final Comparator CLASS_ORDER = new Comparator(){

        public int compare(Object o1, Object o2) {
            Class c1 = (Class)o1;
            Class c2 = (Class)o2;
            if (c1.isInterface()) {
                if (!c2.isInterface()) {
                    return 1;
                }
            } else if (c2.isInterface()) {
                return -1;
            }
            return c1.getName().compareTo(c2.getName());
        }
    };
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;

    MethodMap(String name) {
        this.name = name;
    }

    void addMethod(Method method) {
        this.methods.add(method);
        this.updateUnwrapTypes(method.getParameterTypes());
    }

    void addConstructor(Constructor constructor) {
        this.methods.add(constructor);
        this.updateUnwrapTypes(constructor.getParameterTypes());
    }

    private void updateUnwrapTypes(Class[] argTypes) {
        int l = argTypes.length - 1;
        if (l == -1) {
            return;
        }
        if (this.unwrapTypes == null) {
            this.unwrapTypes = new Class[l + 1][];
            this.unwrapTypes[l] = argTypes;
        } else if (this.unwrapTypes.length <= l) {
            Class[][] newUnwrapTypes = new Class[l + 1][];
            System.arraycopy(this.unwrapTypes, 0, newUnwrapTypes, 0, this.unwrapTypes.length);
            this.unwrapTypes = newUnwrapTypes;
            this.unwrapTypes[l] = argTypes;
        } else {
            Class[] oldTypes = this.unwrapTypes[l];
            if (oldTypes == null) {
                this.unwrapTypes[l] = argTypes;
            } else {
                for (int i = 0; i < oldTypes.length; ++i) {
                    oldTypes[i] = MethodMap.getMostSpecificCommonType(oldTypes[i], argTypes[i]);
                }
            }
        }
    }

    String getName() {
        return this.name;
    }

    Class[] getUnwrapTypes(List args) throws TemplateModelException {
        Class[] retval;
        int l = args.size() - 1;
        if (l == -1) {
            return EMPTY_STRING.getClasses();
        }
        if (l < this.unwrapTypes.length && (retval = this.unwrapTypes[l]) != null) {
            return retval;
        }
        throw new TemplateModelException("No signature of method " + this.name + " accepts " + (l + 1) + " arguments");
    }

    AccessibleObject getMostSpecific(Object[] args) throws TemplateModelException {
        ClassString cs = null;
        if (args == null) {
            args = EMPTY_ARGS;
            cs = EMPTY_STRING;
        } else {
            cs = new ClassString(args);
        }
        Map map = this.selectorCache;
        synchronized (map) {
            Object obj = this.selectorCache.get(cs);
            if (obj == null) {
                obj = cs.getMostSpecific(this.methods);
                this.selectorCache.put(cs, obj);
            }
            if (obj instanceof AccessibleObject) {
                return (AccessibleObject)obj;
            }
            if (obj == NO_SUCH_METHOD) {
                throw new TemplateModelException("No signature of method " + this.name + " matches " + cs.listArgumentTypes());
            }
            throw new TemplateModelException("Multiple signatures of method " + this.name + " match " + cs.listArgumentTypes());
        }
    }

    private static boolean isMoreSpecific(Class specific, Class generic) {
        if (generic.isAssignableFrom(specific)) {
            return true;
        }
        if (generic.isPrimitive()) {
            if (generic == Short.TYPE && specific == Byte.TYPE) {
                return true;
            }
            if (generic == Integer.TYPE && (specific == Short.TYPE || specific == Byte.TYPE)) {
                return true;
            }
            if (generic == Long.TYPE && (specific == Integer.TYPE || specific == Short.TYPE || specific == Byte.TYPE)) {
                return true;
            }
            if (generic == Float.TYPE && (specific == Long.TYPE || specific == Integer.TYPE || specific == Short.TYPE || specific == Byte.TYPE)) {
                return true;
            }
            if (generic == Double.TYPE && (specific == Float.TYPE || specific == Long.TYPE || specific == Integer.TYPE || specific == Short.TYPE || specific == Byte.TYPE)) {
                return true;
            }
        }
        return MethodMap.isBigDecimalConvertible(generic, specific);
    }

    private static boolean isBigDecimalConvertible(Class formal, Class actual) {
        if (BIGDECIMAL_CLASS.isAssignableFrom(actual)) {
            if (NUMBER_CLASS.isAssignableFrom(formal)) {
                return true;
            }
            if (formal.isPrimitive() && formal != Boolean.TYPE && formal != Character.TYPE) {
                return true;
            }
        }
        return false;
    }

    private static Class getMostSpecificCommonType(Class c1, Class c2) {
        if (c1 == c2) {
            return c1;
        }
        if (c2.isPrimitive()) {
            if (c2 == Byte.TYPE) {
                c2 = class$java$lang$Byte == null ? (class$java$lang$Byte = MethodMap.class$("java.lang.Byte")) : class$java$lang$Byte;
            } else if (c2 == Short.TYPE) {
                c2 = class$java$lang$Short == null ? (class$java$lang$Short = MethodMap.class$("java.lang.Short")) : class$java$lang$Short;
            } else if (c2 == Character.TYPE) {
                c2 = class$java$lang$Character == null ? (class$java$lang$Character = MethodMap.class$("java.lang.Character")) : class$java$lang$Character;
            } else if (c2 == Integer.TYPE) {
                c2 = class$java$lang$Integer == null ? (class$java$lang$Integer = MethodMap.class$("java.lang.Integer")) : class$java$lang$Integer;
            } else if (c2 == Float.TYPE) {
                c2 = class$java$lang$Float == null ? (class$java$lang$Float = MethodMap.class$("java.lang.Float")) : class$java$lang$Float;
            } else if (c2 == Long.TYPE) {
                c2 = class$java$lang$Long == null ? (class$java$lang$Long = MethodMap.class$("java.lang.Long")) : class$java$lang$Long;
            } else if (c2 == Double.TYPE) {
                c2 = class$java$lang$Double == null ? (class$java$lang$Double = MethodMap.class$("java.lang.Double")) : class$java$lang$Double;
            }
        }
        Set a1 = MethodMap.getAssignables(c1, c2);
        Set a2 = MethodMap.getAssignables(c2, c1);
        a1.retainAll(a2);
        if (a1.isEmpty()) {
            return class$java$lang$Object == null ? (class$java$lang$Object = MethodMap.class$("java.lang.Object")) : class$java$lang$Object;
        }
        ArrayList<Class> max = new ArrayList<Class>();
        Iterator iter = a1.iterator();
        block0: while (iter.hasNext()) {
            Class clazz = (Class)iter.next();
            Iterator maxiter = max.iterator();
            while (maxiter.hasNext()) {
                Class maxClazz = (Class)maxiter.next();
                if (MethodMap.isMoreSpecific(maxClazz, clazz)) continue block0;
                if (!MethodMap.isMoreSpecific(clazz, maxClazz)) continue;
                maxiter.remove();
            }
            max.add(clazz);
        }
        if (max.size() > 1) {
            Collections.sort(max, CLASS_ORDER);
        }
        return (Class)max.get(0);
    }

    private static Set getAssignables(Class c1, Class c2) {
        HashSet s = new HashSet();
        MethodMap.collectAssignables(c1, c2, s);
        return s;
    }

    private static void collectAssignables(Class c1, Class c2, Set s) {
        Class sc;
        if (c1.isAssignableFrom(c2)) {
            s.add(c1);
        }
        if ((sc = c1.getSuperclass()) != null) {
            MethodMap.collectAssignables(sc, c2, s);
        }
        Class<?>[] itf = c1.getInterfaces();
        for (int i = 0; i < itf.length; ++i) {
            MethodMap.collectAssignables(itf[i], c2, s);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class ClassString {
        private final Class[] classes;
        private static final int MORE_SPECIFIC = 0;
        private static final int LESS_SPECIFIC = 1;
        private static final int INDETERMINATE = 2;

        ClassString(Object[] objects) {
            int l = objects.length;
            this.classes = new Class[l];
            for (int i = 0; i < l; ++i) {
                Object obj = objects[i];
                this.classes[i] = obj == null ? NULL_CLASS : obj.getClass();
            }
        }

        Class[] getClasses() {
            return this.classes;
        }

        public int hashCode() {
            int hash = 0;
            for (int i = 0; i < this.classes.length; ++i) {
                hash ^= this.classes[i].hashCode();
            }
            return hash;
        }

        public boolean equals(Object o) {
            if (o instanceof ClassString) {
                ClassString cs = (ClassString)o;
                if (cs.classes.length != this.classes.length) {
                    return false;
                }
                for (int i = 0; i < this.classes.length; ++i) {
                    if (cs.classes[i] == this.classes[i]) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        Object getMostSpecific(List methods) {
            LinkedList applicables = this.getApplicables(methods);
            if (applicables.isEmpty()) {
                return NO_SUCH_METHOD;
            }
            if (applicables.size() == 1) {
                return applicables.getFirst();
            }
            LinkedList maximals = new LinkedList();
            Iterator applicable = applicables.iterator();
            while (applicable.hasNext()) {
                Object objapp = applicable.next();
                Class[] appArgs = ClassString.getParameterTypes(objapp);
                boolean lessSpecific = false;
                Iterator maximal = maximals.iterator();
                while (!lessSpecific && maximal.hasNext()) {
                    Object max = maximal.next();
                    switch (ClassString.moreSpecific(appArgs, ClassString.getParameterTypes(max))) {
                        case 0: {
                            maximal.remove();
                            break;
                        }
                        case 1: {
                            lessSpecific = true;
                        }
                    }
                }
                if (lessSpecific) continue;
                maximals.addLast(objapp);
            }
            if (maximals.size() > 1) {
                return AMBIGUOUS_METHOD;
            }
            return maximals.getFirst();
        }

        private static Class[] getParameterTypes(Object obj) {
            if (obj instanceof Method) {
                return ((Method)obj).getParameterTypes();
            }
            if (obj instanceof Constructor) {
                return ((Constructor)obj).getParameterTypes();
            }
            throw new Error();
        }

        private static int moreSpecific(Class[] c1, Class[] c2) {
            boolean c1MoreSpecific = false;
            boolean c2MoreSpecific = false;
            for (int i = 0; i < c1.length; ++i) {
                if (c1[i] == c2[i]) continue;
                c1MoreSpecific = c1MoreSpecific || MethodMap.isMoreSpecific(c1[i], c2[i]);
                c2MoreSpecific = c2MoreSpecific || MethodMap.isMoreSpecific(c2[i], c1[i]);
            }
            if (c1MoreSpecific) {
                if (c2MoreSpecific) {
                    return 2;
                }
                return 0;
            }
            if (c2MoreSpecific) {
                return 1;
            }
            return 2;
        }

        LinkedList getApplicables(List methods) {
            LinkedList list = new LinkedList();
            Iterator imethod = methods.iterator();
            while (imethod.hasNext()) {
                Object method = imethod.next();
                if (!this.isApplicable(method)) continue;
                list.add(method);
            }
            return list;
        }

        private boolean isApplicable(Object method) {
            Class[] methodArgs = ClassString.getParameterTypes(method);
            if (methodArgs.length != this.classes.length) {
                return false;
            }
            for (int i = 0; i < this.classes.length; ++i) {
                if (ClassString.isMethodInvocationConvertible(methodArgs[i], this.classes[i])) continue;
                return false;
            }
            return true;
        }

        private static boolean isMethodInvocationConvertible(Class formal, Class actual) {
            if (formal.isAssignableFrom(actual)) {
                return true;
            }
            if (formal.isPrimitive()) {
                if (formal == Boolean.TYPE && actual == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = MethodMap.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
                    return true;
                }
                if (formal == Character.TYPE && actual == (class$java$lang$Character == null ? (class$java$lang$Character = MethodMap.class$("java.lang.Character")) : class$java$lang$Character)) {
                    return true;
                }
                if (formal == Byte.TYPE && actual == (class$java$lang$Byte == null ? (class$java$lang$Byte = MethodMap.class$("java.lang.Byte")) : class$java$lang$Byte)) {
                    return true;
                }
                if (formal == Short.TYPE && (actual == (class$java$lang$Short == null ? (class$java$lang$Short = MethodMap.class$("java.lang.Short")) : class$java$lang$Short) || actual == (class$java$lang$Byte == null ? (class$java$lang$Byte = MethodMap.class$("java.lang.Byte")) : class$java$lang$Byte))) {
                    return true;
                }
                if (formal == Integer.TYPE && (actual == (class$java$lang$Integer == null ? (class$java$lang$Integer = MethodMap.class$("java.lang.Integer")) : class$java$lang$Integer) || actual == (class$java$lang$Short == null ? (class$java$lang$Short = MethodMap.class$("java.lang.Short")) : class$java$lang$Short) || actual == (class$java$lang$Byte == null ? (class$java$lang$Byte = MethodMap.class$("java.lang.Byte")) : class$java$lang$Byte))) {
                    return true;
                }
                if (formal == Long.TYPE && (actual == (class$java$lang$Long == null ? (class$java$lang$Long = MethodMap.class$("java.lang.Long")) : class$java$lang$Long) || actual == (class$java$lang$Integer == null ? (class$java$lang$Integer = MethodMap.class$("java.lang.Integer")) : class$java$lang$Integer) || actual == (class$java$lang$Short == null ? (class$java$lang$Short = MethodMap.class$("java.lang.Short")) : class$java$lang$Short) || actual == (class$java$lang$Byte == null ? (class$java$lang$Byte = MethodMap.class$("java.lang.Byte")) : class$java$lang$Byte))) {
                    return true;
                }
                if (formal == Float.TYPE && (actual == (class$java$lang$Float == null ? (class$java$lang$Float = MethodMap.class$("java.lang.Float")) : class$java$lang$Float) || actual == (class$java$lang$Long == null ? (class$java$lang$Long = MethodMap.class$("java.lang.Long")) : class$java$lang$Long) || actual == (class$java$lang$Integer == null ? (class$java$lang$Integer = MethodMap.class$("java.lang.Integer")) : class$java$lang$Integer) || actual == (class$java$lang$Short == null ? (class$java$lang$Short = MethodMap.class$("java.lang.Short")) : class$java$lang$Short) || actual == (class$java$lang$Byte == null ? (class$java$lang$Byte = MethodMap.class$("java.lang.Byte")) : class$java$lang$Byte))) {
                    return true;
                }
                if (formal == Double.TYPE && (actual == (class$java$lang$Double == null ? (class$java$lang$Double = MethodMap.class$("java.lang.Double")) : class$java$lang$Double) || actual == (class$java$lang$Float == null ? (class$java$lang$Float = MethodMap.class$("java.lang.Float")) : class$java$lang$Float) || actual == (class$java$lang$Long == null ? (class$java$lang$Long = MethodMap.class$("java.lang.Long")) : class$java$lang$Long) || actual == (class$java$lang$Integer == null ? (class$java$lang$Integer = MethodMap.class$("java.lang.Integer")) : class$java$lang$Integer) || actual == (class$java$lang$Short == null ? (class$java$lang$Short = MethodMap.class$("java.lang.Short")) : class$java$lang$Short) || actual == (class$java$lang$Byte == null ? (class$java$lang$Byte = MethodMap.class$("java.lang.Byte")) : class$java$lang$Byte))) {
                    return true;
                }
            }
            return MethodMap.isBigDecimalConvertible(formal, actual);
        }

        private String listArgumentTypes() {
            StringBuffer buf = new StringBuffer(this.classes.length * 32).append('(');
            for (int i = 0; i < this.classes.length; ++i) {
                buf.append(this.classes[i].getName()).append(',');
            }
            buf.setLength(buf.length() - 1);
            return buf.append(')').toString();
        }
    }
}

