/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.editor.java.Utilities;
import org.netbeans.modules.java.editor.semantic.RemoveUnusedImportFix;
import org.netbeans.modules.java.hints.spi.AbstractHint;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class Imports
extends AbstractHint
implements PreferenceChangeListener {
    private static final String DEFAULT_PACKAGE = "java.lang";
    private static final List<Fix> NO_FIXES = Collections.emptyList();
    private static Imports delegate;
    private Imports duplicate;
    private Imports defaultPackage;
    private Imports samePackage;
    private Imports excludedPackage;
    private Imports unused;
    private Imports star;
    private String IMPORTS_ID = "Imports_";
    private Set<Tree.Kind> treeKinds;
    private ImportHintKind kind;

    private Imports(ImportHintKind kind) {
        super(kind.defaultOn(), true, AbstractHint.HintSeverity.WARNING, new String[0]);
        this.kind = kind;
        this.treeKinds = EnumSet.of(Tree.Kind.IMPORT);
    }

    public static Imports createDelegate() {
        return Imports.getDelegate();
    }

    public static Imports createDuplicate() {
        Imports d = Imports.getDelegate();
        d.duplicate = new Imports(ImportHintKind.DUPLICATE);
        return Imports.getDelegate();
    }

    public static Imports createDefaultPackage() {
        Imports d = Imports.getDelegate();
        d.defaultPackage = new Imports(ImportHintKind.DEFAULT_PACKAGE);
        return d.defaultPackage;
    }

    public static Imports createExcluded() {
        Imports d = Imports.getDelegate();
        d.excludedPackage = new Imports(ImportHintKind.EXCLUDED);
        return d.excludedPackage;
    }

    public static Imports createSamePackage() {
        Imports d = Imports.getDelegate();
        d.samePackage = new Imports(ImportHintKind.SAME_PACKAGE);
        return d.samePackage;
    }

    public static Imports createUnused() {
        Imports d = Imports.getDelegate();
        d.unused = new Imports(ImportHintKind.UNUSED);
        d.unused.getPreferences(null);
        return d.unused;
    }

    public static Imports createStar() {
        Imports d = Imports.getDelegate();
        d.star = new Imports(ImportHintKind.STAR);
        return d.star;
    }

    @Override
    public Set<Tree.Kind> getTreeKinds() {
        return this.treeKinds;
    }

    @Override
    public List<ErrorDescription> run(CompilationInfo ci, TreePath treePath) {
        ArrayList<ErrorDescription> result = new ArrayList<ErrorDescription>();
        Tree t = treePath.getLeaf();
        if (t.getKind() != Tree.Kind.IMPORT) {
            return null;
        }
        ImportTree it = (ImportTree)t;
        if (it.isStatic() || !(it.getQualifiedIdentifier() instanceof MemberSelectTree)) {
            return null;
        }
        MemberSelectTree ms = (MemberSelectTree)it.getQualifiedIdentifier();
        Fix allFix = null;
        switch (this.kind) {
            case STAR: {
                Imports starImport = Imports.getDelegate().star;
                if (starImport == null || !starImport.isEnabled() || !"*".equals(ms.getIdentifier().toString())) break;
                result.add(ErrorDescriptionFactory.createErrorDescription((Severity)starImport.getSeverity().toEditorSeverity(), (String)starImport.getDisplayName(), NO_FIXES, (FileObject)ci.getFileObject(), (int)((int)ci.getTrees().getSourcePositions().getStartPosition(ci.getCompilationUnit(), it)), (int)((int)ci.getTrees().getSourcePositions().getEndPosition(ci.getCompilationUnit(), it))));
                break;
            }
            case DEFAULT_PACKAGE: {
                Imports defPackage;
                allFix = null;
                List<ImportTree> defaultList = this.getAllImportsOfKind(ci, ImportHintKind.DEFAULT_PACKAGE);
                if (defaultList.size() > 1) {
                    allFix = this.createFix(ci, defaultList, ImportHintKind.DEFAULT_PACKAGE);
                }
                if ((defPackage = Imports.getDelegate().defaultPackage) == null || !defPackage.isEnabled() || !ms.getExpression().toString().equals(DEFAULT_PACKAGE)) break;
                ArrayList<Fix> fixes = new ArrayList<Fix>();
                fixes.add(this.createFix(ci, it, ImportHintKind.DEFAULT_PACKAGE));
                if (allFix != null) {
                    fixes.add(allFix);
                }
                result.add(ErrorDescriptionFactory.createErrorDescription((Severity)defPackage.getSeverity().toEditorSeverity(), (String)defPackage.getDisplayName(), fixes, (FileObject)ci.getFileObject(), (int)((int)ci.getTrees().getSourcePositions().getStartPosition(ci.getCompilationUnit(), it)), (int)((int)ci.getTrees().getSourcePositions().getEndPosition(ci.getCompilationUnit(), it))));
                break;
            }
            case SAME_PACKAGE: {
                Imports samePack;
                ExpressionTree packageName = ci.getCompilationUnit().getPackageName();
                allFix = null;
                List<ImportTree> sameList = this.getAllImportsOfKind(ci, ImportHintKind.SAME_PACKAGE);
                if (sameList.size() > 1) {
                    allFix = this.createFix(ci, sameList, ImportHintKind.SAME_PACKAGE);
                }
                if ((samePack = Imports.getDelegate().samePackage) == null || !samePack.isEnabled() || packageName == null || !ms.getExpression().toString().equals(packageName.toString())) break;
                ArrayList<Fix> fixes = new ArrayList<Fix>();
                fixes.add(this.createFix(ci, it, ImportHintKind.SAME_PACKAGE));
                if (allFix != null) {
                    fixes.add(allFix);
                }
                result.add(ErrorDescriptionFactory.createErrorDescription((Severity)samePack.getSeverity().toEditorSeverity(), (String)samePack.getDisplayName(), fixes, (FileObject)ci.getFileObject(), (int)((int)ci.getTrees().getSourcePositions().getStartPosition(ci.getCompilationUnit(), it)), (int)((int)ci.getTrees().getSourcePositions().getEndPosition(ci.getCompilationUnit(), it))));
                break;
            }
            case EXCLUDED: {
                Imports excludePackage = Imports.getDelegate().excludedPackage;
                String pkg = ms.getExpression().toString();
                String klass = ms.getIdentifier().toString();
                String exp = pkg + "." + (!klass.equals("*") ? klass : "");
                if (excludePackage == null || !excludePackage.isEnabled() || !Utilities.isExcluded((CharSequence)exp)) break;
                result.add(ErrorDescriptionFactory.createErrorDescription((Severity)excludePackage.getSeverity().toEditorSeverity(), (String)excludePackage.getDisplayName(), NO_FIXES, (FileObject)ci.getFileObject(), (int)((int)ci.getTrees().getSourcePositions().getStartPosition(ci.getCompilationUnit(), it)), (int)((int)ci.getTrees().getSourcePositions().getEndPosition(ci.getCompilationUnit(), it))));
                break;
            }
            default: {
                return null;
            }
        }
        return result;
    }

    private List<ImportTree> getAllImportsOfKind(CompilationInfo ci, ImportHintKind kind) {
        assert (kind == ImportHintKind.DEFAULT_PACKAGE || kind == ImportHintKind.SAME_PACKAGE);
        CompilationUnitTree cut = ci.getCompilationUnit();
        ArrayList<ImportTree> result = new ArrayList<ImportTree>(3);
        List<? extends ImportTree> imports = cut.getImports();
        for (ImportTree importTree : imports) {
            if (importTree.isStatic() || !(importTree.getQualifiedIdentifier() instanceof MemberSelectTree)) continue;
            MemberSelectTree ms = (MemberSelectTree)importTree.getQualifiedIdentifier();
            if (kind == ImportHintKind.DEFAULT_PACKAGE && Imports.getDelegate().defaultPackage != null && Imports.getDelegate().defaultPackage.isEnabled() && ms.getExpression().toString().equals(DEFAULT_PACKAGE)) {
                result.add(importTree);
            }
            if (kind != ImportHintKind.SAME_PACKAGE) continue;
            ExpressionTree packageName = cut.getPackageName();
            if (Imports.getDelegate().samePackage == null || !Imports.getDelegate().samePackage.isEnabled() || packageName == null || !ms.getExpression().toString().equals(packageName.toString())) continue;
            result.add(importTree);
        }
        return result;
    }

    @Override
    public void cancel() {
    }

    @Override
    public String getId() {
        return this.IMPORTS_ID + this.kind.toString();
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(Imports.class, (String)("LBL_Imports_" + this.kind.toString()));
    }

    @Override
    public String getDescription() {
        return NbBundle.getMessage(Imports.class, (String)("DSC_Imports_" + this.kind.toString()));
    }

    @Override
    public Preferences getPreferences(String profile) {
        Preferences p = super.getPreferences(profile);
        if (this.kind == ImportHintKind.UNUSED) {
            try {
                p.removePreferenceChangeListener(this);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            p.addPreferenceChangeListener(this);
        }
        return p;
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent evt) {
        if (this.kind == ImportHintKind.UNUSED) {
            RemoveUnusedImportFix.setEnabled((boolean)this.isEnabled());
            RemoveUnusedImportFix.setSeverity((Severity)Imports.getDelegate().unused.getSeverity().toEditorSeverity());
        }
    }

    private static synchronized Imports getDelegate() {
        if (delegate == null) {
            delegate = new Imports(ImportHintKind.DELEGATE);
        }
        return delegate;
    }

    private Fix createFix(CompilationInfo ci, ImportTree tree, ImportHintKind ihk) {
        return this.createFix(ci, Collections.singletonList(tree), ihk);
    }

    private Fix createFix(CompilationInfo ci, List<ImportTree> trees, ImportHintKind ihk) {
        ArrayList<TreePathHandle> paths = new ArrayList<TreePathHandle>();
        Trees t = ci.getTrees();
        CompilationUnitTree cut = ci.getCompilationUnit();
        for (ImportTree tree : trees) {
            paths.add(TreePathHandle.create((TreePath)t.getPath(cut, tree), (CompilationInfo)ci));
        }
        return new ImportsFix(ci.getFileObject(), paths, ihk);
    }

    private static class ImportsFix
    implements Fix,
    Task<WorkingCopy> {
        FileObject file;
        List<TreePathHandle> tphList;
        ImportHintKind ihk;

        public ImportsFix(FileObject file, List<TreePathHandle> tphList, ImportHintKind ihk) {
            this.file = file;
            this.tphList = tphList;
            this.ihk = ihk;
        }

        public String getText() {
            if (this.tphList.size() == 1) {
                return NbBundle.getMessage(Imports.class, (String)("LBL_Imports_Fix_One_" + this.ihk.toString()));
            }
            return NbBundle.getMessage(Imports.class, (String)("LBL_Imports_Fix_All_" + this.ihk.toString()));
        }

        public ChangeInfo implement() throws IOException {
            JavaSource js = JavaSource.forFileObject((FileObject)this.file);
            js.runModificationTask((Task)this).commit();
            return null;
        }

        public void run(WorkingCopy copy) throws Exception {
            copy.toPhase(JavaSource.Phase.PARSED);
            CompilationUnitTree cut = copy.getCompilationUnit();
            TreeMaker make = copy.getTreeMaker();
            CompilationUnitTree newCut = cut;
            for (TreePathHandle tph : this.tphList) {
                TreePath path = tph.resolve((CompilationInfo)copy);
                if (path == null || !(path.getLeaf() instanceof ImportTree)) continue;
                newCut = make.removeCompUnitImport(newCut, (ImportTree)path.getLeaf());
            }
            copy.rewrite((Tree)cut, (Tree)newCut);
        }
    }

    private static enum ImportHintKind {
        DELEGATE,
        UNUSED,
        DUPLICATE,
        SAME_PACKAGE,
        DEFAULT_PACKAGE,
        EXCLUDED,
        STAR;


        boolean defaultOn() {
            switch (this) {
                case DEFAULT_PACKAGE: 
                case SAME_PACKAGE: 
                case EXCLUDED: 
                case DELEGATE: 
                case UNUSED: {
                    return true;
                }
            }
            return false;
        }
    }
}

