/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.errors;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TypeMirrorHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.infrastructure.ErrorHintsProvider;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public final class CreateMethodFix
implements Fix {
    private FileObject targetFile;
    private ElementHandle<TypeElement> target;
    private TypeMirrorHandle returnType;
    private List<TypeMirrorHandle> argumentTypes;
    private List<String> argumentNames;
    private ClasspathInfo cpInfo;
    private Set<Modifier> modifiers;
    private String name;
    private String inFQN;
    private String methodDisplayName;

    public CreateMethodFix(CompilationInfo info, String name, Set<Modifier> modifiers, TypeElement target, TypeMirror returnType, List<? extends TypeMirror> argumentTypes, List<String> argumentNames, FileObject targetFile) {
        this.name = name;
        this.inFQN = Utilities.target2String(target);
        this.cpInfo = info.getClasspathInfo();
        this.modifiers = modifiers;
        this.targetFile = targetFile;
        this.target = ElementHandle.create((Element)target);
        if (returnType != null && returnType.getKind() == TypeKind.NULL) {
            returnType = info.getElements().getTypeElement("java.lang.Object").asType();
        }
        this.returnType = returnType != null ? TypeMirrorHandle.create((TypeMirror)returnType) : null;
        this.argumentTypes = new ArrayList<TypeMirrorHandle>();
        for (TypeMirror typeMirror : argumentTypes) {
            this.argumentTypes.add(TypeMirrorHandle.create((TypeMirror)typeMirror));
        }
        this.argumentNames = argumentNames;
        StringBuilder methodDisplayName = new StringBuilder();
        if (returnType != null) {
            methodDisplayName.append(name);
        } else {
            methodDisplayName.append(target.getSimpleName().toString());
        }
        methodDisplayName.append('(');
        boolean bl = true;
        for (TypeMirror typeMirror : argumentTypes) {
            boolean bl2;
            if (!bl2) {
                methodDisplayName.append(',');
            }
            bl2 = false;
            methodDisplayName.append(org.netbeans.modules.editor.java.Utilities.getTypeName((CompilationInfo)info, (TypeMirror)typeMirror, (boolean)true));
        }
        methodDisplayName.append(')');
        this.methodDisplayName = methodDisplayName.toString();
    }

    public String getText() {
        if (this.target.getKind() == ElementKind.ANNOTATION_TYPE) {
            return NbBundle.getMessage(CreateMethodFix.class, (String)"LBL_FIX_Create_Annotation_Element", (Object)this.methodDisplayName, (Object)this.inFQN);
        }
        if (this.returnType != null) {
            return NbBundle.getMessage(CreateMethodFix.class, (String)"LBL_FIX_Create_Method", (Object)this.methodDisplayName, (Object)this.inFQN);
        }
        return NbBundle.getMessage(CreateMethodFix.class, (String)"LBL_FIX_Create_Constructor", (Object)this.methodDisplayName, (Object)this.inFQN);
    }

    public ChangeInfo implement() throws IOException {
        JavaSource js = JavaSource.create((ClasspathInfo)this.cpInfo, (FileObject[])new FileObject[]{this.targetFile});
        String methodBodyTag = "mbody";
        ModificationResult diff = js.runModificationTask((Task)new Task<WorkingCopy>(){

            public void run(WorkingCopy working) throws IOException {
                BlockTree body;
                TypeMirror returnType;
                working.toPhase(JavaSource.Phase.RESOLVED);
                TypeElement targetType = (TypeElement)CreateMethodFix.this.target.resolve((CompilationInfo)working);
                if (targetType == null) {
                    ErrorHintsProvider.LOG.log(Level.INFO, "Cannot resolve target.");
                    return;
                }
                TreePath targetTree = working.getTrees().getPath(targetType);
                if (targetTree == null) {
                    ErrorHintsProvider.LOG.log(Level.INFO, "Cannot resolve target tree: " + targetType.getQualifiedName() + ".");
                    return;
                }
                TypeMirrorHandle returnTypeHandle = CreateMethodFix.this.returnType;
                TypeMirror typeMirror = returnType = returnTypeHandle != null ? returnTypeHandle.resolve((CompilationInfo)working) : null;
                if (returnTypeHandle != null && returnType == null) {
                    ErrorHintsProvider.LOG.log(Level.INFO, "Cannot resolve proposed type.");
                    return;
                }
                TreeMaker make = working.getTreeMaker();
                ArrayList<VariableTree> argTypes = new ArrayList<VariableTree>();
                Iterator typeIt = CreateMethodFix.this.argumentTypes.iterator();
                Iterator nameIt = CreateMethodFix.this.argumentNames.iterator();
                while (typeIt.hasNext() && nameIt.hasNext()) {
                    String argName;
                    TypeMirrorHandle tmh = (TypeMirrorHandle)typeIt.next();
                    TypeMirror tm = tmh.resolve((CompilationInfo)working);
                    if (tm == null) {
                        ErrorHintsProvider.LOG.log(Level.INFO, "Cannot resolve argument type.");
                        return;
                    }
                    Element elem = working.getTypes().asElement(tm);
                    if (elem != null && elem.getKind() == ElementKind.ENUM) {
                        StringBuffer buf = new StringBuffer(elem.getSimpleName().toString());
                        buf.setCharAt(0, Character.toLowerCase(buf.charAt(0)));
                        argName = buf.toString();
                    } else {
                        argName = (String)nameIt.next();
                    }
                    argTypes.add(make.Variable(make.Modifiers(EnumSet.noneOf(Modifier.class)), (CharSequence)argName, make.Type(tm), null));
                }
                BlockTree blockTree = body = targetType.getKind().isClass() ? CreateMethodFix.createDefaultMethodBody(working, returnType) : null;
                if (body != null && !body.getStatements().isEmpty()) {
                    working.tag((Tree)body.getStatements().get(0), (Object)"mbody");
                }
                MethodTree mt = make.Method(make.Modifiers(CreateMethodFix.this.modifiers), (CharSequence)CreateMethodFix.this.name, returnType != null ? make.Type(returnType) : null, Collections.emptyList(), argTypes, Collections.emptyList(), body, null);
                ClassTree decl = GeneratorUtilities.get((WorkingCopy)working).insertClassMember((ClassTree)targetTree.getLeaf(), (Tree)mt);
                working.rewrite(targetTree.getLeaf(), (Tree)decl);
            }
        });
        return Utilities.commitAndComputeChangeInfo(this.targetFile, diff, "mbody");
    }

    private void addArguments(CompilationInfo info, StringBuilder value) {
        value.append("(");
        Iterator<TypeMirrorHandle> typeIt = this.argumentTypes.iterator();
        Iterator<String> nameIt = this.argumentNames.iterator();
        boolean first = true;
        while (typeIt.hasNext() && nameIt.hasNext()) {
            if (!first) {
                value.append(",");
            }
            first = false;
            TypeMirrorHandle tmh = typeIt.next();
            String argName = nameIt.next();
            value.append(org.netbeans.modules.editor.java.Utilities.getTypeName((CompilationInfo)info, (TypeMirror)tmh.resolve(info), (boolean)true));
            value.append(' ');
            value.append(argName);
        }
        value.append(")");
    }

    public String toDebugString(CompilationInfo info) {
        StringBuilder value = new StringBuilder();
        if (this.returnType != null) {
            value.append("CreateMethodFix:");
            value.append(this.name);
            this.addArguments(info, value);
            value.append(org.netbeans.modules.editor.java.Utilities.getTypeName((CompilationInfo)info, (TypeMirror)this.returnType.resolve(info), (boolean)true));
        } else {
            value.append("CreateConstructorFix:");
            this.addArguments(info, value);
        }
        value.append(':');
        value.append(this.inFQN);
        return value.toString();
    }

    private static BlockTree createDefaultMethodBody(WorkingCopy wc, TypeMirror returnType) {
        TreeMaker make = wc.getTreeMaker();
        ArrayList<ThrowTree> blockStatements = new ArrayList<ThrowTree>();
        TypeElement uoe = wc.getElements().getTypeElement("java.lang.UnsupportedOperationException");
        if (uoe != null) {
            NewClassTree nue = make.NewClass(null, Collections.emptyList(), make.QualIdent((Element)uoe), Collections.singletonList(make.Literal((Object)"Not yet implemented")), null);
            blockStatements.add(make.Throw((ExpressionTree)nue));
        }
        return make.Block(blockStatements, false);
    }
}

