/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.catalog;

import java.sql.Timestamp;
import org.apache.derby.catalog.ReferencedColumns;
import org.apache.derby.catalog.UUID;
import org.apache.derby.catalog.types.ReferencedColumnsDescriptorImpl;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.sql.dictionary.CatalogRowFactory;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SystemColumn;
import org.apache.derby.iapi.sql.dictionary.TriggerDescriptor;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecutionFactory;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.impl.sql.catalog.SystemColumnImpl;

public class SYSTRIGGERSRowFactory
extends CatalogRowFactory {
    static final String TABLENAME_STRING = "SYSTRIGGERS";
    public static final int SYSTRIGGERS_TRIGGERID = 1;
    public static final int SYSTRIGGERS_TRIGGERNAME = 2;
    public static final int SYSTRIGGERS_SCHEMAID = 3;
    public static final int SYSTRIGGERS_CREATIONTIMESTAMP = 4;
    public static final int SYSTRIGGERS_EVENT = 5;
    public static final int SYSTRIGGERS_FIRINGTIME = 6;
    public static final int SYSTRIGGERS_TYPE = 7;
    public static final int SYSTRIGGERS_STATE = 8;
    public static final int SYSTRIGGERS_TABLEID = 9;
    public static final int SYSTRIGGERS_WHENSTMTID = 10;
    public static final int SYSTRIGGERS_ACTIONSTMTID = 11;
    public static final int SYSTRIGGERS_REFERENCEDCOLUMNS = 12;
    public static final int SYSTRIGGERS_TRIGGERDEFINITION = 13;
    public static final int SYSTRIGGERS_REFERENCINGOLD = 14;
    public static final int SYSTRIGGERS_REFERENCINGNEW = 15;
    public static final int SYSTRIGGERS_OLDREFERENCINGNAME = 16;
    public static final int SYSTRIGGERS_NEWREFERENCINGNAME = 17;
    public static final int SYSTRIGGERS_COLUMN_COUNT = 17;
    public static final int SYSTRIGGERS_INDEX1_ID = 0;
    public static final int SYSTRIGGERS_INDEX2_ID = 1;
    public static final int SYSTRIGGERS_INDEX3_ID = 2;
    private static final int[][] indexColumnPositions = new int[][]{{1}, {2, 3}, {9, 4}};
    private static final boolean[] uniqueness = new boolean[]{true, true, false};
    private static final String[] uuids = new String[]{"c013800d-00d7-c025-4809-000a0a411200", "c013800d-00d7-c025-480a-000a0a411200", "c013800d-00d7-c025-480b-000a0a411200", "c013800d-00d7-c025-480c-000a0a411200", "c013800d-00d7-c025-480d-000a0a411200"};

    public SYSTRIGGERSRowFactory(UUIDFactory uUIDFactory, ExecutionFactory executionFactory, DataValueFactory dataValueFactory, boolean bl) {
        super(uUIDFactory, executionFactory, dataValueFactory, bl);
        this.initInfo(17, TABLENAME_STRING, indexColumnPositions, uniqueness, uuids);
    }

    public ExecRow makeRow(TupleDescriptor tupleDescriptor, TupleDescriptor tupleDescriptor2) throws StandardException {
        String string = null;
        UUID uUID = null;
        UUID uUID2 = null;
        UUID uUID3 = null;
        UUID uUID4 = null;
        UUID uUID5 = null;
        Timestamp timestamp = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        ReferencedColumnsDescriptorImpl referencedColumnsDescriptorImpl = null;
        boolean bl = false;
        boolean bl2 = false;
        if (tupleDescriptor != null) {
            TriggerDescriptor triggerDescriptor = (TriggerDescriptor)tupleDescriptor;
            string = triggerDescriptor.getName();
            uUID = triggerDescriptor.getUUID();
            uUID2 = triggerDescriptor.getSchemaDescriptor().getUUID();
            timestamp = triggerDescriptor.getCreationTimestamp();
            string2 = triggerDescriptor.listensForEvent(1) ? "U" : (triggerDescriptor.listensForEvent(2) ? "D" : "I");
            string3 = triggerDescriptor.isBeforeTrigger() ? "B" : "A";
            string4 = triggerDescriptor.isRowTrigger() ? "R" : "S";
            string5 = triggerDescriptor.isEnabled() ? "E" : "D";
            uUID3 = triggerDescriptor.getTableDescriptor().getUUID();
            int[] nArray = triggerDescriptor.getReferencedCols();
            referencedColumnsDescriptorImpl = nArray != null ? new ReferencedColumnsDescriptorImpl(nArray) : null;
            uUID4 = triggerDescriptor.getActionId();
            uUID5 = triggerDescriptor.getWhenClauseId();
            string6 = triggerDescriptor.getTriggerDefinition();
            bl = triggerDescriptor.getReferencingOld();
            bl2 = triggerDescriptor.getReferencingNew();
            string7 = triggerDescriptor.getOldReferencingName();
            string8 = triggerDescriptor.getNewReferencingName();
        }
        ExecRow execRow = this.getExecutionFactory().getValueRow(17);
        execRow.setColumn(1, this.dvf.getCharDataValue(uUID == null ? null : uUID.toString()));
        execRow.setColumn(2, this.dvf.getVarcharDataValue(string));
        execRow.setColumn(3, this.dvf.getCharDataValue(uUID2 == null ? null : uUID2.toString()));
        execRow.setColumn(4, this.dvf.getDataValue(timestamp));
        execRow.setColumn(5, this.dvf.getCharDataValue(string2));
        execRow.setColumn(6, this.dvf.getCharDataValue(string3));
        execRow.setColumn(7, this.dvf.getCharDataValue(string4));
        execRow.setColumn(8, this.dvf.getCharDataValue(string5));
        execRow.setColumn(9, this.dvf.getCharDataValue(uUID3 == null ? null : uUID3.toString()));
        execRow.setColumn(10, this.dvf.getCharDataValue(uUID5 == null ? null : uUID5.toString()));
        execRow.setColumn(11, this.dvf.getCharDataValue(uUID4 == null ? null : uUID4.toString()));
        execRow.setColumn(12, this.dvf.getDataValue(referencedColumnsDescriptorImpl));
        execRow.setColumn(13, this.dvf.getLongvarcharDataValue(string6));
        execRow.setColumn(14, this.dvf.getDataValue(bl));
        execRow.setColumn(15, this.dvf.getDataValue(bl2));
        execRow.setColumn(16, this.dvf.getVarcharDataValue(string7));
        execRow.setColumn(17, this.dvf.getVarcharDataValue(string8));
        return execRow;
    }

    public TupleDescriptor buildDescriptor(ExecRow execRow, TupleDescriptor tupleDescriptor, DataDictionary dataDictionary) throws StandardException {
        UUID uUID = null;
        UUID uUID2 = null;
        int n = 0;
        DataDescriptorGenerator dataDescriptorGenerator = dataDictionary.getDataDescriptorGenerator();
        DataValueDescriptor dataValueDescriptor = execRow.getColumn(1);
        String string = dataValueDescriptor.getString();
        UUID uUID3 = this.getUUIDFactory().recreateUUID(string);
        dataValueDescriptor = execRow.getColumn(2);
        String string2 = dataValueDescriptor.getString();
        dataValueDescriptor = execRow.getColumn(3);
        string = dataValueDescriptor.getString();
        UUID uUID4 = this.getUUIDFactory().recreateUUID(string);
        dataValueDescriptor = execRow.getColumn(4);
        Timestamp timestamp = (Timestamp)dataValueDescriptor.getObject();
        dataValueDescriptor = execRow.getColumn(5);
        char c = dataValueDescriptor.getString().charAt(0);
        switch (c) {
            case 'U': {
                n = 1;
                break;
            }
            case 'I': {
                n = 4;
                break;
            }
            case 'D': {
                n = 2;
                break;
            }
        }
        boolean bl = this.getCharBoolean(execRow.getColumn(6), 'B', 'A');
        boolean bl2 = this.getCharBoolean(execRow.getColumn(7), 'R', 'S');
        boolean bl3 = this.getCharBoolean(execRow.getColumn(8), 'E', 'D');
        dataValueDescriptor = execRow.getColumn(9);
        string = dataValueDescriptor.getString();
        UUID uUID5 = this.getUUIDFactory().recreateUUID(string);
        dataValueDescriptor = execRow.getColumn(10);
        string = dataValueDescriptor.getString();
        if (string != null) {
            uUID2 = this.getUUIDFactory().recreateUUID(string);
        }
        if ((string = (dataValueDescriptor = execRow.getColumn(11)).getString()) != null) {
            uUID = this.getUUIDFactory().recreateUUID(string);
        }
        dataValueDescriptor = execRow.getColumn(12);
        ReferencedColumns referencedColumns = (ReferencedColumns)dataValueDescriptor.getObject();
        dataValueDescriptor = execRow.getColumn(13);
        String string3 = dataValueDescriptor.getString();
        dataValueDescriptor = execRow.getColumn(14);
        boolean bl4 = dataValueDescriptor.getBoolean();
        dataValueDescriptor = execRow.getColumn(15);
        boolean bl5 = dataValueDescriptor.getBoolean();
        dataValueDescriptor = execRow.getColumn(16);
        String string4 = dataValueDescriptor.getString();
        dataValueDescriptor = execRow.getColumn(17);
        String string5 = dataValueDescriptor.getString();
        TriggerDescriptor triggerDescriptor = new TriggerDescriptor(dataDictionary, dataDictionary.getSchemaDescriptor(uUID4, null), uUID3, string2, n, bl, bl2, bl3, dataDictionary.getTableDescriptor(uUID5), uUID2, uUID, timestamp, referencedColumns == null ? (int[])null : referencedColumns.getReferencedColumnPositions(), string3, bl4, bl5, string4, string5);
        return triggerDescriptor;
    }

    public SystemColumn[] buildColumnList() {
        SystemColumn[] systemColumnArray = new SystemColumn[]{new SystemColumnImpl(this.convertIdCase("TRIGGERID"), 1, 0, 0, false, "CHAR", true, 36), new SystemColumnImpl(this.convertIdCase("TRIGGERNAME"), 2, false), new SystemColumnImpl(this.convertIdCase("SCHEMAID"), 3, 0, 0, false, "CHAR", true, 36), new SystemColumnImpl(this.convertIdCase("CREATIONTIMESTAMP"), 4, 0, 0, false, "TIMESTAMP", true, 26), new SystemColumnImpl(this.convertIdCase("EVENT"), 5, 0, 0, false, "CHAR", true, 1), new SystemColumnImpl(this.convertIdCase("FIRINGTIME"), 6, 0, 0, false, "CHAR", true, 1), new SystemColumnImpl(this.convertIdCase("TYPE"), 7, 0, 0, false, "CHAR", true, 1), new SystemColumnImpl(this.convertIdCase("STATE"), 8, 0, 0, false, "CHAR", true, 1), new SystemColumnImpl(this.convertIdCase("TABLEID"), 9, 0, 0, false, "CHAR", true, 36), new SystemColumnImpl(this.convertIdCase("WHENSTMTID"), 10, 0, 0, true, "CHAR", true, 36), new SystemColumnImpl(this.convertIdCase("ACTIONSTMTID"), 11, 0, 0, true, "CHAR", true, 36), new SystemColumnImpl(this.convertIdCase("REFERENCEDCOLUMNS"), 12, 0, 0, true, "org.apache.derby.catalog.ReferencedColumns", false, -1), new SystemColumnImpl(this.convertIdCase("TRIGGERDEFINITION"), 13, 0, 0, true, "LONG VARCHAR", true, Integer.MAX_VALUE), new SystemColumnImpl(this.convertIdCase("REFERENCINGOLD"), 14, 0, 0, true, "BOOLEAN", true, 1), new SystemColumnImpl(this.convertIdCase("REFERENCINGNEW"), 15, 0, 0, true, "BOOLEAN", true, 1), new SystemColumnImpl(this.convertIdCase("OLDREFERENCINGNAME"), 16, true), new SystemColumnImpl(this.convertIdCase("NEWREFERENCINGNAME"), 17, true)};
        return systemColumnArray;
    }

    private boolean getCharBoolean(DataValueDescriptor dataValueDescriptor, char c, char c2) throws StandardException {
        char c3 = dataValueDescriptor.getString().charAt(0);
        if (c3 == c) {
            return true;
        }
        return c3 != c2;
    }
}

