/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmEnum;
import org.netbeans.modules.cnd.api.model.CsmEnumerator;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.deep.CsmExpression;
import org.netbeans.modules.cnd.modelimpl.csm.EnumImpl;
import org.netbeans.modules.cnd.modelimpl.csm.NameHolder;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableDeclarationBase;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.textcache.NameCache;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.openide.util.CharSequences;

public final class EnumeratorImpl
extends OffsetableDeclarationBase<CsmEnumerator>
implements CsmEnumerator {
    private final CharSequence name;
    private CsmEnum enumerationRef;
    private final CsmUID<CsmEnum> enumerationUID;

    private EnumeratorImpl(AST aST, NameHolder nameHolder, EnumImpl enumImpl) {
        super(aST, enumImpl.getContainingFile());
        this.name = NameCache.getManager().getString(nameHolder.getName());
        this.enumerationUID = UIDCsmConverter.declarationToUID(enumImpl);
        this.enumerationRef = null;
    }

    public static EnumeratorImpl create(AST aST, EnumImpl enumImpl, boolean bl) {
        NameHolder nameHolder = NameHolder.createSimpleName(aST);
        EnumeratorImpl enumeratorImpl = new EnumeratorImpl(aST, nameHolder, enumImpl);
        EnumeratorImpl.postObjectCreateRegistration(bl, enumeratorImpl);
        nameHolder.addReference(enumImpl.getContainingFile(), enumeratorImpl);
        return enumeratorImpl;
    }

    private EnumeratorImpl(EnumImpl enumImpl, String string, int n, int n2) {
        super(enumImpl.getContainingFile(), n, n2);
        this.name = NameCache.getManager().getString((CharSequence)string);
        this.enumerationUID = UIDCsmConverter.declarationToUID(enumImpl);
        this.enumerationRef = null;
    }

    public static EnumeratorImpl create(EnumImpl enumImpl, String string, int n, int n2, boolean bl) {
        EnumeratorImpl enumeratorImpl = new EnumeratorImpl(enumImpl, string, n, n2);
        EnumeratorImpl.postObjectCreateRegistration(bl, enumeratorImpl);
        return enumeratorImpl;
    }

    public CharSequence getName() {
        return this.name;
    }

    public CsmExpression getExplicitValue() {
        return null;
    }

    public CsmEnum getEnumeration() {
        return this._getEnumeration();
    }

    public CsmScope getScope() {
        return this.getEnumeration();
    }

    public CsmDeclaration.Kind getKind() {
        return CsmDeclaration.Kind.ENUMERATOR;
    }

    public CharSequence getQualifiedName() {
        return CharSequences.create((CharSequence)(this._getEnumeration().getQualifiedName() + "::" + this.getQualifiedNamePostfix()));
    }

    private synchronized CsmEnum _getEnumeration() {
        CsmEnum csmEnum = this.enumerationRef;
        if (csmEnum == null) {
            csmEnum = UIDCsmConverter.UIDtoDeclaration(this.enumerationUID);
            assert (csmEnum != null || this.enumerationUID == null) : "null object for UID " + this.enumerationUID;
        }
        return csmEnum;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.onDispose();
    }

    private synchronized void onDispose() {
        if (this.enumerationRef == null) {
            this.enumerationRef = UIDCsmConverter.UIDtoDeclaration(this.enumerationUID);
            assert (this.enumerationRef != null || this.enumerationUID == null) : "no object for UID " + this.enumerationUID;
        }
    }

    @Override
    public void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
        assert (this.name != null);
        PersistentUtils.writeUTF(this.name, dataOutput);
        assert (this.enumerationUID != null);
        UIDObjectFactory.getDefaultFactory().writeUID(this.enumerationUID, dataOutput);
    }

    public EnumeratorImpl(DataInput dataInput) throws IOException {
        super(dataInput);
        this.name = PersistentUtils.readUTF(dataInput, NameCache.getManager());
        assert (this.name != null);
        this.enumerationUID = UIDObjectFactory.getDefaultFactory().readUID(dataInput);
        assert (this.enumerationUID != null);
        this.enumerationRef = null;
    }
}

