/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.deep.CsmCompoundStatement;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelimpl.csm.AstRendererException;
import org.netbeans.modules.cnd.modelimpl.csm.FunctionImpl;
import org.netbeans.modules.cnd.modelimpl.csm.NameHolder;
import org.netbeans.modules.cnd.modelimpl.csm.ParameterListImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstRenderer;
import org.netbeans.modules.cnd.modelimpl.csm.core.Disposable;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;

public class FunctionDDImpl<T>
extends FunctionImpl<T>
implements CsmFunctionDefinition {
    private final CsmCompoundStatement body;

    protected FunctionDDImpl(AST aST, CsmFile csmFile, CsmScope csmScope, NameHolder nameHolder, boolean bl) throws AstRendererException {
        super(aST, csmFile, null, csmScope, nameHolder, bl);
        this.body = AstRenderer.findCompoundStatement(aST, this.getContainingFile(), this);
        if (this.body == null) {
            throw new AstRendererException((FileImpl)csmFile, this.getStartOffset(), "Null body in function definition.");
        }
    }

    public static <T> FunctionDDImpl<T> create(AST aST, CsmFile csmFile, CsmScope csmScope, boolean bl) throws AstRendererException {
        NameHolder nameHolder = NameHolder.createFunctionName(aST);
        FunctionDDImpl<T> functionDDImpl = new FunctionDDImpl<T>(aST, csmFile, csmScope, nameHolder, bl);
        FunctionDDImpl.postObjectCreateRegistration(bl, functionDDImpl);
        nameHolder.addReference(csmFile, functionDDImpl);
        return functionDDImpl;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.body instanceof Disposable) {
            ((Disposable)this.body).dispose();
        }
    }

    @Override
    public CsmCompoundStatement getBody() {
        return this.body;
    }

    @Override
    public CsmFunction getDeclaration() {
        CsmFunction csmFunction;
        if (this.isCStyleStatic()) {
            CharSequence charSequence = this.getName();
            CsmSelect.CsmFilter csmFilter = CsmSelect.getFilterBuilder().createNameFilter(charSequence, true, true, false);
            Iterator iterator = CsmSelect.getStaticFunctions((CsmFile)this.getContainingFile(), (CsmSelect.CsmFilter)csmFilter);
            while (iterator.hasNext()) {
                CsmFunction csmFunction2 = (CsmFunction)iterator.next();
                if (!charSequence.equals(csmFunction2.getName())) continue;
                return csmFunction2;
            }
            return this;
        }
        String string = Utils.getCsmDeclarationKindkey(CsmDeclaration.Kind.FUNCTION) + ':' + this.getUniqueNameWithoutPrefix();
        CsmProject csmProject = this.getContainingFile().getProject();
        CsmFunction csmFunction3 = this.findDeclaration(csmProject, string);
        if (csmFunction3 != null && csmFunction3.getKind() == CsmDeclaration.Kind.FUNCTION && (!this.isStatic() || CsmKindUtilities.isClassMember((CsmObject)this) || !CsmKindUtilities.isOffsetableDeclaration((Object)csmFunction3) || this.getContainingFile().equals(((CsmOffsetableDeclaration)csmFunction3).getContainingFile()))) {
            return csmFunction3;
        }
        for (CsmProject csmProject2 : csmProject.getLibraries()) {
            csmFunction = this.findDeclaration(csmProject2, string);
            if (csmFunction == null) continue;
            return csmFunction;
        }
        if (csmFunction3 == null) {
            string = Utils.getCsmDeclarationKindkey(CsmDeclaration.Kind.FUNCTION_FRIEND) + ':' + this.getUniqueNameWithoutPrefix();
            csmFunction3 = this.findDeclaration(csmProject, string);
            if (csmFunction3 != null && csmFunction3.getKind() == CsmDeclaration.Kind.FUNCTION_FRIEND && (!this.isStatic() || CsmKindUtilities.isClassMember((CsmObject)this) || !CsmKindUtilities.isOffsetableDeclaration((Object)csmFunction3) || this.getContainingFile().equals(((CsmOffsetableDeclaration)csmFunction3).getContainingFile()))) {
                return csmFunction3;
            }
            for (CsmProject csmProject2 : csmProject.getLibraries()) {
                csmFunction = this.findDeclaration(csmProject2, string);
                if (csmFunction == null) continue;
                return csmFunction;
            }
        }
        return this;
    }

    @Override
    public boolean isPureDefinition() {
        return false;
    }

    private CsmFunction findDeclaration(CsmProject csmProject, String string) {
        CsmFile csmFile;
        Object object2;
        ArrayList<CsmDeclaration> arrayList = new ArrayList<CsmDeclaration>(1);
        for (Object object2 : csmProject.findDeclarations((CharSequence)string)) {
            if (object2.getKind() != CsmDeclaration.Kind.FUNCTION && object2.getKind() != CsmDeclaration.Kind.FUNCTION_FRIEND || !FunctionImpl.isObjectVisibleInFile(this.getContainingFile(), (CsmOffsetableDeclaration)object2)) continue;
            arrayList.add((CsmDeclaration)object2);
        }
        CsmFunction csmFunction = this.chooseDeclaration(arrayList);
        if (csmFunction != null) {
            return csmFunction;
        }
        object2 = this.getParameterList();
        if (object2 != null && !((ParameterListImpl)object2).isEmpty() && !Utils.isCppFile(csmFile = this.getContainingFile()) && (csmFunction = csmProject.findDeclaration((CharSequence)(string = string.substring(0, string.indexOf(40)) + "()"))) instanceof FunctionImpl && !((FunctionImpl)csmFunction).isVoidParameterList()) {
            return csmFunction;
        }
        return null;
    }

    @Override
    public CsmDeclaration.Kind getKind() {
        return CsmDeclaration.Kind.FUNCTION_DEFINITION;
    }

    @Override
    public Collection<CsmScopeElement> getScopeElements() {
        Collection<CsmScopeElement> collection = super.getScopeElements();
        collection.add((CsmScopeElement)this.getBody());
        return collection;
    }

    @Override
    public void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
        assert (this.body != null) : "null body in " + this.getQualifiedName();
        PersistentUtils.writeCompoundStatement(this.body, dataOutput);
    }

    public FunctionDDImpl(DataInput dataInput) throws IOException {
        super(dataInput);
        this.body = PersistentUtils.readCompoundStatement(dataInput);
        assert (this.body != null) : "read null body for " + this.getName();
    }
}

