/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import org.netbeans.modules.cnd.antlr.Token;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceKind;
import org.netbeans.modules.cnd.apt.utils.APTUtils;
import org.netbeans.modules.cnd.modelimpl.csm.CastUtils;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstUtil;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableBase;
import org.netbeans.modules.cnd.modelimpl.parser.CsmAST;
import org.openide.util.CharSequences;

public class NameHolder {
    private final CharSequence name;
    private int start = 0;
    private int end = 0;
    private boolean isMacroExpanded = false;
    private static final int FUNCTION = 0;
    private static final int DESTRUCTOR = 1;
    private static final int DESTRUCTOR_DEFINITION = 2;
    private static final int CLASS = 3;
    private static final int ENUM = 4;

    private NameHolder(AST aST, int n) {
        switch (n) {
            case 1: {
                this.name = "~" + this.findFunctionName(aST);
                break;
            }
            case 2: {
                this.name = this.findDestructorDefinitionName(aST);
                break;
            }
            case 3: {
                this.name = this.findClassName(aST);
                break;
            }
            case 4: {
                this.name = this.findEnumName(aST);
                break;
            }
            default: {
                this.name = this.findFunctionName(aST);
            }
        }
    }

    private NameHolder(CharSequence charSequence) {
        this.name = charSequence;
    }

    public static NameHolder createName(CharSequence charSequence) {
        return new NameHolder(charSequence);
    }

    public static NameHolder createFunctionName(AST aST) {
        return new NameHolder(aST, 0);
    }

    public static NameHolder createDestructorName(AST aST) {
        return new NameHolder(aST, 1);
    }

    public static NameHolder createDestructorDefinitionName(AST aST) {
        return new NameHolder(aST, 2);
    }

    public static NameHolder createClassName(AST aST) {
        return new NameHolder(aST, 3);
    }

    public static NameHolder createEnumName(AST aST) {
        return new NameHolder(aST, 4);
    }

    public static NameHolder createSimpleName(AST aST) {
        NameHolder nameHolder = new NameHolder(AstUtil.getText(aST));
        nameHolder.start = OffsetableBase.getStartOffset(aST);
        nameHolder.isMacroExpanded = NameHolder.isMacroExpandedToken(aST);
        nameHolder.end = OffsetableBase.getEndOffset(aST);
        return nameHolder;
    }

    public CharSequence getName() {
        if (this.name == null || this.name.length() == 0) {
            return CharSequences.empty();
        }
        return this.name;
    }

    public int getStartOffset() {
        return this.start;
    }

    public int getEndOffset() {
        return this.end;
    }

    public String toString() {
        return "name=" + this.name + ", start=" + this.start + ", end=" + this.end + ", isMacroExpanded=" + this.isMacroExpanded;
    }

    public void addReference(CsmFile csmFile, final CsmObject csmObject) {
        if (csmFile instanceof FileImpl && this.start > 0 && !this.isMacroExpanded) {
            final FileImpl fileImpl = (FileImpl)csmFile;
            final CsmReferenceKind csmReferenceKind = CsmKindUtilities.isFunctionDefinition((CsmObject)csmObject) || CsmKindUtilities.isVariableDefinition((CsmObject)csmObject) ? CsmReferenceKind.DEFINITION : CsmReferenceKind.DECLARATION;
            CsmReference csmReference = new CsmReference(){

                public CsmReferenceKind getKind() {
                    return csmReferenceKind;
                }

                public CsmObject getReferencedObject() {
                    return csmObject;
                }

                public CsmObject getOwner() {
                    return csmObject;
                }

                public CsmFile getContainingFile() {
                    return fileImpl;
                }

                public int getStartOffset() {
                    return NameHolder.this.start;
                }

                public int getEndOffset() {
                    return NameHolder.this.end;
                }

                public CsmOffsetable.Position getStartPosition() {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                public CsmOffsetable.Position getEndPosition() {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                public CharSequence getText() {
                    return NameHolder.this.name;
                }

                public CsmObject getClosestTopLevelObject() {
                    return csmObject;
                }
            };
            fileImpl.addReference(csmReference, csmObject);
        }
    }

    private static boolean isMacroExpandedToken(AST aST) {
        if (aST instanceof CsmAST) {
            return APTUtils.isMacroExpandedToken((Token)((CsmAST)aST).getToken());
        }
        return false;
    }

    private CharSequence findDestructorDefinitionName(AST aST) {
        AST aST2 = aST.getFirstChild();
        if (aST2 != null) {
            aST2 = AstUtil.findSiblingOfType(aST2, 503);
        }
        if (aST2 != null && (aST2 = AstUtil.findChildOfType(aST2, 45)) != null) {
            AST aST3 = aST2.getNextSibling();
            if (aST3 == null) {
                aST3 = aST2;
            }
            this.start = OffsetableBase.getStartOffset(aST3);
            this.isMacroExpanded = NameHolder.isMacroExpandedToken(aST2);
            this.end = OffsetableBase.getEndOffset(aST2);
            if ((aST2 = aST2.getNextSibling()) != null && aST2.getType() == 90) {
                this.end = OffsetableBase.getEndOffset(aST2);
                return "~" + aST2.getText();
            }
        }
        return "~";
    }

    private CharSequence findFunctionName(AST aST) {
        if (CastUtils.isCast(aST)) {
            return this.getFunctionName(aST);
        }
        AST aST2 = AstUtil.findMethodName(aST);
        if (aST2 != null) {
            return this.extractName(aST2);
        }
        return "";
    }

    private String getFunctionName(AST aST) {
        AST aST2 = AstUtil.findChildOfType(aST, 109);
        if (aST2 == null) {
            return "operator ???";
        }
        this.start = OffsetableBase.getStartOffset(aST2);
        this.isMacroExpanded = NameHolder.isMacroExpandedToken(aST2);
        this.end = OffsetableBase.getEndOffset(aST2);
        StringBuilder stringBuilder = new StringBuilder(aST2.getText());
        stringBuilder.append(' ');
        block6: for (AST aST3 = aST2.getNextSibling(); aST3 != null; aST3 = aST3.getNextSibling()) {
            switch (aST3.getType()) {
                case 469: 
                case 470: {
                    stringBuilder.append(' ');
                    this.addTypeText(aST3, stringBuilder);
                    continue block6;
                }
                case 535: {
                    this.addTypeText(aST3, stringBuilder);
                    continue block6;
                }
                case 12: {
                    break block6;
                }
                case 32: 
                case 43: 
                case 134: 
                case 135: 
                case 136: {
                    this.end = OffsetableBase.getEndOffset(aST3);
                    stringBuilder.append(aST3.getText());
                    continue block6;
                }
                default: {
                    stringBuilder.append(' ');
                    this.end = OffsetableBase.getEndOffset(aST3);
                    stringBuilder.append(aST3.getText());
                }
            }
        }
        return stringBuilder.toString();
    }

    private void addTypeText(AST aST, StringBuilder stringBuilder) {
        if (aST == null) {
            return;
        }
        for (AST aST2 = aST.getFirstChild(); aST2 != null; aST2 = aST2.getNextSibling()) {
            if (455 <= aST2.getType() && aST2.getType() <= 542) {
                this.addTypeText(aST2, stringBuilder);
                continue;
            }
            this.end = OffsetableBase.getEndOffset(aST2);
            String string = aST2.getText();
            assert (string != null);
            assert (string.length() > 0);
            if (stringBuilder.length() > 0 && Character.isLetterOrDigit(stringBuilder.charAt(stringBuilder.length() - 1)) && Character.isLetterOrDigit(string.charAt(0))) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(string);
        }
    }

    private CharSequence extractName(AST aST) {
        AST aST2;
        int n = aST.getType();
        if (n == 90) {
            this.start = OffsetableBase.getStartOffset(aST);
            this.isMacroExpanded = NameHolder.isMacroExpandedToken(aST);
            this.end = OffsetableBase.getEndOffset(aST);
            return AstUtil.getText(aST);
        }
        if (n == 503 && (aST2 = AstUtil.getLastChild(aST)) != null) {
            AST aST3;
            AST aST4;
            if (aST2.getType() == 23) {
                aST4 = null;
                int n2 = 0;
                block5: for (aST3 = aST.getFirstChild(); aST3 != null; aST3 = aST3.getNextSibling()) {
                    int n3 = aST3.getType();
                    switch (n3) {
                        case 90: {
                            aST4 = aST3;
                            continue block5;
                        }
                        case 23: {
                            --n2;
                            continue block5;
                        }
                        case 21: {
                            ++n2;
                            continue block5;
                        }
                        default: {
                            if (n2 != 0) continue block5;
                            aST4 = null;
                        }
                    }
                }
                if (aST4 != null) {
                    aST2 = aST4;
                }
            }
            if (aST2.getType() == 90) {
                this.start = OffsetableBase.getStartOffset(aST2);
                this.isMacroExpanded = NameHolder.isMacroExpandedToken(aST2);
                this.end = OffsetableBase.getEndOffset(aST2);
                return AstUtil.getText(aST2);
            }
            aST4 = AstUtil.findChildOfType(aST, 109);
            if (aST4 != null) {
                this.start = OffsetableBase.getStartOffset(aST4);
                this.isMacroExpanded = NameHolder.isMacroExpandedToken(aST4);
                this.end = OffsetableBase.getEndOffset(aST4);
                StringBuilder stringBuilder = new StringBuilder(aST4.getText());
                stringBuilder.append(' ');
                for (aST3 = aST4.getNextSibling(); aST3 != null; aST3 = aST3.getNextSibling()) {
                    stringBuilder.append(aST3.getText());
                    this.end = OffsetableBase.getEndOffset(aST3);
                }
                return stringBuilder.toString();
            }
            AST aST5 = aST.getFirstChild();
            if (aST5.getType() == 90) {
                this.start = OffsetableBase.getStartOffset(aST5);
                this.isMacroExpanded = NameHolder.isMacroExpandedToken(aST5);
                this.end = OffsetableBase.getEndOffset(aST5);
                return AstUtil.getText(aST5);
            }
        }
        return "";
    }

    private CharSequence findClassName(AST aST) {
        return this.findId(aST, 17, true);
    }

    private CharSequence findEnumName(AST aST) {
        AST aST2;
        CharSequence charSequence = this.findId(aST, 17, false);
        if ((charSequence == null || charSequence.length() == 0) && (aST2 = aST.getNextSibling()) != null && aST2.getType() == 90) {
            this.start = OffsetableBase.getStartOffset(aST2);
            this.isMacroExpanded = NameHolder.isMacroExpandedToken(aST2);
            this.end = OffsetableBase.getEndOffset(aST2);
            charSequence = AstUtil.getText(aST2);
        }
        return charSequence;
    }

    private CharSequence findId(AST aST, int n, boolean bl) {
        for (AST aST2 = aST.getFirstChild(); aST2 != null; aST2 = aST2.getNextSibling()) {
            AST aST3;
            int n2 = aST2.getType();
            if (n2 == n && n >= 0) {
                return null;
            }
            if (n2 == 90) {
                this.start = OffsetableBase.getStartOffset(aST2);
                this.isMacroExpanded = NameHolder.isMacroExpandedToken(aST2);
                this.end = OffsetableBase.getEndOffset(aST2);
                return AstUtil.getText(aST2);
            }
            if (n2 != 503) continue;
            if (bl) {
                aST3 = AstUtil.getLastChild(aST2);
                this.start = OffsetableBase.getStartOffset(aST3);
                this.isMacroExpanded = NameHolder.isMacroExpandedToken(aST3);
                this.end = OffsetableBase.getEndOffset(aST3);
                return AstUtil.getText(aST2);
            }
            aST3 = AstUtil.getLastChild(aST2);
            if (aST3 == null) continue;
            if (aST3.getType() == 90) {
                this.start = OffsetableBase.getStartOffset(aST3);
                this.isMacroExpanded = NameHolder.isMacroExpandedToken(aST3);
                this.end = OffsetableBase.getEndOffset(aST3);
                return AstUtil.getText(aST3);
            }
            AST aST4 = aST2.getFirstChild();
            if (aST4.getType() == 109) {
                this.start = OffsetableBase.getStartOffset(aST4);
                this.isMacroExpanded = NameHolder.isMacroExpandedToken(aST4);
                this.end = OffsetableBase.getEndOffset(aST4);
                StringBuilder stringBuilder = new StringBuilder(aST4.getText());
                stringBuilder.append(' ');
                AST aST5 = aST4.getNextSibling();
                if (aST5 != null) {
                    this.end = OffsetableBase.getEndOffset(aST5);
                    stringBuilder.append(aST5.getText());
                }
                return stringBuilder.toString();
            }
            if (aST4.getType() != 90) continue;
            this.start = OffsetableBase.getStartOffset(aST4);
            this.end = OffsetableBase.getEndOffset(aST4);
            this.isMacroExpanded = NameHolder.isMacroExpandedToken(aST4);
            return AstUtil.getText(aST4);
        }
        return "";
    }
}

