/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.modelimpl.csm.IncludeImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileComponent;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.repository.FileIncludesKey;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryUtils;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.spi.Persistent;
import org.netbeans.modules.cnd.repository.support.SelfPersistent;

public class FileComponentIncludes
extends FileComponent
implements Persistent,
SelfPersistent {
    private Set<CsmUID<CsmInclude>> includes = this.createIncludes();
    private Set<CsmUID<CsmInclude>> brokenIncludes = new LinkedHashSet<CsmUID<CsmInclude>>(0);
    private final ReadWriteLock includesLock = new ReentrantReadWriteLock();
    private static final FileComponentIncludes EMPTY = new FileComponentIncludes(){

        @Override
        public void put() {
        }
    };
    private static final Comparator<CsmUID<?>> UID_START_OFFSET_COMPARATOR = new Comparator<CsmUID<?>>(){

        @Override
        public int compare(CsmUID<?> csmUID, CsmUID<?> csmUID2) {
            if (csmUID == csmUID2) {
                return 0;
            }
            Comparable comparable = (Comparable)csmUID;
            assert (comparable != null);
            return comparable.compareTo(csmUID2);
        }
    };

    public static FileComponentIncludes empty() {
        return EMPTY;
    }

    public FileComponentIncludes(FileImpl fileImpl) {
        super(new FileIncludesKey(fileImpl));
        this.put();
    }

    public FileComponentIncludes(DataInput dataInput) throws IOException {
        super(dataInput);
        UIDObjectFactory uIDObjectFactory = UIDObjectFactory.getDefaultFactory();
        uIDObjectFactory.readUIDCollection(this.includes, dataInput);
        uIDObjectFactory.readUIDCollection(this.brokenIncludes, dataInput);
    }

    private FileComponentIncludes() {
        super((Key)null);
    }

    void clean() {
        this._clearIncludes();
        this.put();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _clearIncludes() {
        try {
            this.includesLock.writeLock().lock();
            RepositoryUtils.remove(this.includes);
            this.brokenIncludes.clear();
            this.includes = this.createIncludes();
        }
        finally {
            this.includesLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean addInclude(IncludeImpl includeImpl, boolean bl) {
        CsmUID<IncludeImpl> csmUID = RepositoryUtils.put(includeImpl);
        assert (csmUID != null);
        try {
            this.includesLock.writeLock().lock();
            this.includes.add(csmUID);
            if (bl) {
                this.brokenIncludes.add(csmUID);
            } else {
                this.brokenIncludes.remove(csmUID);
            }
        }
        finally {
            this.includesLock.writeLock().unlock();
        }
        this.put();
        return !this.brokenIncludes.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<CsmInclude> getIncludes() {
        Collection<CsmInclude> collection;
        try {
            this.includesLock.readLock().lock();
            collection = UIDCsmConverter.UIDsToIncludes(this.includes);
        }
        finally {
            this.includesLock.readLock().unlock();
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Iterator<CsmInclude> getIncludes(CsmSelect.CsmFilter csmFilter) {
        Iterator<CsmInclude> iterator;
        try {
            this.includesLock.readLock().lock();
            iterator = UIDCsmConverter.UIDsToIncludes(this.includes, csmFilter);
        }
        finally {
            this.includesLock.readLock().unlock();
        }
        return iterator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<CsmInclude> getBrokenIncludes() {
        Collection<CsmInclude> collection;
        try {
            this.includesLock.readLock().lock();
            collection = UIDCsmConverter.UIDsToIncludes(this.brokenIncludes);
        }
        finally {
            this.includesLock.readLock().unlock();
        }
        return collection;
    }

    private Set<CsmUID<CsmInclude>> createIncludes() {
        return new TreeSet<CsmUID<CsmInclude>>(UID_START_OFFSET_COMPARATOR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
        UIDObjectFactory uIDObjectFactory = UIDObjectFactory.getDefaultFactory();
        try {
            this.includesLock.readLock().lock();
            uIDObjectFactory.writeUIDCollection(this.includes, dataOutput, false);
            uIDObjectFactory.writeUIDCollection(this.brokenIncludes, dataOutput, false);
        }
        finally {
            this.includesLock.readLock().unlock();
        }
    }
}

