/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.io.PrintWriter;
import java.util.Collection;
import org.netbeans.modules.cnd.api.model.CsmErrorDirective;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmMacro;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.openide.filesystems.FileObject;

public class FileSnapshot
implements CsmFile {
    private final CharSequence absPath;
    private final CsmProject project;
    private final CharSequence name;
    private final Collection<CsmInclude> includes;
    private final Collection<CsmErrorDirective> errors;
    private final Collection<CsmOffsetableDeclaration> declarations;
    private final Collection<CsmMacro> macros;
    private final Collection<CsmScopeElement> scoped;
    private final CsmFile.FileType fileType;
    private final boolean isSource;
    private final boolean isHeader;
    private final FileImpl delegate;
    private final FileObject fileObject;

    FileSnapshot(FileImpl fileImpl) {
        this.absPath = fileImpl.getAbsolutePath();
        this.project = fileImpl.getProject();
        this.name = fileImpl.getName();
        this.includes = fileImpl.getIncludes();
        this.errors = fileImpl.getErrors();
        this.declarations = fileImpl.getDeclarations();
        this.macros = fileImpl.getMacros();
        this.scoped = fileImpl.getScopeElements();
        this.isSource = fileImpl.isSourceFile();
        this.isHeader = fileImpl.isHeaderFile();
        this.fileType = fileImpl.getFileType();
        this.fileObject = fileImpl.getFileObject();
        this.delegate = fileImpl;
    }

    public CharSequence getAbsolutePath() {
        return this.absPath;
    }

    public FileObject getFileObject() {
        return this.fileObject;
    }

    public CsmProject getProject() {
        return this.project;
    }

    public CharSequence getText() {
        assert (false);
        return this.delegate.getText();
    }

    public CharSequence getText(int n, int n2) {
        assert (false);
        return this.delegate.getText(n, n2);
    }

    public Collection<CsmInclude> getIncludes() {
        return this.includes;
    }

    public Collection<CsmErrorDirective> getErrors() {
        return this.errors;
    }

    public Collection<CsmOffsetableDeclaration> getDeclarations() {
        return this.declarations;
    }

    public Collection<CsmMacro> getMacros() {
        return this.macros;
    }

    public boolean isParsed() {
        return true;
    }

    public void scheduleParsing(boolean bl) throws InterruptedException {
    }

    public boolean isSourceFile() {
        return this.isSource;
    }

    public boolean isHeaderFile() {
        return this.isHeader;
    }

    public CsmFile.FileType getFileType() {
        return this.fileType;
    }

    public CharSequence getName() {
        return this.name;
    }

    public Collection<CsmScopeElement> getScopeElements() {
        return this.scoped;
    }

    public boolean isValid() {
        return true;
    }

    public void dumpInfo(PrintWriter printWriter) {
        printWriter.printf("Snapshot %s\n", this.absPath);
    }
}

