/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.deep;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.deep.CsmExpression;
import org.netbeans.modules.cnd.modelimpl.csm.core.CsmIdentifiable;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableBase;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;

public final class ExpressionBase
extends OffsetableBase
implements CsmExpression {
    private List<CsmExpression> operands;
    private CsmScope scopeRef;
    private CsmUID<CsmScope> scopeUID;

    private ExpressionBase(AST aST, CsmFile csmFile, CsmScope csmScope) {
        super(aST, csmFile);
        if (csmScope != null) {
            this.setScope(csmScope);
        }
    }

    public static ExpressionBase create(AST aST, CsmFile csmFile, CsmScope csmScope) {
        return new ExpressionBase(aST, csmFile, csmScope);
    }

    public ExpressionBase(int n, int n2, CsmFile csmFile, CsmScope csmScope) {
        super(csmFile, n, n2);
        if (csmScope != null) {
            this.setScope(csmScope);
        }
    }

    public static ExpressionBase create(int n, int n2, CsmFile csmFile, CsmScope csmScope) {
        return new ExpressionBase(n, n2, csmFile, csmScope);
    }

    public CsmExpression.Kind getKind() {
        return null;
    }

    public CsmScope getScope() {
        return this._getScope();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.onDispose();
    }

    private synchronized void onDispose() {
        if (this.scopeRef == null) {
            CsmScope csmScope = this.scopeRef = this.scopeRef != null ? this.scopeRef : UIDCsmConverter.UIDtoScope(this.scopeUID);
            assert (this.scopeRef != null || this.scopeUID == null) : "empty scope for UID " + this.scopeUID;
        }
    }

    private synchronized CsmScope _getScope() {
        CsmScope csmScope = this.scopeRef;
        if (csmScope == null) {
            csmScope = UIDCsmConverter.UIDtoScope(this.scopeUID);
            assert (csmScope != null || this.scopeUID == null) : "null object for UID " + this.scopeUID;
        }
        return csmScope;
    }

    protected void setScope(CsmScope csmScope) {
        if (csmScope instanceof CsmIdentifiable) {
            this.scopeUID = UIDCsmConverter.scopeToUID(csmScope);
            assert (this.scopeUID != null || csmScope == null);
        } else {
            this.scopeRef = csmScope;
        }
    }

    public List<CsmExpression> getOperands() {
        if (this.operands == null) {
            this.operands = new ArrayList<CsmExpression>(0);
        }
        return Collections.unmodifiableList(this.operands);
    }

    public CsmExpression getParent() {
        return null;
    }

    @Override
    public void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
        PersistentUtils.writeExpressions(this.operands, dataOutput);
        UIDObjectFactory.getDefaultFactory().writeUID(this.scopeUID, dataOutput);
    }

    public ExpressionBase(DataInput dataInput) throws IOException {
        super(dataInput);
        this.operands = PersistentUtils.readExpressions(new ArrayList(0), dataInput);
        this.scopeUID = UIDObjectFactory.getDefaultFactory().readUID(dataInput);
    }
}

