/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.resolver;

import java.util.Iterator;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmMethod;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelimpl.csm.resolver.Resolver3;
import org.netbeans.modules.cnd.modelimpl.impl.services.BaseUtilitiesProviderImpl;

public class Context {
    private final CsmFile file;
    private final int origOffset;
    private final Resolver3 resolver;
    private CsmNamespace containingNamespace;
    private CsmClass containingClass;
    private boolean contextFound = false;

    Context(CsmFile csmFile, int n, Resolver3 resolver3) {
        this.file = csmFile;
        this.origOffset = n;
        this.resolver = resolver3;
    }

    CsmNamespace getContainingNamespace() {
        if (!this.contextFound) {
            this.findContext(this.origOffset);
        }
        return this.containingNamespace;
    }

    CsmClass getContainingClass() {
        if (!this.contextFound) {
            this.findContext(this.origOffset);
        }
        return this.containingClass;
    }

    private void findContext(int n) {
        this.contextFound = true;
        CsmSelect.CsmFilter csmFilter = CsmSelect.getFilterBuilder().createOffsetFilter(0, n);
        this.findContext(CsmSelect.getDeclarations((CsmFile)this.file, (CsmSelect.CsmFilter)csmFilter), csmFilter, n);
    }

    private void findContext(Iterator<?> iterator, CsmSelect.CsmFilter csmFilter, int n) {
        while (iterator.hasNext()) {
            CsmFunction csmFunction;
            CsmNamespaceDefinition csmNamespaceDefinition;
            CsmDeclaration csmDeclaration = (CsmDeclaration)iterator.next();
            if (csmDeclaration.getKind() == CsmDeclaration.Kind.NAMESPACE_DEFINITION) {
                csmNamespaceDefinition = (CsmNamespaceDefinition)csmDeclaration;
                if (csmNamespaceDefinition.getStartOffset() >= n || n >= csmNamespaceDefinition.getEndOffset()) continue;
                this.containingNamespace = csmNamespaceDefinition.getNamespace();
                this.findContext(CsmSelect.getDeclarations((CsmNamespaceDefinition)csmNamespaceDefinition, (CsmSelect.CsmFilter)csmFilter), csmFilter, n);
                continue;
            }
            if (csmDeclaration.getKind() == CsmDeclaration.Kind.CLASS || csmDeclaration.getKind() == CsmDeclaration.Kind.STRUCT || csmDeclaration.getKind() == CsmDeclaration.Kind.UNION) {
                csmNamespaceDefinition = (CsmClass)csmDeclaration;
                if (csmNamespaceDefinition.getStartOffset() >= n || n >= csmNamespaceDefinition.getEndOffset()) continue;
                this.containingClass = csmNamespaceDefinition;
                this.findContext(CsmSelect.getClassMembers((CsmClass)this.containingClass, (CsmSelect.CsmFilter)csmFilter), csmFilter, n);
                continue;
            }
            if (csmDeclaration.getKind() != CsmDeclaration.Kind.FUNCTION_DEFINITION && csmDeclaration.getKind() != CsmDeclaration.Kind.FUNCTION_FRIEND_DEFINITION || (csmNamespaceDefinition = (CsmFunctionDefinition)csmDeclaration).getStartOffset() >= n || n >= csmNamespaceDefinition.getEndOffset()) continue;
            CsmNamespace csmNamespace = BaseUtilitiesProviderImpl.getImpl()._getFunctionNamespace((CsmFunction)csmNamespaceDefinition);
            if (csmNamespace != null && !csmNamespace.isGlobal()) {
                this.containingNamespace = csmNamespace;
            }
            if ((csmFunction = this.getFunctionDeclaration((CsmFunctionDefinition)csmNamespaceDefinition)) == null || !CsmKindUtilities.isMethodDeclaration((CsmObject)csmFunction)) continue;
            this.containingClass = this.getMethodContainingClass((CsmMethod)csmFunction);
        }
    }

    private CsmFunction getFunctionDeclaration(CsmFunctionDefinition csmFunctionDefinition) {
        if (this.resolver.isRecursionOnResolving(200)) {
            return null;
        }
        return csmFunctionDefinition.getDeclaration();
    }

    private CsmClass getMethodContainingClass(CsmMethod csmMethod) {
        return csmMethod.getContainingClass();
    }
}

