/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.impl.services;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmListeners;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmNamespaceAlias;
import org.netbeans.modules.cnd.api.model.CsmProgressListener;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmUsingDeclaration;
import org.netbeans.modules.cnd.api.model.CsmUsingDirective;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.services.CsmUsingResolver;
import org.netbeans.modules.cnd.modelimpl.impl.services.FileElementsCollector;

public final class UsingResolverImpl
extends CsmUsingResolver
implements CsmProgressListener {
    private final Object lock = new Lock();
    private Reference<SearchInfo> lastSearch = new SoftReference<Object>(null);
    private final boolean cache = true;

    public UsingResolverImpl() {
        CsmListeners.getDefault().addProgressListener((CsmProgressListener)this);
    }

    public Collection<CsmDeclaration> findUsedDeclarations(CsmFile csmFile, int n, CsmProject csmProject) {
        return this.getCollector(csmFile, n, csmProject).getUsedDeclarations();
    }

    public Collection<CsmDeclaration> findUsedDeclarations(CsmNamespace csmNamespace) {
        ArrayList<CsmUsingDeclaration> arrayList = new ArrayList<CsmUsingDeclaration>();
        Iterator iterator = CsmSelect.getDeclarations((CsmNamespace)csmNamespace, (CsmSelect.CsmFilter)CsmSelect.getFilterBuilder().createKindFilter(new CsmDeclaration.Kind[]{CsmDeclaration.Kind.USING_DECLARATION}));
        while (iterator.hasNext()) {
            arrayList.add((CsmUsingDeclaration)iterator.next());
        }
        if (!csmNamespace.isGlobal()) {
            for (CsmProject csmProject : csmNamespace.getProject().getLibraries()) {
                CsmNamespace csmNamespace2 = csmProject.findNamespace(csmNamespace.getQualifiedName());
                if (csmNamespace2 == null) continue;
                Iterator iterator2 = CsmSelect.getDeclarations((CsmNamespace)csmNamespace2, (CsmSelect.CsmFilter)CsmSelect.getFilterBuilder().createKindFilter(new CsmDeclaration.Kind[]{CsmDeclaration.Kind.USING_DECLARATION}));
                while (iterator2.hasNext()) {
                    arrayList.add((CsmUsingDeclaration)iterator2.next());
                }
            }
        }
        return UsingResolverImpl.extractDeclarations(arrayList);
    }

    public Collection<CsmNamespace> findVisibleNamespaces(CsmFile csmFile, int n, CsmProject csmProject) {
        LinkedHashSet<CsmNamespace> linkedHashSet = new LinkedHashSet<CsmNamespace>();
        LinkedList<CsmNamespace> linkedList = new LinkedList<CsmNamespace>(this.getCollector(csmFile, n, csmProject).getVisibleNamespaces());
        this.findVisibleNamespacesBfs(linkedHashSet, linkedList, csmProject, csmFile.getProject());
        return linkedHashSet;
    }

    private void findVisibleNamespacesBfs(Set<CsmNamespace> set, Queue<CsmNamespace> queue, CsmProject csmProject, CsmProject csmProject2) {
        while (!queue.isEmpty()) {
            CsmNamespace csmNamespace = queue.poll();
            for (CsmNamespace csmNamespace2 : this.findVisibleNamespaces(csmNamespace, csmProject2)) {
                if (set.contains(csmNamespace2) || queue.contains(csmNamespace2) || csmProject != null && csmProject != csmNamespace2.getProject()) continue;
                queue.add(csmNamespace2);
            }
            set.add(csmNamespace);
        }
    }

    public Collection<CsmUsingDirective> findUsingDirectives(CsmNamespace csmNamespace) {
        ArrayList<CsmUsingDirective> arrayList = new ArrayList<CsmUsingDirective>();
        Iterator iterator = CsmSelect.getDeclarations((CsmNamespace)csmNamespace, (CsmSelect.CsmFilter)CsmSelect.getFilterBuilder().createKindFilter(new CsmDeclaration.Kind[]{CsmDeclaration.Kind.USING_DIRECTIVE}));
        while (iterator.hasNext()) {
            arrayList.add((CsmUsingDirective)iterator.next());
        }
        return arrayList;
    }

    public Collection<CsmNamespaceAlias> findNamespaceAliases(CsmFile csmFile, int n, CsmProject csmProject) {
        return this.getCollector(csmFile, n, csmProject).getNamespaceAliases();
    }

    public Collection<CsmNamespaceAlias> findNamespaceAliases(CsmNamespace csmNamespace) {
        ArrayList<CsmNamespaceAlias> arrayList = new ArrayList<CsmNamespaceAlias>();
        Iterator iterator = CsmSelect.getDeclarations((CsmNamespace)csmNamespace, (CsmSelect.CsmFilter)CsmSelect.getFilterBuilder().createKindFilter(new CsmDeclaration.Kind[]{CsmDeclaration.Kind.NAMESPACE_ALIAS}));
        while (iterator.hasNext()) {
            arrayList.add((CsmNamespaceAlias)iterator.next());
        }
        return arrayList;
    }

    public static Collection<CsmDeclaration> extractDeclarations(Collection<CsmUsingDeclaration> collection) {
        LinkedHashMap<CharSequence, CsmDeclaration> linkedHashMap = new LinkedHashMap<CharSequence, CsmDeclaration>(collection.size());
        for (CsmUsingDeclaration csmUsingDeclaration : collection) {
            CsmDeclaration csmDeclaration = null;
            csmDeclaration = csmUsingDeclaration.getReferencedDeclaration();
            if (csmDeclaration == null) continue;
            CharSequence charSequence = csmUsingDeclaration.getName();
            linkedHashMap.remove(charSequence);
            linkedHashMap.put(charSequence, csmDeclaration);
        }
        return new ArrayList<CsmDeclaration>(linkedHashMap.values());
    }

    public static Collection<CsmNamespace> extractNamespaces(Collection<CsmUsingDirective> collection, CsmProject csmProject) {
        Object object22;
        LinkedHashSet<Pair> linkedHashSet = new LinkedHashSet<Pair>();
        for (Object object22 : collection) {
            Object object;
            CsmFile object4;
            CsmNamespace csmNamespace = object22.getReferencedNamespace();
            if (csmNamespace == null || (object4 = object22.getContainingFile()) == null || (object = object4.getProject()) == null) continue;
            Pair pair = new Pair(csmNamespace, (CsmProject)object);
            linkedHashSet.remove(pair);
            linkedHashSet.add(pair);
        }
        LinkedHashSet linkedHashSet2 = new LinkedHashSet();
        object22 = csmProject.getLibraries();
        for (Pair pair : linkedHashSet) {
            for (CsmNamespace csmNamespace : UsingResolverImpl.findNamespacesInProject(pair.proj, pair.fqn, (Collection<CsmProject>)object22)) {
                linkedHashSet2.remove(csmNamespace);
                linkedHashSet2.add(csmNamespace);
            }
        }
        return linkedHashSet2;
    }

    public Collection<CsmNamespace> findVisibleNamespaces(CsmNamespace csmNamespace, CsmProject csmProject) {
        ArrayList<CsmNamespace> arrayList = new ArrayList<CsmNamespace>();
        if (!csmNamespace.isGlobal()) {
            for (CsmNamespace csmNamespace2 : csmNamespace.getNestedNamespaces()) {
                if (csmNamespace2.getName().length() != 0) continue;
                arrayList.add(csmNamespace2);
            }
        }
        arrayList.addAll(UsingResolverImpl.extractNamespaces(this.findUsingDirectives(csmNamespace), csmProject));
        return arrayList;
    }

    private static Collection<CsmNamespace> findNamespacesInProject(CsmProject csmProject, CharSequence charSequence, Collection<CsmProject> collection) {
        HashSet<CsmProject> hashSet = new HashSet<CsmProject>();
        ArrayList<CsmNamespace> arrayList = new ArrayList<CsmNamespace>();
        CsmNamespace csmNamespace = csmProject.findNamespace(charSequence);
        if (csmNamespace != null) {
            arrayList.add(csmNamespace);
        }
        hashSet.add(csmProject);
        arrayList.addAll(UsingResolverImpl.findNamespacesInProjects(collection, charSequence, hashSet));
        return arrayList;
    }

    private static Collection<CsmNamespace> findNamespacesInProjects(Collection<CsmProject> collection, CharSequence charSequence, HashSet<CsmProject> hashSet) {
        ArrayList<CsmNamespace> arrayList = new ArrayList<CsmNamespace>();
        for (CsmProject csmProject : collection) {
            if (hashSet.contains(csmProject)) continue;
            CsmNamespace csmNamespace = csmProject.findNamespace(charSequence);
            if (csmNamespace != null) {
                arrayList.add(csmNamespace);
            }
            hashSet.add(csmProject);
            Collection collection2 = csmProject.getLibraries();
            if (collection2.isEmpty()) continue;
            arrayList.addAll(UsingResolverImpl.findNamespacesInProjects(collection2, charSequence, hashSet));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileElementsCollector getCollector(CsmFile csmFile, int n, CsmProject csmProject) {
        Object object = this.lock;
        synchronized (object) {
            SearchInfo searchInfo = this.lastSearch.get();
            if (searchInfo == null || !searchInfo.valid(csmFile, n, csmProject)) {
                FileElementsCollector fileElementsCollector = new FileElementsCollector(csmFile, n, csmProject);
                searchInfo = new SearchInfo(csmFile, n, csmProject, fileElementsCollector);
                this.lastSearch = new SoftReference<SearchInfo>(searchInfo);
            } else {
                searchInfo.offset = n;
                searchInfo.collector.incrementOffset(n);
            }
            assert (searchInfo != null);
            assert (searchInfo.collector != null);
            return searchInfo.collector;
        }
    }

    public void projectParsingStarted(CsmProject csmProject) {
    }

    public void projectFilesCounted(CsmProject csmProject, int n) {
    }

    public void projectParsingFinished(CsmProject csmProject) {
        this.cleanCache();
    }

    public void projectParsingCancelled(CsmProject csmProject) {
    }

    public void fileInvalidated(CsmFile csmFile) {
    }

    public void fileAddedToParse(CsmFile csmFile) {
    }

    public void fileParsingStarted(CsmFile csmFile) {
    }

    public void fileParsingFinished(CsmFile csmFile) {
        this.cleanCache();
    }

    public void projectLoaded(CsmProject csmProject) {
    }

    public void parserIdle() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanCache() {
        Object object = this.lock;
        synchronized (object) {
            this.lastSearch.clear();
        }
    }

    private static final class SearchInfo {
        private final CsmFile file;
        private int offset;
        private final FileElementsCollector collector;
        private final CsmProject onlyInProject;

        public SearchInfo(CsmFile csmFile, int n, CsmProject csmProject, FileElementsCollector fileElementsCollector) {
            this.file = csmFile;
            this.offset = n;
            this.collector = fileElementsCollector;
            this.onlyInProject = csmProject;
        }

        private boolean valid(CsmFile csmFile, int n, CsmProject csmProject) {
            return this.file.equals(csmFile) && this.offset <= n && this.onlyInProject == csmProject;
        }
    }

    private static final class Lock {
        private Lock() {
        }
    }

    private static class Pair {
        private final CharSequence fqn;
        private CsmProject proj;

        private Pair(CsmNamespace csmNamespace, CsmProject csmProject) {
            this.fqn = csmNamespace.getQualifiedName();
            this.proj = csmProject;
        }

        public int hashCode() {
            return this.fqn.hashCode() + this.proj.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof Pair) {
                Pair pair = (Pair)object;
                return this.fqn.equals(pair.fqn) && this.proj.equals(pair.proj);
            }
            return false;
        }
    }
}

