/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.repository;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.netbeans.modules.cnd.modelimpl.repository.AbstractKey;
import org.netbeans.modules.cnd.modelimpl.repository.KeyUtilities;
import org.netbeans.modules.cnd.repository.spi.KeyDataPresentation;

abstract class ProjectNameBasedKey
extends AbstractKey {
    private final short unitIndex;

    protected ProjectNameBasedKey(CharSequence charSequence) {
        assert (charSequence != null);
        this.unitIndex = (short)KeyUtilities.getUnitId(charSequence);
    }

    protected ProjectNameBasedKey(KeyDataPresentation keyDataPresentation) {
        this.unitIndex = keyDataPresentation.getUnitPresentation();
    }

    @Override
    public String toString() {
        return ((Object)this.getProjectName()).toString();
    }

    @Override
    public int hashCode() {
        return this.unitIndex;
    }

    @Override
    public final int getUnitId() {
        return this.unitIndex;
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        ProjectNameBasedKey projectNameBasedKey = (ProjectNameBasedKey)object;
        return this.unitIndex == projectNameBasedKey.unitIndex;
    }

    protected CharSequence getProjectName() {
        return this.getUnit();
    }

    public void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeShort(this.unitIndex);
    }

    protected ProjectNameBasedKey(DataInput dataInput) throws IOException {
        this.unitIndex = dataInput.readShort();
    }

    @Override
    public int getDepth() {
        return 0;
    }

    @Override
    public CharSequence getAt(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CharSequence getUnit() {
        return KeyUtilities.getUnitName(this.unitIndex);
    }

    public final short getUnitPresentation() {
        return this.unitIndex;
    }
}

