/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.todo.settings;

import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.tasklist.todo.settings.Settings;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

class ToDoCustomizer
extends JPanel {
    private boolean changed = false;
    private boolean isUpdating = false;
    private JButton btnAdd;
    private JButton btnChange;
    private JButton btnRemove;
    private JCheckBox checkScanCommentsOnly;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JTable table;

    public ToDoCustomizer() {
        this.initComponents();
        this.table.getSelectionModel().setSelectionMode(0);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ToDoCustomizer.this.enableButtons();
            }
        });
        this.jScrollPane1.getViewport().setOpaque(false);
        this.enableButtons();
    }

    private void enableButtons() {
        int selIndex = this.table.getSelectedRow();
        this.btnChange.setEnabled(selIndex >= 0);
        this.btnRemove.setEnabled(selIndex >= 0);
    }

    void update() {
        this.isUpdating = true;
        Collection<String> patterns = Settings.getDefault().getPatterns();
        this.table.setModel(this.createModel(patterns));
        this.table.setTableHeader(null);
        this.checkScanCommentsOnly.setSelected(Settings.getDefault().isScanCommentsOnly());
        this.changed = false;
        this.isUpdating = false;
    }

    void applyChanges() {
        DefaultTableModel model = (DefaultTableModel)this.table.getModel();
        ArrayList<String> patterns = new ArrayList<String>(model.getRowCount());
        for (int i = 0; i < model.getRowCount(); ++i) {
            patterns.add(model.getValueAt(i, 0).toString());
        }
        Settings.getDefault().setPatterns(patterns);
        Settings.getDefault().setScanCommentsOnly(this.checkScanCommentsOnly.isSelected());
    }

    boolean isDataValid() {
        return this.table.getRowCount() > 0;
    }

    boolean isChanged() {
        return this.changed;
    }

    private DefaultTableModel createModel(Collection<String> patterns) {
        DefaultTableModel model = new DefaultTableModel(new Object[]{NbBundle.getMessage(ToDoCustomizer.class, (String)"ToDoCustomizer.TableHeader")}, patterns.size());
        int row = 0;
        for (String p : patterns) {
            model.setValueAt(p, row++, 0);
        }
        return model;
    }

    private void initComponents() {
        this.btnAdd = new JButton();
        this.btnChange = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.table = new MyTable();
        this.checkScanCommentsOnly = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.btnRemove = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.btnAdd, (String)NbBundle.getMessage(ToDoCustomizer.class, (String)"ToDoCustomizer.btnAdd.text"));
        this.btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToDoCustomizer.this.btnAddActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.btnChange, (String)NbBundle.getMessage(ToDoCustomizer.class, (String)"ToDoCustomizer.btnChange.text"));
        this.btnChange.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToDoCustomizer.this.btnChangeActionPerformed(evt);
            }
        });
        this.jScrollPane1.setOpaque(false);
        this.table.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.table.setOpaque(false);
        this.table.setTableHeader(null);
        this.jScrollPane1.setViewportView(this.table);
        Mnemonics.setLocalizedText((AbstractButton)this.checkScanCommentsOnly, (String)NbBundle.getMessage(ToDoCustomizer.class, (String)"ToDoCustomizer.checkScanCommentsOnly.text"));
        this.checkScanCommentsOnly.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.checkScanCommentsOnly.setMargin(new Insets(0, 0, 0, 0));
        this.checkScanCommentsOnly.setOpaque(false);
        this.checkScanCommentsOnly.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ToDoCustomizer.this.scanCommentsOnlyChanged(evt);
            }
        });
        this.jLabel1.setLabelFor(this.table);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(ToDoCustomizer.class, (String)"ToDoCustomizer.TableHeader"));
        Mnemonics.setLocalizedText((AbstractButton)this.btnRemove, (String)NbBundle.getMessage(ToDoCustomizer.class, (String)"ToDoCustomizer.btnRemove.text"));
        this.btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToDoCustomizer.this.btnRemoveActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 257, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.btnAdd, -1, -1, Short.MAX_VALUE).addComponent(this.btnChange, -1, -1, Short.MAX_VALUE).addComponent(this.btnRemove, -2, 81, Short.MAX_VALUE))).addComponent(this.jLabel1).addComponent(this.checkScanCommentsOnly));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.btnAdd).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnChange).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnRemove)).addComponent(this.jScrollPane1, -1, 171, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkScanCommentsOnly)));
    }

    private void btnRemoveActionPerformed(ActionEvent evt) {
        TableCellEditor editor = this.table.getCellEditor();
        if (null != editor) {
            editor.cancelCellEditing();
        }
        boolean wasValid = this.isDataValid();
        int selRow = this.table.getSelectedRow();
        if (selRow < 0) {
            return;
        }
        DefaultTableModel model = (DefaultTableModel)this.table.getModel();
        model.removeRow(selRow);
        if (selRow > model.getRowCount() - 1) {
            --selRow;
        }
        if (selRow >= 0) {
            this.table.getSelectionModel().setSelectionInterval(selRow, selRow);
        }
        boolean wasChanged = this.changed;
        this.changed = true;
        this.firePropertyChange("changed", new Boolean(wasChanged), Boolean.TRUE);
        this.firePropertyChange("valid", new Boolean(wasValid), new Boolean(this.isDataValid()));
    }

    private void btnChangeActionPerformed(ActionEvent evt) {
        int selRow = this.table.getSelectedRow();
        if (selRow < 0) {
            return;
        }
        final boolean wasChanged = this.changed;
        this.table.editCellAt(selRow, 0);
        final TableCellEditor editor = this.table.getCellEditor();
        editor.addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingStopped(ChangeEvent e) {
                editor.removeCellEditorListener(this);
                ToDoCustomizer.this.changed = true;
                ToDoCustomizer.this.firePropertyChange("changed", new Boolean(wasChanged), Boolean.TRUE);
                ToDoCustomizer.this.firePropertyChange("valid", null, null);
            }

            @Override
            public void editingCanceled(ChangeEvent e) {
                editor.removeCellEditorListener(this);
            }
        });
    }

    private void btnAddActionPerformed(ActionEvent evt) {
        DefaultTableModel model = (DefaultTableModel)this.table.getModel();
        model.addRow(new Object[]{NbBundle.getMessage(ToDoCustomizer.class, (String)"ToDoCustomizer.DefaultPattern")});
        this.table.getSelectionModel().setSelectionInterval(model.getRowCount() - 1, model.getRowCount() - 1);
        final boolean wasChanged = this.changed;
        this.table.editCellAt(model.getRowCount() - 1, 0);
        final TableCellEditor editor = this.table.getCellEditor();
        editor.addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingStopped(ChangeEvent e) {
                editor.removeCellEditorListener(this);
                ToDoCustomizer.this.changed = true;
                ToDoCustomizer.this.firePropertyChange("changed", new Boolean(wasChanged), Boolean.TRUE);
                ToDoCustomizer.this.firePropertyChange("valid", null, null);
            }

            @Override
            public void editingCanceled(ChangeEvent e) {
                editor.removeCellEditorListener(this);
            }
        });
    }

    private void scanCommentsOnlyChanged(ItemEvent evt) {
        if (this.isUpdating) {
            return;
        }
        boolean wasChanged = this.changed;
        this.changed = true;
        this.firePropertyChange("changed", new Boolean(wasChanged), Boolean.TRUE);
    }

    private static class MyTable
    extends JTable {
        private MyTable() {
        }

        @Override
        public Component prepareEditor(TableCellEditor editor, int row, int column) {
            Component res = super.prepareEditor(editor, row, column);
            if (res instanceof JTextComponent) {
                final JTextComponent txt = (JTextComponent)res;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        txt.selectAll();
                        txt.requestFocusInWindow();
                    }
                });
            }
            return res;
        }
    }
}

