/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2me.cdc.project.nsicom;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.netbeans.mobility.activesync.ActiveSyncException;
import org.netbeans.mobility.activesync.ActiveSyncOps;
import org.netbeans.mobility.activesync.RemoteFile;
import org.netbeans.mobility.activesync.RemoteProcess;

public class NSIcomExecDeployTask
extends Task {
    private List filesets = new LinkedList();
    private File home;
    private String mainclass;
    private String args;
    private String jvmargs;
    private String device;
    private String profile;
    private boolean xlet;
    private boolean applet;
    private boolean verbose;
    private String hostIP;
    private String debuggerAddressProperty;
    private boolean debug;
    private boolean runOnDevice;
    private String remoteVMLocation;
    private String remoteDataLocation;
    private boolean deploy;
    protected PrintWriter fos = null;
    private ActiveSyncOps activeSync;
    private RemoteFile remoteFolder = null;

    public void addFileset(FileSet fs) {
        this.filesets.add(fs);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() throws BuildException {
        if (this.deploy) {
            this.runOnDevice = true;
        }
        if (this.runOnDevice) {
            try {
                this.activeSync = ActiveSyncOps.getDefault();
                this.log("Library nbactivesync.dll loaded correctly", 3);
            }
            catch (Throwable e) {
                throw new BuildException("Library nbactivesync.dll can not be loaded!");
            }
            this.checkActiveSync();
        }
        ArrayList<String> arguments = new ArrayList<String>();
        if (!this.runOnDevice) {
            String os = System.getProperty("os.name");
            if (os.toLowerCase().indexOf("windows") < 0) throw new BuildException("Only Windows version is supported!");
            arguments.add(this.home + File.separator + "bin" + File.separator + "pJSCP.exe");
        } else {
            if (!this.deploy) {
                this.verifyRemoteVM();
            }
            if (this.remoteDataLocation == null || this.remoteDataLocation.length() == 0) {
                throw new BuildException("Remote folder must be set!");
            }
        }
        if (this.jvmargs != null && this.jvmargs.trim().length() != 0) {
            StringTokenizer st = new StringTokenizer(this.jvmargs, " ");
            while (st.hasMoreTokens()) {
                arguments.add(st.nextToken());
            }
        }
        if (!this.runOnDevice) {
            arguments.add("-TCK");
        }
        if (this.debug || this.runOnDevice) {
            arguments.add("-mon");
            if (this.hostIP != null && this.hostIP.length() != 0) {
                arguments.add(this.hostIP);
            }
            if (this.runOnDevice) {
                arguments.add("'-Of" + this.remoteDataLocation + "'");
            }
        } else {
            arguments.add("-Ob");
        }
        if (this.verbose) {
            arguments.add("-verbose");
        }
        if (!this.xlet && !this.applet) {
            arguments.add("-classpath");
            arguments.add(this.createClassPath());
            arguments.add(this.mainclass);
            this.appendArguments(arguments);
        } else if (!this.xlet) {
            arguments.add("-av");
            String html = this.generateHtml();
            File f = new File(this.getProject().getBaseDir().toString() + "/build", "applet.html");
            try {
                FileOutputStream dos = new FileOutputStream(f);
                dos.write(html.getBytes());
                dos.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            if (!this.runOnDevice) {
                arguments.add(f.toString());
            } else {
                try {
                    this.remoteFolder = this.createRemoteFolder(this.remoteDataLocation);
                }
                catch (Exception e) {
                    throw new BuildException("Remote folder can not be created!");
                }
                try {
                    RemoteFile remoteHtmlItem = new RemoteFile(this.remoteFolder.getFullPath(), "applet.html");
                    if (remoteHtmlItem.exists()) {
                        this.activeSync.delete(remoteHtmlItem);
                    }
                    this.activeSync.copyToDevice(f, remoteHtmlItem);
                    arguments.add("'" + remoteHtmlItem.getFullPath() + "'");
                }
                catch (IOException ioEx) {
                    throw new BuildException("Can not create applet.html");
                }
            }
        }
        if (this.deploy) return;
        String[] arg = arguments.toArray(new String[0]);
        this.getProject().log("Application arguments:", 3);
        for (int i = 0; i < arg.length; ++i) {
            this.getProject().log("'" + arg[i] + "'", 3);
        }
        try {
            if (!this.runOnDevice) {
                Process p = null;
                try {
                    p = Runtime.getRuntime().exec(arg);
                    StreamReader inputReader = new StreamReader(p.getInputStream(), 2);
                    StreamReader errorReader = new StreamReader(p.getErrorStream(), 1);
                    inputReader.start();
                    errorReader.start();
                    p.waitFor();
                    inputReader.join();
                    errorReader.join();
                }
                catch (ThreadDeath td) {
                    p.destroy();
                    throw td;
                }
                finally {
                    this.logFlush();
                }
                if (p.exitValue() == 0) return;
                throw new BuildException("Emulator execution failed!");
            }
            RemoteFile root = this.activeSync.getRootFilesystems()[0];
            RemoteFile log = new RemoteFile(this.remoteFolder.getFullPath(), "jspcout.txt");
            try {
                if (log.exists()) {
                    this.activeSync.delete(log);
                }
            }
            catch (Exception e) {
                this.log("Can not delete log file", 3);
            }
            ProcessHandler handler = null;
            try {
                handler = new ProcessHandler(this.remoteDataLocation, arg, this.remoteFolder);
                handler.start();
                try {
                    handler.join();
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                if (handler.getExitCode() == 0) return;
                throw handler.getCause();
            }
            catch (ThreadDeath threadDeath) {
                if (handler.getProcess() == null) throw threadDeath;
                handler.destroyRemoteProcess();
                throw threadDeath;
            }
        }
        catch (IOException ex) {
            throw new BuildException("Emulator execution failed!");
        }
        catch (InterruptedException ex) {
            throw new BuildException("Emulator execution failed!");
        }
    }

    private String generateHtml() throws BuildException {
        StringWriter sw = new StringWriter();
        PrintWriter pw = null;
        pw = new PrintWriter(sw);
        pw.println("<HTML>");
        pw.println("<HEAD>");
        pw.println("<TITLE> A Testing Program for " + this.mainclass + " </TITLE>");
        pw.println("</HEAD>");
        pw.println("<BODY>");
        pw.println("<APPLET CODE=\"" + this.mainclass + ".class\" WIDTH=250 HEIGHT=350>");
        pw.println("<PARAM NAME=ARCHIVE VALUE=" + this.createClassPath() + "/>");
        pw.println("</APPLET>");
        pw.println("</BODY>");
        pw.println("</HTML>");
        pw.flush();
        return sw.getBuffer().toString();
    }

    private String createClassPath() {
        Iterator it = this.filesets.iterator();
        StringBuffer sb = new StringBuffer();
        while (it.hasNext()) {
            FileSet fs = (FileSet)it.next();
            DirectoryScanner ds = fs.getDirectoryScanner(this.project);
            File basedir = ds.getBasedir();
            String[] files = ds.getIncludedFiles();
            for (int i = 0; i < files.length; ++i) {
                if (!this.runOnDevice) {
                    if (!this.applet) {
                        sb.append("\"" + basedir.getAbsolutePath() + File.separatorChar + files[i] + "\"");
                    } else {
                        sb.append("../dist/" + files[i]);
                    }
                    if (i + 1 >= files.length) continue;
                    sb.append(";");
                    continue;
                }
                try {
                    this.remoteFolder = this.createRemoteFolder(this.remoteDataLocation);
                }
                catch (Exception e) {
                    throw new BuildException("Remote folder can not be created!");
                }
                try {
                    RemoteFile remoteCpItem = new RemoteFile(this.remoteFolder.getFullPath(), files[i]);
                    if (remoteCpItem.exists()) {
                        this.activeSync.delete(remoteCpItem);
                    }
                    this.activeSync.copyToDevice(new File(basedir.getAbsolutePath(), files[i]), remoteCpItem);
                    this.log("Copy classpath element " + files[i] + " into " + this.remoteFolder.getFullPath(), 3);
                }
                catch (IOException ex) {
                    throw new BuildException("Can not copy classpath " + files[i] + " item to remote device!");
                }
                if (!this.applet) {
                    sb.append("'" + this.remoteFolder.getFullPath() + File.separatorChar + files[i] + "'");
                } else {
                    sb.append(files[i]);
                }
                if (i + 1 >= files.length) continue;
                sb.append(";");
            }
        }
        return sb.toString();
    }

    private void appendArguments(List args) {
        if (this.args == null || this.args.length() == 0) {
            return;
        }
        StringTokenizer st = new StringTokenizer(this.args, " ");
        while (st.hasMoreTokens()) {
            args.add(st.nextToken());
        }
    }

    private void outputLog(String line, int messageLevel) {
        if (this.fos == null) {
            this.log(line, messageLevel);
        } else {
            this.fos.println(line);
        }
    }

    private void logFlush() {
        if (this.fos != null) {
            this.fos.close();
        }
    }

    private void checkActiveSync() throws BuildException {
        NSIcomExecDeployTask nSIcomExecDeployTask = this;
        if (!nSIcomExecDeployTask.activeSync.isAvailable()) {
            throw new BuildException("ActiveSync is not installed!");
        }
        this.log("Active sync available", 3);
        try {
            if (!this.activeSync.isDeviceConnected()) {
                throw new BuildException("Device is not connected!");
            }
            this.log("Device connected", 3);
        }
        catch (ActiveSyncException ex) {
            throw new BuildException("Error during connecting to remote device!");
        }
    }

    private void verifyRemoteVM() throws BuildException {
        if (this.remoteVMLocation == null || this.remoteVMLocation.length() == 0) {
            throw new BuildException("Remote VM location must be set!");
        }
        RemoteFile remoteVM = new RemoteFile(this.remoteVMLocation, "");
        if (!remoteVM.exists() || remoteVM.isDirectory()) {
            throw new BuildException("Remote VM does not exist in specified location: " + remoteVM.getFullPath());
        }
        this.log("Remote VM OK", 3);
    }

    private RemoteFile createRemoteFolder(String name) throws ActiveSyncException, IOException {
        StringTokenizer st = new StringTokenizer(name, "/\\");
        RemoteFile root = this.activeSync.getRootFilesystems()[0];
        while (st.hasMoreElements()) {
            name = st.nextToken();
            if (name.length() <= 0) continue;
            RemoteFile next = new RemoteFile(root.getFullPath(), name);
            if (!next.exists()) {
                next = this.activeSync.createNewDirectory(root.getFullPath(), name);
            }
            root = next;
        }
        this.log("Remote folder successfuly created", 3);
        return root;
    }

    public File getHome() {
        return this.home;
    }

    public void setHome(File home) {
        this.home = home;
    }

    public String getMainclass() {
        return this.mainclass;
    }

    public void setMainclass(String mainclass) {
        this.mainclass = mainclass;
    }

    public String getArgs() {
        return this.args;
    }

    public void setArgs(String args) {
        this.args = args;
    }

    public String getJvmargs() {
        return this.jvmargs;
    }

    public void setJvmargs(String jvmargs) {
        this.jvmargs = jvmargs;
    }

    public String getDevice() {
        return this.device;
    }

    public void setDevice(String device) {
        this.device = device;
    }

    public boolean isXlet() {
        return this.xlet;
    }

    public void setXlet(boolean xlet) {
        this.xlet = xlet;
    }

    public boolean isApplet() {
        return this.applet;
    }

    public void setApplet(boolean applet) {
        this.applet = applet;
    }

    public String getDebuggerAddressProperty() {
        return this.debuggerAddressProperty;
    }

    public void setDebuggerAddressProperty(String debuggerAddressProperty) {
        this.debuggerAddressProperty = debuggerAddressProperty;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public String getProfile() {
        return this.profile;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public String getHostIP() {
        return this.hostIP;
    }

    public void setHostIP(String hostIP) {
        this.hostIP = hostIP;
    }

    public boolean isRunOnDevice() {
        return this.runOnDevice;
    }

    public void setRunOnDevice(boolean runOnDevice) {
        this.runOnDevice = runOnDevice;
    }

    public String getRemoteVMLocation() {
        return this.remoteVMLocation;
    }

    public void setRemoteVMLocation(String remoteVMLocation) {
        this.remoteVMLocation = remoteVMLocation;
    }

    public String getRemoteDataLocation() {
        return this.remoteDataLocation;
    }

    public void setRemoteDataLocation(String remoteDataLocation) {
        this.remoteDataLocation = remoteDataLocation;
    }

    public boolean isDeploy() {
        return this.deploy;
    }

    public void setDeploy(boolean deploy) {
        this.deploy = deploy;
    }

    class ProcessHandler
    extends Thread {
        private RemoteProcess process;
        private int exitCode = -1;
        private IOException cause = null;
        private RemoteFile remoteFolder;
        private String[] vmArguments;
        private String vmLocation;
        private RemoteLogReader remoteReader = null;

        public ProcessHandler(String vmLocation, String[] vmArguments, RemoteFile remoteFolder) {
            this.vmLocation = vmLocation;
            this.vmArguments = vmArguments;
            this.remoteFolder = remoteFolder;
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.process = NSIcomExecDeployTask.this.activeSync.executeRemoteProcess(NSIcomExecDeployTask.this.remoteVMLocation, this.vmArguments);
                this.remoteReader = new RemoteLogReader(this.remoteFolder);
                this.remoteReader.start();
                this.exitCode = NSIcomExecDeployTask.this.activeSync.waitFor(this.process);
            }
            catch (ActiveSyncException asEx) {
                this.cause = asEx;
            }
            catch (IOException ioEx) {
                this.cause = ioEx;
            }
            finally {
                if (this.remoteReader != null) {
                    this.remoteReader.finish();
                }
            }
        }

        public int getExitCode() {
            return this.exitCode;
        }

        public IOException getCause() {
            return this.cause;
        }

        public RemoteProcess getProcess() {
            return this.process;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void destroyRemoteProcess() {
            try {
                if (this.process != null) {
                    NSIcomExecDeployTask.this.activeSync.destroyRemoteProcess(this.process);
                }
            }
            catch (ActiveSyncException ex) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            finally {
                if (this.remoteReader != null) {
                    this.remoteReader.finish();
                }
            }
        }
    }

    class StreamReader
    extends Thread {
        private BufferedReader din;
        private int messageLevel;
        private boolean endOfStream = false;
        private int SLEEP_TIME = 5;

        public StreamReader(InputStream is, int messageLevel) {
            this.din = new BufferedReader(new InputStreamReader(is));
            this.messageLevel = messageLevel;
        }

        public void pumpStream() throws IOException {
            if (!this.endOfStream) {
                String line = this.din.readLine();
                if (line != null) {
                    NSIcomExecDeployTask.this.outputLog(line, this.messageLevel);
                } else {
                    this.endOfStream = true;
                }
            }
        }

        public void run() {
            try {
                try {
                    while (!this.endOfStream) {
                        this.pumpStream();
                        StreamReader.sleep(this.SLEEP_TIME);
                    }
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                this.din.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private class RemoteLogReader
    extends Thread {
        private RemoteFile logFile;
        private boolean running = true;

        RemoteLogReader(RemoteFile logFile) {
            this.logFile = logFile;
            this.setDaemon(true);
        }

        public void run() {
            BufferedReader br = null;
            while (this.running) {
                if (br == null && !new RemoteFile(this.logFile.getFullPath(), "jspcout.txt").exists()) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException ex) {}
                    continue;
                }
                try {
                    if (br == null) {
                        InputStream is = NSIcomExecDeployTask.this.activeSync.getRemoteInputStream(new RemoteFile(this.logFile.getFullPath(), "jspcout.txt"));
                        if (is != null) {
                            br = new BufferedReader(new InputStreamReader(is));
                        }
                    } else {
                        String line = br.readLine();
                        if (line != null) {
                            NSIcomExecDeployTask.this.log(line);
                        }
                    }
                    Thread.sleep(5L);
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }

        public void finish() {
            this.running = false;
        }
    }
}

