/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.project.deps;

import org.netbeans.modules.javacard.project.deps.ArtifactKind;
import org.netbeans.modules.javacard.project.deps.DependencyKind;
import org.netbeans.modules.javacard.project.deps.DeploymentStrategy;
import org.openide.util.Parameters;

public final class Dependency {
    private final DependencyKind kind;
    private final DeploymentStrategy strategy;
    private final String id;
    protected static final String DEP_PROPERTY_PREFIX = "dependency.";

    public Dependency(String id, DependencyKind kind, DeploymentStrategy strategy) {
        Parameters.notNull((CharSequence)"id", (Object)id);
        Parameters.notNull((CharSequence)"kind", (Object)((Object)kind));
        Parameters.notNull((CharSequence)"strategy", (Object)((Object)strategy));
        Parameters.notEmpty((CharSequence)"id", (CharSequence)id);
        this.id = id;
        this.kind = kind;
        this.strategy = strategy;
    }

    public static Dependency convert(Dependency orig, DependencyKind newKind) {
        return new Dependency(orig.getID(), newKind, orig.getDeploymentStrategy());
    }

    public String toString() {
        return super.toString() + "[" + this.id + " : " + (Object)((Object)this.kind) + " : " + (Object)((Object)this.strategy) + "]";
    }

    public String getPropertyName(ArtifactKind kind) {
        switch (kind) {
            case SOURCES_PATH: {
                return this.getSourceLocationPropertyName();
            }
            case ORIGIN: {
                return this.getOriginPropertyName();
            }
            case EXP_FILE: {
                return this.getExpFilePropertyName();
            }
            case SIG_FILE: {
                if (this.getKind().supportedArtifacts().contains((Object)kind)) {
                    return this.getSigFilePropertyName();
                }
                throw new IllegalArgumentException((Object)((Object)this.getKind()) + " does not " + "support " + (Object)((Object)kind) + " artifacts");
            }
        }
        throw new AssertionError();
    }

    private String getOriginPropertyName() {
        return DEP_PROPERTY_PREFIX + this.getID() + '.' + "origin";
    }

    private String getSourceLocationPropertyName() {
        return DEP_PROPERTY_PREFIX + this.getID() + '.' + "sourcepath";
    }

    private String getExpFilePropertyName() {
        return DEP_PROPERTY_PREFIX + this.getID() + ".expfile";
    }

    private String getSigFilePropertyName() {
        return DEP_PROPERTY_PREFIX + this.getID() + ".sigfile";
    }

    public DependencyKind getKind() {
        return this.kind;
    }

    public DeploymentStrategy getDeploymentStrategy() {
        return this.strategy;
    }

    public final String getID() {
        return this.id;
    }

    public Dependency copy() {
        return new Dependency(this.id, this.kind, this.strategy);
    }

    public boolean equals(Object o) {
        return o != null && o instanceof Dependency && ((Dependency)o).getID().equals(this.getID());
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + (this.id != null ? this.id.hashCode() : 0);
        hash = 1951 * hash + this.kind.hashCode();
        return hash;
    }
}

