/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.dynamic;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.bind.JAXBException;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.dynamic.DynamicClassLoader;
import org.eclipse.persistence.dynamic.DynamicEntity;
import org.eclipse.persistence.dynamic.DynamicHelper;
import org.eclipse.persistence.dynamic.DynamicType;
import org.eclipse.persistence.dynamic.DynamicTypeBuilder;
import org.eclipse.persistence.internal.descriptors.InstantiationPolicy;
import org.eclipse.persistence.internal.jaxb.JaxbClassLoader;
import org.eclipse.persistence.jaxb.JAXBContext;
import org.eclipse.persistence.jaxb.compiler.Generator;
import org.eclipse.persistence.jaxb.dynamic.metadata.Metadata;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.factories.SessionManager;
import org.eclipse.persistence.sessions.factories.XMLSessionConfigLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicJAXBContext
extends JAXBContext {
    private ArrayList<DynamicHelper> helpers = new ArrayList();
    private DynamicClassLoader dClassLoader;

    DynamicJAXBContext(ClassLoader classLoader) {
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        if (classLoader instanceof DynamicClassLoader) {
            this.dClassLoader = (DynamicClassLoader)classLoader;
        } else {
            JaxbClassLoader jaxbLoader = new JaxbClassLoader(classLoader);
            this.dClassLoader = new DynamicClassLoader(jaxbLoader);
        }
    }

    public DynamicClassLoader getDynamicClassLoader() {
        return this.dClassLoader;
    }

    public DynamicType getDynamicType(String javaName) {
        for (DynamicHelper helper : this.helpers) {
            DynamicType type = helper.getType(javaName);
            if (type == null) continue;
            return type;
        }
        return null;
    }

    public DynamicEntity newDynamicEntity(String javaName) throws IllegalArgumentException {
        IllegalArgumentException ex = null;
        for (DynamicHelper helper : this.helpers) {
            try {
                return helper.newDynamicEntity(javaName);
            }
            catch (IllegalArgumentException e) {
                ex = e;
            }
        }
        throw ex;
    }

    public DynamicEntity newDynamicEntity(DynamicType dynamicType) {
        return dynamicType.newDynamicEntity();
    }

    public Object getEnumConstant(String enumName, String constantName) throws ClassNotFoundException, JAXBException {
        ?[] enumConstants;
        Object valueToReturn = null;
        Class<?> enumClass = this.dClassLoader.loadClass(enumName);
        for (Object enumConstant : enumConstants = enumClass.getEnumConstants()) {
            if (!enumConstant.toString().equals(constantName)) continue;
            valueToReturn = enumConstant;
        }
        if (valueToReturn != null) {
            return valueToReturn;
        }
        throw new JAXBException((Throwable)org.eclipse.persistence.exceptions.JAXBException.enumConstantNotFound(enumName + "." + constantName));
    }

    void initializeFromSessionsXML(String sessionNames, ClassLoader classLoader) {
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        this.dClassLoader = classLoader instanceof DynamicClassLoader ? (DynamicClassLoader)classLoader : new DynamicClassLoader(classLoader);
        StringTokenizer st = new StringTokenizer(sessionNames, ":");
        ArrayList<Project> dynamicProjects = new ArrayList<Project>(st.countTokens());
        XMLSessionConfigLoader loader = new XMLSessionConfigLoader();
        while (st.hasMoreTokens()) {
            DatabaseSession dbSession = (DatabaseSession)((Object)SessionManager.getManager().getSession(loader, st.nextToken(), classLoader, false, true));
            Project p = DynamicTypeBuilder.loadDynamicProject(dbSession.getProject(), null, this.dClassLoader);
            dynamicProjects.add(p);
        }
        this.xmlContext = new XMLContext(dynamicProjects);
        List sessions = this.xmlContext.getSessions();
        for (Session session : sessions) {
            this.helpers.add(new DynamicHelper((DatabaseSession)session));
        }
    }

    void initializeFromMetadata(Metadata metadata, ClassLoader classLoader, Map<String, ?> properties) throws JAXBException {
        Generator g = new Generator(metadata.getJavaModelInput(), metadata.getBindings(), this.dClassLoader, null);
        Project p = null;
        Project dp = null;
        try {
            p = g.generateProject();
            List<ClassDescriptor> descriptors = p.getOrderedDescriptors();
            for (ClassDescriptor classDescriptor : descriptors) {
                classDescriptor.setInstantiationPolicy(new InstantiationPolicy());
            }
            dp = DynamicTypeBuilder.loadDynamicProject(p, null, this.dClassLoader);
        }
        catch (Exception e) {
            throw new JAXBException((Throwable)org.eclipse.persistence.exceptions.JAXBException.errorCreatingDynamicJAXBContext(e));
        }
        this.xmlContext = new XMLContext(dp, (ClassLoader)this.dClassLoader);
        List sessions = this.xmlContext.getSessions();
        for (Session session : sessions) {
            this.helpers.add(new DynamicHelper((DatabaseSession)session));
        }
    }
}

