/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.composer;

import com.sun.perseus.j2d.Box;
import java.awt.Color;
import java.awt.Graphics;
import org.w3c.dom.svg.SVGRect;

public abstract class GraphicUtils {
    public static void drawRoundSelectorCorner(Graphics g, Color outline, Color body, int x, int y, int size) {
        g.setColor(outline);
        g.fillOval(x - size, y - size, size * 2 + 1, size * 2 + 1);
        g.setColor(body);
        g.drawOval(x - (size - 1), y - (size - 1), (size - 1) * 2, (size - 1) * 2);
    }

    public static void drawDiamondSelectorCorner(Graphics g, Color outline, Color body, int x, int y, int size) {
        int[] xs = new int[]{x, x + size, x, x - size};
        int[] ys = new int[]{y - size, y, y + size, y};
        g.setColor(body);
        g.fillPolygon(xs, ys, xs.length);
        g.setColor(outline);
        g.drawPolygon(xs, ys, xs.length);
    }

    public static boolean areNear(float x1, float y1, float x2, float y2, float dist) {
        float dx = x1 - x2;
        float dy = y1 - y2;
        return dx * dx + dy * dy <= dist;
    }

    public static boolean isNearLine(float px, float py, float x0, float y0, float x1, float y1, float dist) {
        double dsqrt = Math.sqrt(dist);
        if ((double)px + dsqrt < (double)Math.min(x0, x1) || (double)px - dsqrt > (double)Math.max(x0, x1)) {
            return false;
        }
        if ((double)py + dsqrt < (double)Math.min(y0, y1) || (double)py - dsqrt > (double)Math.max(y0, y1)) {
            return false;
        }
        double d = GraphicUtils.getPointToLineDistance(px, py, x0, y0, x1, y1);
        return d * d <= dsqrt;
    }

    private static double getPointToLineDistance(float px, float py, float x0, float y0, float x1, float y1) {
        float numerator = (y0 - y1) * px + (x1 - x0) * py + (x0 * y1 - x1 * y0);
        double denominator = Math.sqrt((x1 - x0) * (x1 - x0) + (y1 - y0) * (y1 - y0));
        return Math.abs((double)numerator / denominator);
    }

    public static boolean areEqual(SVGRect rect1, SVGRect rect2) {
        if (rect1 == rect2) {
            return true;
        }
        if (rect1 == null || rect2 == null) {
            return false;
        }
        return rect1.getX() == rect2.getX() && rect1.getY() == rect2.getY() && rect1.getWidth() == rect2.getWidth() && rect1.getHeight() == rect2.getHeight();
    }

    public static SVGRect scale(SVGRect rect, float scale) {
        return new Box(rect.getX() * scale, rect.getY() * scale, rect.getWidth() * scale, rect.getHeight() * scale);
    }

    public static float calcAngle(float x1, float y1, float x2, float y2) {
        float dx = x2 - x1;
        float dy = y2 - y1;
        double angle = 0.0;
        angle = (double)dx == 0.0 ? ((double)dy == 0.0 ? 0.0 : ((double)dy > 0.0 ? 1.5707963267948966 : 4.71238898038469)) : ((double)dy == 0.0 ? ((double)dx > 0.0 ? 0.0 : Math.PI) : ((double)dx < 0.0 ? Math.atan(dy / dx) + Math.PI : ((double)dy < 0.0 ? Math.atan(dy / dx) + Math.PI * 2 : Math.atan(dy / dx))));
        angle = angle * 180.0 / Math.PI;
        return (float)angle;
    }
}

