/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.jsploader;

import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.core.api.ErrorInfo;
import org.netbeans.modules.web.core.api.JspColoringData;
import org.netbeans.modules.web.core.jsploader.TimeReference;
import org.netbeans.modules.web.core.jsploader.api.TagLibParseCookie;
import org.netbeans.modules.web.core.spi.ErrorAnnotation;
import org.netbeans.modules.web.core.spi.ErrorAnnotationFactory;
import org.netbeans.modules.web.jsps.parserapi.JspParserAPI;
import org.netbeans.modules.web.jsps.parserapi.JspParserFactory;
import org.netbeans.modules.web.jsps.parserapi.PageInfo;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public class TagLibParseSupport
implements Node.Cookie,
TagLibParseCookie {
    private FileObject jspFile;
    private boolean documentDirty;
    private RequestProcessor.Task parsingTask = null;
    private static RequestProcessor requestProcessor;
    private WeakReference jspColoringDataRef;
    private TimeReference jspOpenInfoRef;
    private SoftReference parseResultRef;
    private SoftReference parseResultSuccessfulRef;
    private final Object parseResultLock = new Object();
    private final Object openInfoLock = new Object();
    private boolean wasAnEditorPaneChangeEvent = false;
    private boolean parsingTaskCancelled = false;
    private boolean parserStarted = false;
    private ErrorAnnotation annotations;
    private boolean hasError = false;

    public TagLibParseSupport(FileObject jspFile) {
        this.jspFile = jspFile;
        if (requestProcessor == null) {
            requestProcessor = new RequestProcessor("background jsp parsing", 10);
        }
        this.annotations = ErrorAnnotationFactory.Query.create(jspFile);
    }

    public JspColoringData getJSPColoringData() {
        return this.getJSPColoringData(false);
    }

    private WebModule getWebModule(FileObject fo) {
        FileObject wmRoot;
        WebModule wm = WebModule.getWebModule((FileObject)fo);
        if (wm != null && (wmRoot = wm.getDocumentBase()) != null && (fo == wmRoot || FileUtil.isParentOf((FileObject)wmRoot, (FileObject)fo))) {
            return wm;
        }
        return null;
    }

    JspColoringData getJSPColoringData(boolean prepare) {
        Object o;
        if (this.jspColoringDataRef != null && (o = this.jspColoringDataRef.get()) != null) {
            return (JspColoringData)o;
        }
        JspColoringData jcd = new JspColoringData(this);
        this.jspColoringDataRef = new WeakReference<JspColoringData>(jcd);
        if (prepare) {
            this.prepare();
        }
        return jcd;
    }

    @Override
    public void setDocumentDirty(boolean b) {
        this.documentDirty = b;
    }

    @Override
    public boolean isDocumentDirty() {
        return this.documentDirty;
    }

    public RequestProcessor.Task autoParse() {
        if (this.isDocumentDirty() || !this.isParserStarted()) {
            return this.parseObject(1);
        }
        return requestProcessor.post(new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    public RequestProcessor.Task prepare() {
        return this.parseObject(9);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RequestProcessor.Task parseObject(int priority) {
        this.parsingTaskCancelled = false;
        if (!this.wasAnEditorPaneChangeEvent) {
            Exceptions.attachLocalizedMessage((Throwable)new IllegalStateException(), (String)"The TagLibParseSupport.parseObject() is called before editor support is created!");
        }
        Object object = this.parseResultLock;
        synchronized (object) {
            RequestProcessor.Task t = this.parsingTask;
            if (t != null) {
                t.setPriority(Math.max(t.getPriority(), priority));
                return t;
            }
            this.setParserStarted();
            this.setDocumentDirty(false);
            this.parsingTask = t = requestProcessor.post((Runnable)new ParsingRunnable(), 0, priority);
            return this.parsingTask;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setEditorOpened(boolean editorOpened) {
        this.wasAnEditorPaneChangeEvent = true;
        Object object = this.parseResultLock;
        synchronized (object) {
            if (!editorOpened) {
                // empty if block
            }
        }
    }

    void cancelParsingTask() {
        if (this.parsingTask != null) {
            boolean removed = this.parsingTask.cancel();
            this.parsingTask = null;
            this.jspColoringDataRef = null;
        }
        this.parsingTaskCancelled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JspParserAPI.JspOpenInfo getCachedOpenInfo(boolean preferCurrent, boolean useEditor) {
        Object object = this.openInfoLock;
        synchronized (object) {
            JspParserAPI.JspOpenInfo info;
            if (preferCurrent) {
                this.jspOpenInfoRef = null;
            }
            long timestamp = this.jspFile.lastModified().getTime();
            if (this.jspOpenInfoRef == null) {
                this.jspOpenInfoRef = new TimeReference();
            }
            if ((info = (JspParserAPI.JspOpenInfo)this.jspOpenInfoRef.get(timestamp)) == null) {
                info = JspParserFactory.getJspParser().getJspOpenInfo(this.jspFile, this.getWebModule(this.jspFile), useEditor);
                this.jspOpenInfoRef.put(info, timestamp);
            }
            return info;
        }
    }

    @Override
    public TagLibParseCookie.OpenInfo getOpenInfo(boolean preferCurrent, boolean useEditor) {
        JspParserAPI.JspOpenInfo delegate = this.getCachedOpenInfo(preferCurrent, useEditor);
        return TagLibParseCookie.OpenInfo.create(delegate.isXmlSyntax(), delegate.getEncoding());
    }

    public JspParserAPI.ParseResult getCachedParseResult(boolean successfulOnly, boolean preferCurrent) {
        return this.getCachedParseResult(successfulOnly, preferCurrent, false);
    }

    public JspParserAPI.ParseResult getCachedParseResult(boolean successfulOnly, boolean preferCurrent, boolean forceParse) {
        SoftReference myRef;
        boolean needToParse = forceParse;
        if (preferCurrent && this.isDocumentDirty()) {
            needToParse = true;
        }
        if (this.parseResultRef == null) {
            needToParse = true;
        }
        JspParserAPI.ParseResult ret = null;
        SoftReference softReference = myRef = successfulOnly ? this.parseResultSuccessfulRef : this.parseResultRef;
        if (myRef != null) {
            ret = (JspParserAPI.ParseResult)myRef.get();
        }
        if (ret == null && !successfulOnly) {
            needToParse = true;
        }
        if (needToParse) {
            RequestProcessor.Task t = this.prepare();
            t.waitFinished();
            SoftReference softReference2 = myRef = successfulOnly ? this.parseResultSuccessfulRef : this.parseResultRef;
            if (myRef != null) {
                ret = (JspParserAPI.ParseResult)myRef.get();
            }
        }
        return ret;
    }

    private synchronized boolean isParserStarted() {
        return this.parserStarted;
    }

    private synchronized void setParserStarted() {
        this.parserStarted = true;
    }

    private class ParsingRunnable
    implements Runnable {
        JspParserAPI.ParseResult locResult = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (!TagLibParseSupport.this.parsingTaskCancelled && TagLibParseSupport.this.getWebModule(TagLibParseSupport.this.jspFile) != null) {
                JspParserAPI parser = JspParserFactory.getJspParser();
                if (parser == null) {
                    throw new InternalError();
                }
                TagLibParseSupport.this.getJSPColoringData(false).parsingStarted();
                this.locResult = parser.analyzePage(TagLibParseSupport.this.jspFile, TagLibParseSupport.this.getWebModule(TagLibParseSupport.this.jspFile), 1);
                assert (this.locResult != null);
                Object object = TagLibParseSupport.this.parseResultLock;
                synchronized (object) {
                    TagLibParseSupport.this.parseResultRef = new SoftReference<JspParserAPI.ParseResult>(this.locResult);
                    if (this.locResult.isParsingSuccess()) {
                        TagLibParseSupport.this.parseResultSuccessfulRef = new SoftReference<JspParserAPI.ParseResult>(this.locResult);
                        if (TagLibParseSupport.this.hasError) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    TagLibParseSupport.this.annotations.annotate(new ErrorInfo[0]);
                                }
                            });
                            TagLibParseSupport.this.hasError = false;
                        }
                    } else {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ArrayList<ErrorInfo> errors = new ArrayList<ErrorInfo>(ParsingRunnable.this.locResult.getErrors().length);
                                for (int i = 0; i < ParsingRunnable.this.locResult.getErrors().length; ++i) {
                                    JspParserAPI.ErrorDescriptor err = ParsingRunnable.this.locResult.getErrors()[i];
                                    if (!ParsingRunnable.this.checkError(err)) continue;
                                    errors.add(new ErrorInfo(ParsingRunnable.this.translate(err.getErrorMessage()), err.getLine(), err.getColumn(), 1));
                                }
                                TagLibParseSupport.this.annotations.annotate(errors.toArray(new ErrorInfo[0]));
                                if (!TagLibParseSupport.this.hasError) {
                                    TagLibParseSupport.this.hasError = true;
                                }
                            }
                        });
                    }
                    PageInfo pageInfo = this.locResult.getPageInfo();
                    TagLibParseSupport.this.parsingTask = null;
                    if (pageInfo == null) {
                        return;
                    }
                    Map prefixMapper = null;
                    if (pageInfo.getXMLPrefixMapper().size() > 0) {
                        prefixMapper = pageInfo.getApproxXmlPrefixMapper();
                        if (prefixMapper.size() == 0) {
                            prefixMapper = pageInfo.getXMLPrefixMapper();
                        }
                        prefixMapper.putAll(pageInfo.getJspPrefixMapper());
                    } else {
                        prefixMapper = pageInfo.getJspPrefixMapper();
                    }
                    TagLibParseSupport.this.getJSPColoringData(false).applyParsedData(pageInfo.getTagLibraries(), prefixMapper, pageInfo.isELIgnored(), TagLibParseSupport.this.getCachedOpenInfo(false, false).isXmlSyntax(), this.locResult.isParsingSuccess());
                }
            }
        }

        private boolean checkError(JspParserAPI.ErrorDescriptor err) {
            if (err.getErrorMessage() == null) {
                Logger.global.log(Level.INFO, null, new IllegalStateException("Invalid JspParserAPI.ErrorDescription from jsp parser - null error message: " + err.toString()));
                return false;
            }
            return true;
        }

        private String translate(String text) {
            String value = text.replaceAll("&lt;", "<");
            value = value.replaceAll("&gt;", ">");
            return value;
        }
    }
}

