/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb2;

import java.util.logging.Logger;
import org.netbeans.modules.cnd.debugger.common2.debugger.Address;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebugger;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.Handler;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.HandlerCommand;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.HandlerExpert;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.NativeBreakpoint;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.NativeBreakpointType;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.types.FunctionBreakpoint;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.types.InstructionBreakpoint;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.types.LineBreakpoint;
import org.netbeans.modules.cnd.debugger.common2.utils.IpeUtils;
import org.netbeans.modules.cnd.debugger.common2.values.Action;
import org.netbeans.modules.cnd.debugger.common2.values.FunctionSubEvent;
import org.netbeans.modules.cnd.debugger.gdb2.Catalog;
import org.netbeans.modules.cnd.debugger.gdb2.GdbDebuggerImpl;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MIResult;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MITList;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MIValue;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;

public class GdbHandlerExpert
implements HandlerExpert {
    private static final boolean sendShortPaths = Boolean.getBoolean("gdb.breakpoints.shortpaths");
    static final Integer infinity = new Integer(Integer.MAX_VALUE);
    private final GdbDebuggerImpl debugger;
    private static final Logger LOG = Logger.getLogger(GdbHandlerExpert.class.toString());

    public GdbHandlerExpert(GdbDebuggerImpl debugger) {
        this.debugger = debugger;
    }

    Handler newHandler(NativeBreakpoint template, MIResult result, NativeBreakpoint breakpoint) {
        assert (result.variable().equals("bkpt"));
        MIValue bkptValue = result.value();
        MITList props = bkptValue.asTuple();
        if (breakpoint == null) {
            breakpoint = GdbHandlerExpert.createBreakpoint(props, template);
        } else assert (!breakpoint.hasHandler());
        this.update(template, breakpoint, props);
        Handler handler = new Handler((NativeDebugger)this.debugger, breakpoint);
        this.setGenericProperties(handler, props);
        return handler;
    }

    Handler replaceHandler(NativeBreakpoint template, Handler originalHandler, MIResult result) {
        assert (result.variable().equals("bkpt"));
        MIValue bkptValue = result.value();
        MITList props = bkptValue.asTuple();
        NativeBreakpoint breakpoint = originalHandler.breakpoint();
        this.update(template, breakpoint, props);
        Handler handler = new Handler((NativeDebugger)this.debugger, breakpoint);
        this.setGenericProperties(handler, props);
        return handler;
    }

    public HandlerExpert.ReplacementPolicy replacementPolicy() {
        return HandlerExpert.ReplacementPolicy.EXPLICIT;
    }

    public Handler childHandler(NativeBreakpoint bpt) {
        NativeBreakpoint breakpoint = bpt.isToplevel() ? bpt.makeSubBreakpointCopy() : bpt;
        Handler handler = new Handler((NativeDebugger)this.debugger, breakpoint);
        return handler;
    }

    public HandlerCommand commandFormNew(NativeBreakpoint breakpoint) {
        Class<?> bClass;
        if (breakpoint.getAction() != Action.STOP) {
            LOG.warning(Catalog.get("MSG_OnlyStopGdb"));
        }
        if (!IpeUtils.isEmpty((String)breakpoint.getWhileIn())) {
            LOG.warning(Catalog.get("MSG_NoWhileGdb"));
        }
        if (!IpeUtils.isEmpty((String)breakpoint.getLwp())) {
            LOG.warning(Catalog.get("MSG_NoLwpGdb"));
        }
        StringBuilder cmd = new StringBuilder("-break-insert");
        cmd.append(this.debugger.getGdbVersionPeculiarity().breakPendingFlag());
        if (breakpoint.getTemp()) {
            cmd.append(" -t");
        }
        if (breakpoint.getCondition() != null) {
            cmd.append(" -c ").append(GdbHandlerExpert.quote(breakpoint.getCondition()));
        }
        if (breakpoint.hasCountLimit()) {
            if (breakpoint.getCountLimit() == -1L) {
                cmd.append(" -i ").append(infinity);
            } else {
                Long limit = new Long(breakpoint.getCountLimit() - 1L);
                cmd.append(" -i ").append(limit);
            }
        }
        if (breakpoint.getThread() != null) {
            cmd.append(" -p ").append(breakpoint.getThread());
        }
        if ((bClass = breakpoint.getClass()) == LineBreakpoint.class) {
            LineBreakpoint lb = (LineBreakpoint)breakpoint;
            String file = lb.getFileName();
            int line = lb.getLineNumber();
            file = this.debugger.localToRemote("LineBreakpoint", file);
            file = file.replace("\\", "/");
            if (sendShortPaths || file.indexOf(32) != -1) {
                String baseDir = this.debugger.getNDI().getConfiguration().getBaseDir().replace("\\", "/");
                file = file.startsWith(baseDir + '/') ? file.substring(baseDir.length() + 1) : CndPathUtilitities.getBaseName((String)file);
            }
            String fileLine = null;
            fileLine = file != null && file.length() > 0 ? file + ":" + line : "" + line;
            cmd.append(" \"").append(fileLine).append('\"');
        } else if (bClass == InstructionBreakpoint.class) {
            InstructionBreakpoint ib = (InstructionBreakpoint)breakpoint;
            cmd.append(" *").append(ib.getAddress());
        } else if (bClass == FunctionBreakpoint.class) {
            FunctionBreakpoint fb = (FunctionBreakpoint)breakpoint;
            FunctionSubEvent se = fb.getSubEvent();
            String function = null;
            if (se.equals(FunctionSubEvent.IN)) {
                function = fb.getFunction();
            } else {
                if (se.equals(FunctionSubEvent.INFUNCTION)) {
                    return HandlerCommand.makeError(null);
                }
                if (se.equals(FunctionSubEvent.RETURNS)) {
                    return HandlerCommand.makeError(null);
                }
            }
            cmd.append(" \"").append(function).append('\"');
        } else {
            return HandlerCommand.makeError(null);
        }
        return HandlerCommand.makeCommand((String)cmd.toString());
    }

    public HandlerCommand commandFormCustomize(NativeBreakpoint clonedBreakpoint, NativeBreakpoint repairedBreakpoint) {
        return this.commandFormNew(clonedBreakpoint);
    }

    private static NativeBreakpoint createBreakpoint(MITList results, NativeBreakpoint template) {
        NativeBreakpointType type = null;
        type = (NativeBreakpointType)template.getBreakpointType();
        NativeBreakpoint newBreakpoint = null;
        if (type != null) {
            newBreakpoint = type.newInstance(4);
        }
        return newBreakpoint;
    }

    private void update(NativeBreakpoint template, NativeBreakpoint breakpoint, MITList props) {
        breakpoint.removeAnnotations();
        this.setGenericProperties(breakpoint, props);
        this.setSpecificProperties(template, breakpoint, props);
    }

    private void setGenericProperties(Handler handler, MITList props) {
        MIValue enabledValue = props.valueOf("enabled");
        String enabledString = enabledValue.asConst().value();
        if (IpeUtils.sameString((String)enabledString, (String)"y")) {
            handler.setEnabled(true);
        } else if (IpeUtils.sameString((String)enabledString, (String)"n")) {
            handler.setEnabled(false);
        } else {
            handler.setEnabled(false);
        }
        MIValue numberValue = props.valueOf("number");
        String numberString = numberValue.asConst().value();
        int number = Integer.parseInt(numberString);
        handler.setId(number);
    }

    private void setGenericProperties(NativeBreakpoint breakpoint, MITList props) {
        MIValue dispValue = props.valueOf("disp");
        String dispString = dispValue.asConst().value();
        if ("keep".equals(dispString)) {
            breakpoint.setTemp(false);
        } else if ("del".equals(dispString)) {
            breakpoint.setTemp(true);
        } else {
            breakpoint.setTemp(false);
        }
        MIValue ignoreValue = props.valueOf("ignore");
        if (ignoreValue != null) {
            String ignoreString = ignoreValue.asConst().value();
            long ignore = Long.parseLong(ignoreString);
            ignore = ignore == (long)infinity.intValue() ? -1L : ++ignore;
            breakpoint.setCountLimit(ignore, true);
        } else {
            breakpoint.setCountLimit(0L, false);
        }
        MIValue threadValue = props.valueOf("thread");
        if (threadValue != null) {
            String threadString = threadValue.asConst().value();
            breakpoint.setThread(threadString);
        } else {
            breakpoint.setThread(null);
        }
        MIValue condValue = props.valueOf("cond");
        if (condValue != null) {
            String condString = condValue.asConst().value();
            breakpoint.setCondition(condString);
        } else {
            breakpoint.setCondition(null);
        }
        Action action = Action.STOP;
        breakpoint.setAction(action);
    }

    private String getFileName(MITList props, NativeBreakpoint originalBreakpoint) {
        String filename = null;
        MIValue fullnameValue = props.valueOf("fullname");
        String fullnameString = null;
        if (fullnameValue == null) {
            int pos;
            fullnameValue = props.valueOf("pending");
            if (fullnameValue != null && (pos = (fullnameString = fullnameValue.asConst().value()).lastIndexOf(":")) != -1) {
                fullnameString = fullnameString.substring(0, pos);
            }
        } else {
            fullnameString = fullnameValue.asConst().value();
        }
        if (fullnameString != null) {
            fullnameString = this.debugger.remoteToLocal("getFileName", fullnameString);
            filename = fullnameString = this.debugger.fmap().engineToWorld(fullnameString);
        } else {
            MIValue fileValue = props.valueOf("file");
            if (fileValue == null) {
                return null;
            }
            if (originalBreakpoint instanceof LineBreakpoint) {
                LineBreakpoint olb = (LineBreakpoint)originalBreakpoint;
                filename = olb.getFileName();
            }
        }
        return filename;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int getLine(MITList props) {
        String lineString;
        MIValue lineValue = props.valueOf("line");
        if (lineValue == null) {
            MIValue fullnameValue = props.valueOf("pending");
            if (fullnameValue == null) {
                return 0;
            }
            String lineStr = fullnameValue.asConst().value();
            int pos = lineStr.lastIndexOf(":");
            if (pos == -1) return 0;
            lineString = lineStr.substring(pos + 1);
        } else {
            lineString = lineValue.asConst().value();
        }
        try {
            return Integer.parseInt(lineString);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    private static long getAddr(MITList props) {
        MIValue addrValue = props.valueOf("addr");
        if (addrValue == null) {
            return 0L;
        }
        String addrString = addrValue.asConst().value();
        try {
            return Address.parseAddr((String)addrString);
        }
        catch (Exception e) {
            return 0L;
        }
    }

    private void setSpecificProperties(NativeBreakpoint template, NativeBreakpoint breakpoint, MITList props) {
        if (template instanceof LineBreakpoint) {
            LineBreakpoint lb = (LineBreakpoint)breakpoint;
            String filename = this.getFileName(props, template);
            int line = GdbHandlerExpert.getLine(props);
            lb.setFileAndLine(filename, line);
        } else if (template instanceof FunctionBreakpoint) {
            FunctionBreakpoint fb = (FunctionBreakpoint)breakpoint;
            String funcString = ((FunctionBreakpoint)template).getFunction();
            fb.setFunction(funcString);
        } else if (template instanceof InstructionBreakpoint) {
            InstructionBreakpoint ib = (InstructionBreakpoint)breakpoint;
            long addr = GdbHandlerExpert.getAddr(props);
            ib.setAddress(Address.toHexString0x((long)addr, (boolean)true));
        }
    }

    void addAnnotations(Handler handler, NativeBreakpoint breakpoint, NativeBreakpoint template, MIResult result) {
        assert (result.variable().equals("bkpt"));
        MIValue bkptValue = result.value();
        MITList props = bkptValue.asTuple();
        int line = GdbHandlerExpert.getLine(props);
        String fileName = line != 0 ? this.getFileName(props, template) : null;
        long addr = GdbHandlerExpert.getAddr(props);
        if (fileName == null) {
            line = 0;
        }
        handler.breakpoint().addAnnotation(fileName, line, addr);
    }

    private static String quote(String in) {
        StringBuilder out = new StringBuilder();
        out.append('\"');
        for (int sx = 0; sx < in.length(); ++sx) {
            char c = in.charAt(sx);
            if (c == '\"') {
                out.append('\\');
            }
            out.append(c);
        }
        out.append('\"');
        return out.toString();
    }
}

