/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb2;

import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.modules.cnd.debugger.common2.debugger.Log;
import org.netbeans.modules.cnd.debugger.common2.debugger.ModelChangeDelegator;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebugger;
import org.netbeans.modules.cnd.debugger.common2.debugger.Variable;
import org.netbeans.modules.cnd.debugger.common2.debugger.VariableModel;
import org.netbeans.modules.cnd.debugger.common2.debugger.WatchModel;
import org.netbeans.modules.cnd.debugger.gdb2.GdbDebuggerImpl;

class GdbVariable
extends Variable {
    protected final GdbDebuggerImpl debugger;
    private final boolean isWatch;
    private String mi_name;
    private String mi_format = "natural";
    private int numchild;
    private boolean editable;
    private boolean changed;
    private boolean inScope = true;

    public GdbVariable(GdbDebuggerImpl debugger, ModelChangeDelegator updater, Variable parent, String name, String type, String value, boolean watch) {
        super(updater, parent, name, type, value);
        this.debugger = debugger;
        this.isWatch = watch;
    }

    public NativeDebugger getDebugger() {
        return this.debugger;
    }

    protected void setChanged(boolean changed) {
        this.changed = changed;
    }

    protected boolean isChanged() {
        return this.changed;
    }

    public boolean isWatch() {
        return this.isWatch;
    }

    public void setInScope(boolean inScope) {
        this.inScope = inScope;
    }

    public boolean isInScope() {
        return this.inScope;
    }

    public String getAsText() {
        String prefix;
        String string = prefix = Log.Watch.varprefix ? this.mi_name + ": " : "";
        if (this.inScope) {
            String res = super.getAsText();
            if (res != null) {
                res = res.replace("\\\"", "\"");
            }
            return prefix + res;
        }
        return prefix + "<OUT_OF_SCOPE>";
    }

    protected void setEditable(String attr) {
        this.editable = attr.equals("editable");
        if (this.editable && this.numchild > 0) {
            this.setPtr(true);
        }
    }

    public boolean isEditable() {
        return this.editable;
    }

    protected void setMIName(String mi_name) {
        this.mi_name = mi_name;
    }

    public void setValue(String v) {
        this.setAsText(v);
    }

    public String getMIName() {
        return this.mi_name;
    }

    void setFormat(String format) {
        this.mi_format = format;
    }

    protected void setNumChild(String child) {
        this.numchild = Integer.parseInt(child);
        if (this.numchild > 0) {
            this.setLeaf(false);
        } else {
            this.setLeaf(true);
        }
    }

    public int getNumChild() {
        return this.numchild;
    }

    public Variable[] getChildren() {
        if (this.isLeaf()) {
            return new Variable[0];
        }
        if (this.children != null) {
            return this.children;
        }
        if (this.waitingForDebugger) {
            return new Variable[0];
        }
        this.setExpanded(true);
        this.waitingForDebugger = true;
        Runnable r = new Runnable(){

            public void run() {
                try {
                    GdbVariable.this.setChildren();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        SwingUtilities.invokeLater(r);
        return new Variable[0];
    }

    public void setChildren() {
        this.debugger.getMIChildren(this, this.getMIName(), 0);
    }

    public void noteExpanded(boolean isWatch) {
        if (this.isExpanded()) {
            return;
        }
        this.setExpanded(true);
    }

    public void noteCollapsed(boolean isWatch) {
        this.setExpanded(false);
    }

    public void setVariableValue(String assigned_v) {
        if (!assigned_v.equals(this.value)) {
            boolean miName = !"char *".equals(this.type);
            this.debugger.assignVar(this, assigned_v, miName);
        }
    }

    public void removeAllDescendantFromOpenList(boolean isLocal) {
    }

    public String getDebugInfo() {
        return "";
    }

    public boolean getDelta() {
        return false;
    }

    public Action[] getActions(boolean isWatch) {
        VariableModel.OutputFormatAction outputFormatAction = (VariableModel.OutputFormatAction)VariableModel.Action_OUTPUT_FORMAT;
        outputFormatAction.setVar((Variable)this);
        if (isWatch) {
            return new Action[]{WatchModel.NEW_WATCH_ACTION, null, new WatchModel.DeleteAllAction(), null, outputFormatAction, null};
        }
        return new Action[]{outputFormatAction, null};
    }

    public boolean isArrayBrowsable() {
        return false;
    }

    public void postFormat(String format) {
        this.debugger.postVarFormat(this, format);
    }

    public String getFormat() {
        return this.mi_format;
    }
}

