/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb2.mi;

import java.util.LinkedList;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.netbeans.modules.cnd.debugger.gdb2.mi.Log;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MICommand;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MICommandInjector;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MIRecord;

class MICommandManager {
    private final MICommandInjector injector;
    private static final int MIN_TOKEN = 2;
    private static final int MAX_TOKEN = 2147482647;
    private int commandToken = 2;
    private final ConcurrentLinkedQueue<MICommand> pendingCommands = new ConcurrentLinkedQueue();
    private final LinkedList<String> streamMessages = new LinkedList();
    private final LinkedList<String> consoleMessages = new LinkedList();

    public MICommandManager(MICommandInjector injector) {
        this.injector = injector;
    }

    public synchronized void send(MICommand cmd) {
        cmd.setManagerData(this, this.commandToken++);
        if (this.commandToken > 2147482647) {
            this.commandToken = 2;
        }
        this.pendingCommands.add(cmd);
        this.injector.inject(String.valueOf(cmd.getToken()) + cmd.command() + "\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finish(MICommand cmd) {
        this.pendingCommands.remove(cmd);
        if (Log.MI.finish) {
            this.injector.log(String.format("## finished %d\n\r", cmd.getToken()));
            this.injector.log(String.format("## outstanding: ", new Object[0]));
            ConcurrentLinkedQueue<MICommand> concurrentLinkedQueue = this.pendingCommands;
            synchronized (concurrentLinkedQueue) {
                if (this.pendingCommands.isEmpty()) {
                    this.injector.log(String.format("none", new Object[0]));
                } else {
                    for (MICommand oc : this.pendingCommands) {
                        this.injector.log(String.format(" %d", oc.getToken()));
                    }
                }
            }
            this.injector.log(String.format("\n\r", new Object[0]));
        }
    }

    public void dispatch(MIRecord record) {
        int token = record.token();
        MICommand cmd = this.pendingCommands.peek();
        while (cmd != null && cmd.getToken() < token) {
            cmd = this.pendingCommands.poll();
            this.injector.log(String.format("No answer for: %s\n\r", cmd.toString()));
            cmd = this.pendingCommands.peek();
        }
        if (cmd == null || cmd.getToken() != token) {
            this.injector.log(String.format("No command for record %s\n\r", record));
            this.streamMessages.clear();
            this.consoleMessages.clear();
            return;
        }
        record.setCommand(cmd);
        cmd.recordLogStream(this.streamMessages);
        this.streamMessages.clear();
        cmd.recordConsoleStream(this.consoleMessages);
        this.consoleMessages.clear();
        if (record.isError()) {
            this.injector.log(record.error() + "\n\r");
            this.finish(cmd);
            return;
        }
        if (record.type == '^') {
            if (record.cls.equals("done")) {
                cmd.onDone(record);
            } else if (record.cls.equals("running")) {
                cmd.onRunning(record);
            } else if (record.cls.equals("error")) {
                cmd.onError(record);
            } else if (record.cls.equals("exit")) {
                cmd.onExit(record);
            } else {
                cmd.onOther(record);
            }
        } else if (record.type == '*') {
            if (record.cls.equals("stopped")) {
                cmd.onStopped(record);
            } else {
                cmd.onOther(record);
            }
        } else {
            cmd.onOther(record);
        }
    }

    void logStream(String data) {
        this.streamMessages.add(data);
    }

    void logConsole(String data) {
        this.consoleMessages.add(data);
    }

    void clearMessages() {
        this.streamMessages.clear();
        this.consoleMessages.clear();
    }

    void echo(String data) {
        this.injector.log(data);
    }
}

