/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.cplusplus.ext;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.modules.cnd.api.model.CsmType;

public class CsmCompletionExpression {
    private static final int INVALID = -1;
    public static final int CONSTANT = 0;
    public static final int VARIABLE = 1;
    public static final int OPERATOR = 2;
    public static final int UNARY_OPERATOR = 3;
    public static final int DOT = 4;
    public static final int DOT_OPEN = 5;
    public static final int ARRAY_OPEN = 6;
    public static final int ARRAY = 7;
    public static final int PARENTHESIS_OPEN = 8;
    public static final int PARENTHESIS = 9;
    public static final int METHOD_OPEN = 10;
    public static final int METHOD = 11;
    public static final int CONSTRUCTOR = 12;
    public static final int CONVERSION = 13;
    public static final int TYPE = 14;
    public static final int NEW = 15;
    public static final int INSTANCEOF = 16;
    public static final int GENERIC_TYPE = 17;
    public static final int GENERIC_TYPE_OPEN = 18;
    public static final int GENERIC_WILD_CHAR = 19;
    public static final int ANNOTATION = 20;
    public static final int ANNOTATION_OPEN = 21;
    public static final int CPPINCLUDE = 22;
    public static final int CPPINCLUDE_NEXT = 23;
    public static final int CASE = 24;
    public static final int ARROW = 25;
    public static final int ARROW_OPEN = 26;
    public static final int SCOPE = 27;
    public static final int SCOPE_OPEN = 28;
    public static final int TYPE_PREFIX = 29;
    public static final int TYPE_POSTFIX = 30;
    public static final int TYPE_REFERENCE = 31;
    public static final int MEMBER_POINTER = 32;
    public static final int MEMBER_POINTER_OPEN = 33;
    public static final int GOTO = 34;
    public static final int LABEL = 35;
    public static final int CLASSIFIER = 36;
    public static final int CONVERSION_OPEN = 37;
    public static final int PREPROC_DIRECTIVE = 38;
    public static final int PREPROC_DIRECTIVE_OPEN = 39;
    public static final int TERNARY_OPERATOR = 40;
    public static final int FOR = 41;
    public static final int IF = 42;
    public static final int SWITCH = 43;
    public static final int WHILE = 44;
    public static final int SPECIAL_PARENTHESIS = 45;
    public static final int SPECIAL_PARENTHESIS_OPEN = 46;
    private static final int LAST_ID = 46;
    private static final int cppTokenIDsLength = EnumSet.allOf(CppTokenId.class).size();
    private static final int[] OP = new int[cppTokenIDsLength + 46 + 1];
    private static final int RIGHT_ASSOCIATIVE = 32;
    private static final Object[] EMPTY_OBJECT_ARRAY;
    private CsmCompletionExpression parent;
    private int expID;
    private String type;
    private int tokenCountM3;
    private Object[] tokenBlocks = EMPTY_OBJECT_ARRAY;
    private List<CsmCompletionExpression> prmList;
    private CsmType cachedType;

    CsmCompletionExpression(int expID) {
        if (expID < 0 || expID > 46) {
            throw new IllegalArgumentException("expID=" + expID);
        }
        this.expID = expID;
    }

    static CsmCompletionExpression createEmptyVariable(int pos) {
        CsmCompletionExpression empty = new CsmCompletionExpression(1);
        empty.addToken(CppTokenId.IDENTIFIER, pos, "");
        return empty;
    }

    static boolean isSeparatorOrOperator(CppTokenId tokenID) {
        return CndLexerUtilities.isSeparatorOrOperator((CppTokenId)tokenID);
    }

    static int getOperatorID(CppTokenId tokenID) {
        int id = -1;
        if (CsmCompletionExpression.isSeparatorOrOperator(tokenID)) {
            id = tokenID.ordinal();
        } else {
            switch (tokenID) {
                case NEW: {
                    id = cppTokenIDsLength + 15;
                }
            }
        }
        return id;
    }

    static int getOperatorID(CsmCompletionExpression exp) {
        int expID = exp != null ? exp.getExpID() : -1;
        switch (expID) {
            case 2: {
                return exp.getTokenID(0).ordinal();
            }
        }
        return cppTokenIDsLength + expID;
    }

    static int getOperatorPrecedence(int opID) {
        return OP[opID] & 0x1F;
    }

    static boolean isOperatorRightAssociative(int opID) {
        return (OP[opID] & 0x20) != 0;
    }

    static boolean isValidType(CsmCompletionExpression exp) {
        switch (exp.getExpID()) {
            case 7: {
                if (exp.getParameterCount() == 1) {
                    return CsmCompletionExpression.isValidType(exp.getParameter(0));
                }
                return false;
            }
            case 29: 
            case 30: 
            case 31: {
                if (exp.getParameterCount() >= 1) {
                    return CsmCompletionExpression.isValidType(exp.getParameter(0));
                }
                return false;
            }
            case 27: {
                int prmCnt = exp.getParameterCount();
                for (int i = 0; i < prmCnt; ++i) {
                    if (exp.getParameter(i).getExpID() == 1) continue;
                    return false;
                }
                return true;
            }
            case 1: 
            case 14: 
            case 17: {
                return true;
            }
        }
        return false;
    }

    public int getExpID() {
        return this.expID;
    }

    void setExpID(int expID) {
        this.expID = expID;
    }

    public CsmCompletionExpression getParent() {
        return this.parent;
    }

    void setParent(CsmCompletionExpression parent) {
        this.parent = parent;
    }

    public String getType() {
        return this.type;
    }

    void setType(String type) {
        this.type = type;
    }

    public int getTokenCount() {
        return this.tokenCountM3 / 3;
    }

    public String getTokenText(int tokenInd) {
        return (String)this.tokenBlocks[(tokenInd *= 3) + 2];
    }

    public int getTokenOffset(int tokenInd) {
        return (Integer)this.tokenBlocks[(tokenInd *= 3) + 1];
    }

    public int getTokenLength(int tokenInd) {
        return ((String)this.tokenBlocks[(tokenInd *= 3) + 2]).length();
    }

    public CppTokenId getTokenID(int tokenInd) {
        return (CppTokenId)this.tokenBlocks[tokenInd *= 3];
    }

    void addToken(CppTokenId CppTokenId2, int tokenOffset, String tokenText) {
        if (this.tokenCountM3 == this.tokenBlocks.length) {
            Object[] tmp = new Object[Math.max(3, this.tokenBlocks.length * 2)];
            if (this.tokenBlocks.length > 0) {
                System.arraycopy(this.tokenBlocks, 0, tmp, 0, this.tokenBlocks.length);
            }
            this.tokenBlocks = tmp;
        }
        this.tokenBlocks[this.tokenCountM3++] = CppTokenId2;
        this.tokenBlocks[this.tokenCountM3++] = tokenOffset;
        this.tokenBlocks[this.tokenCountM3++] = tokenText;
    }

    public int getParameterCount() {
        return this.prmList != null ? this.prmList.size() : 0;
    }

    public CsmCompletionExpression getParameter(int index) {
        return this.prmList.get(index);
    }

    void addParameter(CsmCompletionExpression prm) {
        if (this.prmList == null) {
            this.prmList = new ArrayList<CsmCompletionExpression>();
        }
        prm.setParent(this);
        this.prmList.add(prm);
    }

    void swapOperatorParms() {
        if ((this.expID == 2 || this.expID == 16) && this.getParameterCount() == 2) {
            CsmCompletionExpression exp1 = this.prmList.remove(0);
            this.prmList.add(exp1);
            exp1.swapOperatorParms();
            this.prmList.get(0).swapOperatorParms();
        }
    }

    private static void appendSpaces(StringBuilder sb, int spaceCount) {
        while (--spaceCount >= 0) {
            sb.append(' ');
        }
    }

    static String getIDName(int expID) {
        switch (expID) {
            case 0: {
                return "CONSTANT";
            }
            case 1: {
                return "VARIABLE";
            }
            case 2: {
                return "OPERATOR";
            }
            case 3: {
                return "UNARY_OPERATOR";
            }
            case 4: {
                return "DOT";
            }
            case 5: {
                return "DOT_OPEN";
            }
            case 25: {
                return "ARROW";
            }
            case 26: {
                return "ARROW_OPEN";
            }
            case 27: {
                return "SCOPE";
            }
            case 28: {
                return "SCOPE_OPEN";
            }
            case 7: {
                return "ARRAY";
            }
            case 6: {
                return "ARRAY_OPEN";
            }
            case 8: {
                return "PARENTHESIS_OPEN";
            }
            case 9: {
                return "PARENTHESIS";
            }
            case 10: {
                return "METHOD_OPEN";
            }
            case 11: {
                return "METHOD";
            }
            case 12: {
                return "CONSTRUCTOR";
            }
            case 13: {
                return "CONVERSION";
            }
            case 14: {
                return "TYPE";
            }
            case 15: {
                return "NEW";
            }
            case 16: {
                return "INSTANCEOF";
            }
            case 17: {
                return "GENERIC_TYPE";
            }
            case 18: {
                return "GENERIC_TYPE_OPEN";
            }
            case 19: {
                return "GENERIC_WILD_CHAR";
            }
            case 20: {
                return "ANNOTATION";
            }
            case 21: {
                return "ANNOTATION_OPEN";
            }
            case 22: {
                return "INCLUDE";
            }
            case 24: {
                return "CASE";
            }
            case 29: {
                return "TYPE_PREFIX";
            }
            case 30: {
                return "TYPE_POSTFIX";
            }
            case 31: {
                return "TYPE_REFERENCE";
            }
            case 32: {
                return "MEMBER_POINTER";
            }
            case 33: {
                return "MEMBER_POINTER_OPEN";
            }
            case 34: {
                return "GOTO";
            }
            case 35: {
                return "LABEL";
            }
            case 36: {
                return "CLASSIFIER";
            }
            case 37: {
                return "CONVERSION_OPEN";
            }
            case 38: {
                return "PREPROC_DIRECTIVE";
            }
            case 39: {
                return "PREPROC_DIRECTIVE_OPEN";
            }
            case 40: {
                return "TERNARY_OPERATOR";
            }
            case 41: {
                return "FOR";
            }
            case 42: {
                return "IF";
            }
            case 43: {
                return "SWITCH";
            }
            case 44: {
                return "WHILE";
            }
            case 45: {
                return "SPECIAL_PARENTHESIS";
            }
            case 46: {
                return "SPECIAL_PARENTHESIS_OPEN";
            }
        }
        return "Unknown expID " + expID;
    }

    public String toString(int indent) {
        StringBuilder sb = new StringBuilder();
        CsmCompletionExpression.appendSpaces(sb, indent);
        sb.append("expID=" + CsmCompletionExpression.getIDName(this.expID));
        if (this.type != null) {
            sb.append(", result type=");
            sb.append(this.type);
        }
        int tokenCnt = this.getTokenCount();
        sb.append(", token count=");
        sb.append(tokenCnt);
        if (tokenCnt > 0) {
            int i = 0;
            while (i < this.tokenCountM3) {
                CppTokenId CppTokenId2 = (CppTokenId)this.tokenBlocks[i++];
                int tokenOffset = (Integer)this.tokenBlocks[i++];
                String tokenText = (String)this.tokenBlocks[i++];
                sb.append(", token" + (i / 3 - 1) + "='" + CsmCompletionExpression.debugString(tokenText) + "'");
            }
        }
        int parmCnt = this.getParameterCount();
        sb.append(", parm count=");
        sb.append(parmCnt);
        if (parmCnt > 0) {
            for (int i = 0; i < parmCnt; ++i) {
                sb.append('\n');
                CsmCompletionExpression.appendSpaces(sb, indent + 4);
                sb.append("parm" + i + "=[" + this.getParameter(i).toString(indent + 4) + "]");
            }
        }
        return sb.toString();
    }

    public String toString() {
        return this.toString(0);
    }

    private static String debugString(String s) {
        return s != null ? CsmCompletionExpression.debugChars(s.toCharArray(), 0, s.length()) : "NULL STRING";
    }

    private static String debugChars(char[] chars, int offset, int len) {
        if (len < 0) {
            return "debugChars() !ERROR! len=" + len + " < 0";
        }
        if (offset < 0) {
            return "debugChars() !ERROR! offset=" + offset + " < 0";
        }
        if (offset + len > chars.length) {
            return "debugChars() !ERROR! offset=" + offset + " + len=" + len + " > chars.length=" + chars.length;
        }
        StringBuilder sb = new StringBuilder(len);
        int endOffset = offset + len;
        while (offset < endOffset) {
            switch (chars[offset]) {
                case '\n': {
                    sb.append("\\n");
                    break;
                }
                case '\t': {
                    sb.append("\\t");
                    break;
                }
                case '\r': {
                    sb.append("\\r");
                    break;
                }
                default: {
                    sb.append(chars[offset]);
                }
            }
            ++offset;
        }
        return sb.toString();
    }

    CsmType getCachedType() {
        return this.cachedType;
    }

    void cacheType(CsmType expType) {
        this.cachedType = expType;
    }

    static {
        CsmCompletionExpression.OP[CppTokenId.EQ.ordinal()] = 34;
        CsmCompletionExpression.OP[CppTokenId.LT.ordinal()] = 10;
        CsmCompletionExpression.OP[CppTokenId.GT.ordinal()] = 10;
        CsmCompletionExpression.OP[CppTokenId.LTLT.ordinal()] = 11;
        CsmCompletionExpression.OP[CppTokenId.GTGT.ordinal()] = 11;
        CsmCompletionExpression.OP[CppTokenId.PLUS.ordinal()] = 12;
        CsmCompletionExpression.OP[CppTokenId.MINUS.ordinal()] = 12;
        CsmCompletionExpression.OP[CppTokenId.STAR.ordinal()] = 13;
        CsmCompletionExpression.OP[CppTokenId.SLASH.ordinal()] = 13;
        CsmCompletionExpression.OP[CppTokenId.AMP.ordinal()] = 8;
        CsmCompletionExpression.OP[CppTokenId.BAR.ordinal()] = 6;
        CsmCompletionExpression.OP[CppTokenId.CARET.ordinal()] = 7;
        CsmCompletionExpression.OP[CppTokenId.PERCENT.ordinal()] = 13;
        CsmCompletionExpression.OP[CppTokenId.NOT.ordinal()] = 15;
        CsmCompletionExpression.OP[CppTokenId.TILDE.ordinal()] = 15;
        CsmCompletionExpression.OP[CppTokenId.EQEQ.ordinal()] = 9;
        CsmCompletionExpression.OP[CppTokenId.LTEQ.ordinal()] = 10;
        CsmCompletionExpression.OP[CppTokenId.GTEQ.ordinal()] = 10;
        CsmCompletionExpression.OP[CppTokenId.LTLTEQ.ordinal()] = 34;
        CsmCompletionExpression.OP[CppTokenId.GTGTEQ.ordinal()] = 34;
        CsmCompletionExpression.OP[CppTokenId.PLUSEQ.ordinal()] = 34;
        CsmCompletionExpression.OP[CppTokenId.MINUSEQ.ordinal()] = 34;
        CsmCompletionExpression.OP[CppTokenId.STAREQ.ordinal()] = 34;
        CsmCompletionExpression.OP[CppTokenId.SLASHEQ.ordinal()] = 34;
        CsmCompletionExpression.OP[CppTokenId.AMPEQ.ordinal()] = 34;
        CsmCompletionExpression.OP[CppTokenId.BAREQ.ordinal()] = 34;
        CsmCompletionExpression.OP[CppTokenId.CARETEQ.ordinal()] = 34;
        CsmCompletionExpression.OP[CppTokenId.PERCENTEQ.ordinal()] = 34;
        CsmCompletionExpression.OP[CppTokenId.NOTEQ.ordinal()] = 9;
        CsmCompletionExpression.OP[CppTokenId.DOT.ordinal()] = 16;
        CsmCompletionExpression.OP[CppTokenId.DOTMBR.ordinal()] = 14;
        CsmCompletionExpression.OP[CppTokenId.ARROW.ordinal()] = 16;
        CsmCompletionExpression.OP[CppTokenId.ARROWMBR.ordinal()] = 14;
        CsmCompletionExpression.OP[CppTokenId.SCOPE.ordinal()] = 18;
        CsmCompletionExpression.OP[CppTokenId.COLON.ordinal()] = 35;
        CsmCompletionExpression.OP[CppTokenId.QUESTION.ordinal()] = 35;
        CsmCompletionExpression.OP[CppTokenId.LBRACKET.ordinal()] = 16;
        CsmCompletionExpression.OP[CppTokenId.RBRACKET.ordinal()] = 0;
        CsmCompletionExpression.OP[CppTokenId.PLUSPLUS.ordinal()] = 16;
        CsmCompletionExpression.OP[CppTokenId.MINUSMINUS.ordinal()] = 16;
        CsmCompletionExpression.OP[CppTokenId.AMPAMP.ordinal()] = 5;
        CsmCompletionExpression.OP[CppTokenId.BARBAR.ordinal()] = 4;
        CsmCompletionExpression.OP[CppTokenId.COMMA.ordinal()] = 0;
        CsmCompletionExpression.OP[CppTokenId.SEMICOLON.ordinal()] = 0;
        CsmCompletionExpression.OP[CppTokenId.LPAREN.ordinal()] = 17;
        CsmCompletionExpression.OP[CppTokenId.RPAREN.ordinal()] = 0;
        CsmCompletionExpression.OP[CppTokenId.LBRACE.ordinal()] = 0;
        CsmCompletionExpression.OP[CppTokenId.RBRACE.ordinal()] = 0;
        CsmCompletionExpression.OP[CsmCompletionExpression.cppTokenIDsLength + -1] = 0;
        CsmCompletionExpression.OP[CsmCompletionExpression.cppTokenIDsLength + 0] = 1;
        CsmCompletionExpression.OP[CsmCompletionExpression.cppTokenIDsLength + 1] = 1;
        CsmCompletionExpression.OP[CsmCompletionExpression.cppTokenIDsLength + 3] = 15;
        CsmCompletionExpression.OP[CsmCompletionExpression.cppTokenIDsLength + 40] = 35;
        CsmCompletionExpression.OP[CsmCompletionExpression.cppTokenIDsLength + 4] = 1;
        CsmCompletionExpression.OP[CsmCompletionExpression.cppTokenIDsLength + 5] = 0;
        CsmCompletionExpression.OP[CsmCompletionExpression.cppTokenIDsLength + 25] = 1;
        CsmCompletionExpression.OP[CsmCompletionExpression.cppTokenIDsLength + 26] = 0;
        CsmCompletionExpression.OP[CsmCompletionExpression.cppTokenIDsLength + 27] = 17;
        CsmCompletionExpression.OP[CsmCompletionExpression.cppTokenIDsLength + 28] = 0;
        CsmCompletionExpression.OP[CsmCompletionExpression.cppTokenIDsLength + 6] = 0;
        CsmCompletionExpression.OP[CsmCompletionExpression.cppTokenIDsLength + 7] = 1;
        CsmCompletionExpression.OP[CsmCompletionExpression.cppTokenIDsLength + 8] = 0;
        CsmCompletionExpression.OP[CsmCompletionExpression.cppTokenIDsLength + 9] = 1;
        CsmCompletionExpression.OP[CsmCompletionExpression.cppTokenIDsLength + 10] = 0;
        CsmCompletionExpression.OP[CsmCompletionExpression.cppTokenIDsLength + 11] = 1;
        CsmCompletionExpression.OP[CsmCompletionExpression.cppTokenIDsLength + 12] = 1;
        CsmCompletionExpression.OP[CsmCompletionExpression.cppTokenIDsLength + 13] = 47;
        CsmCompletionExpression.OP[CsmCompletionExpression.cppTokenIDsLength + 14] = 0;
        CsmCompletionExpression.OP[CsmCompletionExpression.cppTokenIDsLength + 15] = 0;
        CsmCompletionExpression.OP[CsmCompletionExpression.cppTokenIDsLength + 16] = 10;
        CsmCompletionExpression.OP[CsmCompletionExpression.cppTokenIDsLength + 22] = 0;
        CsmCompletionExpression.OP[CsmCompletionExpression.cppTokenIDsLength + 33] = 0;
        CsmCompletionExpression.OP[CsmCompletionExpression.cppTokenIDsLength + 32] = 47;
        CsmCompletionExpression.OP[CsmCompletionExpression.cppTokenIDsLength + 31] = 1;
        CsmCompletionExpression.OP[CsmCompletionExpression.cppTokenIDsLength + 30] = 1;
        CsmCompletionExpression.OP[CsmCompletionExpression.cppTokenIDsLength + 29] = 1;
        EMPTY_OBJECT_ARRAY = new Object[0];
    }
}

