/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.doxygensupport;

import java.io.IOException;
import java.net.URL;
import javax.swing.Action;
import javax.swing.text.Document;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.completion.cplusplus.ext.CsmResultItem;
import org.netbeans.modules.cnd.completion.doxygensupport.DoxygenDocumentation;
import org.netbeans.modules.cnd.completion.doxygensupport.ManDocumentation;
import org.netbeans.modules.cnd.completion.spi.dynhelp.CompletionDocumentationProvider;
import org.netbeans.spi.editor.completion.CompletionDocumentation;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;
import org.openide.util.NbBundle;

public class CompletionDocumentationProviderImpl
implements CompletionDocumentationProvider {
    @Override
    public CompletionDocumentation createDocumentation(CsmObject csmObject, CsmFile csmFile) {
        return CompletionDocumentationProviderImpl.createDocumentationImpl(csmObject, csmFile);
    }

    @Override
    public CompletionTask createDocumentationTask(CompletionItem item) {
        if (!(item instanceof CsmResultItem)) {
            return null;
        }
        CsmObject csmObject = (CsmObject)((CsmResultItem)item).getAssociatedObject();
        CsmFile csmFile = CompletionDocumentationProviderImpl.getCsmFile(csmObject);
        return csmFile == null ? null : new AsyncCompletionTask((AsyncCompletionQuery)new DocQuery(csmObject, csmFile));
    }

    private static CsmFile getCsmFile(CsmObject csmObject) {
        CsmFile csmFile = null;
        if (CsmKindUtilities.isOffsetable((Object)csmObject)) {
            CsmOffsetable csmOffsetable = (CsmOffsetable)csmObject;
            csmFile = csmOffsetable.getContainingFile();
        }
        return csmFile;
    }

    private static CompletionDocumentation createDocumentationImpl(CsmObject obj, CsmFile file) {
        Object bestDocumentation = null;
        DoxygenDocumentation.CompletionDocumentationImpl codeDocumentation = DoxygenDocumentation.create(obj);
        String errorText = null;
        if (codeDocumentation != null && codeDocumentation.getKind() == CppTokenId.DOXYGEN_COMMENT) {
            bestDocumentation = codeDocumentation;
        } else {
            CompletionDocumentation manDocumentation = null;
            try {
                manDocumentation = ManDocumentation.getDocumentation(obj, file);
            }
            catch (IOException ioe) {
                errorText = ioe.getMessage();
            }
            if (manDocumentation != null) {
                bestDocumentation = manDocumentation;
            } else if (codeDocumentation != null) {
                bestDocumentation = codeDocumentation;
                errorText = null;
            }
        }
        if (bestDocumentation == null) {
            StringBuilder w = new StringBuilder();
            w.append("<html><body>");
            w.append("<p>").append(CompletionDocumentationProviderImpl.getString("NO_DOC_FOUND")).append("</p>");
            if (errorText != null) {
                w.append("<p>").append(errorText).append("</p>");
            }
            bestDocumentation = new EmptyCompletionDocumentationImpl(w.toString());
        }
        return bestDocumentation;
    }

    private static String getString(String s) {
        return NbBundle.getBundle(CompletionDocumentationProviderImpl.class).getString(s);
    }

    private static final class EmptyCompletionDocumentationImpl
    implements CompletionDocumentation {
        private final String text;

        public EmptyCompletionDocumentationImpl(String text) {
            this.text = text;
        }

        public String getText() {
            return this.text;
        }

        public URL getURL() {
            return null;
        }

        public CompletionDocumentation resolveLink(String link) {
            return null;
        }

        public Action getGotoSourceAction() {
            return null;
        }
    }

    private static class DocQuery
    extends AsyncCompletionQuery {
        private final CsmObject obj;
        private final CsmFile file;

        public DocQuery(CsmObject obj, CsmFile file) {
            this.obj = obj;
            this.file = file;
        }

        protected void query(CompletionResultSet resultSet, Document doc, int caretOffset) {
            CompletionDocumentation documentation = CompletionDocumentationProviderImpl.createDocumentationImpl(this.obj, this.file);
            if (documentation != null) {
                resultSet.setDocumentation(documentation);
            }
            resultSet.finish();
        }
    }
}

