/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.threadmap.dataprovider;

import java.awt.event.ActionEvent;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.modules.dlight.api.datafilter.DataFilter;
import org.netbeans.modules.dlight.api.datafilter.support.TimeIntervalDataFilter;
import org.netbeans.modules.dlight.api.datafilter.support.TimeIntervalDataFilterFactory;
import org.netbeans.modules.dlight.api.support.DataModelSchemeProvider;
import org.netbeans.modules.dlight.core.stack.api.ThreadDump;
import org.netbeans.modules.dlight.core.stack.api.ThreadDumpProvider;
import org.netbeans.modules.dlight.core.stack.api.ThreadDumpQuery;
import org.netbeans.modules.dlight.core.stack.api.ThreadInfo;
import org.netbeans.modules.dlight.core.stack.api.ThreadSnapshot;
import org.netbeans.modules.dlight.core.stack.api.ThreadSnapshotQuery;
import org.netbeans.modules.dlight.core.stack.api.ThreadState;
import org.netbeans.modules.dlight.core.stack.dataprovider.StackDataProvider;
import org.netbeans.modules.dlight.management.api.DLightManager;
import org.netbeans.modules.dlight.management.api.DLightSession;
import org.netbeans.modules.dlight.msa.support.MSASQLTables;
import org.netbeans.modules.dlight.spi.storage.DataStorage;
import org.netbeans.modules.dlight.spi.storage.ServiceInfoDataStorage;
import org.netbeans.modules.dlight.spi.support.SQLDataStorage;
import org.netbeans.modules.dlight.spi.support.SQLExceptions;
import org.netbeans.modules.dlight.threadmap.api.ThreadData;
import org.netbeans.modules.dlight.threadmap.api.ThreadMapData;
import org.netbeans.modules.dlight.threadmap.api.ThreadMapSummaryData;
import org.netbeans.modules.dlight.threadmap.api.ThreadSummaryData;
import org.netbeans.modules.dlight.threadmap.spi.dataprovider.ThreadMapDataProvider;
import org.netbeans.modules.dlight.threadmap.spi.dataprovider.ThreadMapDataQuery;
import org.netbeans.modules.dlight.threadmap.spi.dataprovider.ThreadMapSummaryDataQuery;
import org.netbeans.modules.dlight.threadmap.storage.ThreadInfoImpl;
import org.netbeans.modules.dlight.threadmap.storage.ThreadStateImpl;
import org.netbeans.modules.dlight.util.DLightLogger;
import org.netbeans.modules.dlight.util.Range;

public class ThreadMapDataProviderImpl
implements ThreadMapDataProvider {
    private static final Logger log = DLightLogger.getLogger(ThreadMapDataProviderImpl.class);
    private SQLDataStorage sqlStorage;
    private PreparedStatement queryDataStatement;
    private static final String[] summaryColNames = new String[]{"", MSASQLTables.msa.LWP_ID.getColumnName(), MSASQLTables.msa.LWP_MSA_USR.getColumnName(), MSASQLTables.msa.LWP_MSA_SYS.getColumnName(), MSASQLTables.msa.LWP_MSA_TRP.getColumnName(), MSASQLTables.msa.LWP_MSA_TFL.getColumnName(), MSASQLTables.msa.LWP_MSA_DFL.getColumnName(), MSASQLTables.msa.LWP_MSA_KFL.getColumnName(), MSASQLTables.msa.LWP_MSA_LCK.getColumnName(), MSASQLTables.msa.LWP_MSA_SLP.getColumnName(), MSASQLTables.msa.LWP_MSA_LAT.getColumnName(), MSASQLTables.msa.LWP_MSA_STP.getColumnName()};
    private PreparedStatement querySummaryStatement;
    private PreparedStatement queryLWPInfo;
    private final HashMap<Integer, ThreadInfo> ti = new HashMap();
    private ThreadDumpProvider threadDumpProvider;

    public synchronized void attachTo(ServiceInfoDataStorage serviceInfoDataStorage) {
        DLightSession session = DLightManager.getDefault().getActiveSession();
        StackDataProvider sdp = (StackDataProvider)session.createDataProvider(DataModelSchemeProvider.getInstance().getScheme("model:threaddump"), null);
        if (sdp != null) {
            this.threadDumpProvider = sdp.getThreadDumpProvider();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized ThreadMapData queryData(ThreadMapDataQuery query) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest(String.format("DataQuery: [%d, %d], fullstate: %s", query.getTimeFrom(), query.getTimeTo(), query.isFullState() ? "yes" : "no"));
        }
        if (this.sqlStorage == null) {
            throw new NullPointerException("No STORAGE");
        }
        final ArrayList<1> data = new ArrayList<1>();
        HashMap lwpStates = new HashMap();
        try {
            this.queryDataStatement.setLong(1, query.getTimeFrom());
            this.queryDataStatement.setLong(2, query.getTimeTo());
            ResultSet rset = this.queryDataStatement.executeQuery();
            try {
                while (rset.next()) {
                    List<ThreadStateImpl> states;
                    ThreadInfo lwpInfo;
                    int threadID = rset.getInt(MSASQLTables.lwps.LWP_ID.getColumnName());
                    if (this.ti.containsKey(threadID)) {
                        lwpInfo = this.ti.get(threadID);
                    } else {
                        lwpInfo = this.getLWPInfo(threadID);
                        this.ti.put(threadID, lwpInfo);
                    }
                    if (lwpStates.containsKey(threadID)) {
                        states = (List)lwpStates.get(threadID);
                    } else {
                        states = new ArrayList();
                        lwpStates.put(threadID, states);
                        data.add(new ThreadData(){

                            @Override
                            public ThreadInfo getThreadInfo() {
                                return lwpInfo;
                            }

                            @Override
                            public List<ThreadState> getThreadState() {
                                return states;
                            }
                        });
                    }
                    long ts = rset.getLong(MSASQLTables.msa.TIMESTAMP.getColumnName());
                    long sample = rset.getLong(MSASQLTables.msa.SAMPLE.getColumnName());
                    long[] stateValues = new long[]{1L, 0L, 0L, rset.getLong(MSASQLTables.msa.LWP_MSA_USR.getColumnName()), rset.getLong(MSASQLTables.msa.LWP_MSA_SYS.getColumnName()), rset.getLong(MSASQLTables.msa.LWP_MSA_TRP.getColumnName()), rset.getLong(MSASQLTables.msa.LWP_MSA_TFL.getColumnName()), rset.getLong(MSASQLTables.msa.LWP_MSA_DFL.getColumnName()), rset.getLong(MSASQLTables.msa.LWP_MSA_KFL.getColumnName()), rset.getLong(MSASQLTables.msa.LWP_MSA_LAT.getColumnName()), rset.getLong(MSASQLTables.msa.LWP_MSA_STP.getColumnName()), rset.getLong(MSASQLTables.msa.LWP_MSA_LCK.getColumnName()), rset.getLong(MSASQLTables.msa.LWP_MSA_SLP.getColumnName())};
                    ThreadStateImpl threadState = new ThreadStateImpl(ts, sample, stateValues);
                    states.add(threadState);
                }
            }
            finally {
                rset.close();
            }
        }
        catch (SQLException ex) {
            SQLExceptions.printStackTrace((SQLDataStorage)this.sqlStorage, (SQLException)ex);
        }
        ThreadMapData tmd = new ThreadMapData(){

            @Override
            public List<ThreadData> getThreadsData() {
                return data;
            }

            @Override
            public boolean isSamplingMode() {
                return false;
            }
        };
        return tmd;
    }

    @Override
    public synchronized ThreadDump getThreadDump(ThreadDumpQuery query) {
        return this.threadDumpProvider == null ? null : this.threadDumpProvider.getThreadDump(query);
    }

    @Override
    public Collection<ThreadSnapshot> getThreadSnapshots(ThreadSnapshotQuery query) {
        return this.threadDumpProvider == null ? null : this.threadDumpProvider.getThreadSnapshots(query);
    }

    public synchronized void attachTo(DataStorage storage) {
        if (storage instanceof SQLDataStorage) {
            this.sqlStorage = (SQLDataStorage)storage;
            String query = String.format("select %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s from %s where %s >= ? and %s < ?", MSASQLTables.msa.TIMESTAMP.getColumnName(), MSASQLTables.msa.SAMPLE.getColumnName(), MSASQLTables.msa.LWP_ID.getColumnName(), MSASQLTables.msa.LWP_MSA_USR.getColumnName(), MSASQLTables.msa.LWP_MSA_SYS.getColumnName(), MSASQLTables.msa.LWP_MSA_TRP.getColumnName(), MSASQLTables.msa.LWP_MSA_TFL.getColumnName(), MSASQLTables.msa.LWP_MSA_DFL.getColumnName(), MSASQLTables.msa.LWP_MSA_KFL.getColumnName(), MSASQLTables.msa.LWP_MSA_LCK.getColumnName(), MSASQLTables.msa.LWP_MSA_SLP.getColumnName(), MSASQLTables.msa.LWP_MSA_LAT.getColumnName(), MSASQLTables.msa.LWP_MSA_STP.getColumnName(), MSASQLTables.msa.tableMetadata.getName(), MSASQLTables.msa.TIMESTAMP.getColumnName(), MSASQLTables.msa.TIMESTAMP.getColumnName());
            try {
                this.queryDataStatement = this.sqlStorage.prepareStatement(query);
            }
            catch (SQLException ex) {
                SQLExceptions.printStackTrace((SQLDataStorage)this.sqlStorage, (SQLException)ex);
            }
            query = String.format("select %s, sum(%s), sum(%s), sum(%s), sum(%s), sum(%s), sum(%s), sum(%s), sum(%s), sum(%s), sum(%s) from %s where %s >= ? and %s < ? group by %s", summaryColNames[1], summaryColNames[2], summaryColNames[3], summaryColNames[4], summaryColNames[5], summaryColNames[6], summaryColNames[7], summaryColNames[8], summaryColNames[9], summaryColNames[10], summaryColNames[11], MSASQLTables.msa.tableMetadata.getName(), MSASQLTables.msa.TIMESTAMP.getColumnName(), MSASQLTables.msa.TIMESTAMP.getColumnName(), MSASQLTables.msa.LWP_ID.getColumnName());
            try {
                this.querySummaryStatement = this.sqlStorage.prepareStatement(query);
            }
            catch (SQLException ex) {
                SQLExceptions.printStackTrace((SQLDataStorage)this.sqlStorage, (SQLException)ex);
            }
            query = String.format("select %s from %s where %s = ?", MSASQLTables.lwps.LWP_START.getColumnName(), MSASQLTables.lwps.tableMetadata.getName(), MSASQLTables.lwps.LWP_ID.getColumnName());
            try {
                this.queryLWPInfo = this.sqlStorage.prepareStatement(query);
            }
            catch (SQLException ex) {
                SQLExceptions.printStackTrace((SQLDataStorage)this.sqlStorage, (SQLException)ex);
            }
            this.ti.clear();
        }
    }

    public void dataFiltersChanged(List<DataFilter> newSet, boolean isAdjusting) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized ThreadInfo getLWPInfo(int lwpID) {
        ThreadInfoImpl lwpInfo = null;
        try {
            this.queryLWPInfo.setInt(1, lwpID);
            ResultSet rset = this.queryLWPInfo.executeQuery();
            try {
                if (rset.next()) {
                    long startts = rset.getLong(1);
                    lwpInfo = new ThreadInfoImpl(lwpID, "Thread " + lwpID, startts);
                }
            }
            finally {
                rset.close();
            }
        }
        catch (SQLException ex) {
            SQLExceptions.printStackTrace((SQLDataStorage)this.sqlStorage, (SQLException)ex);
        }
        return lwpInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized ThreadMapSummaryData queryData(ThreadMapSummaryDataQuery query) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest(String.format("DataQuery: [%s], fullstate: %s", Arrays.toString(query.getIntervals().toArray()), query.isFullState() ? "yes" : "no"));
        }
        if (this.sqlStorage == null) {
            throw new NullPointerException("No STORAGE");
        }
        Collection<TimeIntervalDataFilter> intervals = query.getIntervals();
        if (intervals.isEmpty()) {
            intervals = new ArrayList<TimeIntervalDataFilter>(1);
            intervals.add(TimeIntervalDataFilterFactory.create((Range)new Range((Number)0L, (Number)Long.MAX_VALUE)));
        }
        final ArrayList<4> result = new ArrayList<4>();
        Range interval = intervals.iterator().next().getInterval();
        try {
            this.querySummaryStatement.setLong(1, (Long)interval.getStart());
            this.querySummaryStatement.setLong(2, (Long)interval.getEnd());
            ResultSet rset = this.querySummaryStatement.executeQuery();
            try {
                while (rset.next()) {
                    int threadID = rset.getInt(MSASQLTables.lwps.LWP_ID.getColumnName());
                    final ThreadInfo lwpInfo = this.getLWPInfo(threadID);
                    if (lwpInfo == null) continue;
                    final ArrayList<3> states = new ArrayList<3>();
                    for (int colNum = 2; colNum < 12; ++colNum) {
                        final long stateDuration = rset.getLong(colNum);
                        if (stateDuration <= 0L) continue;
                        final ThreadState.MSAState state = ThreadState.MSAState.fromCode((int)(colNum - 2), (boolean)query.isFullState());
                        states.add(new ThreadSummaryData.StateDuration(){

                            @Override
                            public ThreadState.MSAState getState() {
                                return state;
                            }

                            @Override
                            public long getDuration() {
                                return stateDuration;
                            }

                            public String toString() {
                                return String.format("%s: %dns", state.toString(), stateDuration);
                            }
                        });
                    }
                    result.add(new ThreadSummaryData(){

                        @Override
                        public ThreadInfo getThreadInfo() {
                            return lwpInfo;
                        }

                        @Override
                        public List<ThreadSummaryData.StateDuration> getThreadSummary() {
                            return states;
                        }
                    });
                }
            }
            finally {
                rset.close();
            }
        }
        catch (SQLException ex) {
            SQLExceptions.printStackTrace((SQLDataStorage)this.sqlStorage, (SQLException)ex);
        }
        return new ThreadMapSummaryData(){

            @Override
            public List<ThreadSummaryData> getThreadsData() {
                return result;
            }
        };
    }

    @Override
    public List<ThreadMapDataProvider.ThreadNameDetails> getThreadNameDetails(final int threadID) {
        ArrayList<ThreadMapDataProvider.ThreadNameDetails> res = new ArrayList<ThreadMapDataProvider.ThreadNameDetails>();
        res.add(new ThreadMapDataProvider.ThreadNameDetails(){

            @Override
            public String getName() {
                return "Thread" + threadID;
            }

            @Override
            public Action goToSource() {
                return new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                    }
                };
            }
        });
        return res;
    }
}

