/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jpa.refactoring.rename;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.Tree;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.jpa.refactoring.EntityAnnotationReference;
import org.netbeans.modules.j2ee.jpa.refactoring.EntityAssociationResolver;
import org.netbeans.modules.j2ee.jpa.refactoring.JPARefactoring;
import org.netbeans.modules.j2ee.jpa.refactoring.RefactoringUtil;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.persistence.api.PersistenceScope;
import org.netbeans.modules.j2ee.persistence.api.PersistenceScopes;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.EntityMappingsMetadata;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImplementation;
import org.openide.filesystems.FileObject;
import org.openide.text.PositionBounds;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class EntityRename
implements JPARefactoring {
    private final RenameRefactoring rename;
    private TreePathHandle treePathHandle;

    public EntityRename(RenameRefactoring rename) {
        this.rename = rename;
        try {
            this.treePathHandle = RefactoringUtil.resolveTreePathHandle((AbstractRefactoring)rename);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private PersistenceScope getPersistenceScope() {
        if (this.treePathHandle == null) {
            return null;
        }
        Project project = FileOwnerQuery.getOwner((FileObject)this.treePathHandle.getFileObject());
        if (project == null) {
            return null;
        }
        PersistenceScopes scopes = PersistenceScopes.getPersistenceScopes((Project)project);
        if (scopes == null) {
            return null;
        }
        if (scopes.getPersistenceScopes().length == 0) {
            return null;
        }
        return scopes.getPersistenceScopes()[0];
    }

    private MetadataModel<EntityMappingsMetadata> getEntityMappingsModel() {
        PersistenceScope scope = this.getPersistenceScope();
        return scope != null ? scope.getEntityMappingsModel(null) : null;
    }

    @Override
    public Problem prepare(RefactoringElementsBag refactoringElementsBag) {
        MetadataModel<EntityMappingsMetadata> emModel = this.getEntityMappingsModel();
        if (emModel == null) {
            return null;
        }
        EntityAssociationResolver resolver = new EntityAssociationResolver(this.treePathHandle, emModel);
        try {
            List<EntityAnnotationReference> references = resolver.resolveReferences();
            for (EntityAnnotationReference ref : references) {
                EntityRenameElement element = new EntityRenameElement(ref, this.rename);
                refactoringElementsBag.add((AbstractRefactoring)this.rename, (RefactoringElementImplementation)element);
            }
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
        return null;
    }

    @Override
    public Problem preCheck() {
        return null;
    }

    private static class EntityRenameElement
    extends SimpleRefactoringElementImplementation {
        private final RenameRefactoring rename;
        private final EntityAnnotationReference reference;

        public EntityRenameElement(EntityAnnotationReference reference, RenameRefactoring rename) {
            this.reference = reference;
            this.rename = rename;
        }

        public String getText() {
            return this.getDisplayText();
        }

        public String getDisplayText() {
            Object[] args = new Object[]{this.reference.getHandle().getFileObject().getNameExt(), this.reference.getAttributeValue(), this.rename.getNewName()};
            return MessageFormat.format(NbBundle.getMessage(EntityRename.class, (String)"TXT_EntityAnnotationRename"), args);
        }

        public void performChange() {
            try {
                JavaSource source = JavaSource.forFileObject((FileObject)this.reference.getHandle().getFileObject());
                source.runModificationTask((Task)new CancellableTask<WorkingCopy>(){

                    public void cancel() {
                    }

                    public void run(WorkingCopy workingCopy) throws Exception {
                        workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                        Element element = EntityRenameElement.this.reference.getHandle().resolveElement((CompilationInfo)workingCopy);
                        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
                            if (!annotationMirror.getAnnotationType().toString().equals(EntityRenameElement.this.reference.getAnnotation())) continue;
                            Map<? extends ExecutableElement, ? extends AnnotationValue> values = annotationMirror.getElementValues();
                            TreeMaker make = workingCopy.getTreeMaker();
                            AnnotationTree oldAt = (AnnotationTree)workingCopy.getTrees().getTree(element, annotationMirror);
                            List<? extends ExpressionTree> arguments = oldAt.getArguments();
                            ArrayList<ExpressionTree> newArguments = new ArrayList<ExpressionTree>();
                            Iterator<? extends ExpressionTree> i$ = arguments.iterator();
                            while (i$.hasNext()) {
                                ExpressionTree argument;
                                ExpressionTree tmp = argument = i$.next();
                                if (argument instanceof AssignmentTree) {
                                    AssignmentTree assignment = (AssignmentTree)argument;
                                    ExpressionTree expression = assignment.getExpression();
                                    ExpressionTree variable = assignment.getVariable();
                                    if (expression instanceof LiteralTree) {
                                        LiteralTree literal = (LiteralTree)expression;
                                        String value = literal.getValue().toString();
                                        if (EntityRenameElement.this.reference.getAttributeValue().equals(value)) {
                                            tmp = make.Assignment(variable, (ExpressionTree)make.Literal((Object)EntityRenameElement.this.rename.getNewName()));
                                        }
                                    }
                                }
                                newArguments.add(tmp);
                            }
                            TypeElement typeElement = workingCopy.getElements().getTypeElement(EntityRenameElement.this.reference.getAnnotation());
                            AnnotationTree newAt = make.Annotation((Tree)make.QualIdent((Element)typeElement), newArguments);
                            workingCopy.rewrite((Tree)oldAt, (Tree)newAt);
                        }
                    }
                }).commit();
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
            }
        }

        public Lookup getLookup() {
            return Lookups.singleton((Object)this.reference.getHandle().getFileObject());
        }

        public FileObject getParentFile() {
            return this.reference.getHandle().getFileObject();
        }

        public PositionBounds getPosition() {
            return null;
        }
    }
}

