/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ide.sunresources.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.sun.api.SunDeploymentManagerInterface;
import org.netbeans.modules.j2ee.sun.api.restricted.ResourceUtils;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.Resources;
import org.netbeans.modules.j2ee.sun.ide.sunresources.beans.BaseResourceNode;
import org.netbeans.modules.j2ee.sun.ide.sunresources.resourcesloader.SunResourceDataObject;
import org.netbeans.modules.j2ee.sun.sunresources.beans.WizardConstants;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.awt.StatusDisplayer;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class ListServerInstances
extends JPanel
implements WizardConstants {
    static final ResourceBundle bundle = NbBundle.getBundle(ListServerInstances.class);
    Component initialFocusOwner = null;
    String title;
    Hashtable servers = new Hashtable();
    private JButton applyButton;
    private JButton closeButton;
    private JTextArea msgArea;
    private JTextField serverListCB;

    public ListServerInstances(String _title, SunResourceDataObject dObj, String type, InstanceProperties targetName) {
        this.title = _title;
        this.initComponents(dObj, type, targetName);
    }

    private void initComponents(final SunResourceDataObject resourceObj, final String resType, InstanceProperties targetName) {
        Vector<String> names = new Vector<String>();
        if (targetName == null) {
            this.showInvalidServerError();
            return;
        }
        try {
            SunDeploymentManagerInterface dm = (SunDeploymentManagerInterface)targetName.getDeploymentManager();
            String servName = targetName.getProperty("displayName");
            names.addElement(servName);
            this.servers.put(servName, dm);
        }
        catch (ClassCastException cce) {
            this.showInvalidServerError();
            return;
        }
        JPanel p = new JPanel();
        JLabel nameLabel = new JLabel(bundle.getString("LBL_resource_name"));
        JLabel rsNameLabel = new JLabel(resourceObj.getName());
        this.serverListCB = new JTextField();
        this.serverListCB.setText(" " + names.get(0).toString());
        this.serverListCB.setEditable(false);
        this.serverListCB.getAccessibleContext().setAccessibleName(bundle.getString("LBL_select_server"));
        this.serverListCB.getAccessibleContext().setAccessibleDescription(bundle.getString("LBL_select_server"));
        JLabel selectLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)selectLabel, (String)bundle.getString("LBL_select_server"));
        selectLabel.setLabelFor(this.serverListCB);
        this.msgArea = new JTextArea(4, 1);
        this.msgArea.setLineWrap(true);
        this.msgArea.setWrapStyleWord(true);
        this.msgArea.setEditable(false);
        this.msgArea.setBackground(p.getBackground());
        this.applyButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.applyButton, (String)bundle.getString("LBL_Register"));
        this.applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ListServerInstances.this.applyButton.setEnabled(false);
                ListServerInstances.this.doRegistration(resourceObj, resType);
                ListServerInstances.this.applyButton.setEnabled(true);
            }
        });
        this.closeButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.closeButton, (String)bundle.getString("LBL_Close"));
        p.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        GridBagConstraints gbc1 = new GridBagConstraints();
        gbc1.fill = 2;
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.gridwidth = 3;
        gbc.gridheight = 1;
        gbc1.anchor = 13;
        gbc1.gridwidth = 0;
        gbc.insets = new Insets(12, 12, 10, 0);
        gbc1.insets = new Insets(12, 12, 10, 12);
        p.add((Component)nameLabel, gbc);
        p.add((Component)rsNameLabel, gbc1);
        gbc.insets = new Insets(0, 12, 10, 0);
        gbc1.insets = new Insets(0, 12, 10, 12);
        p.add((Component)selectLabel, gbc);
        p.add((Component)this.serverListCB, gbc1);
        gbc1.gridheight = 2;
        gbc1.weighty = 0.5;
        p.add((Component)new JLabel(""), gbc1);
        gbc.insets = new Insets(0, 12, 10, 12);
        gbc.gridwidth = 4;
        gbc.weightx = 0.5;
        p.add((Component)new JScrollPane(this.msgArea), gbc);
        this.setLayout(new BorderLayout());
        this.add((Component)p, "Center");
        Object[] options = new Object[]{this.applyButton, this.closeButton};
        DialogDescriptor dd = new DialogDescriptor((Object)this, this.title, true, options, (Object)this.applyButton, 0, HelpCtx.findHelp((Component)this), null);
        dd.setClosingOptions(new Object[]{this.closeButton});
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
        dialog.setLocation(350, 350);
        dialog.pack();
        dialog.setVisible(true);
        dialog.getAccessibleContext().setAccessibleName(bundle.getString("DSC_ListServers"));
        dialog.getAccessibleContext().setAccessibleDescription(bundle.getString("DSC_ListServers"));
    }

    public void doRegistration(SunResourceDataObject resourceObj, String resType) {
        String serverNm = this.serverListCB.getText().trim();
        try {
            this.msgArea.setText(bundle.getString("Msg_RegDS"));
            this.setTopManagerStatus(bundle.getString("Msg_RegDS"));
            Resources res = this.getResourceGraph(resourceObj);
            SunDeploymentManagerInterface sunDm = this.getSunDm(serverNm);
            if (res != null) {
                ResourceUtils.register(res, sunDm, false, resType);
                this.setTopManagerStatus(bundle.getString("Msg_RegDone"));
                this.msgArea.setText(bundle.getString("Msg_RegDone"));
            }
        }
        catch (Exception ex) {
            String errorMsg = MessageFormat.format(bundle.getString("Msg_RegFailure"), ex.getLocalizedMessage());
            this.msgArea.setText(errorMsg);
            this.setTopManagerStatus(errorMsg);
        }
    }

    private void setTopManagerStatus(String msg) {
        StatusDisplayer.getDefault().setStatusText(msg);
    }

    private Resources getResourceGraph(SunResourceDataObject resourceObj) {
        BaseResourceNode resNode = (BaseResourceNode)resourceObj.getNodeDelegate();
        return resNode.getBeanGraph();
    }

    private SunDeploymentManagerInterface getSunDm(String serverName) {
        SunDeploymentManagerInterface eightDM = (SunDeploymentManagerInterface)this.servers.get(serverName);
        return eightDM;
    }

    private void showInvalidServerError() {
        NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)bundle.getString("Msg_invalid_server"), 1);
        d.setTitle(bundle.getString("Title_invalid_server"));
        DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
        this.setTopManagerStatus(bundle.getString("Msg_invalid_server"));
    }
}

