/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.editor.hints;

import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.mobility.editor.actions.RecommentAction;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.ErrorManager;
import org.openide.text.NbDocument;
import org.openide.util.NbBundle;

public class RemoveHint
implements Fix {
    protected final int offset;
    protected final BaseDocument doc;

    public RemoveHint(BaseDocument doc, int offset) {
        this.doc = doc;
        this.offset = offset;
    }

    public String getText() {
        return NbBundle.getMessage(RemoveHint.class, (String)"HintInlineRemove");
    }

    public ChangeInfo implement() {
        NbDocument.runAtomic((StyledDocument)((StyledDocument)this.doc), (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    int start = Utilities.getRowStart((BaseDocument)RemoveHint.this.doc, (int)RemoveHint.this.offset);
                    int end = Utilities.getRowEnd((BaseDocument)RemoveHint.this.doc, (int)RemoveHint.this.offset);
                    RemoveHint.this.doc.remove(start, end - start + 1);
                }
                catch (BadLocationException ble) {
                    ErrorManager.getDefault().notify((Throwable)ble);
                }
                RecommentAction.actionPerformed((Document)RemoveHint.this.doc);
            }
        });
        return null;
    }
}

