/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.impl;

import com.thaiopensource.relaxng.impl.NameClass;
import com.thaiopensource.relaxng.impl.OverlapDetector;
import com.thaiopensource.relaxng.impl.RestrictionViolationException;
import java.util.ArrayList;
import java.util.List;

class DuplicateAttributeDetector {
    private final List nameClasses = new ArrayList();
    private Alternative alternatives = null;

    DuplicateAttributeDetector() {
    }

    void addAttribute(NameClass nc) throws RestrictionViolationException {
        int lim = this.nameClasses.size();
        Alternative a = this.alternatives;
        while (a != null) {
            for (int i = a.endIndex; i < lim; ++i) {
                DuplicateAttributeDetector.checkAttributeOverlap(nc, (NameClass)this.nameClasses.get(i));
            }
            lim = a.startIndex;
            a = a.parent;
        }
        for (int i = 0; i < lim; ++i) {
            DuplicateAttributeDetector.checkAttributeOverlap(nc, (NameClass)this.nameClasses.get(i));
        }
        this.nameClasses.add(nc);
    }

    private static void checkAttributeOverlap(NameClass nc1, NameClass nc2) throws RestrictionViolationException {
        OverlapDetector.checkOverlap(nc1, nc2, "duplicate_attribute_name", "duplicate_attribute_ns", "duplicate_attribute");
    }

    void startChoice() {
        this.alternatives = new Alternative(this.nameClasses.size(), this.alternatives);
    }

    void alternative() {
        this.alternatives.endIndex = this.nameClasses.size();
    }

    void endChoice() {
        this.alternatives = this.alternatives.parent;
    }

    private static class Alternative {
        private final int startIndex;
        private int endIndex;
        private final Alternative parent;

        private Alternative(int startIndex, Alternative parent) {
            this.startIndex = startIndex;
            this.endIndex = startIndex;
            this.parent = parent;
        }
    }
}

