/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.palette.items;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.ext.html.parser.SyntaxAnalyzer;
import org.netbeans.editor.ext.html.parser.SyntaxElement;
import org.netbeans.editor.ext.html.parser.api.HtmlSource;
import org.netbeans.modules.html.palette.HtmlPaletteUtilities;
import org.netbeans.modules.html.palette.items.RADIOCustomizer;
import org.openide.text.ActiveEditorDrop;
import org.openide.util.Exceptions;

public class RADIO
implements ActiveEditorDrop {
    private static final int GROUP_DEFAULT = -1;
    private String group = "";
    private int groupIndex = -1;
    private String value = "";
    private boolean selected = false;
    private boolean disabled = false;
    private String[] groups = new String[0];

    public boolean handleTransfer(JTextComponent targetComponent) {
        RADIOCustomizer c;
        boolean accept;
        Document doc = targetComponent.getDocument();
        if (doc instanceof BaseDocument) {
            String oldGN = null;
            if (this.groupIndex >= 0) {
                oldGN = this.groups[this.groupIndex];
            } else if (this.group.length() > 0) {
                oldGN = this.group;
            }
            this.groups = this.findGroups((BaseDocument)doc);
            if (this.groups.length == 0) {
                this.groupIndex = -1;
            }
            if (this.groups.length > 0) {
                this.groupIndex = 0;
                if (this.groupIndex != -1 && oldGN != null) {
                    while (this.groupIndex < this.groups.length && !oldGN.equalsIgnoreCase(this.groups[this.groupIndex])) {
                        ++this.groupIndex;
                    }
                    if (this.groupIndex == this.groups.length) {
                        this.groupIndex = 0;
                    }
                }
            }
        }
        if (accept = (c = new RADIOCustomizer(this)).showDialog()) {
            String body = this.createBody();
            try {
                HtmlPaletteUtilities.insert(body, targetComponent);
            }
            catch (BadLocationException ble) {
                accept = false;
            }
        }
        return accept;
    }

    private String createBody() {
        String strName = " name=\"\"";
        strName = this.groupIndex == -1 ? " name=\"" + this.group + "\"" : " name=\"" + this.groups[this.groupIndex] + "\"";
        String strValue = " value=\"" + this.value + "\"";
        String strSelected = this.selected ? " checked=\"checked\"" : "";
        String strDisabled = this.disabled ? " disabled=\"disabled\"" : "";
        String radioBody = "<input type=\"radio\"" + strName + strValue + strSelected + strDisabled + " />";
        return radioBody;
    }

    private String[] findGroups(final BaseDocument doc) {
        final CharSequence[] content = new CharSequence[1];
        doc.render(new Runnable(){

            @Override
            public void run() {
                try {
                    content[0] = doc.getText(0, doc.getLength());
                }
                catch (BadLocationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        });
        CharSequence code = content[0];
        if (code == null) {
            return new String[0];
        }
        ArrayList<String> names = new ArrayList<String>();
        List elements = SyntaxAnalyzer.create((HtmlSource)new HtmlSource(code)).analyze().getElements().items();
        for (SyntaxElement e : elements) {
            String name;
            SyntaxElement.TagAttribute nameAttr;
            SyntaxElement.TagAttribute typeAttr;
            SyntaxElement.Tag tag;
            if (e.type() != 4 || !(tag = (SyntaxElement.Tag)e).getName().equalsIgnoreCase("input") || (typeAttr = tag.getAttribute("type")) == null || !"radio".equalsIgnoreCase(typeAttr.getValue()) || (nameAttr = tag.getAttribute("name")) == null || (name = nameAttr.getValue()) == null) continue;
            names.add(name);
        }
        return names.toArray(new String[0]);
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public int getGroupIndex() {
        return this.groupIndex;
    }

    public void setGroupIndex(int groupIndex) {
        this.groupIndex = groupIndex;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public String[] getGroups() {
        return this.groups;
    }

    public void setGroups(String[] groups) {
        this.groups = groups;
    }
}

