/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import org.apache.lucene.analysis.tokenattributes.FlagsAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PayloadAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.index.Payload;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.Attribute;
import org.apache.lucene.util.AttributeImpl;
import org.apache.lucene.util.AttributeSource;

public class Token
extends AttributeImpl
implements Cloneable,
TermAttribute,
TypeAttribute,
PositionIncrementAttribute,
FlagsAttribute,
OffsetAttribute,
PayloadAttribute {
    public static final String DEFAULT_TYPE = "word";
    private static int MIN_BUFFER_SIZE = 10;
    private char[] termBuffer;
    private int termLength;
    private int startOffset;
    private int endOffset;
    private String type = "word";
    private int flags;
    private Payload payload;
    private int positionIncrement = 1;
    public static final AttributeSource.AttributeFactory TOKEN_ATTRIBUTE_FACTORY = new TokenAttributeFactory(AttributeSource.AttributeFactory.DEFAULT_ATTRIBUTE_FACTORY);

    public Token() {
    }

    public Token(int start, int end) {
        this.startOffset = start;
        this.endOffset = end;
    }

    public Token(int start, int end, String typ) {
        this.startOffset = start;
        this.endOffset = end;
        this.type = typ;
    }

    public Token(int start, int end, int flags) {
        this.startOffset = start;
        this.endOffset = end;
        this.flags = flags;
    }

    public Token(String text, int start, int end) {
        this.setTermBuffer(text);
        this.startOffset = start;
        this.endOffset = end;
    }

    public Token(String text, int start, int end, String typ) {
        this.setTermBuffer(text);
        this.startOffset = start;
        this.endOffset = end;
        this.type = typ;
    }

    public Token(String text, int start, int end, int flags) {
        this.setTermBuffer(text);
        this.startOffset = start;
        this.endOffset = end;
        this.flags = flags;
    }

    public Token(char[] startTermBuffer, int termBufferOffset, int termBufferLength, int start, int end) {
        this.setTermBuffer(startTermBuffer, termBufferOffset, termBufferLength);
        this.startOffset = start;
        this.endOffset = end;
    }

    public void setPositionIncrement(int positionIncrement) {
        if (positionIncrement < 0) {
            throw new IllegalArgumentException("Increment must be zero or greater: " + positionIncrement);
        }
        this.positionIncrement = positionIncrement;
    }

    public int getPositionIncrement() {
        return this.positionIncrement;
    }

    public final String term() {
        this.initTermBuffer();
        return new String(this.termBuffer, 0, this.termLength);
    }

    public final void setTermBuffer(char[] buffer, int offset, int length) {
        this.growTermBuffer(length);
        System.arraycopy(buffer, offset, this.termBuffer, 0, length);
        this.termLength = length;
    }

    public final void setTermBuffer(String buffer) {
        int length = buffer.length();
        this.growTermBuffer(length);
        buffer.getChars(0, length, this.termBuffer, 0);
        this.termLength = length;
    }

    public final void setTermBuffer(String buffer, int offset, int length) {
        assert (offset <= buffer.length());
        assert (offset + length <= buffer.length());
        this.growTermBuffer(length);
        buffer.getChars(offset, offset + length, this.termBuffer, 0);
        this.termLength = length;
    }

    public final char[] termBuffer() {
        this.initTermBuffer();
        return this.termBuffer;
    }

    public char[] resizeTermBuffer(int newSize) {
        if (this.termBuffer == null) {
            this.termBuffer = new char[ArrayUtil.getNextSize(newSize < MIN_BUFFER_SIZE ? MIN_BUFFER_SIZE : newSize)];
        } else if (this.termBuffer.length < newSize) {
            char[] newCharBuffer = new char[ArrayUtil.getNextSize(newSize)];
            System.arraycopy(this.termBuffer, 0, newCharBuffer, 0, this.termBuffer.length);
            this.termBuffer = newCharBuffer;
        }
        return this.termBuffer;
    }

    private void growTermBuffer(int newSize) {
        if (this.termBuffer == null) {
            this.termBuffer = new char[ArrayUtil.getNextSize(newSize < MIN_BUFFER_SIZE ? MIN_BUFFER_SIZE : newSize)];
        } else if (this.termBuffer.length < newSize) {
            this.termBuffer = new char[ArrayUtil.getNextSize(newSize)];
        }
    }

    private void initTermBuffer() {
        if (this.termBuffer == null) {
            this.termBuffer = new char[ArrayUtil.getNextSize(MIN_BUFFER_SIZE)];
            this.termLength = 0;
        }
    }

    public final int termLength() {
        this.initTermBuffer();
        return this.termLength;
    }

    public final void setTermLength(int length) {
        this.initTermBuffer();
        if (length > this.termBuffer.length) {
            throw new IllegalArgumentException("length " + length + " exceeds the size of the termBuffer (" + this.termBuffer.length + ")");
        }
        this.termLength = length;
    }

    public final int startOffset() {
        return this.startOffset;
    }

    public void setStartOffset(int offset) {
        this.startOffset = offset;
    }

    public final int endOffset() {
        return this.endOffset;
    }

    public void setEndOffset(int offset) {
        this.endOffset = offset;
    }

    public void setOffset(int startOffset, int endOffset) {
        this.startOffset = startOffset;
        this.endOffset = endOffset;
    }

    public final String type() {
        return this.type;
    }

    public final void setType(String type) {
        this.type = type;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public Payload getPayload() {
        return this.payload;
    }

    public void setPayload(Payload payload) {
        this.payload = payload;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        this.initTermBuffer();
        if (this.termBuffer == null) {
            sb.append("null");
        } else {
            sb.append(this.termBuffer, 0, this.termLength);
        }
        sb.append(',').append(this.startOffset).append(',').append(this.endOffset);
        if (!this.type.equals(DEFAULT_TYPE)) {
            sb.append(",type=").append(this.type);
        }
        if (this.positionIncrement != 1) {
            sb.append(",posIncr=").append(this.positionIncrement);
        }
        sb.append(')');
        return sb.toString();
    }

    public void clear() {
        this.payload = null;
        this.termLength = 0;
        this.positionIncrement = 1;
        this.flags = 0;
        this.endOffset = 0;
        this.startOffset = 0;
        this.type = DEFAULT_TYPE;
    }

    public Object clone() {
        Token t = (Token)super.clone();
        if (this.termBuffer != null) {
            t.termBuffer = new char[this.termLength];
            System.arraycopy(this.termBuffer, 0, t.termBuffer, 0, this.termLength);
        }
        if (this.payload != null) {
            t.payload = (Payload)this.payload.clone();
        }
        return t;
    }

    public Token clone(char[] newTermBuffer, int newTermOffset, int newTermLength, int newStartOffset, int newEndOffset) {
        Token t = new Token(newTermBuffer, newTermOffset, newTermLength, newStartOffset, newEndOffset);
        t.positionIncrement = this.positionIncrement;
        t.flags = this.flags;
        t.type = this.type;
        if (this.payload != null) {
            t.payload = (Payload)this.payload.clone();
        }
        return t;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Token) {
            Token other = (Token)obj;
            this.initTermBuffer();
            other.initTermBuffer();
            if (this.termLength == other.termLength && this.startOffset == other.startOffset && this.endOffset == other.endOffset && this.flags == other.flags && this.positionIncrement == other.positionIncrement && this.subEqual(this.type, other.type) && this.subEqual(this.payload, other.payload)) {
                for (int i = 0; i < this.termLength; ++i) {
                    if (this.termBuffer[i] == other.termBuffer[i]) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private boolean subEqual(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o1.equals(o2);
    }

    public int hashCode() {
        this.initTermBuffer();
        int code = this.termLength;
        code = code * 31 + this.startOffset;
        code = code * 31 + this.endOffset;
        code = code * 31 + this.flags;
        code = code * 31 + this.positionIncrement;
        code = code * 31 + this.type.hashCode();
        code = this.payload == null ? code : code * 31 + this.payload.hashCode();
        code = code * 31 + ArrayUtil.hashCode(this.termBuffer, 0, this.termLength);
        return code;
    }

    private void clearNoTermBuffer() {
        this.payload = null;
        this.positionIncrement = 1;
        this.flags = 0;
        this.endOffset = 0;
        this.startOffset = 0;
        this.type = DEFAULT_TYPE;
    }

    public Token reinit(char[] newTermBuffer, int newTermOffset, int newTermLength, int newStartOffset, int newEndOffset, String newType) {
        this.clearNoTermBuffer();
        this.payload = null;
        this.positionIncrement = 1;
        this.setTermBuffer(newTermBuffer, newTermOffset, newTermLength);
        this.startOffset = newStartOffset;
        this.endOffset = newEndOffset;
        this.type = newType;
        return this;
    }

    public Token reinit(char[] newTermBuffer, int newTermOffset, int newTermLength, int newStartOffset, int newEndOffset) {
        this.clearNoTermBuffer();
        this.setTermBuffer(newTermBuffer, newTermOffset, newTermLength);
        this.startOffset = newStartOffset;
        this.endOffset = newEndOffset;
        this.type = DEFAULT_TYPE;
        return this;
    }

    public Token reinit(String newTerm, int newStartOffset, int newEndOffset, String newType) {
        this.clearNoTermBuffer();
        this.setTermBuffer(newTerm);
        this.startOffset = newStartOffset;
        this.endOffset = newEndOffset;
        this.type = newType;
        return this;
    }

    public Token reinit(String newTerm, int newTermOffset, int newTermLength, int newStartOffset, int newEndOffset, String newType) {
        this.clearNoTermBuffer();
        this.setTermBuffer(newTerm, newTermOffset, newTermLength);
        this.startOffset = newStartOffset;
        this.endOffset = newEndOffset;
        this.type = newType;
        return this;
    }

    public Token reinit(String newTerm, int newStartOffset, int newEndOffset) {
        this.clearNoTermBuffer();
        this.setTermBuffer(newTerm);
        this.startOffset = newStartOffset;
        this.endOffset = newEndOffset;
        this.type = DEFAULT_TYPE;
        return this;
    }

    public Token reinit(String newTerm, int newTermOffset, int newTermLength, int newStartOffset, int newEndOffset) {
        this.clearNoTermBuffer();
        this.setTermBuffer(newTerm, newTermOffset, newTermLength);
        this.startOffset = newStartOffset;
        this.endOffset = newEndOffset;
        this.type = DEFAULT_TYPE;
        return this;
    }

    public void reinit(Token prototype) {
        prototype.initTermBuffer();
        this.setTermBuffer(prototype.termBuffer, 0, prototype.termLength);
        this.positionIncrement = prototype.positionIncrement;
        this.flags = prototype.flags;
        this.startOffset = prototype.startOffset;
        this.endOffset = prototype.endOffset;
        this.type = prototype.type;
        this.payload = prototype.payload;
    }

    public void reinit(Token prototype, String newTerm) {
        this.setTermBuffer(newTerm);
        this.positionIncrement = prototype.positionIncrement;
        this.flags = prototype.flags;
        this.startOffset = prototype.startOffset;
        this.endOffset = prototype.endOffset;
        this.type = prototype.type;
        this.payload = prototype.payload;
    }

    public void reinit(Token prototype, char[] newTermBuffer, int offset, int length) {
        this.setTermBuffer(newTermBuffer, offset, length);
        this.positionIncrement = prototype.positionIncrement;
        this.flags = prototype.flags;
        this.startOffset = prototype.startOffset;
        this.endOffset = prototype.endOffset;
        this.type = prototype.type;
        this.payload = prototype.payload;
    }

    public void copyTo(AttributeImpl target) {
        if (target instanceof Token) {
            Token to = (Token)target;
            to.reinit(this);
            if (this.payload != null) {
                to.payload = (Payload)this.payload.clone();
            }
        } else {
            this.initTermBuffer();
            ((TermAttribute)((Object)target)).setTermBuffer(this.termBuffer, 0, this.termLength);
            ((OffsetAttribute)((Object)target)).setOffset(this.startOffset, this.endOffset);
            ((PositionIncrementAttribute)((Object)target)).setPositionIncrement(this.positionIncrement);
            ((PayloadAttribute)((Object)target)).setPayload(this.payload == null ? null : (Payload)this.payload.clone());
            ((FlagsAttribute)((Object)target)).setFlags(this.flags);
            ((TypeAttribute)((Object)target)).setType(this.type);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class TokenAttributeFactory
    extends AttributeSource.AttributeFactory {
        private final AttributeSource.AttributeFactory delegate;

        public TokenAttributeFactory(AttributeSource.AttributeFactory delegate) {
            this.delegate = delegate;
        }

        @Override
        public AttributeImpl createAttributeInstance(Class<? extends Attribute> attClass) {
            return attClass.isAssignableFrom(Token.class) ? new Token() : this.delegate.createAttributeInstance(attClass);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof TokenAttributeFactory) {
                TokenAttributeFactory af = (TokenAttributeFactory)other;
                return this.delegate.equals(af.delegate);
            }
            return false;
        }

        public int hashCode() {
            return this.delegate.hashCode() ^ 0xA45AA31;
        }
    }
}

