/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp.packets;

import org.netbeans.modules.php.dbgp.SessionId;
import org.netbeans.modules.php.dbgp.breakpoints.FunctionBreakpoint;
import org.netbeans.modules.php.dbgp.breakpoints.LineBreakpoint;
import org.netbeans.modules.php.dbgp.packets.BrkpntSetCommand;
import org.openide.filesystems.FileObject;
import org.openide.text.Line;

public class BrkpntCommandBuilder {
    private BrkpntCommandBuilder() {
    }

    public static BrkpntSetCommand buildLineBreakpoint(SessionId id, String transactionId, FileObject localFile, int lineNumber) {
        BrkpntSetCommand command = new BrkpntSetCommand(transactionId);
        String uri = id.toWebServerURI(localFile);
        if (uri == null) {
            return null;
        }
        command.setType(BrkpntSetCommand.Types.LINE);
        command.setFile(uri);
        command.setLineNumber(lineNumber);
        return command;
    }

    public static BrkpntSetCommand buildLineBreakpoint(SessionId id, String transactionId, LineBreakpoint breakpoint) {
        Line line = breakpoint.getLine();
        FileObject fileObject = (FileObject)line.getLookup().lookup(FileObject.class);
        BrkpntSetCommand command = BrkpntCommandBuilder.buildLineBreakpoint(id, transactionId, fileObject, line.getLineNumber());
        if (command != null) {
            command.setBreakpoint(breakpoint);
        }
        return command;
    }

    public static BrkpntSetCommand buildCallBreakpoint(String transactionId, String funcName) {
        BrkpntSetCommand command = new BrkpntSetCommand(transactionId);
        command.setType(BrkpntSetCommand.Types.CALL);
        command.setFunction(funcName);
        return command;
    }

    public static BrkpntSetCommand buildCallBreakpoint(String transactionId, FunctionBreakpoint functionBreakpoint) {
        String func = functionBreakpoint.getFunction();
        BrkpntSetCommand command = BrkpntCommandBuilder.buildCallBreakpoint(transactionId, func);
        command.setBreakpoint(functionBreakpoint);
        return command;
    }

    public static BrkpntSetCommand buildReturnBreakpoint(String transactionId, String funcName) {
        BrkpntSetCommand command = new BrkpntSetCommand(transactionId);
        command.setType(BrkpntSetCommand.Types.RETURN);
        command.setFunction(funcName);
        return command;
    }

    public static BrkpntSetCommand buildReturnBreakpoint(String transactionId, FunctionBreakpoint functionBreakpoint) {
        String func = functionBreakpoint.getFunction();
        BrkpntSetCommand command = BrkpntCommandBuilder.buildReturnBreakpoint(transactionId, func);
        command.setBreakpoint(functionBreakpoint);
        return command;
    }

    public static BrkpntSetCommand buildExceptionBreakpoint(String transactionId, String excName) {
        BrkpntSetCommand command = new BrkpntSetCommand(transactionId);
        command.setType(BrkpntSetCommand.Types.EXCEPTION);
        command.setException(excName);
        return command;
    }

    public static BrkpntSetCommand buildConditionalBreakpoint(String transactionId, String expression) {
        BrkpntSetCommand command = new BrkpntSetCommand(transactionId);
        command.setType(BrkpntSetCommand.Types.WATCH);
        command.setExpression(expression);
        return command;
    }
}

