/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.accordionpanel;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.PhaseId;
import org.primefaces.component.accordionpanel.AccordionPanel;
import org.primefaces.component.tabview.Tab;
import org.primefaces.event.TabChangeEvent;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;

public class AccordionPanelRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        AccordionPanel acco = (AccordionPanel)component;
        Map params = context.getExternalContext().getRequestParameterMap();
        String activeIndex = (String)params.get(acco.getClientId(context) + "_active");
        if (activeIndex != null) {
            if (activeIndex.equals("false")) {
                acco.setActiveIndex(-1);
            } else {
                acco.setActiveIndex(Integer.valueOf(activeIndex));
            }
        }
        if (acco.isTabChangeRequest(context)) {
            TabChangeEvent changeEvent = new TabChangeEvent((UIComponent)acco, acco.findTabToLoad(context));
            changeEvent.setPhaseId(PhaseId.INVOKE_APPLICATION);
            acco.queueEvent(changeEvent);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Map params = context.getExternalContext().getRequestParameterMap();
        AccordionPanel acco = (AccordionPanel)component;
        if (acco.isContentLoadRequest(context)) {
            Tab tabToLoad = acco.findTabToLoad(context);
            tabToLoad.encodeAll(context);
        } else {
            this.encodeMarkup(context, acco);
            this.encodeScript(context, acco);
        }
    }

    protected void encodeMarkup(FacesContext context, AccordionPanel accordionPanel) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = accordionPanel.getClientId(context);
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)clientId, null);
        if (accordionPanel.getStyle() != null) {
            writer.writeAttribute("style", (Object)accordionPanel.getStyle(), null);
        }
        if (accordionPanel.getStyleClass() != null) {
            writer.writeAttribute("class", (Object)accordionPanel.getStyleClass(), null);
        }
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)(clientId + "_acco"), null);
        this.encodeTabs(context, accordionPanel);
        writer.endElement("div");
        this.encodeStateHolder(context, accordionPanel);
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext context, AccordionPanel acco) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = acco.getClientId(context);
        int activeIndex = acco.getActiveIndex();
        boolean hasTabChangeListener = acco.getTabChangeListener() != null;
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write(acco.resolveWidgetVar() + " = new PrimeFaces.widget.AccordionPanel('" + clientId + "', {");
        writer.write("active:" + (activeIndex == -1 ? (Comparable<Boolean>)Boolean.valueOf(false) : (Comparable<Boolean>)Integer.valueOf(activeIndex)));
        writer.write(",dynamic:" + acco.isDynamic());
        writer.write(",animated:'" + acco.getEffect() + "'");
        if (acco.getEvent() != null) {
            writer.write(",event:'" + acco.getEvent() + "'");
        }
        if (!acco.isAutoHeight()) {
            writer.write(",autoHeight:false");
        }
        if (acco.isCollapsible()) {
            writer.write(",collapsible:true");
        }
        if (acco.isFillSpace()) {
            writer.write(",fillSpace:true");
        }
        if (acco.isDisabled()) {
            writer.write(",disabled:true");
        }
        if (acco.getOnTabChange() != null) {
            writer.write(",onTabChange: function(event, ui) {" + acco.getOnTabChange() + "}");
        }
        if (acco.isDynamic() || hasTabChangeListener) {
            writer.write(",url:'" + this.getActionURL(context) + "'");
            writer.write(",cache:" + acco.isCache());
        }
        if (hasTabChangeListener) {
            writer.write(",ajaxTabChange:true");
            if (acco.getOnTabChangeUpdate() != null) {
                writer.write(",onTabChangeUpdate:'" + ComponentUtils.findClientIds(context, (UIComponent)acco, acco.getOnTabChangeUpdate()) + "'");
            }
        }
        writer.write("});");
        writer.endElement("script");
    }

    protected void encodeStateHolder(FacesContext context, AccordionPanel accordionPanel) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = accordionPanel.getClientId(context);
        String stateHolderId = clientId + "_active";
        writer.startElement("input", null);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("id", (Object)stateHolderId, null);
        writer.writeAttribute("name", (Object)stateHolderId, null);
        writer.writeAttribute("value", (Object)accordionPanel.getActiveIndex(), null);
        writer.endElement("input");
    }

    protected void encodeTabs(FacesContext context, AccordionPanel acco) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        int activeIndex = acco.getActiveIndex();
        for (int i = 0; i < acco.getChildCount(); ++i) {
            UIComponent kid = (UIComponent)acco.getChildren().get(i);
            if (!kid.isRendered() || !(kid instanceof Tab)) continue;
            Tab tab = (Tab)kid;
            writer.startElement("h3", null);
            writer.startElement("a", null);
            writer.writeAttribute("href", (Object)"#", null);
            if (tab.getTitle() != null) {
                writer.write(tab.getTitle());
            }
            writer.endElement("a");
            writer.endElement("h3");
            writer.startElement("div", null);
            writer.writeAttribute("id", (Object)kid.getClientId(context), null);
            if (acco.isDynamic()) {
                if (i == activeIndex) {
                    tab.encodeAll(context);
                }
            } else {
                tab.encodeAll(context);
            }
            writer.endElement("div");
        }
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

