/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.chart;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.chart.BaseChartRenderer;
import org.primefaces.component.chart.CartesianChart;
import org.primefaces.component.chart.UIChart;
import org.primefaces.component.chart.series.ChartSeries;
import org.primefaces.model.chart.CartesianChartModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CartesianChartRenderer
extends BaseChartRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        CartesianChart chart = (CartesianChart)component;
        if (chart.isLiveDataRequest(context)) {
            this.encodeData(context, chart, this.getSeries(chart), true);
        } else {
            this.encodeResources(context);
            this.encodeMarkup(context, chart);
            this.encodeScript(context, chart);
        }
    }

    protected void encodeScript(FacesContext context, UIChart uiChart) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        CartesianChart chart = (CartesianChart)uiChart;
        String clientId = chart.getClientId(context);
        List<ChartSeries> series = this.getSeries(chart);
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("jQuery(function(){");
        writer.write(chart.resolveWidgetVar() + " = new " + chart.getChartWidget() + "('" + clientId + "', {");
        this.encodeCommonConfig(context, chart);
        this.encodeAxises(context, chart, clientId);
        this.encodeData(context, chart, series, false);
        this.encodeSeries(context, chart, series);
        this.encodeFields(context, chart, series);
        writer.write("," + chart.getCategoryAxis() + ":'category'");
        writer.write("});});");
        writer.endElement("script");
    }

    protected void encodeData(FacesContext context, CartesianChart chart, List<ChartSeries> series, boolean remote) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        if (remote) {
            writer.write("{");
        } else {
            writer.write(",");
        }
        writer.write("\"data\": [");
        if (chart.hasModel()) {
            CartesianChartModel model = (CartesianChartModel)chart.getModel();
            Iterator<String> iter = model.getCategoryFields().iterator();
            while (iter.hasNext()) {
                String categoryField = iter.next();
                writer.write("{\"category\":\"" + categoryField + "\"");
                for (ChartSeries chartSeries : series) {
                    writer.write(",\"" + chartSeries.getKey() + "\":\"" + chartSeries.getData().get(categoryField) + "\"");
                }
                writer.write("}");
                if (!iter.hasNext()) continue;
                writer.write(",");
            }
        } else {
            Collection value = (Collection)chart.getValue();
            Iterator iterator = value.iterator();
            while (iterator.hasNext()) {
                context.getExternalContext().getRequestMap().put(chart.getVar(), iterator.next());
                Object categoryFieldValue = chart.getValueExpression(chart.getCategoryField()).getValue(context.getELContext());
                writer.write("{\"category\":\"" + categoryFieldValue + "\"");
                for (ChartSeries chartSeries : series) {
                    Object seriesValue = chartSeries.getValueExpression("value").getValue(context.getELContext());
                    writer.write(",\"" + chartSeries.getId() + "\":" + seriesValue);
                }
                writer.write("}");
                if (!iterator.hasNext()) continue;
                writer.write(",");
            }
        }
        writer.write("]");
        if (remote) {
            writer.write("}");
        }
    }

    protected void encodeSeries(FacesContext context, CartesianChart chart, List<ChartSeries> series) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.write(",series:[");
        Iterator<ChartSeries> iterator = series.iterator();
        while (iterator.hasNext()) {
            ChartSeries chartSeries = iterator.next();
            writer.write("{displayName:'" + chartSeries.getLabel() + "'," + chart.getNumericAxis() + ":'" + chartSeries.getKey() + "'");
            if (chartSeries.getStyle() != null) {
                writer.write(",style:" + chartSeries.getStyle());
            }
            writer.write("}");
            if (!iterator.hasNext()) continue;
            writer.write(",");
        }
        writer.write("]");
    }

    protected void encodeAxises(FacesContext context, CartesianChart chart, String clientId) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        if (this.shouldRenderAttribute(chart.getMinY())) {
            writer.write(",minY: " + chart.getMinY());
        }
        if (this.shouldRenderAttribute(chart.getMaxY())) {
            writer.write(",maxY: " + chart.getMaxY());
        }
        if (chart.getTitleX() != null) {
            writer.write(",titleX: '" + chart.getTitleX() + "'");
        }
        if (chart.getTitleY() != null) {
            writer.write(",titleY: '" + chart.getTitleY() + "'");
        }
        if (chart.getLabelFunctionX() != null) {
            writer.write(",labelFunctionX:" + chart.getLabelFunctionX());
        }
        if (chart.getLabelFunctionY() != null) {
            writer.write(",labelFunctionY:" + chart.getLabelFunctionY());
        }
    }

    protected void encodeFields(FacesContext context, CartesianChart chart, List<ChartSeries> series) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.write(",fields:['category'");
        for (ChartSeries chartSeries : series) {
            writer.write(",'" + chartSeries.getKey() + "'");
        }
        writer.write("]");
    }

    protected List<ChartSeries> getSeries(UIChart chart) {
        List<ChartSeries> series = null;
        if (chart.hasModel()) {
            series = ((CartesianChartModel)chart.getModel()).getAllSeries();
        } else {
            List children = chart.getChildren();
            series = new ArrayList<ChartSeries>();
            for (UIComponent component : children) {
                if (!(component instanceof ChartSeries) || !component.isRendered()) continue;
                series.add((ChartSeries)component);
            }
        }
        return series;
    }
}

