/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.datatable;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.model.SelectItem;
import org.primefaces.component.celleditor.CellEditor;
import org.primefaces.component.column.Column;
import org.primefaces.component.columngroup.ColumnGroup;
import org.primefaces.component.columns.Columns;
import org.primefaces.component.datatable.DataHelper;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.component.row.Row;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;

public class DataTableRenderer
extends CoreRenderer {
    private DataHelper dataHelper = new DataHelper();

    public void decode(FacesContext context, UIComponent component) {
        DataTable table = (DataTable)component;
        if (table.isSelectionEnabled()) {
            this.dataHelper.decodeSelection(context, table);
        }
        if (table.isPaginationRequest(context)) {
            this.dataHelper.decodePageRequest(context, table);
        } else if (table.isSortRequest(context)) {
            this.dataHelper.decodeSortRequest(context, table);
        } else if (table.isFilterRequest(context)) {
            this.dataHelper.decodeFilterRequest(context, table);
        } else if (table.isClearFiltersRequest(context)) {
            table.resetValue();
            context.renderResponse();
            return;
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        DataTable table = (DataTable)component;
        if (table.isDataManipulationRequest(context)) {
            this.encodeTbody(context, table);
        } else if (table.isRowExpansionRequest(context)) {
            this.encodeRowExpansion(context, table);
        } else if (table.isRowEditRequest(context)) {
            this.encodeEditedRow(context, table);
        } else if (table.isScrollingRequest(context)) {
            this.encodeLiveRows(context, table);
        } else {
            this.encodeMarkup(context, table);
            this.encodeScript(context, table);
        }
    }

    protected void encodeScript(FacesContext context, DataTable table) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = table.getClientId(context);
        writer.startElement("script", (UIComponent)table);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write(table.resolveWidgetVar() + " = new PrimeFaces.widget.DataTable('" + clientId + "',{");
        UIComponent form = ComponentUtils.findParentForm(context, (UIComponent)table);
        if (form == null) {
            throw new FacesException("DataTable : \"" + clientId + "\" must be inside a form element.");
        }
        writer.write("url:'" + this.getActionURL(context) + "'");
        writer.write(",formId:'" + form.getClientId(context) + "'");
        if (table.isPaginator()) {
            this.encodePaginatorConfig(context, table);
        }
        if (table.isRowSelectionEnabled()) {
            this.encodeSelectionConfig(context, table);
        }
        if (table.isColumnSelectionEnabled()) {
            writer.write(",columnSelectionMode:'" + table.getColumnSelectionMode() + "'");
        }
        if (table.getRowExpansion() != null) {
            writer.write(",expansion:true");
            if (table.getOnExpandStart() != null) {
                writer.write(",onExpandStart:function(row) {" + table.getOnExpandStart() + "}");
            }
        }
        if (table.isScrollable()) {
            writer.write(",scrollable:true");
            writer.write(",liveScroll:" + table.isLiveScroll());
            writer.write(",scrollStep:" + table.getRows());
            writer.write(",scrollLimit:" + table.getRowCount());
            if (table.getHeight() != Integer.MIN_VALUE) {
                writer.write(",height:" + table.getHeight());
            }
        }
        if (table.getOnRowEditUpdate() != null) {
            writer.write(",onRowEditUpdate:'" + ComponentUtils.findClientIds(context, form, table.getOnRowEditUpdate()) + "'");
        }
        writer.write("});");
        writer.endElement("script");
    }

    protected void encodeMarkup(FacesContext context, DataTable table) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = table.getClientId(context);
        boolean scrollable = table.isScrollable();
        String containerClass = scrollable ? "ui-datatable ui-widget ui-datatable-scrollable" : "ui-datatable ui-widget";
        containerClass = table.getStyleClass() != null ? containerClass + " " + table.getStyleClass() : containerClass;
        String style = null;
        boolean hasPaginator = table.isPaginator();
        String paginatorPosition = table.getPaginatorPosition();
        if (hasPaginator) {
            table.calculatePage();
        }
        writer.startElement("div", (UIComponent)table);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)containerClass, "styleClass");
        style = table.getStyle();
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        this.encodeFacet(context, table, table.getHeader(), "ui-datatable-header ui-widget-header ui-corner-tl ui-corner-tr");
        if (hasPaginator && !paginatorPosition.equalsIgnoreCase("bottom")) {
            this.encodePaginatorMarkup(context, table, "top");
        }
        if (scrollable) {
            this.encodeScrollableTable(context, table);
        } else {
            this.encodeRegularTable(context, table);
        }
        if (hasPaginator && !paginatorPosition.equalsIgnoreCase("top")) {
            this.encodePaginatorMarkup(context, table, "bottom");
        }
        this.encodeFacet(context, table, table.getFooter(), "ui-datatable-footer ui-widget-header ui-corner-bl ui-corner-br");
        if (table.isSelectionEnabled()) {
            this.encodeSelectionHolder(context, table);
        }
        writer.endElement("div");
    }

    protected void encodeRegularTable(FacesContext context, DataTable table) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("table", null);
        this.encodeThead(context, table);
        this.encodeTbody(context, table);
        this.encodeTFoot(context, table);
        writer.endElement("table");
    }

    protected void encodeScrollableTable(FacesContext context, DataTable table) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-datatable-scrollable-header", null);
        writer.startElement("table", null);
        this.encodeThead(context, table);
        writer.endElement("table");
        writer.endElement("div");
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-datatable-scrollable-body", null);
        writer.writeAttribute("style", (Object)("height:" + table.getHeight() + "px"), null);
        writer.startElement("table", null);
        this.encodeTbody(context, table);
        writer.endElement("table");
        writer.endElement("div");
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-datatable-scrollable-footer", null);
        writer.startElement("table", null);
        this.encodeTFoot(context, table);
        writer.endElement("table");
        writer.endElement("div");
    }

    protected void encodeColumnHeader(FacesContext context, DataTable table, Column column) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = column.getClientId(context);
        boolean isSortable = column.getValueExpression("sortBy") != null;
        boolean hasFilter = column.getValueExpression("filterBy") != null;
        String selectionMode = column.getSelectionMode();
        String style = column.getStyle();
        String styleClass = column.getStyleClass();
        String columnClass = isSortable ? "ui-state-default ui-sortable-column" : "ui-state-default";
        columnClass = selectionMode != null ? columnClass + " " + "ui-selection-column" : columnClass;
        columnClass = styleClass != null ? columnClass + " " + styleClass : columnClass;
        writer.startElement("th", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)columnClass, null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        if (column.getRowspan() != 1) {
            writer.writeAttribute("rowspan", (Object)column.getRowspan(), null);
        }
        if (column.getColspan() != 1) {
            writer.writeAttribute("colspan", (Object)column.getColspan(), null);
        }
        if (isSortable) {
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)"ui-sortable-column-icon ui-icon ui-icon-carat-2-n-s", null);
            writer.endElement("span");
        }
        UIComponent header = column.getFacet("header");
        String headerText = column.getHeaderText();
        if (selectionMode != null && selectionMode.equalsIgnoreCase("multiple")) {
            writer.startElement("input", header);
            writer.writeAttribute("type", (Object)"checkbox", null);
            writer.writeAttribute("name", (Object)(clientId + "_checkAll"), null);
            writer.writeAttribute("onclick", (Object)(table.resolveWidgetVar() + ".toggleCheckAll(this)"), null);
            writer.endElement("input");
        } else if (header != null) {
            header.encodeAll(context);
        } else if (headerText != null) {
            writer.write(headerText);
        }
        if (hasFilter) {
            this.encodeFilter(context, table, column);
        }
        writer.endElement("th");
    }

    protected void encodeColumnsHeader(FacesContext context, DataTable table, Columns columns) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String columnVar = columns.getVar();
        for (Object column : (Collection)columns.getValue()) {
            context.getExternalContext().getRequestMap().put(columnVar, column);
            UIComponent header = columns.getFacet("header");
            writer.startElement("th", null);
            writer.writeAttribute("class", (Object)"ui-state-default", null);
            if (header != null) {
                header.encodeAll(context);
            }
            writer.endElement("th");
        }
        context.getExternalContext().getRequestMap().remove(columnVar);
    }

    protected void encodeFilter(FacesContext context, DataTable table, Column column) throws IOException {
        Map params = context.getExternalContext().getRequestParameterMap();
        ResponseWriter writer = context.getResponseWriter();
        String widgetVar = table.resolveWidgetVar();
        String filterId = column.getClientId(context) + "_filter";
        String filterFunction = widgetVar + ".filter()";
        String filterStyleClass = column.getFilterStyleClass();
        String string = filterStyleClass = filterStyleClass == null ? "ui-column-filter" : "ui-column-filter " + filterStyleClass;
        if (column.getValueExpression("filterOptions") == null) {
            String filterEvent = "on" + column.getFilterEvent();
            String filterValue = params.containsKey(filterId) ? (String)params.get(filterId) : "";
            writer.startElement("input", null);
            writer.writeAttribute("id", (Object)filterId, null);
            writer.writeAttribute("name", (Object)filterId, null);
            writer.writeAttribute("class", (Object)filterStyleClass, null);
            writer.writeAttribute("value", (Object)filterValue, null);
            writer.writeAttribute(filterEvent, (Object)filterFunction, null);
            if (column.getFilterStyle() != null) {
                writer.writeAttribute("style", (Object)column.getFilterStyle(), null);
            }
            writer.endElement("input");
        } else {
            SelectItem[] itemsArray;
            writer.startElement("select", null);
            writer.writeAttribute("id", (Object)filterId, null);
            writer.writeAttribute("name", (Object)filterId, null);
            writer.writeAttribute("class", (Object)filterStyleClass, null);
            writer.writeAttribute("onchange", (Object)filterFunction, null);
            for (SelectItem item : itemsArray = this.getFilterOptions(column)) {
                writer.startElement("option", null);
                writer.writeAttribute("value", item.getValue(), null);
                writer.write(item.getLabel());
                writer.endElement("option");
            }
            writer.endElement("select");
        }
    }

    protected SelectItem[] getFilterOptions(Column column) {
        Object options = column.getFilterOptions();
        if (options instanceof SelectItem[]) {
            return (SelectItem[])options;
        }
        if (options instanceof Collection) {
            return ((Collection)column.getFilterOptions()).toArray(new SelectItem[0]);
        }
        throw new FacesException("Filter options for column " + column.getClientId() + " should be a SelectItem array or collection");
    }

    protected void encodeColumnFooter(FacesContext context, DataTable table, Column column) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String style = column.getStyle();
        String styleClass = column.getStyleClass();
        String footerClass = styleClass != null ? "ui-state-default " + styleClass : "ui-state-default";
        writer.startElement("td", null);
        writer.writeAttribute("class", (Object)footerClass, null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        if (column.getRowspan() != 1) {
            writer.writeAttribute("rowspan", (Object)column.getRowspan(), null);
        }
        if (column.getColspan() != 1) {
            writer.writeAttribute("colspan", (Object)column.getColspan(), null);
        }
        UIComponent facet = column.getFacet("footer");
        String text = column.getFooterText();
        if (facet != null) {
            facet.encodeAll(context);
        } else if (text != null) {
            writer.write(text);
        }
        writer.endElement("td");
    }

    protected void encodeThead(FacesContext context, DataTable table) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        ColumnGroup group = table.getColumnGroup("header");
        writer.startElement("thead", null);
        if (group != null) {
            for (UIComponent child : group.getChildren()) {
                if (!child.isRendered() || !(child instanceof Row)) continue;
                Row headerRow = (Row)child;
                writer.startElement("tr", null);
                for (UIComponent headerRowChild : headerRow.getChildren()) {
                    if (!headerRowChild.isRendered() || !(headerRowChild instanceof Column)) continue;
                    this.encodeColumnHeader(context, table, (Column)headerRowChild);
                }
                writer.endElement("tr");
            }
        } else {
            writer.startElement("tr", null);
            for (UIComponent kid : table.getChildren()) {
                if (!kid.isRendered()) continue;
                if (kid instanceof Column) {
                    this.encodeColumnHeader(context, table, (Column)kid);
                    continue;
                }
                if (!(kid instanceof Columns)) continue;
                this.encodeColumnsHeader(context, table, (Columns)kid);
            }
            writer.endElement("tr");
        }
        writer.endElement("thead");
    }

    protected void encodeTbody(FacesContext context, DataTable table) throws IOException {
        boolean hasData;
        ResponseWriter writer = context.getResponseWriter();
        String rowIndexVar = table.getRowIndexVar();
        String clientId = table.getClientId(context);
        String emptyMessage = table.getEmptyMessage();
        String selectionMode = table.getSelectionMode();
        String columnSelectionMode = table.getColumnSelectionMode();
        String selMode = selectionMode != null ? selectionMode : (columnSelectionMode != null ? columnSelectionMode : null);
        Object selection = table.getSelection();
        int rows = table.getRows();
        int first = table.getFirst();
        int rowCount = table.getRowCount();
        int rowCountToRender = rows == 0 ? rowCount : rows;
        boolean bl = hasData = rowCount > 0;
        if (table.isLazy()) {
            table.loadLazyData();
        }
        String tbodyClass = hasData ? "ui-datatable-data" : "ui-datatable-data-empty";
        writer.startElement("tbody", null);
        writer.writeAttribute("id", (Object)(clientId + "_data"), null);
        writer.writeAttribute("class", (Object)tbodyClass, null);
        if (hasData) {
            for (int i = first; i < first + rowCountToRender; ++i) {
                this.encodeRow(context, table, clientId, i, rowIndexVar, selMode, selection);
            }
        } else if (emptyMessage != null) {
            writer.startElement("tr", null);
            writer.writeAttribute("class", (Object)"ui-widget-content", null);
            writer.startElement("td", null);
            writer.writeAttribute("colspan", (Object)table.getColumns().size(), null);
            writer.write(emptyMessage);
            writer.endElement("td");
            writer.endElement("tr");
        }
        writer.endElement("tbody");
        table.setRowIndex(-1);
        if (rowIndexVar != null) {
            context.getExternalContext().getRequestMap().remove(rowIndexVar);
        }
    }

    protected void encodeRow(FacesContext context, DataTable table, String clientId, int rowIndex, String rowIndexVar, String selectionMode, Object selection) throws IOException {
        String rowStyleClass;
        table.setRowIndex(rowIndex);
        if (!table.isRowAvailable()) {
            return;
        }
        if (rowIndexVar != null) {
            context.getExternalContext().getRequestMap().put(rowIndexVar, rowIndex);
        }
        boolean selected = this.handlePreselection(table, rowIndex, selectionMode, selection);
        ResponseWriter writer = context.getResponseWriter();
        String userRowStyleClass = table.getRowStyleClass();
        String string = rowStyleClass = rowIndex % 2 == 0 ? "ui-widget-content ui-datatable-even" : "ui-widget-content ui-datatable-odd";
        if (selected && table.getSelectionMode() != null) {
            rowStyleClass = rowStyleClass + " ui-selected ui-state-highlight";
        }
        if (userRowStyleClass != null) {
            rowStyleClass = rowStyleClass + " " + userRowStyleClass;
        }
        writer.startElement("tr", null);
        writer.writeAttribute("id", (Object)(clientId + "_row_" + rowIndex), null);
        writer.writeAttribute("class", (Object)rowStyleClass, null);
        for (UIComponent kid : table.getChildren()) {
            if (!kid.isRendered()) continue;
            if (kid instanceof Column) {
                this.encodeRegularCell(context, table, (Column)kid, clientId, selected);
                continue;
            }
            if (!(kid instanceof Columns)) continue;
            this.encodeDynamicCell(context, table, (Columns)kid);
        }
        if (rowIndexVar != null) {
            context.getExternalContext().getRequestMap().put(rowIndexVar, rowIndex);
        }
        writer.endElement("tr");
    }

    protected void encodeRegularCell(FacesContext context, DataTable table, Column column, String clientId, boolean selected) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("td", null);
        String columnStyleClass = column.getStyleClass();
        if (column.getStyle() != null) {
            writer.writeAttribute("style", (Object)column.getStyle(), null);
        }
        if (column.getSelectionMode() != null) {
            columnStyleClass = columnStyleClass == null ? "ui-selection-column" : "ui-selection-column " + columnStyleClass;
            writer.writeAttribute("class", (Object)columnStyleClass, null);
            this.encodeColumnSelection(context, table, clientId, column, selected);
        } else {
            CellEditor editor = column.getCellEditor();
            if (editor != null) {
                String string = columnStyleClass = columnStyleClass == null ? "ui-editable-column" : "ui-editable-column " + columnStyleClass;
            }
            if (columnStyleClass != null) {
                writer.writeAttribute("class", (Object)columnStyleClass, null);
            }
            column.encodeAll(context);
        }
        writer.endElement("td");
    }

    protected void encodeDynamicCell(FacesContext context, DataTable table, Columns columns) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String columnVar = columns.getVar();
        String columnIndexVar = columns.getColumnIndexVar();
        int colIndex = 0;
        for (Object column : (Collection)columns.getValue()) {
            context.getExternalContext().getRequestMap().put(columnVar, column);
            context.getExternalContext().getRequestMap().put(columnIndexVar, colIndex);
            UIComponent header = columns.getFacet("header");
            writer.startElement("td", null);
            writer.startElement("span", null);
            columns.encodeAll(context);
            writer.endElement("span");
            writer.endElement("td");
            ++colIndex;
        }
        context.getExternalContext().getRequestMap().remove(columnVar);
        context.getExternalContext().getRequestMap().remove(columnIndexVar);
    }

    protected void encodeTFoot(FacesContext context, DataTable table) throws IOException {
        boolean shouldRender;
        ResponseWriter writer = context.getResponseWriter();
        ColumnGroup group = table.getColumnGroup("footer");
        boolean bl = shouldRender = table.hasFooterColumn() || group != null;
        if (!shouldRender) {
            return;
        }
        writer.startElement("tfoot", null);
        if (group != null) {
            for (UIComponent child : group.getChildren()) {
                if (!child.isRendered() || !(child instanceof Row)) continue;
                Row footerRow = (Row)child;
                writer.startElement("tr", null);
                for (UIComponent footerRowChild : footerRow.getChildren()) {
                    if (!footerRowChild.isRendered() || !(footerRowChild instanceof Column)) continue;
                    this.encodeColumnFooter(context, table, (Column)footerRowChild);
                }
                writer.endElement("tr");
            }
        } else {
            writer.startElement("tr", null);
            for (Column column : table.getColumns()) {
                this.encodeColumnFooter(context, table, column);
            }
            writer.endElement("tr");
        }
        writer.endElement("tfoot");
    }

    protected boolean handlePreselection(DataTable table, int rowIndex, String selectionMode, Object selection) {
        boolean selected;
        block2: {
            block3: {
                selected = false;
                if (selectionMode == null || selection == null) break block2;
                if (!selectionMode.equals("single")) break block3;
                if (selection == null || !selection.equals(table.getRowData())) break block2;
                table.addSelectedRowIndex(rowIndex);
                selected = true;
                break block2;
            }
            if (selectionMode.equals("multiple")) {
                Object[] selections = (Object[])selection;
                for (int i = 0; i < selections.length; ++i) {
                    if (!selections[i].equals(table.getRowData())) continue;
                    table.addSelectedRowIndex(rowIndex);
                    selected = true;
                    break;
                }
            }
        }
        return selected;
    }

    protected void encodeFacet(FacesContext context, DataTable table, UIComponent facet, String styleClass) throws IOException {
        if (facet == null) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)styleClass, null);
        facet.encodeAll(context);
        writer.endElement("div");
    }

    protected void encodePaginatorConfig(FacesContext context, DataTable table) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = table.getClientId(context);
        String paginatorPosition = table.getPaginatorPosition();
        String paginatorContainers = null;
        paginatorContainers = paginatorPosition.equalsIgnoreCase("both") ? "'" + clientId + "_paginatortop','" + clientId + "_paginatorbottom'" : "'" + clientId + "_paginator" + paginatorPosition + "'";
        writer.write(",paginator:new YAHOO.widget.Paginator({");
        writer.write("rowsPerPage:" + table.getRows());
        writer.write(",totalRecords:" + table.getRowCount());
        writer.write(",initialPage:" + table.getPage());
        writer.write(",containers:[" + paginatorContainers + "]");
        if (table.getPageLinks() != 10) {
            writer.write(",pageLinks:" + table.getPageLinks());
        }
        if (table.getPaginatorTemplate() != null) {
            writer.write(",template:'" + table.getPaginatorTemplate() + "'");
        }
        if (table.getRowsPerPageTemplate() != null) {
            writer.write(",rowsPerPageOptions : [" + table.getRowsPerPageTemplate() + "]");
        }
        if (table.getCurrentPageReportTemplate() != null) {
            writer.write(",pageReportTemplate:'" + table.getCurrentPageReportTemplate() + "'");
        }
        if (!table.isPaginatorAlwaysVisible()) {
            writer.write(",alwaysVisible:false");
        }
        writer.write("})");
    }

    protected void encodeSelectionConfig(FacesContext context, DataTable table) throws IOException {
        String onRowSelectUpdate;
        ResponseWriter writer = context.getResponseWriter();
        writer.write(",selectionMode:'" + table.getSelectionMode() + "'");
        if (table.isDblClickSelect()) {
            writer.write(",dblclickSelect:true");
        }
        String string = onRowSelectUpdate = table.getOnRowSelectUpdate() != null ? table.getOnRowSelectUpdate() : table.getUpdate();
        if (table.getRowSelectListener() != null || onRowSelectUpdate != null) {
            writer.write(",instantSelect:true");
            if (onRowSelectUpdate != null) {
                writer.write(",onRowSelectUpdate:'" + ComponentUtils.findClientIds(context, table.getParent(), onRowSelectUpdate) + "'");
            }
            if (table.getOnselectStart() != null) {
                writer.write(",onRowSelectStart:function() {" + table.getOnselectStart() + "}");
            }
            if (table.getOnselectComplete() != null) {
                writer.write(",onRowSelectComplete:function(xhr, status, args) {" + table.getOnselectComplete() + "}");
            }
            if (table.getOnRowSelectStart() != null) {
                writer.write(",onRowSelectStart:function() {" + table.getOnRowSelectStart() + "}");
            }
            if (table.getOnRowSelectComplete() != null) {
                writer.write(",onRowSelectComplete:function(xhr, status, args) {" + table.getOnRowSelectComplete() + "}");
            }
        }
        if (table.getRowUnselectListener() != null) {
            writer.write(",instantUnselect:true");
            if (table.getOnRowUnselectUpdate() != null) {
                writer.write(",onRowUnselectUpdate:'" + ComponentUtils.findClientIds(context, table.getParent(), table.getOnRowUnselectUpdate()) + "'");
            }
        }
    }

    protected void encodePaginatorMarkup(FacesContext context, DataTable table, String position) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = table.getClientId(context);
        String styleClass = "ui-paginator ui-paginator-" + position + " ui-widget-header";
        if (!position.equals("top") && table.getFooter() == null) {
            styleClass = styleClass + " ui-corner-bl ui-corner-br";
        } else if (!position.equals("bottom") && table.getHeader() == null) {
            styleClass = styleClass + " ui-corner-tl ui-corner-tr";
        }
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)(clientId + "_paginator" + position), null);
        writer.writeAttribute("class", (Object)styleClass, null);
        writer.endElement("div");
    }

    protected void encodeSelectionHolder(FacesContext context, DataTable table) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String id = table.getClientId(context) + "_selection";
        writer.startElement("input", null);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("id", (Object)id, null);
        writer.writeAttribute("name", (Object)id, null);
        writer.writeAttribute("value", (Object)table.getSelectedRowIndexesAsString(), null);
        writer.endElement("input");
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected void encodeRowEditor(FacesContext context, DataTable table) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String widgetVar = table.resolveWidgetVar();
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-row-editor", null);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-icon ui-icon-pencil", null);
        writer.endElement("span");
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-icon ui-icon-check", null);
        writer.writeAttribute("style", (Object)"display:none", null);
        writer.endElement("span");
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-icon ui-icon-close", null);
        writer.writeAttribute("style", (Object)"display:none", null);
        writer.endElement("span");
        writer.endElement("span");
    }

    protected void encodeRowExpansion(FacesContext context, DataTable table) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Map params = context.getExternalContext().getRequestParameterMap();
        int expandedRowId = Integer.parseInt((String)params.get(table.getClientId(context) + "_expandedRowId"));
        table.setRowIndex(expandedRowId);
        writer.startElement("tr", null);
        writer.writeAttribute("style", (Object)"display:none", null);
        writer.writeAttribute("class", (Object)"ui-expanded-row-content ui-widget-content", null);
        writer.startElement("td", null);
        writer.writeAttribute("colspan", (Object)table.getColumns().size(), null);
        table.getRowExpansion().encodeAll(context);
        writer.endElement("td");
        writer.endElement("tr");
        table.setRowIndex(-1);
    }

    protected void encodeColumnSelection(FacesContext context, DataTable table, String clientId, Column column, boolean selected) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String selectionMode = column.getSelectionMode();
        String name = clientId + "_selection";
        if (selectionMode.equalsIgnoreCase("single")) {
            writer.startElement("input", null);
            writer.writeAttribute("type", (Object)"radio", null);
            writer.writeAttribute("name", (Object)(name + "_radio"), null);
            if (selected) {
                writer.writeAttribute("checked", (Object)"checked", null);
            }
            writer.endElement("input");
        } else if (selectionMode.equalsIgnoreCase("multiple")) {
            writer.startElement("input", null);
            writer.writeAttribute("type", (Object)"checkbox", null);
            writer.writeAttribute("name", (Object)(name + "_checkbox"), null);
            if (selected) {
                writer.writeAttribute("checked", (Object)"checked", null);
            }
            writer.endElement("input");
        } else {
            throw new FacesException("Invalid column selection mode:" + selectionMode);
        }
    }

    protected void encodeEditedRow(FacesContext context, DataTable table) throws IOException {
        Map params = context.getExternalContext().getRequestParameterMap();
        int editedRowId = Integer.parseInt((String)params.get(table.getClientId(context) + "_editedRowId"));
        table.setRowIndex(editedRowId);
        this.encodeRow(context, table, table.getClientId(context), editedRowId, table.getRowIndexVar(), table.getSelectionMode(), table.getSelection());
    }

    private void encodeLiveRows(FacesContext context, DataTable table) throws IOException {
        Map params = context.getExternalContext().getRequestParameterMap();
        int scrollOffset = Integer.parseInt((String)params.get(table.getClientId(context) + "_scrollOffset"));
        String clientId = table.getClientId(context);
        String rowIndexVar = table.getRowIndexVar();
        String selectionMode = table.getSelectionMode();
        Object selection = table.getSelection();
        for (int i = scrollOffset; i < scrollOffset + table.getRows(); ++i) {
            this.encodeRow(context, table, clientId, i, rowIndexVar, selectionMode, selection);
        }
    }
}

