/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.resizable;

import java.io.IOException;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIGraphic;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.resizable.Resizable;
import org.primefaces.event.ResizeEvent;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;

public class ResizableRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        Resizable resizable;
        String clientId;
        Map params = context.getExternalContext().getRequestParameterMap();
        if (params.containsKey((clientId = (resizable = (Resizable)component).getClientId(context)) + "_ajaxResize")) {
            int width = Integer.parseInt((String)params.get(clientId + "_width"));
            int height = Integer.parseInt((String)params.get(clientId + "_height"));
            resizable.queueEvent(new ResizeEvent((UIComponent)resizable, width, height));
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Resizable resizable = (Resizable)component;
        String clientId = resizable.getClientId(context);
        UIComponent target = this.findTarget(context, resizable);
        String targetId = target.getClientId(context);
        writer.startElement("script", (UIComponent)resizable);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        if (target instanceof UIGraphic) {
            writer.write("jQuery(PrimeFaces.escapeClientId('" + targetId + "')).load(function(){");
        } else {
            writer.write("jQuery(function(){");
        }
        writer.write(resizable.resolveWidgetVar() + " = new PrimeFaces.widget.Resizable('" + clientId + "',{");
        writer.write("target:'" + targetId + "'");
        if (resizable.getMinWidth() != Integer.MIN_VALUE) {
            writer.write(",minWidth:" + resizable.getMinWidth());
        }
        if (resizable.getMaxWidth() != Integer.MAX_VALUE) {
            writer.write(",maxWidth:" + resizable.getMaxWidth());
        }
        if (resizable.getMinHeight() != Integer.MIN_VALUE) {
            writer.write(",minHeight:" + resizable.getMinHeight());
        }
        if (resizable.getMaxHeight() != Integer.MAX_VALUE) {
            writer.write(",maxHeight:" + resizable.getMaxHeight());
        }
        if (resizable.isAnimate()) {
            writer.write(",animate:true");
            writer.write(",animateEasing:'" + resizable.getEffect() + "'");
            writer.write(",animateDuration:'" + resizable.getEffectDuration() + "'");
        }
        if (resizable.isProxy()) {
            writer.write(",helper:'ui-resizable-proxy'");
        }
        if (resizable.getHandles() != null) {
            writer.write(",handles:'" + resizable.getHandles() + "'");
        }
        if (resizable.getGrid() != 1) {
            writer.write(",grid:" + resizable.getGrid());
        }
        if (resizable.isAspectRatio()) {
            writer.write(",aspectRatio:true");
        }
        if (resizable.isGhost()) {
            writer.write(",ghost:true");
        }
        if (resizable.isContainment()) {
            writer.write(",containment:PrimeFaces.escapeClientId('" + resizable.getParent().getClientId(context) + "')");
        }
        if (resizable.getOnStart() != null) {
            writer.write(",onStart:function(event, ui) {" + resizable.getOnStart() + "}");
        }
        if (resizable.getOnResize() != null) {
            writer.write(",onResize:function(event, ui) {" + resizable.getOnResize() + "}");
        }
        if (resizable.getOnStop() != null) {
            writer.write(",onStop:function(event, ui) {" + resizable.getOnStop() + "}");
        }
        if (resizable.getResizeListener() != null) {
            UIComponent form = ComponentUtils.findParentForm(context, (UIComponent)resizable);
            if (form == null) {
                throw new FacesException("Resizable '" + resizable.getClientId(context) + "' must be inside a form");
            }
            writer.write(",url:'" + this.getActionURL(context) + "'");
            writer.write(",ajaxResize:true");
            writer.write(",formID:'" + form.getClientId(context) + "'");
            if (resizable.getOnResizeUpdate() != null) {
                writer.write(",onResizeUpdate:'" + ComponentUtils.findClientIds(context, (UIComponent)resizable, resizable.getOnResizeUpdate()) + "'");
            }
        }
        writer.write("});});");
        writer.endElement("script");
    }

    protected UIComponent findTarget(FacesContext context, Resizable resizable) {
        String _for = resizable.getFor();
        if (_for != null) {
            UIComponent component = resizable.findComponent(_for);
            if (component == null) {
                throw new FacesException("Cannot find component \"" + _for + "\" in view.");
            }
            return component;
        }
        return resizable.getParent();
    }
}

