/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.model.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationHandler;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationModelHelper;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.ObjectProvider;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.PersistentObjectManager;
import org.netbeans.modules.websvc.rest.model.api.RestApplication;
import org.netbeans.modules.websvc.rest.model.api.RestApplications;
import org.netbeans.modules.websvc.rest.model.impl.RestApplicationImpl;
import org.netbeans.modules.websvc.rest.model.impl.Utils;

public class RestApplicationsImpl
implements RestApplications {
    private Project project;
    private AnnotationModelHelper helper;
    private volatile PersistentObjectManager<RestApplicationImpl> restApplicationManager;

    public static RestApplicationsImpl create(AnnotationModelHelper helper, Project project) {
        RestApplicationsImpl instance = new RestApplicationsImpl(helper, project);
        instance.initialize();
        return instance;
    }

    private void initialize() {
        this.restApplicationManager = this.helper.createPersistentObjectManager((ObjectProvider)new RestApplicationsProvider());
    }

    private RestApplicationsImpl(AnnotationModelHelper helper, Project project) {
        this.project = project;
        this.helper = helper;
    }

    @Override
    public List<RestApplication> getRestApplications() {
        return new ArrayList<RestApplication>(this.restApplicationManager.getObjects());
    }

    private final class RestApplicationsProvider
    implements ObjectProvider<RestApplicationImpl> {
        private RestApplicationsProvider() {
        }

        public List<RestApplicationImpl> createInitialObjects() throws InterruptedException {
            HashMap<TypeElement, RestApplicationImpl> result = new HashMap<TypeElement, RestApplicationImpl>();
            this.findAnnotations("javax.ws.rs.ApplicationPath", EnumSet.of(ElementKind.CLASS), result);
            return new ArrayList<RestApplicationImpl>(result.values());
        }

        public List<RestApplicationImpl> createObjects(TypeElement type) {
            if (Utils.isRestApplication(type, RestApplicationsImpl.this.helper)) {
                return Collections.singletonList(new RestApplicationImpl(RestApplicationsImpl.this.helper, type));
            }
            return Collections.emptyList();
        }

        public boolean modifyObjects(TypeElement type, List<RestApplicationImpl> objects) {
            assert (objects.size() == 1);
            if (Utils.isRestApplication(type, RestApplicationsImpl.this.helper)) {
                return false;
            }
            String oldPath = objects.get(0).getApplicationPath();
            return oldPath != null && !oldPath.equals(Utils.getApplicationPath(type));
        }

        private void findAnnotations(String annotationType, EnumSet<ElementKind> kinds, final Map<TypeElement, RestApplicationImpl> result) throws InterruptedException {
            RestApplicationsImpl.this.helper.getAnnotationScanner().findAnnotations(annotationType, kinds, new AnnotationHandler(){

                public void handleAnnotation(TypeElement type, Element element, AnnotationMirror annotation) {
                    if (!result.containsKey(type)) {
                        result.put(type, new RestApplicationImpl(RestApplicationsImpl.this.helper, type));
                    }
                }
            });
        }
    }
}

